/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopConstants;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;

@Deprecated
public class HeaderRenderer
extends org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.HeaderRenderer
implements BaseDesktopConstants {
    private static final String _TOP_ANCHOR_HREF = "#top";
    private static final String _QUICK_LINKS_RETURN_TOP_TIP = "af_panelPage.QUICK_LINKS_RETURN_TOP_TIP";
    private static final String _QUICK_LINKS_RETURN_TOP_TEXT = "af_panelPage.QUICK_LINKS_RETURN_TOP";

    protected boolean rendersTableHeader(UIXRenderingContext context) {
        return false;
    }

    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        if (this.rendersTableHeader(context)) {
            super.prerender(context, node);
        } else {
            this._prerender(context, node);
        }
    }

    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        if (this.rendersTableHeader(context)) {
            super.postrender(context, node);
        } else {
            this._postrender(context, node);
        }
    }

    protected boolean hasQuickLinkAnchor(UIXRenderingContext context, UINode node, int headerIndentLevel) {
        return false;
    }

    protected Object getTopAnchor() {
        return _TOP_ANCHOR_HREF;
    }

    protected Object getReturnAltString(UIXRenderingContext context) {
        return HeaderRenderer.getTranslatedValue(context, _QUICK_LINKS_RETURN_TOP_TIP);
    }

    protected Object getReturnString(UIXRenderingContext context) {
        return HeaderRenderer.getTranslatedValue(context, _QUICK_LINKS_RETURN_TOP_TEXT);
    }

    private void _prerender(UIXRenderingContext context, UINode node) throws IOException {
        int nestLevel = HeaderRenderer.getHeaderNestLevel(context);
        int size = this._getSize(context, node);
        String messageType = BaseDesktopUtils.getStringAttributeValue(context, node, MESSAGE_TYPE_ATTR);
        Object label = this.getText(context, node, messageType);
        String headerElement = size < HEADER_ELEMENT.length ? HEADER_ELEMENT[size] : HEADER_ELEMENT[HEADER_ELEMENT.length - 1];
        ResponseWriter writer = context.getResponseWriter();
        UIComponent component = NodeUtils.getUIComponent(context, node);
        writer.startElement("div", component);
        super.renderAttributes(context, node);
        if (nestLevel > 0) {
            HeaderRenderer.renderStyleClassAttribute(context, "p_OraHeaderNest");
        }
        super.prerender(context, node);
        if (this.hasQuickLinkAnchor(context, node, nestLevel)) {
            writer.startElement("a", null);
            if (context.getAgent().getAgentOS() == 2 && context.getAgent().getAgentApplication() == 2) {
                this.renderAttribute(context, "name", label);
            } else {
                this.renderURIAttribute(context, "name", label);
            }
            writer.endElement("a");
        }
        writer.startElement(headerElement, null);
        HeaderRenderer.renderStyleClassAttribute(context, "af|panelHeader");
        this.renderIcon(context, node);
        boolean isError = "error".equals(messageType);
        if (isError) {
            writer.startElement("span", null);
            HeaderRenderer.renderStyleClassAttribute(context, "af|panelHeader::error");
        }
        if (label != null) {
            writer.writeText(label, TEXT_ATTR.getAttributeName());
        }
        if (isError) {
            writer.endElement("span");
        }
        writer.endElement(headerElement);
        HeaderRenderer.incrementHeaderNestLevel(context);
    }

    protected void renderIcon(UIXRenderingContext context, UINode node) throws IOException {
        Object messageType = node.getAttributeValue(context, MESSAGE_TYPE_ATTR);
        if (messageType != null && !"none".equals(messageType)) {
            Icon icon;
            String iconName = this._getMessageIconName(messageType);
            if (iconName != null && (icon = context.getIcon(iconName)) != null) {
                BaseDesktopUtils.renderIcon(context, icon, "", null);
            }
        } else {
            Object iconURI = this.getIconURI(context, node, null);
            if (iconURI != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("img", null);
                writer.writeAttribute("alt", (Object)"", null);
                HeaderRenderer.renderStyleClassAttribute(context, "af|panelHeader::icon-style");
                this.renderEncodedResourceURI(context, "src", iconURI);
                writer.endElement("img");
            }
        }
    }

    private void _postrender(UIXRenderingContext context, UINode node) throws IOException {
        HeaderRenderer.decrementHeaderNestLevel(context);
        HeaderRenderer.resetHeaderSize(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        if (HtmlLafRenderer.isIE(context) && 1 == context.getAgent().getAgentOS()) {
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)"clear:both", null);
            writer.endElement("div");
        }
        super.postrender(context, node);
    }

    private int _getSize(UIXRenderingContext context, UINode node) throws IOException {
        int size;
        HeaderRenderer.setPrevHeaderSize(context);
        Number sizeNumber = (Number)HeaderRenderer.getAttributeValue(context, node, SIZE_ATTR, null);
        if (sizeNumber != null) {
            size = sizeNumber.intValue();
            HeaderRenderer.setContextHeaderSize(context, sizeNumber);
        } else {
            sizeNumber = HeaderRenderer.getContextHeaderSize(context, null);
            size = sizeNumber == null ? 0 : sizeNumber.intValue() + 1;
            HeaderRenderer.setContextHeaderSize(context, size);
        }
        return size;
    }

    private String _getMessageIconName(Object messageType) {
        String iconName = null;
        if ("error".equals(messageType)) {
            iconName = "af|panelHeader::error-icon";
        } else if ("warning".equals(messageType)) {
            iconName = "af|panelHeader::warning-icon";
        } else if ("info".equals(messageType)) {
            iconName = "af|panelHeader::info-icon";
        } else if ("confirmation".equals(messageType)) {
            iconName = "af|panelHeader::confirmation-icon";
        } else if ("processing".equals(messageType)) {
            iconName = "af|panelHeader::processing-icon";
        }
        assert (iconName != null || "none".equals(messageType));
        return iconName;
    }
}

