/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXProcess;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;

public class ProcessUtils {
    private static final String _NAV_SUBMIT_SCRIPTLET = "NavSubmit";
    private static final String _NAV_CHOICE_SUBMIT_SCRIPTLET = "NavChoiceSubmit";
    private static final String _NAV_SUBMIT_SCRIPT = "function _navSubmit(formName, event, id, vld, val){return _submitPartialChange(formName,vld,{event:event,source:id,value:val});}";
    private static final String _LINK_ON_CHANGE_FORM_START = "_navSubmit('";
    private static final String _CHOICE_ON_CHANGE_FORM_START = "_navChoiceSubmit(this, '";
    private static final String _CHOICE_ON_CHANGE_FORM_END = ")";
    private static final String _CHOICE_SUBMIT_SCRIPT = "function _navChoiceSubmit(choice, formName, event, id, vld){if (!_navSubmit(formName, event, id, vld, choice.options[choice.selectedIndex].value)){choice.selectedIndex = choice._lastValue;}}";
    public static final int NO_INDEX = -1;

    public static String getSubmitScriptCall(String form, String id, long value, boolean doValidate) {
        String valueString = IntegerUtils.getString((long)value);
        String gotoEvent = "goto";
        int bufferSize = _LINK_ON_CHANGE_FORM_START.length() + form.length() + 34 + gotoEvent.length() + id.length() + valueString.length();
        StringBuffer buffer = new StringBuffer(bufferSize);
        buffer.append(_LINK_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("', '");
        buffer.append(gotoEvent);
        buffer.append("', '");
        buffer.append(id);
        if (doValidate) {
            buffer.append("',1,'");
        } else {
            buffer.append("',0,'");
        }
        buffer.append(valueString);
        buffer.append("');return false");
        return buffer.toString();
    }

    public static int getBackIndex(UIXProcess component, UIComponent stamp, int startIndex) {
        for (int i = startIndex - 1; i >= 0; --i) {
            component.setRowIndex(i);
            boolean disabled = Boolean.TRUE.equals(stamp.getAttributes().get("disabled"));
            boolean readOnly = Boolean.TRUE.equals(stamp.getAttributes().get("readOnly"));
            boolean rendered = stamp.isRendered();
            if (disabled || readOnly || !rendered) continue;
            component.setRowIndex(startIndex);
            return i;
        }
        component.setRowIndex(startIndex);
        return -1;
    }

    public static String getChoiceOnChangeFormSubmitted(String form, String id, boolean validate) {
        String gotoEvent = "goto";
        int initialSize = _CHOICE_ON_CHANGE_FORM_START.length() + form.length() + 13 + id.length() + _CHOICE_ON_CHANGE_FORM_END.length();
        StringBuffer buffer = new StringBuffer(initialSize);
        buffer.append(_CHOICE_ON_CHANGE_FORM_START);
        buffer.append(form);
        buffer.append("','");
        buffer.append(gotoEvent);
        buffer.append("','");
        buffer.append(id);
        if (validate) {
            buffer.append("',1");
        } else {
            buffer.append("',0");
        }
        buffer.append(_CHOICE_ON_CHANGE_FORM_END);
        return buffer.toString();
    }

    public static int getNextIndex(UIXProcess component, UIComponent stamp, int startIndex) {
        int rowCount = component.getRowCount();
        for (int i = startIndex + 1; i < rowCount; ++i) {
            component.setRowIndex(i);
            boolean disabled = Boolean.TRUE.equals(stamp.getAttributes().get("disabled"));
            boolean readOnly = Boolean.TRUE.equals(stamp.getAttributes().get("readOnly"));
            boolean rendered = stamp.isRendered();
            if (disabled || readOnly || !rendered) continue;
            component.setRowIndex(startIndex);
            return i;
        }
        component.setRowIndex(startIndex);
        return -1;
    }

    public static void renderNavSubmitScript(FacesContext context, RenderingContext arc) throws IOException {
        XhtmlUtils.addLib(context, arc, _NAV_SUBMIT_SCRIPTLET);
    }

    public static void renderNavChoiceSubmitScript(FacesContext context, RenderingContext arc) throws IOException {
        XhtmlUtils.addLib(context, arc, _NAV_CHOICE_SUBMIT_SCRIPTLET);
    }

    static {
        NavSubmitScriptlet.sharedInstance().registerSelf();
        NavChoiceSubmitScriptlet.sharedInstance().registerSelf();
    }

    private static class NavChoiceSubmitScriptlet
    extends Scriptlet {
        private static NavChoiceSubmitScriptlet _sInstance = new NavChoiceSubmitScriptlet();

        private NavChoiceSubmitScriptlet() {
        }

        public static Scriptlet sharedInstance() {
            return _sInstance;
        }

        public Object getScriptletKey() {
            return ProcessUtils._NAV_CHOICE_SUBMIT_SCRIPTLET;
        }

        protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeText((Object)ProcessUtils._CHOICE_SUBMIT_SCRIPT, null);
        }
    }

    private static class NavSubmitScriptlet
    extends Scriptlet {
        private static NavSubmitScriptlet _sInstance = new NavSubmitScriptlet();

        private NavSubmitScriptlet() {
        }

        public static Scriptlet sharedInstance() {
            return _sInstance;
        }

        public Object getScriptletKey() {
            return ProcessUtils._NAV_SUBMIT_SCRIPTLET;
        }

        protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
            context.getResponseWriter().writeText((Object)ProcessUtils._NAV_SUBMIT_SCRIPT, null);
        }
    }
}

