/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.action;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidadinternal.share.url.URLEncoder;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.action.ActionUtils;
import org.apache.myfaces.trinidadinternal.ui.action.ClientAction;
import org.apache.myfaces.trinidadinternal.ui.collection.Parameter;
import org.apache.myfaces.trinidadinternal.ui.data.BoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.FormValueRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;

@Deprecated
public class FireAction
extends ClientAction {
    private boolean _isBlocked;
    private boolean _submitted;
    private String _formName;
    private BoundValue _formNameBinding;
    private String _event;
    private BoundValue _eventBinding;
    private String _source;
    private BoundValue _sourceBinding;
    private boolean _unvalidated;
    private BoundValue _unvalidatedBinding;
    private Parameter[] _parameters;
    protected static final String FULL_START_SCRIPT = "document.location.href='";
    protected static final String FULL_END_SCRIPT = "';";
    protected static final String _SUBMIT_START = "submitForm('";
    protected static final String _BLOCK_SCRIPT = "_blockOnEverySubmit=true;submitForm('";

    public FireAction() {
        this(null);
    }

    public FireAction(String event) {
        this(event, true);
    }

    public FireAction(String event, boolean submit) {
        this._submitted = submit;
        this._event = event;
    }

    public String getScript(UIXRenderingContext context, UINode node, Boolean returnVal) {
        if (BaseLafRenderer.supportsScripting(context)) {
            String returnScript = Boolean.TRUE.equals(returnVal) ? "return true;" : "return false;";
            return this.isFormSubmitted() ? this.getSubmitScript(context, node, returnScript) : this.getChangeScript(context, node, returnScript);
        }
        return null;
    }

    public void writeDependencies(UIXRenderingContext context, UINode node) throws IOException {
        super.writeDependencies(context, node);
        if (this.isFormSubmitted()) {
            String formName = this.getFormName(context, node);
            if (formName == null) {
                return;
            }
            URLEncoder encoder = context.getURLEncoder();
            String eventKey = encoder.encodeParameter("event");
            String sourceKey = encoder.encodeParameter("source");
            FormValueRenderer.addNeededValue(context, formName, eventKey, sourceKey, null, null);
            Parameter[] parameters = this.getParameters();
            if (parameters != null) {
                String[] paramKeys = new String[4];
                for (int i = 0; i < parameters.length; i += 4) {
                    paramKeys[3] = null;
                    paramKeys[2] = null;
                    paramKeys[1] = null;
                    for (int j = 0; j < 4 && parameters.length > i + j; ++j) {
                        paramKeys[j] = parameters[i + j].getKey();
                    }
                    FormValueRenderer.addNeededValue(context, formName, paramKeys[0], paramKeys[1], paramKeys[2], paramKeys[3]);
                }
            }
        }
    }

    protected String getSubmitScript(UIXRenderingContext context, UINode node, String returnScript) {
        String startScript = this._isBlocked ? _BLOCK_SCRIPT : _SUBMIT_START;
        String endScript = ");";
        String source = ActionUtils.getSource(context, node, this._sourceBinding, this._source);
        String formName = this.getFormName(context, node);
        if (formName == null) {
            return null;
        }
        boolean unvalidated = this.isUnvalidated(context);
        Parameter[] parameters = this._parameters;
        String event = this.getEventValue(context);
        int length = FireAction.getBufferSize(context, startScript, endScript, null, formName, event, source, null, null, null, null, returnScript, parameters);
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(startScript);
        buffer.append(formName);
        buffer.append("',");
        buffer.append(unvalidated ? "0" : "1");
        ActionUtils.appendClientParameters(context, buffer, parameters, event, source, formName);
        buffer.append(endScript);
        buffer.append(returnScript);
        return buffer.toString();
    }

    protected String getChangeScript(UIXRenderingContext context, UINode node, String returnScript) {
        return this.getChangeScript(context, node, returnScript, FULL_START_SCRIPT, FULL_END_SCRIPT, null, null);
    }

    protected String getChangeScript(UIXRenderingContext context, UINode node, String returnScript, String startScript, String endScript, String extraKey, String extraValue) {
        String event = this.getEventValue(context);
        String source = ActionUtils.getSource(context, node, this._sourceBinding, this._source);
        String destination = FireAction.getDestination(context, node);
        URLEncoder encoder = context.getURLEncoder();
        String eventKey = encoder.encodeParameter("event");
        String sourceKey = FireAction.getSourceKey(encoder, source);
        Parameter[] parameters = this._parameters;
        int length = FireAction.getBufferSize(context, startScript, endScript, destination, null, event, source, extraValue, eventKey, sourceKey, extraKey, returnScript, parameters);
        StringBuilder buffer = new StringBuilder(length);
        StringBuilder urlBuffer = new StringBuilder(length);
        buffer.append(startScript);
        urlBuffer.append(destination);
        if (destination.indexOf(63) == -1) {
            urlBuffer.append("?");
        }
        FireAction.appendURLParameter(urlBuffer, eventKey, event);
        FireAction.appendURLParameter(urlBuffer, sourceKey, source);
        if (extraKey != null && extraValue != null) {
            FireAction.appendURLParameter(urlBuffer, extraKey, extraValue);
        }
        FireAction.appendClientParameters(context, urlBuffer, parameters);
        String url = urlBuffer.toString();
        FacesContext facesContext = context.getFacesContext();
        if (facesContext != null) {
            url = facesContext.getExternalContext().encodeActionURL(url);
        }
        buffer.append(url);
        buffer.append(endScript);
        buffer.append(returnScript);
        return buffer.toString();
    }

    public final Parameter[] getParameters() {
        return ActionUtils.cloneParameterArray(this._parameters);
    }

    public Parameter[] getParameters(UIXRenderingContext context, UINode node) {
        URLEncoder encoder = context.getURLEncoder();
        String eventKey = encoder.encodeParameter("event");
        String sourceKey = encoder.encodeParameter("source");
        Parameter eventParam = ActionUtils.buildParameter(context, node, this._eventBinding, this._event, eventKey);
        int numParams = 1;
        Parameter sourceParam = null;
        if (this._sourceBinding != null || this._source != null) {
            sourceParam = ActionUtils.buildParameter(context, node, this._sourceBinding, this._source, sourceKey);
            ++numParams;
        }
        Parameter[] localParams = new Parameter[numParams];
        localParams[0] = eventParam;
        if (sourceParam != null) {
            localParams[1] = sourceParam;
        }
        return ActionUtils.joinParameterArrays(localParams, this._parameters);
    }

    public final String getSource() {
        return this._source;
    }

    public final String getEvent() {
        return this._event;
    }

    public final boolean isFormSubmitted() {
        return this._submitted;
    }

    public final boolean isUnvalidated() {
        return this._unvalidated;
    }

    public boolean renderAsEvent(UIXRenderingContext context, UINode node) {
        return this._submitted && BaseLafRenderer.supportsScripting(context);
    }

    public void setFormName(String formName) {
        this._formName = formName;
    }

    public void setFormNameBinding(BoundValue formNameBinding) {
        this._formNameBinding = formNameBinding;
    }

    public void setEvent(String event) {
        this._event = event;
    }

    public void setEventBinding(BoundValue eventBinding) {
        this._eventBinding = eventBinding;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public void setSourceBinding(BoundValue sourceBinding) {
        this._sourceBinding = sourceBinding;
    }

    public void setParameters(Parameter[] parameters) {
        this._parameters = parameters == null ? null : (Parameter[])parameters.clone();
    }

    public void setFormSubmitted(boolean submitted) {
        this._submitted = submitted;
    }

    public void setUnvalidated(boolean unvalidated) {
        this._unvalidated = unvalidated;
    }

    public void setUnvalidatedBinding(BoundValue unvalidatedBinding) {
        this._unvalidatedBinding = unvalidatedBinding;
    }

    protected String getEventValue(UIXRenderingContext context) {
        return (String)ActionUtils.getValue(context, this._eventBinding, this.getEvent());
    }

    protected boolean isUnvalidated(UIXRenderingContext context) {
        Boolean unvalidated = (Boolean)ActionUtils.getValue(context, this._unvalidatedBinding, null);
        if (unvalidated != null) {
            return unvalidated;
        }
        return this._unvalidated;
    }

    protected static void appendJSParameter(StringBuilder buffer, String value) {
        if (buffer.charAt(buffer.length() - 1) != ',') {
            buffer.append(",");
        }
        if (value == null) {
            buffer.append("0");
        } else {
            buffer.append("'");
            XhtmlLafUtils.escapeJS(buffer, value, true, 2);
            buffer.append("'");
        }
    }

    protected static void appendURLParameter(StringBuilder buffer, String name, String value) {
        ActionUtils.appendURLParameter(buffer, name, value);
    }

    protected static void appendClientParameters(UIXRenderingContext context, StringBuilder buffer, Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            FireAction.appendURLParameter(buffer, param.getKey(), param.getValue(context));
        }
    }

    protected static int getClientParametersSize(UIXRenderingContext context, Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return 0;
        }
        int length = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            String value = param.getValue(context);
            if (value == null) continue;
            length += value.length();
            length += param.getKey().length();
            length += 5;
        }
        return length;
    }

    protected static int getBufferSize(UIXRenderingContext context, String startScript, String endScript, String destination, String formName, String event, String source, String partialTargets, String eventKey, String sourceKey, String partialTargetsKey, String returnScript, Parameter[] parameters) {
        int length = startScript.length() + endScript.length() + returnScript.length();
        if (destination != null) {
            length += destination.length();
        }
        if (formName != null) {
            length += formName.length() + 2;
        }
        length = eventKey != null ? (length += eventKey.length()) : (length += 9);
        if (event != null) {
            length += event.length() + 2;
        }
        if (sourceKey != null) {
            length += sourceKey.length();
        }
        if (source != null) {
            length += source.length() + 2;
        }
        if (partialTargetsKey != null) {
            length += partialTargetsKey.length();
        }
        if (partialTargets != null) {
            length += partialTargets.length() + 2;
        }
        length += ActionUtils.getClientParametersSize(context, parameters);
        return length += 2;
    }

    protected static String getDestination(UIXRenderingContext context, UINode node) {
        Object destination = node.getAttributeValue(context, UIConstants.DESTINATION_ATTR);
        if (destination != null) {
            return destination.toString();
        }
        URLEncoder encoder = context.getURLEncoder();
        return encoder.getDefaultURL();
    }

    protected static String getSourceKey(URLEncoder encoder, String source) {
        if (source == null) {
            return null;
        }
        return encoder.encodeParameter("source");
    }

    protected String getSource(UIXRenderingContext context, UINode node) {
        return ActionUtils.getSource(context, node, this._sourceBinding, this._source);
    }

    protected String getFormName(UIXRenderingContext context, UINode node) {
        String formName = null;
        if (this._formNameBinding != null) {
            formName = (String)this._formNameBinding.getValue(context);
        }
        if (formName == null) {
            formName = this._formName;
        }
        if (formName == null) {
            formName = ActionUtils.getFormName(context);
        }
        return formName;
    }

    public void setBlocking(boolean isBlocked) {
        this._isBlocked = isBlocked;
    }
}

