/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreImage;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRendererUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class ImageRenderer
extends XhtmlRenderer {
    private PropertyKey _imageMapTypeKey;
    private PropertyKey _longDescURLKey;
    private PropertyKey _sourceKey;

    public ImageRenderer() {
        super(CoreImage.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._imageMapTypeKey = type.findKey("imageMapType");
        this._longDescURLKey = type.findKey("longDescURL");
        this._sourceKey = type.findKey("source");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, rc, comp)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("img", comp);
        this.renderId(context, rc, comp, rw);
        this.renderAllAttributes(context, rc, comp, bean);
        rw.endElement("img");
    }

    @Override
    protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        super.renderAllAttributes(context, rc, component, bean);
        this.renderEncodedResourceURI(context, "src", this.getSource(component, bean));
        this.renderEncodedActionURI(context, "longdesc", this.getLongDescURL(component, bean));
        this._renderImageMap(component, bean, rw);
    }

    @Override
    protected void renderShortDescAttribute(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        String shortDesc = this.getShortDesc(component, bean);
        if (shortDesc != null) {
            OutputUtils.renderAltAndTooltipForImage(context, rc, shortDesc);
        }
    }

    protected String getImageMapType(UIComponent component, FacesBean bean) {
        return ImageRenderer.toString((Object)bean.getProperty(this._imageMapTypeKey));
    }

    protected String getLongDescURL(UIComponent component, FacesBean bean) {
        return ImageRenderer.toActionUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._longDescURLKey));
    }

    protected String getSource(UIComponent component, FacesBean bean) {
        return ImageRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._sourceKey));
    }

    protected void renderId(FacesContext context, RenderingContext rc, UIComponent comp, ResponseWriter writer) throws IOException {
        super.renderId(context, comp);
        if (this.shouldRenderId(context, comp) && CoreRendererUtils.supportsNameIdentification(rc)) {
            String clientId = this.getClientId(context, comp);
            writer.writeAttribute("name", (Object)clientId, null);
        }
    }

    private void _renderImageMap(UIComponent component, FacesBean bean, ResponseWriter writer) throws IOException {
        String mType = this.getImageMapType(component, bean);
        if ("server".equals(mType)) {
            writer.writeAttribute("ismap", (Object)Boolean.TRUE, "imageMapType");
        }
    }
}

