/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import java.awt.Color;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequestImpl;
import org.apache.myfaces.trinidadinternal.image.xml.parse.ImageParseUtils;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class BaseImageProviderRequestParser
extends BaseNodeParser {
    private String _namespaceURI;
    private String _localName;
    private Map<Object, Object> _properties;
    private boolean _error;
    private static final String _DIRECTION_ERROR = "Error while parsing direction attribute value.";
    private static final int _MNEMONIC_INDEX_NONE = -1;
    private static final char _MNEMONIC_INDICATOR = '&';
    static Object __STRIP_MNEMONICS_PROPERTY = "stripMnemonics";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BaseImageProviderRequestParser.class);

    protected BaseImageProviderRequestParser(int capacity) {
        this._properties = new ArrayMap(capacity + 1);
    }

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        String encoding;
        Integer direction;
        Integer height;
        Integer width;
        Boolean disabled;
        Boolean textAntialias;
        if (namespaceURI == null || namespaceURI.length() == 0 || "http://myfaces.apache.org/cabo/tecate".equals(namespaceURI)) {
            namespaceURI = "http://myfaces.apache.org/uix/image";
        }
        this._namespaceURI = namespaceURI;
        this._localName = localName;
        String name = attrs.getValue("name");
        if (name != null) {
            this.setProperty(ImageConstants.NAME_KEY, name);
        }
        if ((textAntialias = this.isTextAntaliased(context, attrs)) != null) {
            this.setProperty(ImageConstants.TEXT_ANTIALIAS_KEY, textAntialias);
        }
        if ((disabled = this.isDisabled(context, attrs)) != null) {
            this.setProperty(ImageConstants.DISABLED_KEY, disabled);
        }
        if ((width = this.getWidth(context, attrs)) != null) {
            this.setProperty(ImageConstants.WIDTH_RESPONSE_KEY, width);
        }
        if ((height = this.getHeight(context, attrs)) != null) {
            this.setProperty(ImageConstants.HEIGHT_RESPONSE_KEY, height);
        }
        if ((direction = this.getDirection(context, attrs)) != null) {
            this.setProperty(ImageConstants.DIRECTION_KEY, direction);
        }
        if ((encoding = this.getEncodingType(context, attrs)) == null) {
            encoding = "image/gif";
        }
        this.setProperty(ImageConstants.ENCODING_TYPE_KEY, encoding);
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._error) {
            return null;
        }
        return new ImageProviderRequestImpl(this._namespaceURI, this._localName, this._properties);
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if (this.isColorElement(namespaceURI, localName)) {
            return context.getParser(Color.class, namespaceURI, localName);
        }
        if (this.isFontElement(namespaceURI, localName)) {
            return context.getParser(FontProxy.class, namespaceURI, localName);
        }
        if ("colorScheme".equals(localName)) {
            return BaseImageProviderRequestParser.getIgnoreParser();
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (this.isColorElement(namespaceURI, localName)) {
            this.setProperty(this.getColorKey(namespaceURI, localName), child);
        } else if (this.isFontElement(namespaceURI, localName)) {
            this.setProperty(this.getFontKey(namespaceURI, localName), child);
        }
    }

    protected void setProperty(Object key, Object value) {
        this._properties.put(key, value);
    }

    protected boolean isColorElement(String namespaceURI, String localName) {
        return localName.equals("background") || localName.equals("foreground") || localName.equals("surroundingColor");
    }

    protected boolean isFontElement(String namespaceURI, String localName) {
        return localName.equals("font");
    }

    protected Object getColorKey(String namespaceURI, String localName) {
        if (localName.equals("background")) {
            return ImageConstants.BACKGROUND_KEY;
        }
        if (localName.equals("foreground")) {
            return ImageConstants.FOREGROUND_KEY;
        }
        if (localName.equals("surroundingColor")) {
            return ImageConstants.SURROUNDING_COLOR_KEY;
        }
        return null;
    }

    protected Object getFontKey(String namespaceURI, String localName) {
        if (localName.equals("font")) {
            return ImageConstants.FONT_KEY;
        }
        return null;
    }

    protected Boolean isTextAntaliased(ParseContext context, Attributes attrs) {
        return ImageParseUtils.getBooleanAttributeValue(context, attrs, "textAntialias");
    }

    protected Boolean isDisabled(ParseContext context, Attributes attrs) {
        return ImageParseUtils.getBooleanAttributeValue(context, attrs, "disabled");
    }

    protected Integer getWidth(ParseContext context, Attributes attrs) {
        return ImageParseUtils.getIntegerAttributeValue(context, attrs, "width");
    }

    protected Integer getHeight(ParseContext context, Attributes attrs) {
        return ImageParseUtils.getIntegerAttributeValue(context, attrs, "height");
    }

    protected Integer getDirection(ParseContext context, Attributes attrs) {
        String value = attrs.getValue("direction");
        if (value == null) {
            return null;
        }
        if (value.equals("ltr")) {
            return 1;
        }
        if (value.equals("rtl")) {
            return 2;
        }
        _LOG.warning(_DIRECTION_ERROR);
        return null;
    }

    protected String getEncodingType(ParseContext context, Attributes attrs) {
        String value = attrs.getValue("type");
        if (value == null) {
            return null;
        }
        return value.intern();
    }

    void __errorOccured() {
        this._error = true;
    }

    static int __getMnemonicIndex(String string) {
        int index;
        if (string == null) {
            return -1;
        }
        int lengthMinusOne = string.length() - 1;
        int i = 0;
        int count = 0;
        while (i < lengthMinusOne && (index = string.indexOf(38, i)) != -1 && index < lengthMinusOne) {
            if (string.charAt(index + 1) != '&') {
                return index - count;
            }
            i = index + 2;
            ++count;
        }
        return -1;
    }

    static String __stripMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        if (length <= 1) {
            return string;
        }
        StringBuffer buffer = null;
        int i = 0;
        while (i < length) {
            int index = string.indexOf(38, i);
            if (index < 0 || index >= length - 1) {
                if (buffer == null) break;
                buffer.append(string.substring(i));
                break;
            }
            if (buffer == null) {
                if (index == 0 && string.charAt(1) != '&') {
                    string = string.substring(1);
                    --length;
                    continue;
                }
                buffer = new StringBuffer(length - 1);
            }
            buffer.append(string.substring(i, index));
            buffer.append(string.charAt(index + 1));
            i = index + 2;
        }
        if (buffer == null) {
            return string;
        }
        return new String(buffer);
    }

    private BaseImageProviderRequestParser() {
    }
}

