/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputDocument;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;

public class OutputDocumentRenderer
extends ValueRenderer {
    private static final char _LINE_FEED = '\n';
    private static final char _CARRIAGE_RETURN = '\r';
    private static final String _PARAGRAPH_ELEMENT = "p";
    private static final String _ROOT_ELEMENT = "div";
    private static final String _SEPARATOR_ELEMENT = "div";
    private static final String _TITLE_ELEMENT = "div";
    private static final String _SEPARATOR_CLASS_ATTRIBUTE = "separatorClass";
    private static final String _TITLE_CLASS_ATTRIBUTE = "titleClass";
    private static final String _PARAGRAPH_SELECTOR = "af|outputDocument::paragraph";
    private static final String _ROOT_SELECTOR = "af|outputDocument";
    private static final String _SEPARATOR_SELECTOR = "af|outputDocument::separator";
    private static final String _TITLE_SELECTOR = "af|outputDocument::title";
    private PropertyKey _separatorClassKey;
    private PropertyKey _titleClassKey;

    public OutputDocumentRenderer() {
        super(CoreOutputDocument.TYPE);
    }

    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", comp);
        this.renderId(context, comp);
        this.renderAllAttributes(context, rc, comp, bean);
    }

    public void encodeEnd(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        String value = this.getConvertedString(context, comp, bean);
        this._renderTitle(context, rc, comp, bean);
        boolean firstParagraphRendered = false;
        UIComponent separator = OutputDocumentRenderer.getFacet((UIComponent)comp, (String)"separator");
        boolean hasSeparator = separator != null;
        int length = value.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char character = value.charAt(i);
            if (this._isLineFeed(character)) {
                if (builder.length() <= 0) continue;
                this._renderParagraph(context, builder);
                firstParagraphRendered = true;
                continue;
            }
            if (builder.length() == 0) {
                if (firstParagraphRendered && hasSeparator) {
                    this._renderSeparator(context, rc, separator, bean);
                }
                this._renderParagraphStart(context, rc);
            }
            builder.append(character);
        }
        if (builder.length() > 0) {
            this._renderParagraph(context, builder);
        }
        rw.endElement("div");
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._separatorClassKey = type.findKey(_SEPARATOR_CLASS_ATTRIBUTE);
        this._titleClassKey = type.findKey(_TITLE_CLASS_ATTRIBUTE);
    }

    protected String getSeparatorClass(UIComponent component, FacesBean bean) {
        return OutputDocumentRenderer.toString((Object)bean.getProperty(this._separatorClassKey));
    }

    protected String getTitleClass(UIComponent component, FacesBean bean) {
        return OutputDocumentRenderer.toString((Object)bean.getProperty(this._titleClassKey));
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, rc, component, bean, _ROOT_SELECTOR);
    }

    private String[] _getStyleClasses(FacesBean bean, PropertyKey key, String skinSelector) {
        assert (bean != null);
        String specifiedClass = OutputDocumentRenderer.toString((Object)bean.getProperty(key));
        if (specifiedClass != null) {
            return new String[]{specifiedClass, skinSelector};
        }
        return new String[]{skinSelector};
    }

    private boolean _isLineFeed(char character) {
        return character == '\n' || character == '\r';
    }

    private void _renderParagraph(FacesContext context, StringBuilder builder) throws IOException {
        assert (builder != null);
        assert (context != null);
        this.renderFormattedText(context, builder.toString());
        context.getResponseWriter().endElement(_PARAGRAPH_ELEMENT);
        builder.delete(0, builder.length());
    }

    private void _renderParagraphStart(FacesContext context, RenderingContext rc) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement(_PARAGRAPH_ELEMENT, null);
        OutputDocumentRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])new String[]{_PARAGRAPH_SELECTOR});
    }

    private void _renderSeparator(FacesContext context, RenderingContext rc, UIComponent separator, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", null);
        String[] classes = this._getStyleClasses(bean, this._separatorClassKey, _SEPARATOR_SELECTOR);
        OutputDocumentRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])classes);
        this.encodeChild(context, separator);
        rw.endElement("div");
    }

    private void _renderTitle(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        UIComponent title = OutputDocumentRenderer.getFacet((UIComponent)comp, (String)"title");
        if (title != null) {
            ResponseWriter rw = context.getResponseWriter();
            rw.startElement("div", null);
            String[] classes = this._getStyleClasses(bean, this._titleClassKey, _TITLE_SELECTOR);
            OutputDocumentRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])classes);
            this.encodeChild(context, title);
            rw.endElement("div");
        }
    }
}

