/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.util.Args;
import org.apache.myfaces.trinidad.util.URLUtils;

public class CachingResourceLoader
extends ResourceLoader {
    private final ConcurrentMap<String, URL> _cache = new ConcurrentHashMap<String, URL>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CachingResourceLoader.class);

    public CachingResourceLoader(ResourceLoader parent) {
        super(parent);
    }

    @Override
    protected URL findResource(String path) throws IOException {
        URL url = (URL)this._cache.get(path);
        if (url == null && (url = this.getParent().getResource(path)) != null) {
            url = new URL("cache", null, -1, path, new CachingURLStreamHandler(url));
            this._cache.putIfAbsent(path, url);
        }
        return url;
    }

    @Override
    public boolean isCachable() {
        return false;
    }

    private static class URLConnectionImpl
    extends URLConnection {
        private final URLConnection _conn;
        private final CachingURLStreamHandler _handler;

        public URLConnectionImpl(URL url, URLConnection conn, CachingURLStreamHandler handler) {
            super(url);
            this._conn = conn;
            this._handler = handler;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public String getContentType() {
            return this._conn.getContentType();
        }

        @Override
        public int getContentLength() {
            int contentLength = this._conn.getContentLength();
            this._handler.validateContentLength(contentLength);
            return contentLength;
        }

        @Override
        public long getLastModified() {
            try {
                return URLUtils.getLastModified(this._conn);
            }
            catch (IOException exception) {
                return -1L;
            }
        }

        @Override
        public String getHeaderField(String name) {
            return this._conn.getHeaderField(name);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._handler.getInputStream(this._conn);
        }
    }

    private static final class CachedContents {
        private final URL _url;
        private final byte[] _data;
        private final long _lastModified;
        private final int _contentLength;

        public CachedContents(URL resourceURL, byte[] data, long lastModified, int contentLength) {
            Args.notNull(data, "data");
            Args.notNull(resourceURL, "resourceURL");
            this._ensureValidSize(resourceURL, data, contentLength);
            this._url = resourceURL;
            this._data = data;
            this._lastModified = lastModified;
            this._contentLength = contentLength;
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(this._data);
        }

        public boolean isStale(long lastModified) {
            return lastModified > this._lastModified;
        }

        public boolean validateContentLength(int newContentLength) {
            return this._isValidSize(this._data, newContentLength);
        }

        public String toString() {
            String urlString = this._url.toString();
            String sizeString = Integer.toString(this._data.length);
            int builderLength = urlString.length() + sizeString.length() + 13;
            StringBuilder builder = new StringBuilder(builderLength);
            builder.append("[url=");
            builder.append(urlString);
            builder.append(", size=");
            builder.append(sizeString);
            builder.append("]");
            return builder.toString();
        }

        private void _ensureValidSize(URL resourceURL, byte[] data, int contentLength) throws IllegalStateException {
            assert (data != null);
            if (!this._isValidSize(data, contentLength)) {
                String messageKey = "INVALID_RESOURCE_SIZE";
                String message = _LOG.getMessage(messageKey, new Object[]{resourceURL.toString(), data.length, contentLength});
                _LOG.severe(message);
                throw new IllegalStateException(messageKey);
            }
        }

        private boolean _isValidSize(byte[] data, int contentLength) {
            assert (data != null);
            return contentLength < 0 || contentLength == data.length;
        }
    }

    private static final class CachingURLStreamHandler
    extends URLStreamHandler {
        private final URL _delegate;
        private final AtomicReference<CachedContents> _contents;

        public CachingURLStreamHandler(URL delegate) {
            this._delegate = delegate;
            this._contents = new AtomicReference();
        }

        public void validateContentLength(int newContentLength) {
            CachedContents contents = this._contents.get();
            if (contents != null && !contents.validateContentLength(newContentLength)) {
                this._contents.compareAndSet(contents, null);
                this._logResourceSizeChanged(newContentLength, contents);
            }
        }

        private void _logResourceSizeChanged(int newContentLength, CachedContents contents) {
            if (_LOG.isFine()) {
                _LOG.fine("RESOURCE_SIZE_CHANGED", new Object[]{newContentLength, contents});
            }
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new URLConnectionImpl(url, this._delegate.openConnection(), this);
        }

        protected InputStream getInputStream(URLConnection conn) throws IOException {
            CachedContents contents = this._contents.get();
            if (contents == null || this._isStale(contents, this._delegate)) {
                contents = this._updateContents(conn);
                assert (contents != null);
            }
            return contents.toInputStream();
        }

        private boolean _isStale(CachedContents contents, URL url) throws IOException {
            Args.notNull(contents, "contents");
            Args.notNull(url, "url");
            long lastModified = URLUtils.getLastModified(this._delegate);
            return contents.isStale(lastModified);
        }

        private CachedContents _updateContents(URLConnection conn) throws IOException {
            CachedContents newContents = this._createContents(conn);
            assert (newContents != null);
            this._contents.set(newContents);
            return newContents;
        }

        private CachedContents _createContents(URLConnection conn) throws IOException {
            long lastModified = URLUtils.getLastModified(conn);
            byte[] data = this._readBytes(conn);
            int contentLength = conn.getContentLength();
            return new CachedContents(this._delegate, data, lastModified, contentLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] _readBytes(URLConnection conn) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (InputStream in = conn.getInputStream();){
                int length;
                byte[] buffer = new byte[2048];
                while ((length = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, length);
                }
            }
            return out.toByteArray();
        }
    }
}

