/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.code;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jpt.sun.tools.javac.code.AnnoConstruct;
import jpt.sun.tools.javac.code.Attribute;
import jpt.sun.tools.javac.code.DeferredCompletionFailureHandler;
import jpt.sun.tools.javac.code.Directive;
import jpt.sun.tools.javac.code.Flags;
import jpt.sun.tools.javac.code.Kinds;
import jpt.sun.tools.javac.code.MissingInfoHandler;
import jpt.sun.tools.javac.code.Scope;
import jpt.sun.tools.javac.code.SymbolMetadata;
import jpt.sun.tools.javac.code.TargetType;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.code.TypeTag;
import jpt.sun.tools.javac.code.Types;
import jpt.sun.tools.javac.comp.Annotate;
import jpt.sun.tools.javac.comp.Attr;
import jpt.sun.tools.javac.comp.AttrContext;
import jpt.sun.tools.javac.comp.Env;
import jpt.sun.tools.javac.jvm.Code;
import jpt.sun.tools.javac.jvm.PoolConstant;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.Constants;
import jpt.sun.tools.javac.util.Convert;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.ListBuffer;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Pair;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ElementVisitor;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.NestingKind;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.RecordComponentElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.TypeParameterElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.tools.JavaFileManager;
import jpt30.tools.JavaFileObject;

public abstract class Symbol
extends AnnoConstruct
implements PoolConstant,
Element {
    public Kinds.Kind kind;
    public long flags_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;
    protected SymbolMetadata metadata;

    public long flags() {
        return this.flags_field;
    }

    public List<Attribute.Compound> getRawAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getDeclarationAttributes();
    }

    public List<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getTypeAttributes();
    }

    public Attribute.Compound attribute(Symbol anno) {
        for (Attribute.Compound a : this.getRawAttributes()) {
            if (a.type.tsym != anno) continue;
            return a;
        }
        return null;
    }

    public boolean annotationsPendingCompletion() {
        return this.metadata == null ? false : this.metadata.pendingCompletion();
    }

    public void appendAttributes(List<Attribute.Compound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().append(l);
        }
    }

    public void appendClassInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().appendClassInitTypeAttributes(l);
        }
    }

    public void appendInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().appendInitTypeAttributes(l);
        }
    }

    public void appendUniqueTypeAttributes(List<Attribute.TypeCompound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().appendUniqueTypes(l);
        }
    }

    public List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getClassInitTypeAttributes();
    }

    public List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getInitTypeAttributes();
    }

    public void setInitTypeAttributes(List<Attribute.TypeCompound> l) {
        this.initedMetadata().setInitTypeAttributes(l);
    }

    public void setClassInitTypeAttributes(List<Attribute.TypeCompound> l) {
        this.initedMetadata().setClassInitTypeAttributes(l);
    }

    public List<Attribute.Compound> getDeclarationAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getDeclarationAttributes();
    }

    public boolean hasAnnotations() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    public boolean hasTypeAnnotations() {
        return this.metadata != null && !this.metadata.isTypesEmpty();
    }

    public boolean isCompleted() {
        return this.completer.isTerminal();
    }

    public void prependAttributes(List<Attribute.Compound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().prepend(l);
        }
    }

    public void resetAnnotations() {
        this.initedMetadata().reset();
    }

    public void setAttributes(Symbol other) {
        if (this.metadata != null || other.metadata != null) {
            this.initedMetadata().setAttributes(other.metadata);
        }
    }

    public void setDeclarationAttributes(List<Attribute.Compound> a) {
        if (this.metadata != null || a.nonEmpty()) {
            this.initedMetadata().setDeclarationAttributes(a);
        }
    }

    public void setTypeAttributes(List<Attribute.TypeCompound> a) {
        if (this.metadata != null || a.nonEmpty()) {
            if (this.metadata == null) {
                this.metadata = new SymbolMetadata(this);
            }
            this.metadata.setTypeAttributes(a);
        }
    }

    private SymbolMetadata initedMetadata() {
        if (this.metadata == null) {
            this.metadata = new SymbolMetadata(this);
        }
        return this.metadata;
    }

    public SymbolMetadata getMetadata() {
        return this.metadata;
    }

    public Symbol(Kinds.Kind kind, long flags, Name name, Type type, Symbol owner) {
        this.kind = kind;
        this.flags_field = flags;
        this.type = type;
        this.owner = owner;
        this.completer = Completer.NULL_COMPLETER;
        this.erasure_field = null;
        this.name = name;
    }

    @Override
    public int poolTag() {
        throw new AssertionError((Object)"Invalid pool entry");
    }

    public Symbol clone(Symbol newOwner) {
        throw new AssertionError();
    }

    public <R, P> R accept(Visitor<R, P> v, P p) {
        return v.visitSymbol(this, p);
    }

    public String toString() {
        return this.name.toString();
    }

    public Symbol location() {
        if (this.owner.name == null || this.owner.name.isEmpty() && (this.owner.flags() & 0x100000L) == 0L && this.owner.kind != Kinds.Kind.PCK && this.owner.kind != Kinds.Kind.TYP) {
            return null;
        }
        return this.owner;
    }

    public Symbol location(Type site, Types types) {
        Type ownertype;
        if (this.owner.name == null || this.owner.name.isEmpty()) {
            return this.location();
        }
        if (this.owner.type.hasTag(TypeTag.CLASS) && (ownertype = types.asOuterSuper(site, this.owner)) != null) {
            return ownertype.tsym;
        }
        return this.owner;
    }

    public Symbol baseSymbol() {
        return this;
    }

    public Type erasure(Types types) {
        if (this.erasure_field == null) {
            this.erasure_field = types.erasure(this.type);
        }
        return this.erasure_field;
    }

    public Type externalType(Types types) {
        Type t = this.erasure(types);
        if (this.name == this.name.table.names.init && this.owner.hasOuterInstance()) {
            Type outerThisType = types.erasure(this.owner.type.getEnclosingType());
            return new Type.MethodType(t.getParameterTypes().prepend(outerThisType), t.getReturnType(), t.getThrownTypes(), t.tsym);
        }
        return t;
    }

    public boolean isDeprecated() {
        return (this.flags_field & 0x20000L) != 0L;
    }

    public boolean hasDeprecatedAnnotation() {
        return (this.flags_field & 0x40000000000000L) != 0L;
    }

    public boolean isDeprecatedForRemoval() {
        return (this.flags_field & 0x80000000000000L) != 0L;
    }

    public boolean isPreviewApi() {
        return (this.flags_field & 0x100000000000000L) != 0L;
    }

    public boolean isDeprecatableViaAnnotation() {
        switch (this.getKind()) {
            case LOCAL_VARIABLE: 
            case PACKAGE: 
            case PARAMETER: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                return false;
            }
        }
        return true;
    }

    public boolean isStatic() {
        return (this.flags() & 8L) != 0L || (this.owner.flags() & 0x200L) != 0L && this.kind != Kinds.Kind.MTH && this.name != this.name.table.names._this;
    }

    public boolean isInterface() {
        return (this.flags() & 0x200L) != 0L;
    }

    public boolean isAbstract() {
        return (this.flags_field & 0x400L) != 0L;
    }

    public boolean isPrivate() {
        return (this.flags_field & 7L) == 2L;
    }

    public boolean isPublic() {
        return (this.flags_field & 7L) == 1L;
    }

    public boolean isEnum() {
        return (this.flags() & 0x4000L) != 0L;
    }

    public boolean isSealed() {
        return (this.flags_field & 0x4000000000000000L) != 0L;
    }

    public boolean isNonSealed() {
        return (this.flags_field & Long.MIN_VALUE) != 0L;
    }

    public boolean isFinal() {
        return (this.flags_field & 0x10L) != 0L;
    }

    public boolean isDirectlyOrIndirectlyLocal() {
        return this.owner.kind.matches(Kinds.KindSelector.VAL_MTH) || this.owner.kind == Kinds.Kind.TYP && this.owner.isDirectlyOrIndirectlyLocal();
    }

    public boolean isAnonymous() {
        return this.name.isEmpty();
    }

    public boolean isConstructor() {
        return this.name == this.name.table.names.init;
    }

    public boolean isDynamic() {
        return false;
    }

    public Name getQualifiedName() {
        return this.name;
    }

    public Name flatName() {
        return this.getQualifiedName();
    }

    public Scope.WriteableScope members() {
        return null;
    }

    public boolean isInner() {
        return this.kind == Kinds.Kind.TYP && this.type.getEnclosingType().hasTag(TypeTag.CLASS);
    }

    public boolean hasOuterInstance() {
        return this.type.getEnclosingType().hasTag(TypeTag.CLASS) && (this.flags() & 0x400200L) == 0L;
    }

    public ClassSymbol enclClass() {
        Symbol c = this;
        while (!(c == null || c.kind.matches(Kinds.KindSelector.TYP) && c.type.hasTag(TypeTag.CLASS))) {
            c = c.owner;
        }
        return (ClassSymbol)c;
    }

    public ClassSymbol outermostClass() {
        Symbol sym = this;
        Symbol prev = null;
        while (sym.kind != Kinds.Kind.PCK) {
            prev = sym;
            sym = sym.owner;
        }
        return (ClassSymbol)prev;
    }

    public PackageSymbol packge() {
        Symbol sym = this;
        while (sym.kind != Kinds.Kind.PCK) {
            sym = sym.owner;
        }
        return (PackageSymbol)sym;
    }

    public boolean isSubClass(Symbol base, Types types) {
        throw new AssertionError((Object)("isSubClass " + this));
    }

    public boolean isMemberOf(TypeSymbol clazz, Types types) {
        return this.owner == clazz || clazz.isSubClass(this.owner, types) && this.isInheritedIn(clazz, types) && !this.hiddenIn((ClassSymbol)clazz, types);
    }

    public boolean isEnclosedBy(ClassSymbol clazz) {
        Symbol sym = this;
        while (sym.kind != Kinds.Kind.PCK) {
            if (sym == clazz) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }

    private boolean hiddenIn(ClassSymbol clazz, Types types) {
        Symbol sym = this.hiddenInInternal(clazz, types);
        Assert.check(sym != null, "the result of hiddenInInternal() can't be null");
        return sym != this;
    }

    private Symbol hiddenInInternal(ClassSymbol currentClass, Types types) {
        if (currentClass == this.owner) {
            return this;
        }
        for (Symbol sym : currentClass.members().getSymbolsByName(this.name)) {
            if (sym.kind != this.kind || this.kind == Kinds.Kind.MTH && ((sym.flags() & 8L) == 0L || !types.isSubSignature(sym.type, this.type))) continue;
            return sym;
        }
        Symbol hiddenSym = null;
        for (Type st : types.interfaces(currentClass.type).prepend(types.supertype(currentClass.type))) {
            if (st == null || !st.hasTag(TypeTag.CLASS)) continue;
            Symbol sym = this.hiddenInInternal((ClassSymbol)st.tsym, types);
            if (sym == this) {
                return this;
            }
            if (sym == null) continue;
            hiddenSym = sym;
        }
        return hiddenSym;
    }

    public final boolean isAccessibleIn(Symbol clazz, Types types) {
        switch ((int)(this.flags_field & 7L)) {
            default: {
                return true;
            }
            case 2: {
                return this.owner == clazz;
            }
            case 4: {
                return (clazz.flags() & 0x200L) == 0L;
            }
            case 0: 
        }
        PackageSymbol thisPackage = this.packge();
        Symbol sup = clazz;
        while (sup != null && sup != this.owner) {
            while (sup.type.hasTag(TypeTag.TYPEVAR)) {
                sup = sup.type.getUpperBound().tsym;
            }
            if (sup.type.isErroneous()) {
                return true;
            }
            if ((sup.flags() & 0x1000000L) == 0L && sup.packge() != thisPackage) {
                return false;
            }
            sup = types.supertype((Type)sup.type).tsym;
        }
        return (clazz.flags() & 0x200L) == 0L;
    }

    public boolean isInheritedIn(Symbol clazz, Types types) {
        return this.isAccessibleIn(clazz, types);
    }

    public Symbol asMemberOf(Type site, Types types) {
        throw new AssertionError();
    }

    public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult) {
        return false;
    }

    public void complete() throws CompletionFailure {
        if (this.completer != Completer.NULL_COMPLETER) {
            Completer c = this.completer;
            this.completer = Completer.NULL_COMPLETER;
            c.complete(this);
        }
    }

    public void apiComplete() throws CompletionFailure {
        try {
            this.complete();
        }
        catch (CompletionFailure cf) {
            cf.dcfh.handleAPICompletionFailure(cf);
        }
    }

    public boolean exists() {
        return true;
    }

    @Override
    public Type asType() {
        return this.type;
    }

    @Override
    public Symbol getEnclosingElement() {
        return this.owner;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        this.apiComplete();
        return Flags.asModifierSet(this.flags());
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    @Override
    public List<Attribute.Compound> getAnnotationMirrors() {
        this.apiComplete();
        return this.getRawAttributes();
    }

    public java.util.List<Symbol> getEnclosedElements() {
        return List.nil();
    }

    public List<TypeVariableSymbol> getTypeParameters() {
        ListBuffer<TypeVariableSymbol> l = new ListBuffer<TypeVariableSymbol>();
        for (Type t : this.type.getTypeArguments()) {
            Assert.check(t.tsym.getKind() == ElementKind.TYPE_PARAMETER);
            l.append((TypeVariableSymbol)t.tsym);
        }
        return l.toList();
    }

    public static abstract class TypeSymbol
    extends Symbol {
        public TypeSymbol(Kinds.Kind kind, long flags, Name name, Type type, Symbol owner) {
            super(kind, flags, name, type, owner);
        }

        public static Name formFullName(Name name, Symbol owner) {
            if (owner == null) {
                return name;
            }
            if (owner.kind != Kinds.Kind.ERR && (owner.kind.matches(Kinds.KindSelector.VAL_MTH) || owner.kind == Kinds.Kind.TYP && owner.type.hasTag(TypeTag.TYPEVAR))) {
                return name;
            }
            Name prefix = owner.getQualifiedName();
            if (prefix == null || prefix == prefix.table.names.empty) {
                return name;
            }
            return prefix.append('.', name);
        }

        public static Name formFlatName(Name name, Symbol owner) {
            if (owner == null || owner.kind.matches(Kinds.KindSelector.VAL_MTH) || owner.kind == Kinds.Kind.TYP && owner.type.hasTag(TypeTag.TYPEVAR)) {
                return name;
            }
            char sep = owner.kind == Kinds.Kind.TYP ? (char)'$' : '.';
            Name prefix = owner.flatName();
            if (prefix == null || prefix == prefix.table.names.empty) {
                return name;
            }
            return prefix.append(sep, name);
        }

        public final boolean precedes(TypeSymbol that, Types types) {
            if (this == that) {
                return false;
            }
            if (this.type.hasTag(that.type.getTag())) {
                if (this.type.hasTag(TypeTag.CLASS)) {
                    return types.rank(that.type) < types.rank(this.type) || types.rank(that.type) == types.rank(this.type) && that.getQualifiedName().compareTo(this.getQualifiedName()) < 0;
                }
                if (this.type.hasTag(TypeTag.TYPEVAR)) {
                    return types.isSubtype(this.type, that.type);
                }
            }
            return this.type.hasTag(TypeTag.TYPEVAR);
        }

        public List<Symbol> getEnclosedElements() {
            List<Symbol> list = List.nil();
            if (this.kind == Kinds.Kind.TYP && this.type.hasTag(TypeTag.TYPEVAR)) {
                return list;
            }
            this.apiComplete();
            for (Symbol sym : this.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                sym.apiComplete();
                if ((sym.flags() & 0x1000L) != 0L || sym.owner != this || sym.kind == Kinds.Kind.ERR) continue;
                list = list.prepend(sym);
            }
            return list;
        }

        public Annotate.AnnotationTypeMetadata getAnnotationTypeMetadata() {
            Assert.error("Only on ClassSymbol");
            return null;
        }

        public boolean isAnnotationType() {
            return false;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitTypeSymbol(this, p);
        }
    }

    public static interface Completer {
        public static final Completer NULL_COMPLETER = new Completer(){

            @Override
            public void complete(Symbol sym) {
            }

            @Override
            public boolean isTerminal() {
                return true;
            }
        };

        public void complete(Symbol var1) throws CompletionFailure;

        default public boolean isTerminal() {
            return false;
        }
    }

    public static interface Visitor<R, P> {
        public R visitClassSymbol(ClassSymbol var1, P var2);

        public R visitMethodSymbol(MethodSymbol var1, P var2);

        public R visitPackageSymbol(PackageSymbol var1, P var2);

        public R visitOperatorSymbol(OperatorSymbol var1, P var2);

        public R visitVarSymbol(VarSymbol var1, P var2);

        public R visitTypeSymbol(TypeSymbol var1, P var2);

        public R visitSymbol(Symbol var1, P var2);
    }

    public static class ClassSymbol
    extends TypeSymbol
    implements TypeElement {
        public Scope.WriteableScope members_field = null;
        public Name fullname;
        public Name flatname;
        public JavaFileObject sourcefile;
        public JavaFileObject classfile;
        public List<ClassSymbol> trans_local;
        private Annotate.AnnotationTypeMetadata annotationTypeMetadata;
        private List<RecordComponent> recordComponents = List.nil();
        public List<Symbol> permitted;
        public boolean isPermittedExplicit = false;

        public ClassSymbol(long flags, Name name, Type type, Symbol owner) {
            super(Kinds.Kind.TYP, flags, name, type, owner);
            this.fullname = ClassSymbol.formFullName(name, owner);
            this.flatname = ClassSymbol.formFlatName(name, owner);
            this.sourcefile = null;
            this.classfile = null;
            this.annotationTypeMetadata = Annotate.AnnotationTypeMetadata.notAnAnnotationType();
            this.permitted = List.nil();
        }

        public ClassSymbol(long flags, Name name, Symbol owner) {
            this(flags, name, new Type.ClassType(Type.noType, null, null), owner);
            this.type.tsym = this;
        }

        @Override
        public String toString() {
            return this.className();
        }

        @Override
        public long flags() {
            this.complete();
            return this.flags_field;
        }

        @Override
        public Scope.WriteableScope members() {
            this.complete();
            return this.members_field;
        }

        @Override
        public List<Attribute.Compound> getRawAttributes() {
            this.complete();
            return super.getRawAttributes();
        }

        @Override
        public List<Attribute.TypeCompound> getRawTypeAttributes() {
            this.complete();
            return super.getRawTypeAttributes();
        }

        @Override
        public Type erasure(Types types) {
            if (this.erasure_field == null) {
                this.erasure_field = new Type.ClassType(types.erasure(this.type.getEnclosingType()), List.nil(), this, this.type.getMetadata());
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.isEmpty()) {
                return Log.getLocalizedString("anonymous.class", this.flatname);
            }
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public List<Symbol> getEnclosedElements() {
            List<RecordComponent> result = super.getEnclosedElements();
            if (!this.recordComponents.isEmpty()) {
                List<RecordComponent> reversed = this.recordComponents.reverse();
                for (RecordComponent rc : reversed) {
                    result = result.prepend(rc);
                }
            }
            return result;
        }

        @Override
        public Name flatName() {
            return this.flatname;
        }

        @Override
        public boolean isSubClass(Symbol base, Types types) {
            if (this == base) {
                return true;
            }
            if ((base.flags() & 0x200L) != 0L) {
                Type t = this.type;
                while (t.hasTag(TypeTag.CLASS)) {
                    List<Type> is = types.interfaces(t);
                    while (is.nonEmpty()) {
                        if (((Type)is.head).tsym.isSubClass(base, types)) {
                            return true;
                        }
                        is = is.tail;
                    }
                    t = types.supertype(t);
                }
            } else {
                Type t = this.type;
                while (t.hasTag(TypeTag.CLASS)) {
                    if (t.tsym == base) {
                        return true;
                    }
                    t = types.supertype(t);
                }
            }
            return false;
        }

        @Override
        public void complete() throws CompletionFailure {
            Completer origCompleter = this.completer;
            try {
                super.complete();
            }
            catch (CompletionFailure ex) {
                ex.dcfh.classSymbolCompleteFailed(this, origCompleter);
                this.flags_field |= 9L;
                this.type = new Type.ErrorType(this, Type.noType);
                throw ex;
            }
        }

        public List<Type> getInterfaces() {
            this.apiComplete();
            Type type = this.type;
            if (type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)type;
                if (classType.interfaces_field == null) {
                    classType.interfaces_field = List.nil();
                }
                if (classType.all_interfaces_field != null) {
                    return Type.getModelTypes(classType.all_interfaces_field);
                }
                return classType.interfaces_field;
            }
            return List.nil();
        }

        @Override
        public Type getSuperclass() {
            this.apiComplete();
            Type type = this.type;
            if (type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)type;
                if (classType.supertype_field == null) {
                    classType.supertype_field = Type.noType;
                }
                return classType.isInterface() ? Type.noType : classType.supertype_field.getModelType();
            }
            return Type.noType;
        }

        private ClassSymbol getSuperClassToSearchForAnnotations() {
            Type sup = this.getSuperclass();
            if (!sup.hasTag(TypeTag.CLASS) || sup.isErroneous()) {
                return null;
            }
            return (ClassSymbol)sup.tsym;
        }

        @Override
        protected <A extends Annotation> A[] getInheritedAnnotations(Class<A> annoType) {
            ClassSymbol sup = this.getSuperClassToSearchForAnnotations();
            return sup == null ? super.getInheritedAnnotations(annoType) : sup.getAnnotationsByType(annoType);
        }

        @Override
        public ElementKind getKind() {
            this.apiComplete();
            long flags = this.flags();
            if ((flags & 0x2000L) != 0L) {
                return ElementKind.ANNOTATION_TYPE;
            }
            if ((flags & 0x200L) != 0L) {
                return ElementKind.INTERFACE;
            }
            if ((flags & 0x4000L) != 0L) {
                return ElementKind.ENUM;
            }
            if ((flags & 0x2000000000000000L) != 0L) {
                return ElementKind.RECORD;
            }
            return ElementKind.CLASS;
        }

        @Override
        public Set<Modifier> getModifiers() {
            this.apiComplete();
            long flags = this.flags();
            return Flags.asModifierSet(flags & 0xFFFFF7FFFFFFFFFFL);
        }

        public RecordComponent getRecordComponent(VarSymbol field) {
            for (RecordComponent rc : this.recordComponents) {
                if (rc.name != field.name) continue;
                return rc;
            }
            return null;
        }

        public RecordComponent getRecordComponent(JCTree.JCVariableDecl var, boolean addIfMissing, List<JCTree.JCAnnotation> annotations) {
            for (RecordComponent rc : this.recordComponents) {
                if (rc.name != var.name || var.pos != rc.pos) continue;
                return rc;
            }
            RecordComponent rc = null;
            if (addIfMissing) {
                rc = new RecordComponent(var.sym, annotations);
                this.recordComponents = this.recordComponents.append(rc);
            }
            return rc;
        }

        public List<? extends RecordComponent> getRecordComponents() {
            return this.recordComponents;
        }

        public void setRecordComponents(List<RecordComponent> recordComponents) {
            this.recordComponents = recordComponents;
        }

        @Override
        public NestingKind getNestingKind() {
            this.apiComplete();
            if (this.owner.kind == Kinds.Kind.PCK) {
                return NestingKind.TOP_LEVEL;
            }
            if (this.name.isEmpty()) {
                return NestingKind.ANONYMOUS;
            }
            if (this.owner.kind == Kinds.Kind.MTH) {
                return NestingKind.LOCAL;
            }
            return NestingKind.MEMBER;
        }

        @Override
        protected <A extends Annotation> Attribute.Compound getAttribute(Class<A> annoType) {
            Attribute.Compound attrib = super.getAttribute(annoType);
            boolean inherited = annoType.isAnnotationPresent(Inherited.class);
            if (attrib != null || !inherited) {
                return attrib;
            }
            ClassSymbol superType = this.getSuperClassToSearchForAnnotations();
            return superType == null ? null : superType.getAttribute(annoType);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitType(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitClassSymbol(this, p);
        }

        public void markAbstractIfNeeded(Types types) {
            if (types.enter.getEnv(this) != null && (this.flags() & 0x4000L) != 0L && types.supertype((Type)this.type).tsym == types.syms.enumSym && (this.flags() & 0x410L) == 0L && types.firstUnimplementedAbstract(this) != null) {
                this.flags_field |= 0x400L;
            }
        }

        public void reset() {
            this.kind = Kinds.Kind.TYP;
            this.erasure_field = null;
            this.members_field = null;
            this.flags_field = 0L;
            Type type = this.type;
            if (type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)type;
                classType.setEnclosingType(Type.noType);
                classType.rank_field = -1;
                classType.typarams_field = null;
                classType.allparams_field = null;
                classType.supertype_field = null;
                classType.interfaces_field = null;
                classType.all_interfaces_field = null;
            }
            this.clearAnnotationMetadata();
        }

        public void clearAnnotationMetadata() {
            this.metadata = null;
            this.annotationTypeMetadata = Annotate.AnnotationTypeMetadata.notAnAnnotationType();
        }

        @Override
        public Annotate.AnnotationTypeMetadata getAnnotationTypeMetadata() {
            return this.annotationTypeMetadata;
        }

        @Override
        public boolean isAnnotationType() {
            return (this.flags_field & 0x2000L) != 0L;
        }

        public void setAnnotationTypeMetadata(Annotate.AnnotationTypeMetadata a) {
            Assert.checkNonNull(a);
            Assert.check(!this.annotationTypeMetadata.isMetadataForAnnotationType());
            this.annotationTypeMetadata = a;
        }

        public boolean isRecord() {
            return (this.flags_field & 0x2000000000000000L) != 0L;
        }

        public List<Type> getPermittedSubclasses() {
            return this.permitted.map(s -> s.type);
        }
    }

    public static class PackageSymbol
    extends TypeSymbol
    implements PackageElement {
        public Scope.WriteableScope members_field = null;
        public Name fullname;
        public ClassSymbol package_info;
        public ModuleSymbol modle;
        public JavaFileObject sourcefile;

        public PackageSymbol(Name name, Type type, Symbol owner) {
            super(Kinds.Kind.PCK, 0L, name, type, owner);
            this.fullname = PackageSymbol.formFullName(name, owner);
        }

        public PackageSymbol(Name name, Symbol owner) {
            this(name, null, owner);
            this.type = new Type.PackageType(this);
        }

        @Override
        public String toString() {
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public boolean isUnnamed() {
            return this.name.isEmpty() && this.owner != null;
        }

        @Override
        public Scope.WriteableScope members() {
            this.complete();
            return this.members_field;
        }

        @Override
        public int poolTag() {
            return 20;
        }

        @Override
        public long flags() {
            this.complete();
            return this.flags_field;
        }

        @Override
        public List<Attribute.Compound> getRawAttributes() {
            this.complete();
            if (this.package_info != null) {
                this.package_info.complete();
                this.mergeAttributes();
            }
            return super.getRawAttributes();
        }

        private void mergeAttributes() {
            if (this.metadata == null && this.package_info.metadata != null) {
                this.metadata = new SymbolMetadata(this);
                this.metadata.setAttributes(this.package_info.metadata);
            }
        }

        @Override
        public boolean exists() {
            return (this.flags_field & 0x800000L) != 0L;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public Symbol getEnclosingElement() {
            return this.modle != null && !this.modle.isNoModule() ? this.modle : null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitPackageSymbol(this, p);
        }

        public void reset() {
            this.metadata = null;
        }
    }

    public static class CompletionFailure
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        public final transient DeferredCompletionFailureHandler dcfh;
        public transient Symbol sym;
        private transient JCDiagnostic diag;
        private transient Supplier<JCDiagnostic> diagSupplier;

        public CompletionFailure(Symbol sym, Supplier<JCDiagnostic> diagSupplier, DeferredCompletionFailureHandler dcfh) {
            this.dcfh = dcfh;
            this.sym = sym;
            this.diagSupplier = diagSupplier;
        }

        public JCDiagnostic getDiagnostic() {
            if (this.diag == null && this.diagSupplier != null) {
                this.diag = this.diagSupplier.get();
            }
            return this.diag;
        }

        @Override
        public String getMessage() {
            return this.getDiagnostic().getMessage(null);
        }

        public JCDiagnostic getDetailValue() {
            return this.getDiagnostic();
        }

        @Override
        public CompletionFailure initCause(Throwable cause) {
            super.initCause(cause);
            return this;
        }

        public void resetDiagnostic(Supplier<JCDiagnostic> diagSupplier) {
            this.diagSupplier = diagSupplier;
            this.diag = null;
        }
    }

    public static class TypeVariableSymbol
    extends TypeSymbol
    implements TypeParameterElement {
        public TypeVariableSymbol(long flags, Name name, Type type, Symbol owner) {
            super(Kinds.Kind.TYP, flags, name, type, owner);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.TYPE_PARAMETER;
        }

        @Override
        public Symbol getGenericElement() {
            return this.owner;
        }

        public List<Type> getBounds() {
            Type.TypeVar t = (Type.TypeVar)this.type;
            Type bound = t.getUpperBound();
            if (!bound.isCompound()) {
                return List.of(bound);
            }
            Type.ClassType ct = (Type.ClassType)bound;
            if (!ct.tsym.erasure_field.isInterface()) {
                return ct.interfaces_field.prepend(ct.supertype_field);
            }
            return ct.interfaces_field;
        }

        @Override
        public List<Attribute.Compound> getAnnotationMirrors() {
            List<Attribute.TypeCompound> candidates = this.owner.getRawTypeAttributes();
            int index = this.owner.getTypeParameters().indexOf(this);
            List<Attribute.TypeCompound> res = List.nil();
            for (Attribute.TypeCompound a : candidates) {
                if (!this.isCurrentSymbolsAnnotation(a, index)) continue;
                res = res.prepend(a);
            }
            return res.reverse();
        }

        @Override
        public <A extends Annotation> Attribute.Compound getAttribute(Class<A> annoType) {
            String name = annoType.getName();
            List<Attribute.TypeCompound> candidates = this.owner.getRawTypeAttributes();
            int index = this.owner.getTypeParameters().indexOf(this);
            for (Attribute.TypeCompound anno : candidates) {
                if (!this.isCurrentSymbolsAnnotation(anno, index) || !name.contentEquals(anno.type.tsym.flatName())) continue;
                return anno;
            }
            return null;
        }

        boolean isCurrentSymbolsAnnotation(Attribute.TypeCompound anno, int index) {
            return (anno.position.type == TargetType.CLASS_TYPE_PARAMETER || anno.position.type == TargetType.METHOD_TYPE_PARAMETER) && anno.position.parameter_index == index;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitTypeParameter(this, p);
        }
    }

    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;
        private int accessCode = Integer.MIN_VALUE;

        public OperatorSymbol(Name name, Type type, int opcode, Symbol owner) {
            super(9L, name, type, owner);
            this.opcode = opcode;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitOperatorSymbol(this, p);
        }

        public int getAccessCode(JCTree.Tag tag) {
            if (this.accessCode != Integer.MIN_VALUE && !tag.isIncOrDecUnaryOp()) {
                return this.accessCode;
            }
            this.accessCode = AccessCode.from(tag, this.opcode);
            return this.accessCode;
        }

        public static enum AccessCode {
            UNKNOWN(-1, JCTree.Tag.NO_TAG),
            DEREF(0, JCTree.Tag.NO_TAG),
            ASSIGN(2, JCTree.Tag.ASSIGN),
            PREINC(4, JCTree.Tag.PREINC),
            PREDEC(6, JCTree.Tag.PREDEC),
            POSTINC(8, JCTree.Tag.POSTINC),
            POSTDEC(10, JCTree.Tag.POSTDEC),
            FIRSTASGOP(12, JCTree.Tag.NO_TAG);

            public final int code;
            public final JCTree.Tag tag;
            public static final int numberOfAccessCodes;

            private AccessCode(int code, JCTree.Tag tag) {
                this.code = code;
                this.tag = tag;
            }

            public static AccessCode getFromCode(int code) {
                for (AccessCode aCodes : AccessCode.values()) {
                    if (aCodes.code != code) continue;
                    return aCodes;
                }
                return UNKNOWN;
            }

            static int from(JCTree.Tag tag, int opcode) {
                switch (tag) {
                    case PREINC: {
                        return AccessCode.PREINC.code;
                    }
                    case PREDEC: {
                        return AccessCode.PREDEC.code;
                    }
                    case POSTINC: {
                        return AccessCode.POSTINC.code;
                    }
                    case POSTDEC: {
                        return AccessCode.POSTDEC.code;
                    }
                }
                if (96 <= opcode && opcode <= 131) {
                    return (opcode - 96) * 2 + AccessCode.FIRSTASGOP.code;
                }
                if (opcode == 256) {
                    return 72 + AccessCode.FIRSTASGOP.code;
                }
                if (270 <= opcode && opcode <= 275) {
                    return (opcode - 270 + 131 + 2 - 96) * 2 + AccessCode.FIRSTASGOP.code;
                }
                return -1;
            }

            static {
                numberOfAccessCodes = 84 + AccessCode.FIRSTASGOP.code + 2;
            }
        }
    }

    public static class MethodHandleSymbol
    extends MethodSymbol
    implements PoolConstant.LoadableConstant {
        private Symbol refSym;
        private boolean getter;

        public MethodHandleSymbol(Symbol msym) {
            this(msym, false);
        }

        public MethodHandleSymbol(Symbol msym, boolean getter) {
            super(msym.flags_field, msym.name, msym.type, msym.owner);
            this.refSym = msym;
            this.getter = getter;
        }

        public int referenceKind() {
            if (this.refSym.kind == Kinds.Kind.VAR) {
                return this.getter ? (this.refSym.isStatic() ? 2 : 1) : (this.refSym.isStatic() ? 4 : 3);
            }
            if (this.refSym.isConstructor()) {
                return 8;
            }
            if (this.refSym.isStatic()) {
                return 6;
            }
            if ((this.refSym.flags() & 2L) != 0L && !this.allowPrivateInvokeVirtual()) {
                return 7;
            }
            if (this.refSym.enclClass().isInterface()) {
                return 9;
            }
            return 5;
        }

        private boolean allowPrivateInvokeVirtual() {
            Symbol rootPack = this;
            while (rootPack != null && !(rootPack instanceof RootPackageSymbol)) {
                rootPack = rootPack.owner;
            }
            return rootPack != null && ((RootPackageSymbol)rootPack).allowPrivateInvokeVirtual;
        }

        @Override
        public int poolTag() {
            return 15;
        }

        @Override
        public Object poolKey(Types types) {
            return new Pair<Symbol, Integer>(this.baseSymbol(), this.referenceKind());
        }

        @Override
        public MethodHandleSymbol asHandle() {
            return this;
        }

        @Override
        public Symbol baseSymbol() {
            return this.refSym;
        }

        @Override
        public boolean isHandle() {
            return true;
        }
    }

    public static class DynamicVarSymbol
    extends VarSymbol
    implements PoolConstant.Dynamic,
    PoolConstant.LoadableConstant {
        public PoolConstant.LoadableConstant[] staticArgs;
        public MethodHandleSymbol bsm;

        public DynamicVarSymbol(Name name, Symbol owner, MethodHandleSymbol bsm, Type type, PoolConstant.LoadableConstant[] staticArgs) {
            super(0L, name, type, owner);
            this.bsm = bsm;
            this.staticArgs = staticArgs;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public PoolConstant dynamicType() {
            return this.type;
        }

        @Override
        public PoolConstant.LoadableConstant[] staticArgs() {
            return this.staticArgs;
        }

        @Override
        public PoolConstant.LoadableConstant bootstrapMethod() {
            return this.bsm;
        }

        @Override
        public int poolTag() {
            return 17;
        }
    }

    public static class DynamicMethodSymbol
    extends MethodSymbol
    implements PoolConstant.Dynamic {
        public PoolConstant.LoadableConstant[] staticArgs;
        public MethodHandleSymbol bsm;

        public DynamicMethodSymbol(Name name, Symbol owner, MethodHandleSymbol bsm, Type type, PoolConstant.LoadableConstant[] staticArgs) {
            super(0L, name, type, owner);
            this.bsm = bsm;
            this.staticArgs = staticArgs;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }

        @Override
        public PoolConstant.LoadableConstant[] staticArgs() {
            return this.staticArgs;
        }

        @Override
        public MethodHandleSymbol bootstrapMethod() {
            return this.bsm;
        }

        @Override
        public int poolTag() {
            return 18;
        }

        @Override
        public Type dynamicType() {
            return this.type;
        }
    }

    public static class MethodSymbol
    extends Symbol
    implements ExecutableElement {
        public Code code = null;
        public List<VarSymbol> extraParams = List.nil();
        public List<VarSymbol> capturedLocals = List.nil();
        public List<VarSymbol> params = null;
        public Attribute defaultValue = null;
        public static final Predicate<Symbol> implementation_filter = s -> s.kind == Kinds.Kind.MTH && (s.flags() & 0x1000L) == 0L;

        public MethodSymbol(long flags, Name name, Type type, Symbol owner) {
            super(Kinds.Kind.MTH, flags, name, type, owner);
            if (owner.type.hasTag(TypeTag.TYPEVAR)) {
                Assert.error(owner + "." + name);
            }
        }

        @Override
        public MethodSymbol clone(final Symbol newOwner) {
            MethodSymbol m = new MethodSymbol(this.flags_field, this.name, this.type, newOwner){

                @Override
                public Symbol baseSymbol() {
                    return this;
                }

                @Override
                public Object poolKey(Types types) {
                    return new Pair<Symbol, Symbol>(newOwner, this.baseSymbol());
                }
            };
            m.code = this.code;
            return m;
        }

        @Override
        public Set<Modifier> getModifiers() {
            long flags = this.flags();
            return Flags.asModifierSet((flags & 0x80000000000L) != 0L ? flags & 0xFFFFFFFFFFFFFBFFL : flags);
        }

        @Override
        public String toString() {
            String s;
            if ((this.flags() & 0x100000L) != 0L) {
                return this.owner.name.toString();
            }
            String string = s = this.name == this.name.table.names.init ? this.owner.name.toString() : this.name.toString();
            if (this.type != null) {
                if (this.type.hasTag(TypeTag.FORALL)) {
                    s = "<" + ((Type.ForAll)this.type).getTypeArguments() + ">" + s;
                }
                s = s + "(" + this.type.argtypes((this.flags() & 0x400000000L) != 0L) + ")";
            }
            return s;
        }

        @Override
        public int poolTag() {
            return this.owner.isInterface() ? 11 : 10;
        }

        public boolean isHandle() {
            return false;
        }

        public MethodHandleSymbol asHandle() {
            return new MethodHandleSymbol(this);
        }

        public Symbol implemented(TypeSymbol c, Types types) {
            Symbol impl = null;
            List<Type> is = types.interfaces(c.type);
            while (impl == null && is.nonEmpty()) {
                TypeSymbol i = ((Type)is.head).tsym;
                impl = this.implementedIn(i, types);
                if (impl == null) {
                    impl = this.implemented(i, types);
                }
                is = is.tail;
            }
            return impl;
        }

        public Symbol implementedIn(TypeSymbol c, Types types) {
            Symbol impl = null;
            for (Symbol sym : c.members().getSymbolsByName(this.name)) {
                if (!this.overrides(sym, (TypeSymbol)this.owner, types, true) || !types.isSameType(this.type.getReturnType(), types.memberType(this.owner.type, sym).getReturnType())) continue;
                impl = sym;
            }
            return impl;
        }

        public boolean binaryOverrides(Symbol _other, TypeSymbol origin, Types types) {
            if (this.isConstructor() || _other.kind != Kinds.Kind.MTH) {
                return false;
            }
            if (this == _other) {
                return true;
            }
            MethodSymbol other = (MethodSymbol)_other;
            if (other.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, other.owner) != null && types.isSameType(this.erasure(types), other.erasure(types))) {
                return true;
            }
            return (this.flags() & 0x400L) == 0L && other.isOverridableIn(origin) && this.isMemberOf(origin, types) && types.isSameType(this.erasure(types), other.erasure(types));
        }

        public MethodSymbol binaryImplementation(ClassSymbol origin, Types types) {
            TypeSymbol c = origin;
            while (c != null) {
                for (Symbol sym : ((Symbol)c).members().getSymbolsByName(this.name)) {
                    if (sym.kind != Kinds.Kind.MTH || !((MethodSymbol)sym).binaryOverrides(this, origin, types)) continue;
                    return (MethodSymbol)sym;
                }
                c = types.supertype((Type)c.type).tsym;
            }
            return null;
        }

        @Override
        public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult) {
            return this.overrides(_other, origin, types, checkResult, true);
        }

        public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult, boolean requireConcreteIfInherited) {
            Type ot;
            Type mt;
            if (this.isConstructor() || _other.kind != Kinds.Kind.MTH) {
                return false;
            }
            if (this == _other) {
                return true;
            }
            MethodSymbol other = (MethodSymbol)_other;
            if (other.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, other.owner) != null && types.isSubSignature(mt = types.memberType(this.owner.type, this), ot = types.memberType(this.owner.type, other))) {
                if (!checkResult) {
                    return true;
                }
                if (types.returnTypeSubstitutable(mt, ot)) {
                    return true;
                }
            }
            if ((this.flags() & 0x400L) != 0L && requireConcreteIfInherited || (other.flags() & 0x400L) == 0L && (other.flags() & 0x80000000000L) == 0L || !other.isOverridableIn(origin) || !this.isMemberOf(origin, types)) {
                return false;
            }
            mt = types.memberType(origin.type, this);
            return types.isSubSignature(mt, ot = types.memberType(origin.type, other)) && (!checkResult || types.resultSubtype(mt, ot, types.noWarnings));
        }

        private boolean isOverridableIn(TypeSymbol origin) {
            switch ((int)(this.flags_field & 7L)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return !this.owner.isInterface() || (this.flags_field & 8L) == 0L;
                }
                case 4: {
                    return (origin.flags() & 0x200L) == 0L;
                }
                case 0: {
                    return this.packge() == origin.packge() && (origin.flags() & 0x200L) == 0L;
                }
            }
            return false;
        }

        @Override
        public boolean isInheritedIn(Symbol clazz, Types types) {
            switch ((int)(this.flags_field & 7L)) {
                case 1: {
                    return !this.owner.isInterface() || clazz == this.owner || (this.flags_field & 8L) == 0L;
                }
            }
            return super.isInheritedIn(clazz, types);
        }

        public boolean isLambdaMethod() {
            return (this.flags() & 0x2000000000000L) == 0x2000000000000L;
        }

        public MethodSymbol originalEnclosingMethod() {
            return this;
        }

        public MethodSymbol implementation(TypeSymbol origin, Types types, boolean checkResult) {
            return this.implementation(origin, types, checkResult, implementation_filter);
        }

        public MethodSymbol implementation(TypeSymbol origin, Types types, boolean checkResult, Predicate<Symbol> implFilter) {
            MethodSymbol res = types.implementation(this, origin, checkResult, implFilter);
            if (res != null) {
                return res;
            }
            if (types.isDerivedRaw(origin.type) && !origin.isInterface()) {
                return this.implementation(types.supertype((Type)origin.type).tsym, types, checkResult);
            }
            return null;
        }

        public List<VarSymbol> params() {
            this.owner.complete();
            if (this.params == null) {
                ListBuffer<VarSymbol> newParams = new ListBuffer<VarSymbol>();
                int i = 0;
                for (Type t : this.type.getParameterTypes()) {
                    Name paramName = this.name.table.fromString("arg" + i);
                    VarSymbol param = new VarSymbol(0x200000000L, paramName, t, this);
                    newParams.append(param);
                    ++i;
                }
                this.params = newParams.toList();
            }
            Assert.checkNonNull(this.params);
            return this.params;
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return new MethodSymbol(this.flags_field, this.name, types.memberType(site, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            if (this.name == this.name.table.names.init) {
                return ElementKind.CONSTRUCTOR;
            }
            if (this.name == this.name.table.names.clinit) {
                return ElementKind.STATIC_INIT;
            }
            if ((this.flags() & 0x100000L) != 0L) {
                return this.isStatic() ? ElementKind.STATIC_INIT : ElementKind.INSTANCE_INIT;
            }
            return ElementKind.METHOD;
        }

        public boolean isStaticOrInstanceInit() {
            return this.getKind() == ElementKind.STATIC_INIT || this.getKind() == ElementKind.INSTANCE_INIT;
        }

        @Override
        public Attribute getDefaultValue() {
            return this.defaultValue;
        }

        public List<VarSymbol> getParameters() {
            return this.params();
        }

        @Override
        public boolean isVarArgs() {
            return (this.flags() & 0x400000000L) != 0L;
        }

        @Override
        public boolean isDefault() {
            return (this.flags() & 0x80000000000L) != 0L;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitMethodSymbol(this, p);
        }

        @Override
        public Type getReceiverType() {
            Type result = ((Type)this.asType()).getReceiverType();
            return result == null ? Type.noType : result;
        }

        @Override
        public Type getReturnType() {
            return ((Type)this.asType()).getReturnType();
        }

        public List<Type> getThrownTypes() {
            return ((Type)this.asType()).getThrownTypes();
        }
    }

    public static class BindingSymbol
    extends VarSymbol {
        public BindingSymbol(long flags, Name name, Type type, Symbol owner) {
            super(flags | 0x40000L | 0x800000000000000L, name, type, owner);
        }

        public boolean isAliasFor(BindingSymbol b) {
            return this.aliases().containsAll(b.aliases());
        }

        List<BindingSymbol> aliases() {
            return List.of(this);
        }

        public void preserveBinding() {
            this.flags_field |= 0x1000000000000000L;
        }

        public boolean isPreserved() {
            return (this.flags_field & 0x1000000000000000L) != 0L;
        }
    }

    public static class ParamSymbol
    extends VarSymbol {
        public ParamSymbol(long flags, Name name, Type type, Symbol owner) {
            super(flags, name, type, owner);
        }

        @Override
        public Name getSimpleName() {
            if ((this.flags_field & 0x10000000000000L) == 0L) {
                Name inferredName;
                this.flags_field |= 0x10000000000000L;
                Symbol rootPack = this;
                while (rootPack != null && !(rootPack instanceof RootPackageSymbol)) {
                    rootPack = rootPack.owner;
                }
                if (rootPack != null && (inferredName = ((RootPackageSymbol)rootPack).missingInfoHandler.getParameterName(this)) != null) {
                    this.name = inferredName;
                }
            }
            return super.getSimpleName();
        }
    }

    public static class RecordComponent
    extends VarSymbol
    implements RecordComponentElement {
        public MethodSymbol accessor;
        public JCTree.JCMethodDecl accessorMeth;
        private final List<JCTree.JCAnnotation> originalAnnos;
        private final int pos;
        private final boolean isVarargs;

        public RecordComponent(Name name, Type type, Symbol owner) {
            super(1L, name, type, owner);
            this.pos = -1;
            this.originalAnnos = List.nil();
            this.isVarargs = false;
        }

        public RecordComponent(VarSymbol field, List<JCTree.JCAnnotation> annotations) {
            super(1L, field.name, field.type, field.owner);
            this.originalAnnos = annotations;
            this.pos = field.pos;
            this.isVarargs = this.type.hasTag(TypeTag.ARRAY) && ((Type.ArrayType)this.type).isVarargs();
        }

        public List<JCTree.JCAnnotation> getOriginalAnnos() {
            return this.originalAnnos;
        }

        public boolean isVarargs() {
            return this.isVarargs;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RECORD_COMPONENT;
        }

        @Override
        public ExecutableElement getAccessor() {
            return this.accessor;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitRecordComponent(this, p);
        }
    }

    public static class VarSymbol
    extends Symbol
    implements VariableElement {
        public int pos = -1;
        public int adr = -1;
        private Object data;

        public VarSymbol(long flags, Name name, Type type, Symbol owner) {
            super(Kinds.Kind.VAR, flags, name, type, owner);
        }

        @Override
        public int poolTag() {
            return 9;
        }

        public MethodHandleSymbol asMethodHandle(boolean getter) {
            return new MethodHandleSymbol(this, getter);
        }

        @Override
        public VarSymbol clone(final Symbol newOwner) {
            VarSymbol v = new VarSymbol(this.flags_field, this.name, this.type, newOwner){

                @Override
                public Symbol baseSymbol() {
                    return this;
                }

                @Override
                public Object poolKey(Types types) {
                    return new Pair<Symbol, Symbol>(newOwner, this.baseSymbol());
                }
            };
            v.pos = this.pos;
            v.adr = this.adr;
            v.data = this.data;
            return v;
        }

        @Override
        public String toString() {
            return this.name.toString();
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return new VarSymbol(this.flags_field, this.name, types.memberType(site, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            long flags = this.flags();
            if ((flags & 0x200000000L) != 0L) {
                if (this.isExceptionParameter()) {
                    return ElementKind.EXCEPTION_PARAMETER;
                }
                return ElementKind.PARAMETER;
            }
            if ((flags & 0x4000L) != 0L) {
                return ElementKind.ENUM_CONSTANT;
            }
            if (this.owner.kind == Kinds.Kind.TYP || this.owner.kind == Kinds.Kind.ERR) {
                return ElementKind.FIELD;
            }
            if (this.isResourceVariable()) {
                return ElementKind.RESOURCE_VARIABLE;
            }
            if ((flags & 0x800000000000000L) != 0L) {
                ElementKind kind = ElementKind.BINDING_VARIABLE;
                return kind;
            }
            return ElementKind.LOCAL_VARIABLE;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitVariable(this, p);
        }

        @Override
        public Object getConstantValue() {
            return Constants.decode(this.getConstValue(), this.type);
        }

        public void setLazyConstValue(Env<AttrContext> env, Attr attr, JCTree.JCVariableDecl variable) {
            this.setData(() -> attr.attribLazyConstantValue(env, variable, this.type));
        }

        public boolean isExceptionParameter() {
            return this.data == ElementKind.EXCEPTION_PARAMETER;
        }

        public boolean isResourceVariable() {
            return this.data == ElementKind.RESOURCE_VARIABLE;
        }

        public Object getConstValue() {
            if (this.data == ElementKind.EXCEPTION_PARAMETER || this.data == ElementKind.RESOURCE_VARIABLE) {
                return null;
            }
            Object object = this.data;
            if (object instanceof Callable) {
                Callable callableData = (Callable)object;
                this.data = null;
                try {
                    this.data = callableData.call();
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            return this.data;
        }

        public void setData(Object data) {
            Assert.check(!(data instanceof Env), this);
            this.data = data;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitVarSymbol(this, p);
        }
    }

    public static class RootPackageSymbol
    extends PackageSymbol {
        public final MissingInfoHandler missingInfoHandler;
        public final boolean allowPrivateInvokeVirtual;

        public RootPackageSymbol(Name name, Symbol owner, MissingInfoHandler missingInfoHandler, boolean allowPrivateInvokeVirtual) {
            super(name, owner);
            this.missingInfoHandler = missingInfoHandler;
            this.allowPrivateInvokeVirtual = allowPrivateInvokeVirtual;
        }
    }

    public static enum ModuleResolutionFlags {
        DO_NOT_RESOLVE_BY_DEFAULT(1),
        WARN_DEPRECATED(2),
        WARN_DEPRECATED_REMOVAL(4),
        WARN_INCUBATING(8);

        public final int value;

        public static int value(Set<ModuleResolutionFlags> s) {
            int v = 0;
            for (ModuleResolutionFlags f : s) {
                v |= f.value;
            }
            return v;
        }

        private ModuleResolutionFlags(int value) {
            this.value = value;
        }
    }

    public static enum ModuleFlags {
        OPEN(32),
        SYNTHETIC(4096),
        MANDATED(32768);

        public final int value;

        public static int value(Set<ModuleFlags> s) {
            int v = 0;
            for (ModuleFlags f : s) {
                v |= f.value;
            }
            return v;
        }

        private ModuleFlags(int value) {
            this.value = value;
        }
    }

    public static class ModuleSymbol
    extends TypeSymbol
    implements ModuleElement {
        public Name version;
        public JavaFileManager.Location sourceLocation;
        public JavaFileManager.Location classLocation;
        public JavaFileManager.Location patchLocation;
        public JavaFileManager.Location patchOutputLocation;
        public List<Directive> directives;
        public List<Directive.RequiresDirective> requires;
        public List<Directive.ExportsDirective> exports;
        public List<Directive.OpensDirective> opens;
        public List<Directive.ProvidesDirective> provides;
        public List<Directive.UsesDirective> uses;
        public ClassSymbol module_info;
        public PackageSymbol unnamedPackage;
        public Map<Name, PackageSymbol> visiblePackages;
        public Set<ModuleSymbol> readModules;
        public List<Symbol> enclosedPackages = List.nil();
        public Completer usesProvidesCompleter = Completer.NULL_COMPLETER;
        public final Set<ModuleFlags> flags = EnumSet.noneOf(ModuleFlags.class);
        public final Set<ModuleResolutionFlags> resolutionFlags = EnumSet.noneOf(ModuleResolutionFlags.class);

        public static ModuleSymbol create(Name name, Name module_info) {
            ModuleSymbol msym = new ModuleSymbol(name, null);
            ClassSymbol info = new ClassSymbol(0x8000000000000L, module_info, msym);
            info.flatname = info.fullname = ModuleSymbol.formFullName(module_info, msym);
            info.members_field = Scope.WriteableScope.create(info);
            msym.module_info = info;
            return msym;
        }

        public ModuleSymbol(Name name, Symbol owner) {
            super(Kinds.Kind.MDL, 0L, name, null, owner);
            Assert.checkNonNull(name);
            this.type = new Type.ModuleType(this);
        }

        @Override
        public int poolTag() {
            return 19;
        }

        @Override
        public Name getSimpleName() {
            return Convert.shortName(this.name);
        }

        @Override
        public boolean isOpen() {
            return this.flags.contains((Object)ModuleFlags.OPEN);
        }

        @Override
        public boolean isUnnamed() {
            return this.name.isEmpty() && this.owner == null;
        }

        @Override
        public boolean isDeprecated() {
            return this.hasDeprecatedAnnotation();
        }

        public boolean isNoModule() {
            return false;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.MODULE;
        }

        public java.util.List<ModuleElement.Directive> getDirectives() {
            this.apiComplete();
            this.completeUsesProvides();
            return Collections.unmodifiableList(this.directives);
        }

        public void completeUsesProvides() {
            if (this.usesProvidesCompleter != Completer.NULL_COMPLETER) {
                Completer c = this.usesProvidesCompleter;
                this.usesProvidesCompleter = Completer.NULL_COMPLETER;
                c.complete(this);
            }
        }

        @Override
        public ClassSymbol outermostClass() {
            return null;
        }

        @Override
        public String toString() {
            String n = this.name == null ? "<unknown>" : (this.name.isEmpty() ? "<unnamed>" : String.valueOf(this.name));
            return n;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitModule(this, p);
        }

        @Override
        public List<Symbol> getEnclosedElements() {
            List<Symbol> list = List.nil();
            for (Symbol sym : this.enclosedPackages) {
                if (!sym.members().anyMatch(m -> m.kind == Kinds.Kind.TYP)) continue;
                list = list.prepend(sym);
            }
            return list;
        }

        public void reset() {
            this.directives = null;
            this.requires = null;
            this.exports = null;
            this.provides = null;
            this.uses = null;
            this.visiblePackages = null;
        }
    }

    public static class DelegatedSymbol<T extends Symbol>
    extends Symbol {
        protected T other;

        public DelegatedSymbol(T other) {
            super(((Symbol)other).kind, ((Symbol)other).flags_field, ((Symbol)other).name, ((Symbol)other).type, ((Symbol)other).owner);
            this.other = other;
        }

        @Override
        public String toString() {
            return ((Symbol)this.other).toString();
        }

        @Override
        public Symbol location() {
            return ((Symbol)this.other).location();
        }

        @Override
        public Symbol location(Type site, Types types) {
            return ((Symbol)this.other).location(site, types);
        }

        @Override
        public Symbol baseSymbol() {
            return this.other;
        }

        @Override
        public Type erasure(Types types) {
            return ((Symbol)this.other).erasure(types);
        }

        @Override
        public Type externalType(Types types) {
            return ((Symbol)this.other).externalType(types);
        }

        @Override
        public boolean isDirectlyOrIndirectlyLocal() {
            return ((Symbol)this.other).isDirectlyOrIndirectlyLocal();
        }

        @Override
        public boolean isConstructor() {
            return ((Symbol)this.other).isConstructor();
        }

        @Override
        public Name getQualifiedName() {
            return ((Symbol)this.other).getQualifiedName();
        }

        @Override
        public Name flatName() {
            return ((Symbol)this.other).flatName();
        }

        @Override
        public Scope.WriteableScope members() {
            return ((Symbol)this.other).members();
        }

        @Override
        public boolean isInner() {
            return ((Symbol)this.other).isInner();
        }

        @Override
        public boolean hasOuterInstance() {
            return ((Symbol)this.other).hasOuterInstance();
        }

        @Override
        public ClassSymbol enclClass() {
            return ((Symbol)this.other).enclClass();
        }

        @Override
        public ClassSymbol outermostClass() {
            return ((Symbol)this.other).outermostClass();
        }

        @Override
        public PackageSymbol packge() {
            return ((Symbol)this.other).packge();
        }

        @Override
        public boolean isSubClass(Symbol base, Types types) {
            return ((Symbol)this.other).isSubClass(base, types);
        }

        @Override
        public boolean isMemberOf(TypeSymbol clazz, Types types) {
            return ((Symbol)this.other).isMemberOf(clazz, types);
        }

        @Override
        public boolean isEnclosedBy(ClassSymbol clazz) {
            return ((Symbol)this.other).isEnclosedBy(clazz);
        }

        @Override
        public boolean isInheritedIn(Symbol clazz, Types types) {
            return ((Symbol)this.other).isInheritedIn(clazz, types);
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return ((Symbol)this.other).asMemberOf(site, types);
        }

        @Override
        public void complete() throws CompletionFailure {
            ((Symbol)this.other).complete();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return this.other.accept(v, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitSymbol((Symbol)this.other, p);
        }

        public T getUnderlyingSymbol() {
            return this.other;
        }
    }
}

