/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class CommandLine {
    public static List<String> parse(List<String> args) throws IOException {
        ArrayList<String> newArgs = new ArrayList<String>();
        CommandLine.appendParsedCommandArgs(newArgs, args);
        return newArgs;
    }

    private static void appendParsedCommandArgs(List<String> newArgs, List<String> args) throws IOException {
        for (String arg : args) {
            if (arg.length() > 1 && arg.charAt(0) == '@') {
                if ((arg = arg.substring(1)).charAt(0) == '@') {
                    newArgs.add(arg);
                    continue;
                }
                CommandLine.loadCmdFile(arg, newArgs);
                continue;
            }
            newArgs.add(arg);
        }
    }

    public static List<String> parse(String envVariable, List<String> args) throws IOException, UnmatchedQuote {
        ArrayList<String> inArgs = new ArrayList<String>();
        CommandLine.appendParsedEnvVariables(inArgs, envVariable);
        inArgs.addAll(args);
        ArrayList<String> newArgs = new ArrayList<String>();
        CommandLine.appendParsedCommandArgs(newArgs, inArgs);
        return newArgs;
    }

    private static void loadCmdFile(String name, List<String> args) throws IOException {
        try (BufferedReader r = Files.newBufferedReader(Paths.get(name, new String[0]), Charset.defaultCharset());){
            String s;
            Tokenizer t = new Tokenizer(r);
            while ((s = t.nextToken()) != null) {
                args.add(s);
            }
        }
    }

    private static void appendParsedEnvVariables(List<String> newArgs, String envVariable) throws UnmatchedQuote {
        if (envVariable == null) {
            return;
        }
        String in = System.getenv(envVariable);
        if (in == null || in.trim().isEmpty()) {
            return;
        }
        boolean NUL = false;
        int len = in.length();
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        char quote = '\u0000';
        block4: while (pos < len) {
            char ch = in.charAt(pos);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        quote = ch;
                    } else if (quote == ch) {
                        quote = '\u0000';
                    } else {
                        sb.append(ch);
                    }
                    ++pos;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (quote == '\u0000') {
                        newArgs.add(sb.toString());
                        sb.setLength(0);
                        while (ch == '\f' || ch == '\n' || ch == '\r' || ch == '\t' || ch == ' ') {
                            if (++pos >= len) break block4;
                            ch = in.charAt(pos);
                        }
                        continue block4;
                    }
                }
                default: {
                    sb.append(ch);
                    ++pos;
                    continue block4;
                }
            }
        }
        if (sb.length() != 0) {
            newArgs.add(sb.toString());
        }
        if (quote != '\u0000') {
            throw new UnmatchedQuote(envVariable);
        }
    }

    public static class Tokenizer {
        private final Reader in;
        private int ch;

        public Tokenizer(Reader in) throws IOException {
            this.in = in;
            this.ch = in.read();
        }

        public String nextToken() throws IOException {
            this.skipWhite();
            if (this.ch == -1) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            char quoteChar = '\u0000';
            block13: while (this.ch != -1) {
                switch (this.ch) {
                    case 9: 
                    case 12: 
                    case 32: {
                        if (quoteChar == '\u0000') {
                            return sb.toString();
                        }
                        sb.append((char)this.ch);
                        break;
                    }
                    case 10: 
                    case 13: {
                        return sb.toString();
                    }
                    case 34: 
                    case 39: {
                        if (quoteChar == '\u0000') {
                            quoteChar = (char)this.ch;
                            break;
                        }
                        if (quoteChar == this.ch) {
                            quoteChar = '\u0000';
                            break;
                        }
                        sb.append((char)this.ch);
                        break;
                    }
                    case 92: {
                        if (quoteChar != '\u0000') {
                            this.ch = this.in.read();
                            switch (this.ch) {
                                case 10: 
                                case 13: {
                                    while (this.ch == 32 || this.ch == 10 || this.ch == 13 || this.ch == 9 || this.ch == 12) {
                                        this.ch = this.in.read();
                                    }
                                    continue block13;
                                }
                                case 110: {
                                    this.ch = 10;
                                    break;
                                }
                                case 114: {
                                    this.ch = 13;
                                    break;
                                }
                                case 116: {
                                    this.ch = 9;
                                    break;
                                }
                                case 102: {
                                    this.ch = 12;
                                }
                            }
                        }
                        sb.append((char)this.ch);
                        break;
                    }
                    default: {
                        sb.append((char)this.ch);
                    }
                }
                this.ch = this.in.read();
            }
            return sb.toString();
        }

        void skipWhite() throws IOException {
            while (this.ch != -1) {
                switch (this.ch) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    case 35: {
                        this.ch = this.in.read();
                        while (this.ch != 10 && this.ch != 13 && this.ch != -1) {
                            this.ch = this.in.read();
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.ch = this.in.read();
            }
        }
    }

    public static class UnmatchedQuote
    extends Exception {
        private static final long serialVersionUID = 0L;
        public final String variableName;

        UnmatchedQuote(String variable) {
            this.variableName = variable;
        }
    }
}

