/*
 * Decompiled with CFR 0.152.
 */
package jpt30.lang.model.util;

import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jpt30.lang.model.AnnotatedConstruct;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.AnnotationValue;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.RecordComponentElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.util.ElementFilter;

public interface Elements {
    public PackageElement getPackageElement(CharSequence var1);

    default public PackageElement getPackageElement(ModuleElement module, CharSequence name) {
        return null;
    }

    default public Set<? extends PackageElement> getAllPackageElements(CharSequence name) {
        Set<? extends ModuleElement> modules = this.getAllModuleElements();
        if (modules.isEmpty()) {
            PackageElement packageElt = this.getPackageElement(name);
            return packageElt != null ? Collections.singleton(packageElt) : Collections.emptySet();
        }
        LinkedHashSet<PackageElement> result = new LinkedHashSet<PackageElement>(1);
        for (ModuleElement moduleElement : modules) {
            PackageElement packageElt = this.getPackageElement(moduleElement, name);
            if (packageElt == null) continue;
            result.add(packageElt);
        }
        return Collections.unmodifiableSet(result);
    }

    public TypeElement getTypeElement(CharSequence var1);

    default public TypeElement getTypeElement(ModuleElement module, CharSequence name) {
        return null;
    }

    default public Set<? extends TypeElement> getAllTypeElements(CharSequence name) {
        Set<? extends ModuleElement> modules = this.getAllModuleElements();
        if (modules.isEmpty()) {
            TypeElement typeElt = this.getTypeElement(name);
            return typeElt != null ? Collections.singleton(typeElt) : Collections.emptySet();
        }
        LinkedHashSet<TypeElement> result = new LinkedHashSet<TypeElement>(1);
        for (ModuleElement moduleElement : modules) {
            TypeElement typeElt = this.getTypeElement(moduleElement, name);
            if (typeElt == null) continue;
            result.add(typeElt);
        }
        return Collections.unmodifiableSet(result);
    }

    default public ModuleElement getModuleElement(CharSequence name) {
        return null;
    }

    default public Set<? extends ModuleElement> getAllModuleElements() {
        return Collections.emptySet();
    }

    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror var1);

    public String getDocComment(Element var1);

    public boolean isDeprecated(Element var1);

    default public Origin getOrigin(Element e) {
        return Origin.EXPLICIT;
    }

    default public Origin getOrigin(AnnotatedConstruct c, AnnotationMirror a) {
        return Origin.EXPLICIT;
    }

    default public Origin getOrigin(ModuleElement m, ModuleElement.Directive directive) {
        return Origin.EXPLICIT;
    }

    default public boolean isBridge(ExecutableElement e) {
        return false;
    }

    public Name getBinaryName(TypeElement var1);

    public PackageElement getPackageOf(Element var1);

    default public ModuleElement getModuleOf(Element e) {
        return null;
    }

    public List<? extends Element> getAllMembers(TypeElement var1);

    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element var1);

    public boolean hides(Element var1, Element var2);

    public boolean overrides(ExecutableElement var1, ExecutableElement var2, TypeElement var3);

    public String getConstantExpression(Object var1);

    public void printElements(Writer var1, Element ... var2);

    public Name getName(CharSequence var1);

    public boolean isFunctionalInterface(TypeElement var1);

    default public boolean isAutomaticModule(ModuleElement module) {
        return false;
    }

    default public RecordComponentElement recordComponentFor(ExecutableElement accessor) {
        if (accessor.getEnclosingElement().getKind() == ElementKind.RECORD) {
            for (RecordComponentElement rec : ElementFilter.recordComponentsIn(accessor.getEnclosingElement().getEnclosedElements())) {
                if (!Objects.equals(rec.getAccessor(), accessor)) continue;
                return rec;
            }
        }
        return null;
    }

    public static enum Origin {
        EXPLICIT,
        MANDATED,
        SYNTHETIC;


        public boolean isDeclared() {
            return this != SYNTHETIC;
        }
    }
}

