/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPModuleInfo;
import org.netbeans.modules.classfile.CPPackageInfo;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.LegacyClassFile;

public final class Module {
    private final String name;
    private final int flags;
    private final String version;
    private final List<RequiresEntry> requires;
    private final List<ExportsEntry> exports;
    private final List<OpensEntry> opens;
    private final List<ClassName> uses;
    private final List<ProvidesEntry> provides;

    Module(DataInputStream in, ConstantPool cp) throws IOException {
        CPEntry entry = cp.get(in.readUnsignedShort());
        if (entry.getTag() != 19) {
            throw new LegacyClassFile("Java 9 older than b148.");
        }
        this.name = ((CPModuleInfo)entry).getName();
        this.flags = in.readUnsignedShort();
        int index = in.readUnsignedShort();
        this.version = index == 0 ? null : ((CPUTF8Info)cp.get(index)).getName();
        int reqCnt = in.readUnsignedShort();
        RequiresEntry[] req = new RequiresEntry[reqCnt];
        for (int i = 0; i < reqCnt; ++i) {
            req[i] = new RequiresEntry(in, cp);
        }
        this.requires = Collections.unmodifiableList(Arrays.asList(req));
        int expCnt = in.readUnsignedShort();
        ExportsEntry[] exp = new ExportsEntry[expCnt];
        for (int i = 0; i < expCnt; ++i) {
            exp[i] = new ExportsEntry(in, cp);
        }
        this.exports = Collections.unmodifiableList(Arrays.asList(exp));
        int opnCnt = in.readUnsignedShort();
        OpensEntry[] opn = new OpensEntry[opnCnt];
        for (int i = 0; i < opnCnt; ++i) {
            opn[i] = new OpensEntry(in, cp);
        }
        this.opens = Collections.unmodifiableList(Arrays.asList(opn));
        int usesCnt = in.readUnsignedShort();
        ClassName[] uss = new ClassName[usesCnt];
        for (int i = 0; i < usesCnt; ++i) {
            uss[i] = ((CPClassInfo)cp.get(in.readUnsignedShort())).getClassName();
        }
        this.uses = Collections.unmodifiableList(Arrays.asList(uss));
        int provCnt = in.readUnsignedShort();
        ProvidesEntry[] prov = new ProvidesEntry[provCnt];
        for (int i = 0; i < provCnt; ++i) {
            prov[i] = new ProvidesEntry(in, cp);
        }
        this.provides = Collections.unmodifiableList(Arrays.asList(prov));
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getVersion() {
        return this.version;
    }

    public List<RequiresEntry> getRequiresEntries() {
        return this.requires;
    }

    public List<ExportsEntry> getExportsEntries() {
        return this.exports;
    }

    public List<OpensEntry> getOpensEntries() {
        return this.opens;
    }

    public List<ClassName> getUses() {
        return this.uses;
    }

    public List<ProvidesEntry> getProvidesEntries() {
        return this.provides;
    }

    public static final class ProvidesEntry {
        private final ClassName service;
        private final List<ClassName> impls;

        ProvidesEntry(DataInputStream in, ConstantPool cp) throws IOException {
            this.service = ((CPClassInfo)cp.get(in.readUnsignedShort())).getClassName();
            int cnt = in.readUnsignedShort();
            ClassName[] ims = new ClassName[cnt];
            for (int i = 0; i < cnt; ++i) {
                ims[i] = ((CPClassInfo)cp.get(in.readUnsignedShort())).getClassName();
            }
            this.impls = Collections.unmodifiableList(Arrays.asList(ims));
        }

        public ClassName getService() {
            return this.service;
        }

        public List<ClassName> getImplementations() {
            return this.impls;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append("provides ").append(this.service);
            if (!this.impls.isEmpty()) {
                sb.append(" with ");
                boolean first = true;
                for (ClassName m : this.impls) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(m.getExternalName());
                }
            }
            return sb.toString();
        }
    }

    public static final class OpensEntry {
        private final String pkg;
        private final int flags;
        private final List<String> to;

        OpensEntry(DataInputStream in, ConstantPool cp) throws IOException {
            this.pkg = ((CPPackageInfo)cp.get(in.readUnsignedShort())).getName();
            this.flags = in.readUnsignedShort();
            int toCnt = in.readUnsignedShort();
            String[] t = new String[toCnt];
            for (int i = 0; i < toCnt; ++i) {
                t[i] = ((CPModuleInfo)cp.get(in.readUnsignedShort())).getName();
            }
            this.to = Collections.unmodifiableList(Arrays.asList(t));
        }

        public String getPackage() {
            return this.pkg;
        }

        public int getFlags() {
            return this.flags;
        }

        public List<String> getOpensTo() {
            return this.to;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("opens");
            if ((this.flags & 0x1000) != 0) {
                sb.append(" synthetic");
            }
            if ((this.flags & 0x8000) != 0) {
                sb.append(" mandated");
            }
            sb.append(' ').append(this.pkg);
            if (!this.to.isEmpty()) {
                sb.append(" to ");
                boolean first = true;
                for (String m : this.to) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(m);
                }
            }
            return sb.toString();
        }
    }

    public static final class ExportsEntry {
        private final String pkg;
        private final int flags;
        private final List<String> to;

        ExportsEntry(DataInputStream in, ConstantPool cp) throws IOException {
            this.pkg = ((CPPackageInfo)cp.get(in.readUnsignedShort())).getName();
            this.flags = in.readUnsignedShort();
            int toCnt = in.readUnsignedShort();
            String[] t = new String[toCnt];
            for (int i = 0; i < toCnt; ++i) {
                t[i] = ((CPModuleInfo)cp.get(in.readUnsignedShort())).getName();
            }
            this.to = Collections.unmodifiableList(Arrays.asList(t));
        }

        public String getPackage() {
            return this.pkg;
        }

        public int getFlags() {
            return this.flags;
        }

        public List<String> getExportsTo() {
            return this.to;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("exports");
            if ((this.flags & 0x1000) != 0) {
                sb.append(" synthetic");
            }
            if ((this.flags & 0x8000) != 0) {
                sb.append(" mandated");
            }
            sb.append(' ').append(this.pkg);
            if (!this.to.isEmpty()) {
                sb.append(" to ");
                boolean first = true;
                for (String m : this.to) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(m);
                }
            }
            return sb.toString();
        }
    }

    public static final class RequiresEntry {
        private final String module;
        private final int flags;
        private final String version;

        RequiresEntry(DataInputStream in, ConstantPool cp) throws IOException {
            this.module = ((CPModuleInfo)cp.get(in.readUnsignedShort())).getName();
            this.flags = in.readUnsignedShort();
            int index = in.readUnsignedShort();
            this.version = index == 0 ? null : ((CPUTF8Info)cp.get(index)).getName();
        }

        public String getModule() {
            return this.module;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("requires");
            if ((this.flags & 0x20) != 0) {
                sb.append(" transitive");
            }
            if ((this.flags & 0x40) != 0) {
                sb.append(" static");
            }
            if ((this.flags & 0x1000) != 0) {
                sb.append(" synthetic");
            }
            if ((this.flags & 0x8000) != 0) {
                sb.append(" mandated");
            }
            sb.append(' ').append(this.module);
            if (this.version != null) {
                sb.append("@").append(this.version);
            }
            return sb.toString();
        }
    }
}

