/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.javadoc;

import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jpt.sun.source.doctree.DocCommentTree;
import jpt.sun.source.doctree.DocTree;
import jpt.sun.source.doctree.ErroneousTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.DocTreePath;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;

public final class JavadocCompletionUtils {
    static final Pattern JAVADOC_LINE_BREAK = Pattern.compile("\\n[ \\t]*\\**[ \\t]*\\z");
    static final Pattern JAVADOC_WHITE_SPACE = Pattern.compile("[^ \\t]");
    static final Pattern JAVADOC_EMPTY = Pattern.compile("(\\s*\\**\\s*\n)*\\s*\\**\\s*\\**");
    static final Pattern JAVADOC_FIRST_WHITE_SPACE = Pattern.compile("[ \\t]*\\**[ \\t]*");
    private static Set<JavaTokenId> IGNORE_TOKES = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT);
    private static final Logger LOGGER = Logger.getLogger(JavadocCompletionUtils.class.getName());
    private static final Set<DocTree.Kind> BLOCK_TAGS = EnumSet.of(DocTree.Kind.AUTHOR, new DocTree.Kind[]{DocTree.Kind.DEPRECATED, DocTree.Kind.PARAM, DocTree.Kind.RETURN, DocTree.Kind.SEE, DocTree.Kind.SERIAL, DocTree.Kind.SERIAL_DATA, DocTree.Kind.SERIAL_FIELD, DocTree.Kind.SINCE, DocTree.Kind.THROWS, DocTree.Kind.UNKNOWN_BLOCK_TAG, DocTree.Kind.VERSION});

    public static boolean isJavadocContext(final Document doc, final int offset) {
        final boolean[] result = new boolean[]{false};
        doc.render(new Runnable(){

            @Override
            public void run() {
                result[0] = JavadocCompletionUtils.isJavadocContext(TokenHierarchy.get(doc), offset);
            }
        });
        return result[0];
    }

    public static boolean isJavadocContext(TokenHierarchy hierarchy, int offset) {
        TokenSequence<JavaTokenId> ts = SourceUtils.getJavaTokenSequence(hierarchy, offset);
        if (!JavadocCompletionUtils.movedToJavadocToken(ts, offset)) {
            return false;
        }
        TokenSequence<JavadocTokenId> jdts = ts.embedded(JavadocTokenId.language());
        if (jdts == null) {
            return false;
        }
        if (jdts.isEmpty()) {
            return JavadocCompletionUtils.isEmptyJavadoc(ts.token(), offset - ts.offset());
        }
        jdts.move(offset);
        if (!jdts.moveNext() && !jdts.movePrevious()) {
            return false;
        }
        return JavadocCompletionUtils.isInsideToken(jdts, offset) && !JavadocCompletionUtils.isInsideIndent(jdts.token(), offset - jdts.offset());
    }

    public static TreePath findJavadoc(CompilationInfo javac2, int offset) {
        TokenSequence<JavaTokenId> ts = SourceUtils.getJavaTokenSequence(javac2.getTokenHierarchy(), offset);
        if (ts == null || !JavadocCompletionUtils.movedToJavadocToken(ts, offset)) {
            return null;
        }
        int offsetBehindJavadoc = ts.offset() + ts.token().length();
        while (ts.moveNext()) {
            JavaTokenId tid = ts.token().id();
            if (tid == JavaTokenId.BLOCK_COMMENT) {
                if (!"/**/".contentEquals(ts.token().text())) continue;
                return null;
            }
            if (tid == JavaTokenId.JAVADOC_COMMENT) {
                if (ts.token().partType() != PartType.COMPLETE) continue;
                return null;
            }
            if (IGNORE_TOKES.contains(tid)) continue;
            offsetBehindJavadoc = ts.offset();
            ++offsetBehindJavadoc;
            break;
        }
        TreePath tp = javac2.getTreeUtilities().pathFor(offsetBehindJavadoc);
        while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) && tp.getLeaf().getKind() != Tree.Kind.METHOD && tp.getLeaf().getKind() != Tree.Kind.VARIABLE && tp.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && (tp = tp.getParentPath()) != null) {
        }
        return tp;
    }

    public static TokenSequence<JavadocTokenId> findJavadocTokenSequence(CompilationInfo javac2, int offset) {
        TokenSequence<JavaTokenId> ts = SourceUtils.getJavaTokenSequence(javac2.getTokenHierarchy(), offset);
        if (ts == null || !JavadocCompletionUtils.movedToJavadocToken(ts, offset)) {
            return null;
        }
        TokenSequence<JavadocTokenId> jdts = ts.embedded(JavadocTokenId.language());
        if (jdts == null) {
            return null;
        }
        jdts.move(offset);
        return jdts;
    }

    public static TokenSequence<JavadocTokenId> findJavadocTokenSequence(CompilationInfo javac2, Tree tree, Element e) {
        if (e == null || javac2.getElementUtilities().isSynthetic(e)) {
            return null;
        }
        if (tree == null) {
            tree = javac2.getTrees().getTree(e);
        }
        if (tree == null) {
            return null;
        }
        int elementStartOffset = (int)javac2.getTrees().getSourcePositions().getStartPosition(javac2.getCompilationUnit(), tree);
        TokenSequence<JavaTokenId> s = SourceUtils.getJavaTokenSequence(javac2.getTokenHierarchy(), elementStartOffset);
        if (s == null) {
            return null;
        }
        s.move(elementStartOffset);
        Token<JavaTokenId> token = null;
        block5: while (s.movePrevious()) {
            token = s.token();
            switch (token.id()) {
                case BLOCK_COMMENT: {
                    if (!"/**/".contentEquals(token.text())) continue block5;
                }
                case JAVADOC_COMMENT: {
                    if (token.partType() != PartType.COMPLETE) continue block5;
                    return javac2.getElements().getDocComment(e) == null ? null : s.embedded(JavadocTokenId.language());
                }
                case WHITESPACE: 
                case LINE_COMMENT: {
                    continue block5;
                }
            }
            return null;
        }
        return null;
    }

    static boolean isInsideIndent(Token<JavadocTokenId> token, int offset) {
        int indent = -1;
        if (token.id() == JavadocTokenId.OTHER_TEXT) {
            CharSequence text = token.text();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    if (i > offset) break;
                    indent = -1;
                    if (i >= offset) break;
                    continue;
                }
                if (i == 0) break;
                if (c != '*' || indent >= 0) continue;
                indent = i;
                if (offset <= i) break;
            }
        }
        return indent >= offset;
    }

    public static boolean isLineBreak(Token<JavadocTokenId> token) {
        return JavadocCompletionUtils.isLineBreak(token, token.length());
    }

    public static boolean isLineBreak(Token<JavadocTokenId> token, int pos) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        try {
            CharSequence text = token.text();
            if (pos < token.length()) {
                text = text.subSequence(0, pos);
            }
            boolean result = pos > 0 && JAVADOC_LINE_BREAK.matcher(text).find() && (pos == token.length() || !JavadocCompletionUtils.isInsideIndent(token, pos));
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            throw (IndexOutOfBoundsException)new IndexOutOfBoundsException("pos: " + pos + ", token.length: " + token.length() + ", token text: " + token.text()).initCause(e);
        }
    }

    public static boolean isWhiteSpace(CharSequence text) {
        return text != null && text.length() > 0 && !JAVADOC_WHITE_SPACE.matcher(text).find();
    }

    public static boolean isWhiteSpace(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence text = token.text();
        boolean result = !JAVADOC_WHITE_SPACE.matcher(text).find();
        return result;
    }

    public static boolean isFirstWhiteSpaceAtFirstLine(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence text = token.text();
        boolean result = JAVADOC_FIRST_WHITE_SPACE.matcher(text).matches();
        return result;
    }

    public static boolean isWhiteSpaceFirst(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT || token.length() < 1) {
            return false;
        }
        CharSequence text = token.text();
        char c = text.charAt(0);
        return c == ' ' || c == '\t';
    }

    public static boolean isWhiteSpaceLast(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT || token.length() < 1) {
            return false;
        }
        CharSequence text = token.text();
        char c = text.charAt(text.length() - 1);
        return c == ' ' || c == '\t';
    }

    public static boolean isInlineTagStart(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        CharSequence text = token.text();
        boolean result = text.charAt(text.length() - 1) == '{';
        return result;
    }

    public static boolean isBlockTag(DocTreePath tag) {
        return BLOCK_TAGS.contains((Object)JavadocCompletionUtils.normalizedKind(tag.getLeaf()));
    }

    public static DocTree.Kind normalizedKind(DocTree tag) {
        DocTree.Kind normalizedKind = tag.getKind();
        if (normalizedKind == DocTree.Kind.ERRONEOUS) {
            String errorBody = ((ErroneousTree)tag).getBody();
            switch (errorBody.split("\\s")[0]) {
                case "@throws": {
                    normalizedKind = DocTree.Kind.THROWS;
                    break;
                }
                case "@see": {
                    normalizedKind = DocTree.Kind.SEE;
                    break;
                }
                case "@param": {
                    normalizedKind = DocTree.Kind.PARAM;
                    break;
                }
                case "{@value": {
                    normalizedKind = DocTree.Kind.VALUE;
                    break;
                }
                case "{@link": {
                    normalizedKind = DocTree.Kind.LINK;
                    break;
                }
                case "{@linkplain": {
                    normalizedKind = DocTree.Kind.LINK;
                }
            }
        }
        return normalizedKind;
    }

    public static CharSequence getCharSequence(Document doc) {
        CharSequence cs = (CharSequence)doc.getProperty(CharSequence.class);
        if (cs == null) {
            try {
                cs = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                throw (IndexOutOfBoundsException)new IndexOutOfBoundsException().initCause(ex);
            }
        }
        return cs;
    }

    public static CharSequence getCharSequence(Document doc, int begin, int end) {
        CharSequence cs = (CharSequence)doc.getProperty(CharSequence.class);
        if (cs != null) {
            cs = cs.subSequence(begin, end);
        } else {
            try {
                cs = doc.getText(begin, end - begin);
            }
            catch (BadLocationException ex) {
                throw (IndexOutOfBoundsException)new IndexOutOfBoundsException().initCause(ex);
            }
        }
        return cs;
    }

    private static boolean isInsideToken(TokenSequence<?> ts, int offset) {
        return offset >= ts.offset() && offset <= ts.offset() + ts.token().length();
    }

    private static boolean movedToJavadocToken(TokenSequence<JavaTokenId> ts, int offset) {
        if (ts == null || !ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        if (ts.token().id() != JavaTokenId.JAVADOC_COMMENT) {
            return false;
        }
        return JavadocCompletionUtils.isInsideToken(ts, offset);
    }

    private static boolean isEmptyJavadoc(Token<JavaTokenId> token, int offset) {
        if (token != null && token.id() == JavaTokenId.JAVADOC_COMMENT) {
            CharSequence text = token.text();
            return offset == 3 && "/***/".contentEquals(text);
        }
        return false;
    }

    public static boolean isInvalidDocInstance(DocCommentTree javadoc, TokenSequence<JavadocTokenId> ts) {
        if ((javadoc == null || javadoc.getFullBody().isEmpty()) && !ts.isEmpty()) {
            ts.moveStart();
            return !ts.moveNext() || !JavadocCompletionUtils.isTokenOfEmptyJavadoc(ts.token()) || ts.moveNext();
        }
        return false;
    }

    static boolean isTokenOfEmptyJavadoc(Token<JavadocTokenId> token) {
        if (token == null || token.id() != JavadocTokenId.OTHER_TEXT) {
            return false;
        }
        return JAVADOC_EMPTY.matcher(token.text()).matches();
    }
}

