/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    public static final int GETTERS_ONLY = 1;
    public static final int SETTERS_ONLY = 2;

    private GeneratorUtils() {
    }

    public static void generateAllAbstractMethodImplementations(WorkingCopy wc, TreePath path) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            GeneratorUtilities gu = GeneratorUtilities.get(wc);
            ElementUtilities elemUtils = wc.getElementUtilities();
            clazz = gu.insertClassMembers(clazz, gu.createAbstractMethodImplementations(te, elemUtils.findUnimplementedMethods(te)));
            wc.rewrite(path.getLeaf(), clazz);
        }
    }

    public static void generateAbstractMethodImplementations(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite(clazz, GeneratorUtils.insertClassMembers(wc, clazz, GeneratorUtilities.get(wc).createAbstractMethodImplementations(te, elements), offset));
        }
    }

    public static void generateAbstractMethodImplementation(WorkingCopy wc, TreePath path, ExecutableElement element, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite(clazz, GeneratorUtils.insertClassMember(wc, clazz, GeneratorUtilities.get(wc).createAbstractMethodImplementation(te, element), offset));
        }
    }

    public static void generateMethodOverrides(WorkingCopy wc, TreePath path, List<? extends ExecutableElement> elements, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite(clazz, GeneratorUtils.insertClassMembers(wc, clazz, GeneratorUtilities.get(wc).createOverridingMethods(te, elements), offset));
        }
    }

    public static void generateMethodOverride(WorkingCopy wc, TreePath path, ExecutableElement element, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree clazz = (ClassTree)path.getLeaf();
            wc.rewrite(clazz, GeneratorUtils.insertClassMember(wc, clazz, GeneratorUtilities.get(wc).createOverridingMethod(te, element), offset));
        }
    }

    public static void generateConstructor(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, ExecutableElement inheritedConstructor, int offset) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        Tree c2 = wc.resolveRewriteTarget(clazz);
        if (c2 instanceof ClassTree && clazz != c2) {
            clazz = (ClassTree)c2;
        }
        wc.rewrite(clazz, GeneratorUtils.insertClassMembers(wc, clazz, Collections.singletonList(GeneratorUtilities.get(wc).createConstructor(te, initFields, inheritedConstructor)), offset));
    }

    public static void generateConstructors(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> initFields, List<? extends ExecutableElement> inheritedConstructors, int offset) {
        ClassTree clazz = (ClassTree)path.getLeaf();
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        GeneratorUtilities gu = GeneratorUtilities.get(wc);
        ArrayList<MethodTree> members = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : inheritedConstructors) {
            members.add(gu.createConstructor(te, initFields, executableElement));
        }
        wc.rewrite(clazz, GeneratorUtils.insertClassMembers(wc, clazz, members, offset));
    }

    public static void generateGettersAndSetters(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> fields, int type, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            GeneratorUtilities gu = GeneratorUtilities.get(wc);
            ClassTree clazz = (ClassTree)path.getLeaf();
            ArrayList<MethodTree> members = new ArrayList<MethodTree>();
            for (VariableElement variableElement : fields) {
                if (type != 2) {
                    members.add(gu.createGetter(te, variableElement));
                }
                if (type == 1) continue;
                members.add(gu.createSetter(te, variableElement));
            }
            wc.rewrite(clazz, GeneratorUtils.insertClassMembers(wc, clazz, members, offset));
        }
    }

    public static ClassTree insertClassMembers(WorkingCopy wc, ClassTree clazz, List<? extends Tree> members, int offset) throws IllegalStateException {
        if (members.isEmpty()) {
            return clazz;
        }
        for (Tree tree : members) {
            Tree dup = GeneratorUtils.checkDuplicates(wc, clazz, tree);
            if (dup == null) continue;
            throw new DuplicateMemberException((int)wc.getTrees().getSourcePositions().getStartPosition(wc.getCompilationUnit(), dup));
        }
        return GeneratorUtilities.get(wc).insertClassMembers(clazz, members, offset);
    }

    public static ClassTree insertClassMember(WorkingCopy wc, ClassTree clazz, Tree member, int offset) throws IllegalStateException {
        return GeneratorUtils.insertClassMembers(wc, clazz, Collections.singletonList(member), offset);
    }

    public static boolean supportsOverride(@NonNull CompilationInfo info) {
        return SourceVersion.RELEASE_5.compareTo(info.getSourceVersion()) <= 0 && info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static List<TypeElement> getAllClasses(TypeElement of) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        TypeMirror sup = of.getSuperclass();
        TypeElement te = sup.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)sup).asElement() : null;
        result.add(of);
        if (te != null) {
            result.addAll(GeneratorUtils.getAllClasses(te));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + of);
        }
        return result;
    }

    static DialogDescriptor createDialogDescriptor(JComponent content, String label) {
        Object[] buttons = new JButton[2];
        buttons[0] = new JButton(NbBundle.getMessage(GeneratorUtils.class, "LBL_generate_button"));
        buttons[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorUtils.class, "A11Y_Generate"));
        buttons[1] = new JButton(NbBundle.getMessage(GeneratorUtils.class, "LBL_cancel_button"));
        DialogDescriptor dd = new DialogDescriptor((Object)content, label, true, buttons, (Object)buttons[0], 0, null, null);
        dd.addPropertyChangeListener(new PropertyChangeListener((JButton[])buttons, dd){
            final /* synthetic */ JButton[] val$buttons;
            final /* synthetic */ DialogDescriptor val$dd;
            {
                this.val$buttons = jButtonArray;
                this.val$dd = dialogDescriptor;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("valid".equals(evt.getPropertyName())) {
                    this.val$buttons[0].setEnabled(this.val$dd.isValid());
                }
            }
        });
        return dd;
    }

    public static void guardedCommit(JTextComponent component, ModificationResult mr) throws IOException {
        block2: {
            try {
                mr.commit();
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof GuardedException)) break block2;
                String message = NbBundle.getMessage(GeneratorUtils.class, "ERR_CannotApplyGuarded");
                Utilities.setStatusBoldText(component, message);
                Logger.getLogger(GeneratorUtils.class.getName()).log(Level.FINE, null, e);
            }
        }
    }

    private static Tree checkDuplicates(WorkingCopy wc, ClassTree clazz, Tree member) {
        List<? extends VariableTree> memberParams = null;
        TreePath tp = null;
        for (Tree tree : clazz.getMembers()) {
            if (tp == null) {
                tp = new TreePath(wc.getCompilationUnit());
            }
            if (tree.getKind() == member.getKind() && !wc.getTreeUtilities().isSynthetic(new TreePath(tp, tree))) {
                block0 : switch (member.getKind()) {
                    case CLASS: {
                        if (!((ClassTree)member).getSimpleName().contentEquals(((ClassTree)tree).getSimpleName())) break;
                        return tree;
                    }
                    case VARIABLE: {
                        if (!((VariableTree)member).getName().contentEquals(((VariableTree)tree).getName())) break;
                        return tree;
                    }
                    case METHOD: {
                        if (!((MethodTree)member).getName().contentEquals(((MethodTree)tree).getName())) break;
                        if (memberParams == null) {
                            memberParams = ((MethodTree)member).getParameters();
                        }
                        List<? extends VariableTree> treeParams = ((MethodTree)tree).getParameters();
                        if (memberParams.size() != treeParams.size()) break;
                        Iterator<? extends VariableTree> memberIt = memberParams.iterator();
                        Iterator<? extends VariableTree> treeIt = treeParams.iterator();
                        while (memberIt.hasNext() && treeIt.hasNext()) {
                            TypeMirror mTM = wc.getTrees().getTypeMirror(new TreePath(tp, memberIt.next().getType()));
                            TypeMirror tTM = wc.getTrees().getTypeMirror(new TreePath(tp, treeIt.next().getType()));
                            if (wc.getTypes().isSameType(mTM, tTM)) continue;
                            break block0;
                        }
                        return tree;
                    }
                }
            }
        }
        return null;
    }

    public static class DuplicateMemberException
    extends IllegalStateException {
        private int pos;

        public DuplicateMemberException(int pos) {
            super("Class member already exists");
            this.pos = pos;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

