/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="CheckRegexTopComponent", persistenceType=0)
public final class CheckRegexTopComponent
extends TopComponent {
    private static CheckRegexTopComponent instance;
    private static final String PREFERRED_ID = "CheckRegexTopComponent";
    private static boolean isStrictMatch;
    private JLabel errorLabel;
    private JLabel exampleLabel;
    private JLayeredPane exampleLayeredPane;
    private JScrollPane exampleScrollPane;
    private JTextArea exampleTextArea;
    private JLabel iconLabel;
    private JLabel regexLabel;
    private JScrollPane regexScrollPane;
    private JTextArea regexTextArea;
    private JCheckBox strictCheckBox;

    public CheckRegexTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_CheckRegexTopComponent());
        this.setToolTipText(Bundle.HINT_CheckRegexTopComponent());
        isStrictMatch = false;
    }

    private void initComponents() {
        this.regexLabel = new JLabel();
        this.regexScrollPane = new JScrollPane();
        this.regexTextArea = new JTextArea();
        this.exampleLabel = new JLabel();
        this.exampleLayeredPane = new JLayeredPane();
        this.iconLabel = new JLabel();
        this.exampleScrollPane = new JScrollPane();
        this.exampleTextArea = new JTextArea();
        this.strictCheckBox = new JCheckBox();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText(this.regexLabel, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.regexLabel.text"));
        this.regexScrollPane.setVerticalScrollBarPolicy(21);
        this.regexScrollPane.setPreferredSize(new Dimension(164, 74));
        this.regexTextArea.setColumns(20);
        this.regexTextArea.setRows(5);
        this.regexTextArea.setFocusAccelerator('g');
        this.regexTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CheckRegexTopComponent.this.regexTextAreaKeyReleased(evt);
            }
        });
        this.regexScrollPane.setViewportView(this.regexTextArea);
        Mnemonics.setLocalizedText(this.exampleLabel, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.exampleLabel.text"));
        this.exampleScrollPane.setVerticalScrollBarPolicy(21);
        this.exampleScrollPane.setOpaque(false);
        this.exampleTextArea.setColumns(20);
        this.exampleTextArea.setRows(5);
        this.exampleTextArea.setFocusAccelerator('x');
        this.exampleTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CheckRegexTopComponent.this.exampleTextAreaKeyReleased(evt);
            }
        });
        this.exampleScrollPane.setViewportView(this.exampleTextArea);
        Mnemonics.setLocalizedText(this.strictCheckBox, NbBundle.getMessage(CheckRegexTopComponent.class, "CheckRegexTopComponent.strictCheckBox.text"));
        this.strictCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CheckRegexTopComponent.this.strictCheckBoxItemStateChanged(evt);
            }
        });
        this.exampleLayeredPane.setLayer(this.iconLabel, JLayeredPane.DEFAULT_LAYER);
        this.exampleLayeredPane.setLayer(this.exampleScrollPane, JLayeredPane.DEFAULT_LAYER);
        this.exampleLayeredPane.setLayer(this.strictCheckBox, JLayeredPane.DEFAULT_LAYER);
        GroupLayout exampleLayeredPaneLayout = new GroupLayout(this.exampleLayeredPane);
        this.exampleLayeredPane.setLayout(exampleLayeredPaneLayout);
        exampleLayeredPaneLayout.setHorizontalGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, exampleLayeredPaneLayout.createSequentialGroup().addContainerGap(297, Short.MAX_VALUE).addComponent(this.iconLabel, -2, 17, -2).addGap(12, 12, 12).addComponent(this.strictCheckBox)).addGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleLayeredPaneLayout.createSequentialGroup().addComponent(this.exampleScrollPane, -2, 320, -2).addGap(0, 15, Short.MAX_VALUE))));
        exampleLayeredPaneLayout.setVerticalGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleLayeredPaneLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.strictCheckBox).addComponent(this.iconLabel, -2, 18, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(exampleLayeredPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exampleLayeredPaneLayout.createSequentialGroup().addComponent(this.exampleScrollPane, -2, 44, -2).addGap(0, 6, Short.MAX_VALUE))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regexLabel).addComponent(this.exampleLabel).addGroup(layout.createSequentialGroup().addComponent(this.regexScrollPane, -2, 320, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errorLabel)).addComponent(this.exampleLayeredPane, -2, -1, -2)).addContainerGap(266, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.regexLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regexScrollPane, -2, 42, -2).addComponent(this.errorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exampleLayeredPane, -2, -1, -2).addContainerGap()));
    }

    private void exampleTextAreaKeyReleased(KeyEvent evt) {
        if (this.exampleTextArea.getSelectedText() == null) {
            this.matchPattern();
        }
    }

    private void regexTextAreaKeyReleased(KeyEvent evt) {
        this.matchPattern();
    }

    private void strictCheckBoxItemStateChanged(ItemEvent evt) {
        isStrictMatch = !isStrictMatch;
        this.matchPattern();
    }

    @Override
    public void componentOpened() {
    }

    @Override
    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public static synchronized CheckRegexTopComponent getDefault() {
        Mode outputMode;
        if (instance == null) {
            instance = new CheckRegexTopComponent();
        }
        if ((outputMode = WindowManager.getDefault().findMode("output")) != null) {
            outputMode.dockInto(instance);
        }
        return instance;
    }

    public static synchronized CheckRegexTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CheckRegexTopComponent.class.getName()).warning("Cannot find CheckRegexTopComponent component. It will not be located properly in the window system.");
            return CheckRegexTopComponent.getDefault();
        }
        if (win instanceof CheckRegexTopComponent) {
            return (CheckRegexTopComponent)win;
        }
        Logger.getLogger(CheckRegexTopComponent.class.getName()).warning("There seem to be multiple components with the 'CheckRegexTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CheckRegexTopComponent.getDefault();
    }

    void setData(String origString) {
        this.regexTextArea.setText(origString);
        this.matchPattern();
    }

    private void matchPattern() {
        Pattern p;
        Highlighter highlighter = this.exampleTextArea.getHighlighter();
        highlighter.removeAllHighlights();
        this.errorLabel.setText("");
        this.iconLabel.setIcon(null);
        if (this.regexTextArea.getText().length() == 0 || this.exampleTextArea.getText().length() == 0) {
            return;
        }
        try {
            p = Pattern.compile(this.regexTextArea.getText());
        }
        catch (PatternSyntaxException pse) {
            this.errorLabel.setText(Bundle.CheckRegexTopComponent_label_error(pse.getDescription()));
            return;
        }
        Matcher m = p.matcher(this.exampleTextArea.getText());
        if (m.matches()) {
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/match.png")));
            this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_match_regex());
        } else if (m.hitEnd()) {
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/half-match.png")));
            this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_need_more_input());
        } else if (isStrictMatch) {
            this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/no-match.png")));
            this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_not_match());
        } else {
            m.reset();
            long count = 0L;
            try {
                while (m.find()) {
                    int start = m.start();
                    int end = m.end();
                    DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN);
                    highlighter.addHighlight(start, end, defaultHighlightPainter);
                    ++count;
                }
                if (count > 0L) {
                    this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/match.png")));
                    this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltop_sub_match(count));
                } else {
                    this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/java/hints/resources/no-match.png")));
                    this.exampleTextArea.setToolTipText(Bundle.CheckRegexTopComponent_tooltip_not_match());
                }
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace(e);
            }
        }
    }
}

