/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant.ui;

import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.LicenseHeadersPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public final class CustomizerUtilities {
    public static JComponent createLicenseHeaderCustomizerPanel(ProjectCustomizer.Category category, LicensePanelContentHandler handler) {
        return new LicenseHeadersPanel(category, handler);
    }

    @NonNull
    public static LibraryChooser.LibraryImportHandler getLibraryChooserImportHandler(final @NonNull ReferenceHelper refHelper) {
        Parameters.notNull("refHelper", refHelper);
        return new LibraryChooser.LibraryImportHandler(){

            @Override
            public Library importLibrary(Library library) throws IOException {
                return refHelper.copyLibrary(library);
            }
        };
    }

    @NonNull
    public static LibraryChooser.LibraryImportHandler getLibraryChooserImportHandler(final @NonNull File librariesLocation) {
        Parameters.notNull("librariesLocation", librariesLocation);
        return new LibraryChooser.LibraryImportHandler(){

            @Override
            public Library importLibrary(@NonNull Library library) throws IOException {
                return ReferenceHelper.copyLibrary(library, librariesLocation);
            }
        };
    }

    public static interface LicensePanelContentHandler {
        public String getProjectLicenseLocation();

        public String getGlobalLicenseName();

        public FileObject resolveProjectLocation(@NonNull String var1);

        public void setProjectLicenseLocation(@NullAllowed String var1);

        public void setGlobalLicenseName(@NullAllowed String var1);

        public String getDefaultProjectLicenseLocation();

        public void setProjectLicenseContent(@NullAllowed String var1);
    }
}

