/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class ModuleUpdater
extends Thread {
    private static final String DOWNLOAD_DIR_NAME = "download";
    static final String DOWNLOAD_DIR = "update" + UpdateTracking.FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + UpdateTracking.FILE_SEPARATOR + "backup";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    public static final String NBM_EXTENSION = "nbm";
    public static final String JAR_EXTENSION = "jar";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    private static final String TEMP_FILE_NAME = "temporary";
    public static final String UPDATER_JAR = "updater.jar";
    public static final String AUTOUPDATE_UPDATER_JAR_PATH = "netbeans/modules/ext/updater.jar";
    public static final String AUTOUPDATE_UPDATER_JAR_LOCALE_PATTERN = "netbeans/modules/ext/locale/updater(_[a-zA-Z0-9]+)+";
    public static final String EXECUTABLE_FILES_ENTRY = "Info/executables.list";
    private Map<File, Collection<File>> files2clustersForInstall;
    private volatile boolean stop = false;
    private long totalLength;
    private final UpdatingContext context;

    ModuleUpdater(UpdatingContext context) {
        super("Module Updater");
        this.context = context;
    }

    @Override
    public void run() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            this.checkStop();
            if (this.getClustersForInstall().isEmpty()) {
                this.endRun();
            }
            this.checkStop();
            this.totalLength();
            this.checkStop();
            this.unpack();
            for (File cluster : UpdateTracking.clusters(true)) {
                this.deleteAdditionalInfo(cluster);
            }
        }
        catch (Exception x) {
            XMLUtil.LOG.log(Level.SEVERE, "Error while upgrading", x);
        }
        finally {
            this.context.runningFinished();
        }
    }

    private void deleteInstallLater(File cluster) {
        File later = new File(cluster, UpdateTracking.FILE_SEPARATOR + DOWNLOAD_DIR + UpdateTracking.FILE_SEPARATOR + LATER_FILE_NAME);
        if (later.exists()) {
            later.delete();
            XMLUtil.LOG.info("File " + later + " deleted.");
        }
        for (File f = later.getParentFile(); f != null && f.delete(); f = f.getParentFile()) {
        }
    }

    private void deleteAdditionalInfo(File cluster) {
        File f;
        File additional = new File(cluster, UpdateTracking.FILE_SEPARATOR + DOWNLOAD_DIR + UpdateTracking.FILE_SEPARATOR + "additional_information.xml");
        if (additional != null && additional.exists()) {
            additional.delete();
            XMLUtil.LOG.info("File " + additional + " deleted.");
        }
        File file = f = additional == null ? null : additional.getParentFile();
        while (f != null && f.delete()) {
            f = f.getParentFile();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.stop) {
            if (this.context.isFromIDE()) {
                this.context.unpackingFinished();
            } else {
                System.exit(0);
            }
        }
    }

    private void processFilesForInstall() {
        if (this.context.forInstall() == null) {
            this.files2clustersForInstall = new HashMap<File, Collection<File>>();
            for (File cluster : UpdateTracking.clusters(true)) {
                Set<File> tmp = ModuleUpdater.getModulesToInstall(cluster);
                this.files2clustersForInstall.put(cluster, tmp);
                if (this.context.isFromIDE()) continue;
                this.deleteInstallLater(cluster);
            }
        } else {
            this.files2clustersForInstall = new HashMap<File, Collection<File>>();
            for (File nbm : this.context.forInstall()) {
                if (!nbm.exists()) continue;
                File cluster = ModuleUpdater.getCluster(nbm);
                if (this.files2clustersForInstall.get(cluster) == null) {
                    this.files2clustersForInstall.put(cluster, new HashSet());
                }
                this.files2clustersForInstall.get(cluster).add(nbm);
            }
        }
    }

    private static File getCluster(File nbm) {
        File cluster = null;
        try {
            assert (nbm.exists()) : nbm + " for install exists.";
            assert (nbm.getParentFile() != null) : nbm + " has parent.";
            assert (DOWNLOAD_DIR_NAME.equalsIgnoreCase(nbm.getParentFile().getName())) : nbm + " is in directory " + "download";
            assert (nbm.getParentFile().getParentFile() != null) : nbm.getParentFile() + " has parent.";
            assert ("update".equalsIgnoreCase(nbm.getParentFile().getParentFile().getName())) : nbm + " is in directory " + "update";
            assert (nbm.getParentFile().getParentFile().getParentFile() != null) : nbm.getParentFile().getParentFile() + " has parent.";
            cluster = nbm.getParentFile().getParentFile().getParentFile();
        }
        catch (NullPointerException npe) {
            XMLUtil.LOG.log(Level.SEVERE, "getCluster (" + nbm + ") throws an exception", npe);
        }
        return cluster;
    }

    private Collection<File> getFilesForInstallInCluster(File cluster) {
        if (this.files2clustersForInstall == null) {
            this.processFilesForInstall();
        }
        return this.files2clustersForInstall == null ? null : this.files2clustersForInstall.get(cluster);
    }

    private Collection<File> getClustersForInstall() {
        if (this.files2clustersForInstall == null) {
            this.processFilesForInstall();
        }
        return this.files2clustersForInstall == null ? null : this.files2clustersForInstall.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalLength() {
        this.totalLength = 0L;
        this.context.setLabel(Localization.getBrandedString("CTL_PreparingUnpack"));
        HashSet<File> allFiles = new HashSet<File>();
        for (File c : this.getClustersForInstall()) {
            allFiles.addAll(this.getFilesForInstallInCluster(c));
        }
        this.context.setProgressRange(0L, allFiles.size());
        int i = 0;
        for (File f : allFiles) {
            ZipFile jarFile = null;
            try {
                if (f.getName().endsWith(".jar")) {
                    this.totalLength += f.length();
                } else {
                    jarFile = new JarFile(f);
                    Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        this.checkStop();
                        if (!entry.getName().startsWith(UPDATE_NETBEANS_DIR) && !entry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !entry.getName().startsWith(UPDATE_MAIN_DIR) || entry.isDirectory()) continue;
                        this.totalLength += entry.getSize();
                    }
                }
                this.context.setProgressValue(i++);
            }
            catch (IOException e) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot count size of entries in " + f, e);
            }
            finally {
                try {
                    if (jarFile == null) continue;
                    jarFile.close();
                }
                catch (IOException e) {
                    XMLUtil.LOG.log(Level.WARNING, "While closing " + jarFile + " input stream", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack() {
        long bytesRead = 0L;
        this.context.setLabel("");
        this.context.setProgressRange(0L, this.totalLength);
        ArrayList<UpdateTracking> allTrackings = new ArrayList<UpdateTracking>();
        HashMap<ModuleUpdate, UpdateTracking.Version> l10ns = new HashMap<ModuleUpdate, UpdateTracking.Version>();
        for (File cluster : this.getClustersForInstall()) {
            UpdateTracking tracking = UpdateTracking.getTracking(cluster, true, this.context);
            if (tracking == null) {
                throw new RuntimeException("No update_tracking file in cluster " + cluster);
            }
            allTrackings.add(tracking);
            int installedNBMs = 0;
            for (File nbm : this.getFilesForInstallInCluster(cluster)) {
                UpdateTracking.Module modtrack;
                ModuleUpdate mu;
                block54: {
                    UpdateTracking.Version version;
                    ++installedNBMs;
                    this.context.setLabel(Localization.getBrandedString("CTL_UnpackingFile") + "  " + nbm.getName());
                    XMLUtil.LOG.info("780: " + Localization.getBrandedString("CTL_UnpackingFile") + " " + nbm.getName());
                    this.context.unpackingIsRunning();
                    try {
                        mu = new ModuleUpdate(nbm);
                    }
                    catch (RuntimeException re) {
                        if (!nbm.exists()) continue;
                        XMLUtil.LOG.info("Deleteing file: " + nbm);
                        if (!nbm.delete()) {
                            XMLUtil.LOG.log(Level.WARNING, "File " + nbm + " cannot be deleted. Propably file lock on the file.");
                            assert (false) : "Error: File " + nbm + " cannot be deleted. Propably file lock on the file.";
                            nbm.deleteOnExit();
                            continue;
                        }
                        XMLUtil.LOG.info("File " + nbm + " deleted.");
                        continue;
                    }
                    assert (mu != null) : "Module update is not null for file: " + nbm;
                    if (mu.isL10n()) {
                        modtrack = null;
                        version = tracking.createVersion("0");
                        l10ns.put(mu, version);
                    } else {
                        modtrack = tracking.readModuleTracking(mu.getCodenamebase(), true);
                        UpdateTracking.AdditionalInfo info = UpdateTracking.getAdditionalInformation(cluster, this.context);
                        String origin = info != null && info.getSource(nbm.getName()) != null ? info.getSource(nbm.getName()) : "updater";
                        version = modtrack.addNewVersion(mu.getSpecification_version(), origin);
                    }
                    boolean hasMainClass = false;
                    this.context.setProgressValue(bytesRead);
                    JarFile jarFile = null;
                    try {
                        MainConfig mconfig;
                        String symbolicName;
                        jarFile = new JarFile(nbm);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        Manifest manifest = jarFile.getManifest();
                        String string = symbolicName = manifest != null ? ModuleUpdate.extractCodeName(manifest.getMainAttributes()) : null;
                        if (symbolicName != null) {
                            File osgiJar = nbm;
                            File destFile = new File(cluster, "modules/" + osgiJar.getName());
                            if (destFile.exists()) {
                                File bckFile = new File(this.getBackupDirectory(cluster), osgiJar.getName());
                                bckFile.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream(destFile), this.context.createOS(bckFile), -1L);
                                XMLUtil.LOG.info("Backup file " + destFile + " to " + bckFile);
                                if (!destFile.delete() && ModuleUpdater.isWindows()) {
                                    ModuleUpdater.trickyDeleteOnWindows(destFile);
                                } else {
                                    XMLUtil.LOG.info("File " + destFile + " deleted.");
                                }
                            } else {
                                destFile.getParentFile().mkdirs();
                            }
                            bytesRead = this.copyStreams(new FileInputStream(osgiJar), this.context.createOS(destFile), bytesRead);
                            XMLUtil.LOG.info("Copied file " + osgiJar + " to " + destFile);
                            long crc = UpdateTracking.getFileCRC(destFile);
                            version.addFileWithCrc("modules/" + osgiJar.getName(), Long.toString(crc));
                            File configDir = new File(new File(cluster, "config"), "Modules");
                            String configFileName = symbolicName.replace('.', '-') + ".xml";
                            File configFile = new File(configDir, configFileName);
                            if (configFile.exists()) {
                                long configFileCRC = UpdateTracking.getFileCRC(configFile);
                                version.addFileWithCrc("config/Modules/" + configFileName, Long.toString(configFileCRC));
                            }
                            this.context.setProgressValue(bytesRead);
                            modtrack.setOSGi(true);
                            break block54;
                        }
                        List<String> executableFiles = this.readExecutableFilesList(jarFile);
                        ArrayList<File> filesToChmod = new ArrayList<File>();
                        while (entries.hasMoreElements()) {
                            File destFile;
                            String pathTo;
                            JarEntry entry = entries.nextElement();
                            this.checkStop();
                            if (entry.getName().startsWith(UPDATE_NETBEANS_DIR)) {
                                long crc;
                                if (entry.isDirectory()) continue;
                                pathTo = entry.getName().substring(UPDATE_NETBEANS_DIR.length() + 1);
                                destFile = new File(cluster, pathTo);
                                if (AUTOUPDATE_UPDATER_JAR_PATH.equals(entry.getName()) || entry.toString().matches(AUTOUPDATE_UPDATER_JAR_LOCALE_PATTERN)) {
                                    version.addFileWithCrc(pathTo, Long.toString(destFile.exists() ? UpdateTracking.getFileCRC(destFile) : 0L));
                                    if (destFile.exists()) continue;
                                }
                                if (destFile.exists()) {
                                    File bckFile = new File(this.getBackupDirectory(cluster), entry.getName());
                                    bckFile.getParentFile().mkdirs();
                                    this.copyStreams(new FileInputStream(destFile), this.context.createOS(bckFile), -1L);
                                    XMLUtil.LOG.info("Backup file " + destFile + " to " + bckFile);
                                    if (!destFile.delete() && ModuleUpdater.isWindows()) {
                                        ModuleUpdater.trickyDeleteOnWindows(destFile);
                                    } else {
                                        XMLUtil.LOG.info("File " + destFile + " deleted.");
                                    }
                                } else {
                                    destFile.getParentFile().mkdirs();
                                }
                                if (pathTo.endsWith(".external")) {
                                    File downloaded = new File(destFile.getParentFile(), destFile.getName().substring(0, destFile.getName().lastIndexOf(".external")));
                                    InputStream spec = jarFile.getInputStream(entry);
                                    pathTo = pathTo.substring(0, pathTo.length() - ".external".length());
                                    long expectedCRC = this.externalDownload(spec, nbm);
                                    File external = new File(nbm + "." + Long.toHexString(expectedCRC));
                                    FileInputStream is = new FileInputStream(external);
                                    try {
                                        spec.close();
                                        try (OutputStream os = this.context.createOS(downloaded);){
                                            XMLUtil.LOG.info("810: " + Localization.getBrandedString("CTL_DownloadingFile") + " " + downloaded);
                                            bytesRead = this.copyStreams(is, os, -1L);
                                            XMLUtil.LOG.info("Copied external file " + external + " to " + downloaded);
                                        }
                                    }
                                    finally {
                                        external.delete();
                                        XMLUtil.LOG.info("File " + external + " deleted.");
                                        ((InputStream)is).close();
                                    }
                                    crc = UpdateTracking.getFileCRC(downloaded);
                                    if (crc != expectedCRC) {
                                        downloaded.delete();
                                        XMLUtil.LOG.info("File " + downloaded + " deleted.");
                                        throw new IOException("Wrong CRC for " + downloaded);
                                    }
                                } else {
                                    bytesRead = this.copyStreams(jarFile.getInputStream(entry), this.context.createOS(destFile), bytesRead);
                                    XMLUtil.LOG.info("Copied file " + jarFile.getName() + ":" + entry + " to " + destFile);
                                    crc = entry.getCrc();
                                }
                                if (executableFiles.contains(pathTo)) {
                                    filesToChmod.add(destFile);
                                }
                                if (pathTo.endsWith(".jar.pack.gz") && jarFile.getEntry(entry.getName().substring(0, entry.getName().lastIndexOf(".pack.gz"))) == null) {
                                    File unpacked = new File(destFile.getParentFile(), destFile.getName().substring(0, destFile.getName().lastIndexOf(".pack.gz")));
                                    this.unpack200(destFile, unpacked);
                                    destFile.delete();
                                    XMLUtil.LOG.info("File " + destFile + " deleted.");
                                    pathTo = pathTo.substring(0, pathTo.length() - ".pack.gz".length());
                                    crc = UpdateTracking.getFileCRC(unpacked);
                                }
                                if (mu.isL10n()) {
                                    version.addL10NFileWithCrc(pathTo, Long.toString(crc), mu.getSpecification_version());
                                } else {
                                    version.addFileWithCrc(pathTo, Long.toString(crc));
                                }
                                this.context.setProgressValue(bytesRead);
                                continue;
                            }
                            if (!entry.getName().startsWith(UPDATE_MAIN_DIR) || entry.isDirectory()) continue;
                            pathTo = entry.getName().substring(UPDATE_MAIN_DIR.length() + 1);
                            destFile = new File(ModuleUpdater.getMainDirectory(cluster), pathTo);
                            if (executableFiles.contains(pathTo)) {
                                filesToChmod.add(destFile);
                            }
                            destFile.getParentFile().mkdirs();
                            hasMainClass = true;
                            bytesRead = this.copyStreams(jarFile.getInputStream(entry), this.context.createOS(destFile), bytesRead);
                            XMLUtil.LOG.info("Copied file " + jarFile.getName() + ":" + entry + " to " + destFile);
                            this.context.setProgressValue(bytesRead);
                        }
                        this.chmod(filesToChmod);
                        if (hasMainClass && (mconfig = new MainConfig(ModuleUpdater.getMainDirString(cluster) + UpdateTracking.FILE_SEPARATOR + JVM_PARAMS_FILE, cluster)).isValid()) {
                            String java_path = System.getProperty("java.home") + UpdateTracking.FILE_SEPARATOR + "bin" + UpdateTracking.FILE_SEPARATOR + "java";
                            java_path = ModuleUpdater.quoteString(java_path);
                            String torun = java_path + " -cp " + ModuleUpdater.quoteString(ModuleUpdater.getMainDirString(cluster) + mconfig.getClasspath()) + mconfig.getCommand();
                            this.startCommand(torun);
                            this.deleteDir(ModuleUpdater.getMainDirectory(cluster));
                        }
                    }
                    catch (IOException e) {
                        XMLUtil.LOG.log(Level.INFO, "Ignore non-readable files ", e);
                    }
                    finally {
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                        }
                        catch (IOException iOException) {}
                        if (!nbm.delete()) {
                            XMLUtil.LOG.log(Level.WARNING, "Error: Cannot delete {0}", nbm);
                            nbm.deleteOnExit();
                        } else {
                            XMLUtil.LOG.info("File " + nbm + " deleted.");
                        }
                    }
                }
                if (mu.isL10n()) continue;
                modtrack.write();
                modtrack.writeConfigModuleXMLIfMissing();
            }
            if (installedNBMs <= 0) continue;
            UpdaterDispatcher.touchLastModified(cluster);
        }
        for (UpdateTracking t : allTrackings) {
            for (Map.Entry entry : l10ns.entrySet()) {
                ModuleUpdate mod = (ModuleUpdate)entry.getKey();
                UpdateTracking.Version version = (UpdateTracking.Version)entry.getValue();
                UpdateTracking.Module modtrack = t.readModuleTracking(mod.getCodenamebase(), true);
                modtrack.addL10NVersion(version);
                modtrack.write();
            }
            t.deleteUnusedFiles();
        }
    }

    private boolean unpack200(File src, File dest) {
        String unpack200 = "unpack200" + (ModuleUpdater.isWindows() ? ".exe" : "");
        File unpack200Executable = this.findUnpack200Executable(unpack200);
        ProcessBuilder pb = new ProcessBuilder(unpack200Executable.getAbsolutePath(), src.getAbsolutePath(), dest.getAbsolutePath());
        pb.directory(src.getParentFile());
        int result = 1;
        try {
            Process process = pb.start();
            result = process.waitFor();
            process.destroy();
            XMLUtil.LOG.info("Unpack " + src + " to " + dest);
        }
        catch (IOException e) {
            XMLUtil.LOG.log(Level.WARNING, null, e);
        }
        catch (InterruptedException e) {
            XMLUtil.LOG.log(Level.WARNING, null, e);
        }
        return result == 0;
    }

    private File findUnpack200Executable(String unpack200) {
        File unpack200Executable = new File(new File(System.getProperty("java.home"), "bin"), unpack200);
        if (!unpack200Executable.canExecute()) {
            for (File clusterRoot : UpdateTracking.clusters(true)) {
                File unpackKeyFile;
                String unpackKey;
                File uiConfig = new File(new File(new File(new File(new File(new File(new File(clusterRoot, "config"), "Preferences"), "org"), UPDATE_NETBEANS_DIR), "modules"), "autoupdate"), "services.properties");
                if (!uiConfig.canRead()) continue;
                Properties p = new Properties();
                try (FileInputStream is2 = new FileInputStream(uiConfig);){
                    p.load(is2);
                }
                catch (IOException is2) {
                    // empty catch block
                }
                if ((unpackKey = p.getProperty("unpack200")) == null || !(unpackKeyFile = new File(unpackKey)).canExecute()) continue;
                unpack200Executable = unpackKeyFile;
                break;
            }
        }
        return unpack200Executable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readExecutableFilesList(JarFile jarFile) {
        ArrayList<String> list = new ArrayList<String>();
        JarEntry executableFilesEntry = jarFile.getJarEntry(EXECUTABLE_FILES_ENTRY);
        if (executableFilesEntry != null) {
            BufferedReader reader = null;
            try {
                String s;
                reader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(executableFilesEntry), "UTF-8"));
                while ((s = reader.readLine()) != null) {
                    list.add(s);
                }
                reader.close();
            }
            catch (Exception e) {
                XMLUtil.LOG.log(Level.WARNING, null, e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return list;
    }

    private void chmod(List<File> executableFiles) {
        if (ModuleUpdater.isWindows() || executableFiles.isEmpty()) {
            return;
        }
        for (File executableFile : executableFiles) {
            executableFile.setExecutable(true, false);
        }
    }

    public static boolean trickyDeleteOnWindows(File destFile) {
        assert (ModuleUpdater.isWindows()) : "Call it only on Windows but system is " + System.getProperty("os.name");
        File f = new File(destFile.getParentFile(), destFile.getName());
        assert (f.exists()) : "The file " + f + " must exists.";
        try {
            File tmpFile = File.createTempFile(TEMP_FILE_NAME, null, f.getParentFile());
            if (tmpFile.delete()) {
                f.renameTo(tmpFile);
                XMLUtil.LOG.info("File " + f + " renamed to " + tmpFile);
                tmpFile.deleteOnExit();
                XMLUtil.LOG.info("Locked file " + tmpFile + " will be deleted on exit.");
            } else {
                XMLUtil.LOG.info("File " + tmpFile + " was deleted.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !f.exists();
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    private void startCommand(String torun) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process proces;
            final Process proc2 = proces = runtime.exec(ModuleUpdater.parseParameters(torun));
            new Thread(){

                @Override
                public void run() {
                    try {
                        String vystup;
                        InputStreamReader stream = new InputStreamReader(proc2.getErrorStream());
                        BufferedReader reader = new BufferedReader(stream);
                        do {
                            if ((vystup = reader.readLine()) == null) continue;
                            XMLUtil.LOG.info(vystup);
                        } while (vystup != null);
                    }
                    catch (Exception e) {
                        XMLUtil.LOG.log(Level.INFO, null, e);
                    }
                }
            }.start();
            int n = proces.waitFor();
        }
        catch (Exception e) {
            XMLUtil.LOG.log(Level.INFO, null, e);
        }
    }

    public File getBackupDirectory(File activeCluster) {
        File backupDirectory = new File(activeCluster, BACKUP_DIR);
        if (!backupDirectory.isDirectory()) {
            backupDirectory.mkdirs();
        }
        return backupDirectory;
    }

    private static File getMainDirectory(File activeCluster) {
        File mainDirectory = new File(activeCluster, UpdateTracking.FILE_SEPARATOR + "update" + UpdateTracking.FILE_SEPARATOR + UPDATE_MAIN_DIR);
        if (!mainDirectory.isDirectory()) {
            mainDirectory.mkdirs();
        }
        return mainDirectory;
    }

    private static String getMainDirString(File activeCluster) {
        return ModuleUpdater.getMainDirectory(activeCluster).getPath();
    }

    public static String quoteString(String s) {
        if (s.indexOf(32) > -1) {
            StringBuilder sb = new StringBuilder(s);
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '\"') {
                    sb.deleteCharAt(i);
                    continue;
                }
                ++i;
            }
            sb.insert(0, '\"');
            sb.append('\"');
            return sb.toString();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStreams(InputStream src, OutputStream dest, long progressVal) throws IOException {
        BufferedInputStream bsrc = new BufferedInputStream(src);
        BufferedOutputStream bdest = new BufferedOutputStream(dest);
        int count = 0;
        byte[] bytes = new byte[8192];
        try {
            int c;
            while ((c = bsrc.read(bytes)) != -1) {
                bdest.write(bytes, 0, c);
                if ((count += c) <= 8500) continue;
                if (progressVal >= 0L) {
                    this.context.setProgressValue(progressVal += (long)count);
                }
                count = 0;
                this.checkStop();
            }
            if (progressVal >= 0L) {
                progressVal += (long)count;
            }
        }
        finally {
            bsrc.close();
            bdest.close();
            src.close();
            dest.close();
        }
        return progressVal;
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        for (int j = 0; j < files.length; ++j) {
            if (files[j].isDirectory()) {
                this.deleteDir(files[j]);
            }
            if (!files[j].delete()) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot delete {0}", files[j]);
                assert (false) : "Cannot delete " + files[j];
                continue;
            }
            XMLUtil.LOG.info("File " + files[j] + " deleted.");
        }
    }

    private static String[] parseParameters(String s) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        Vector<String> params = new Vector<String>(5, 5);
        int state = NULL;
        StringBuilder buff = new StringBuilder(20);
        int slength = s.length();
        for (int i = 0; i < slength; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                if (state == NULL) {
                    if (buff.length() <= 0) continue;
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                if (state == STICK) {
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\\');
                    params.addElement(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    state = INPARAM;
                    buff.append('\\');
                    buff.append(c);
                    continue;
                }
                buff.append(c);
                continue;
            }
            if (c == '\\') {
                if (state == NULL) {
                    if (++i < slength) {
                        char cc = s.charAt(i);
                        if (cc == '\"' || cc == '\\') {
                            buff.append(cc);
                            continue;
                        }
                        if (Character.isWhitespace(cc)) {
                            buff.append(c);
                            --i;
                            continue;
                        }
                        buff.append(c);
                        buff.append(cc);
                        continue;
                    }
                    buff.append('\\');
                    break;
                }
                if (state == INPARAM) {
                    state = INPARAMPENDING;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                    continue;
                }
                if (state == STICK) {
                    state = STICKPENDING;
                    continue;
                }
                if (state != STICKPENDING) continue;
                buff.append('\\');
                state = STICK;
                continue;
            }
            if (c == '\"') {
                if (state == NULL) {
                    state = INPARAM;
                    continue;
                }
                if (state == INPARAM) {
                    state = STICK;
                    continue;
                }
                if (state == STICK) {
                    state = INPARAM;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\"');
                    state = STICK;
                    continue;
                }
                buff.append('\"');
                state = INPARAM;
                continue;
            }
            if (state == INPARAMPENDING) {
                buff.append('\\');
                state = INPARAM;
            } else if (state == STICKPENDING) {
                buff.append('\\');
                state = STICK;
            }
            buff.append(c);
        }
        if (state == INPARAM) {
            params.addElement(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.addElement(buff.toString());
        } else if (buff.length() != 0) {
            params.addElement(buff.toString());
        }
        Object[] ret = new String[params.size()];
        params.copyInto(ret);
        return ret;
    }

    private long externalDownload(InputStream spec, File nbm) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(spec));
        do {
            if ((line = br.readLine()) != null) continue;
            throw new IOException("No CRC in the .external file!");
        } while (!line.startsWith("CRC:"));
        return Long.parseLong(line.substring(4).trim());
    }

    public static Set<File> getModulesToInstall(File cluster) {
        File idir = new File(cluster, DOWNLOAD_DIR);
        class NbmFilter
        implements FilenameFilter {
            NbmFilter() {
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(ModuleUpdater.NBM_EXTENSION) || name.endsWith(ModuleUpdater.JAR_EXTENSION);
            }
        }
        File[] arr = idir.listFiles(new NbmFilter());
        if (arr == null) {
            return Collections.emptySet();
        }
        return new HashSet<File>(Arrays.asList(arr));
    }

    static class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_PATH_SEPARATOR = "%PS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private String parameters = "";
        private String classpath = "";
        private boolean valid = false;
        private final File activeCluster;

        public MainConfig(String spath, File activeCluster) {
            this.valid = this.readParms(spath);
            this.activeCluster = activeCluster;
        }

        public String getCommand() {
            return this.parameters;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readParms(String spath) {
            String mainclass;
            Properties details = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(spath);
                details.load(fis);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String relpath = details.getProperty("relativeClassPath", null);
            if (relpath != null) {
                relpath = this.replaceVars(relpath);
                StringTokenizer token = new StringTokenizer(relpath, UpdateTracking.PATH_SEPARATOR, false);
                while (token.hasMoreTokens()) {
                    this.classpath = this.classpath + UpdateTracking.PATH_SEPARATOR + this.changeRelative(token.nextToken());
                }
            }
            this.parameters = "";
            String jvmparms = details.getProperty("jvm.parameters", null);
            if (jvmparms != null) {
                this.parameters = this.parameters + " " + jvmparms;
            }
            if ((mainclass = details.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + mainclass;
            String mainargs = details.getProperty("mainClass.arguments", null);
            if (mainargs != null) {
                this.parameters = this.parameters + " " + mainargs;
            }
            this.parameters = this.replaceVars(this.parameters);
            return true;
        }

        private String replaceVars(String original) {
            original = this.replaceAll(original, "%IDE_HOME%", UpdateTracking.getPlatformDir() == null ? "" : UpdateTracking.getPlatformDir().getPath());
            original = this.replaceAll(original, "%IDE_USER%", UpdateTracking.getUserDir() == null ? "" : UpdateTracking.getUserDir().getPath());
            original = this.replaceAll(original, "%FS%", UpdateTracking.FILE_SEPARATOR);
            original = this.replaceAll(original, "%PS%", UpdateTracking.PATH_SEPARATOR);
            original = this.replaceAll(original, "%JAVA_HOME%", System.getProperty("java.home"));
            return original;
        }

        private String changeRelative(String path) {
            if (new File(path).isAbsolute()) {
                return path;
            }
            return ModuleUpdater.getMainDirString(this.activeCluster) + UpdateTracking.FILE_SEPARATOR + path;
        }

        private String replaceAll(String sin, String what, String repl) {
            StringBuilder sb = new StringBuilder(sin);
            int i = sb.toString().indexOf(what);
            int len = what.length();
            while (i > -1) {
                sb.replace(i, i + len, repl);
                i = sb.toString().indexOf(what, i + 1);
            }
            return sb.toString();
        }
    }
}

