/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class DefaultEMLookup
extends ProxyLookup
implements LookupListener,
PropertyChangeListener {
    private static final Object PRESENT = new Object();
    private ExplorerManager tc;
    private LookupListener listener;
    private Map<Lookup, Lookup.Result> attachedTo;
    private Lookup actionMap;

    public DefaultEMLookup(ExplorerManager tc, ActionMap map) {
        this.tc = tc;
        this.listener = WeakListeners.create(LookupListener.class, this, null);
        this.actionMap = Lookups.singleton(map);
        tc.addPropertyChangeListener(WeakListeners.propertyChange(this, tc));
        this.updateLookups(tc.getSelectedNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookups(Node[] arr) {
        Map<Object, Object> copy;
        if (arr == null) {
            arr = new Node[]{};
        }
        Lookup[] lookups = new Lookup[arr.length];
        DefaultEMLookup defaultEMLookup = this;
        synchronized (defaultEMLookup) {
            copy = this.attachedTo == null ? Collections.emptyMap() : new HashMap<Lookup, Lookup.Result>(this.attachedTo);
        }
        for (int i = 0; i < arr.length; ++i) {
            lookups[i] = arr[i].getLookup();
            if (copy == null) continue;
            copy.remove(arr[i]);
        }
        for (Lookup.Result res : copy.values()) {
            res.removeLookupListener(this.listener);
        }
        DefaultEMLookup defaultEMLookup2 = this;
        synchronized (defaultEMLookup2) {
            this.attachedTo = null;
        }
        this.setLookups(new NoNodeLookup(new ProxyLookup(lookups), arr), Lookups.fixed(arr), this.actionMap);
    }

    @Override
    public void resultChanged(LookupEvent ev) {
        this.updateLookups(this.tc.getSelectedNodes());
    }

    private static boolean isNodeQuery(Class<?> c) {
        return Node.class.isAssignableFrom(c) || c.isAssignableFrom(Node.class);
    }

    @Override
    protected synchronized void beforeLookup(Lookup.Template<?> t) {
        if (this.attachedTo == null && DefaultEMLookup.isNodeQuery(t.getType())) {
            Lookup[] arr = this.getLookups();
            this.attachedTo = new WeakHashMap<Lookup, Lookup.Result>(arr.length * 2);
            for (int i = 0; i < arr.length - 2; ++i) {
                Lookup.Result<?> res = arr[i].lookup(t);
                res.addLookupListener(this.listener);
                this.attachedTo.put(arr[i], res);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes" == evt.getPropertyName()) {
            this.updateLookups((Node[])evt.getNewValue());
        }
    }

    private static final class NoNodeLookup
    extends Lookup {
        private final Lookup delegate;
        private final Map<Node, Object> verboten;

        public NoNodeLookup(Lookup del, Node[] exclude) {
            this.delegate = del;
            this.verboten = new IdentityHashMap<Node, Object>();
            int i = 0;
            while (i < exclude.length) {
                this.verboten.put(exclude[i++], PRESENT);
            }
        }

        @Override
        public <T> T lookup(Class<T> clazz) {
            if (clazz == Node.class) {
                return null;
            }
            T o = this.delegate.lookup(clazz);
            if (this.verboten.containsKey(o)) {
                for (T o2 : this.lookup(new Lookup.Template<T>(clazz)).allInstances()) {
                    if (this.verboten.containsKey(o2)) continue;
                    return o2;
                }
                return null;
            }
            return o;
        }

        @Override
        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            Class<T> clz = template.getType();
            if (clz == Node.class) {
                return Lookup.EMPTY.lookup(new Lookup.Template<T>(clz));
            }
            return new ExclusionResult<T>(this.delegate.lookup(template), this.verboten);
        }

        private static final class ExclusionResult<T>
        extends Lookup.Result<T>
        implements LookupListener {
            private final Lookup.Result<T> delegate;
            private final Map<Node, Object> verboten;
            private final List<LookupListener> listeners = new ArrayList<LookupListener>();

            public ExclusionResult(Lookup.Result<T> delegate, Map<Node, Object> verboten) {
                this.delegate = delegate;
                this.verboten = verboten;
            }

            @Override
            public Collection<? extends T> allInstances() {
                Collection<T> c = this.delegate.allInstances();
                ArrayList<T> ret = new ArrayList<T>(c.size());
                for (T o : c) {
                    if (this.verboten.containsKey(o)) continue;
                    ret.add(o);
                }
                return ret;
            }

            @Override
            public Set<Class<? extends T>> allClasses() {
                return this.delegate.allClasses();
            }

            @Override
            public Collection<? extends Lookup.Item<T>> allItems() {
                Collection<Lookup.Item<T>> c = this.delegate.allItems();
                ArrayList<Lookup.Item<T>> ret = new ArrayList<Lookup.Item<T>>(c.size());
                for (Lookup.Item<T> i : c) {
                    if (Node.class.isAssignableFrom(i.getType()) && this.verboten.containsKey(i.getInstance())) continue;
                    ret.add(i);
                }
                return ret;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addLookupListener(LookupListener l) {
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    if (this.listeners.isEmpty()) {
                        this.delegate.addLookupListener(this);
                    }
                    this.listeners.add(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeLookupListener(LookupListener l) {
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    this.listeners.remove(l);
                    if (this.listeners.isEmpty()) {
                        this.delegate.removeLookupListener(this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resultChanged(LookupEvent ev) {
                LookupListener[] ls;
                LookupEvent ev2 = new LookupEvent(this);
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    ls = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].resultChanged(ev2);
                }
            }
        }
    }
}

