/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

final class ExternalUtil {
    static final Logger LOG = Logger.getLogger("org.openide.filesystems");

    ExternalUtil() {
    }

    public static void exception(Exception ex) {
        LOG.log(Level.INFO, null, ex);
    }

    public static Throwable copyAnnotation(Throwable newEx, Throwable oldEx) {
        return newEx.initCause(oldEx);
    }

    public static void annotate(Throwable ex, String msg) {
        Exceptions.attachLocalizedMessage(ex, msg);
    }

    public static Throwable annotate(Throwable ex, Throwable stack) {
        Throwable orig = ex;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        try {
            ex.initCause(stack);
        }
        catch (IllegalStateException ise) {
            Exception e = new Exception(ex.getMessage(), stack);
            e.setStackTrace(ex.getStackTrace());
            return e;
        }
        return orig;
    }

    public static void log(String msg) {
        LOG.fine(msg);
    }

    public static Class findClass(String name) throws ClassNotFoundException {
        ClassLoader c = Lookup.getDefault().lookup(ClassLoader.class);
        if (c == null) {
            return Class.forName(name);
        }
        return Class.forName(name, true, c);
    }
}

