/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.netbeans.nbpackage.Configuration;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import picocli.CommandLine;

public class Main {
    public static void main(String[] args) {
        CommandLine cmd = new CommandLine((Object)new Launcher());
        cmd.setResourceBundle(NBPackage.MESSAGES);
        int ret = cmd.execute(args);
        System.exit(ret);
    }

    @CommandLine.Command(mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
    private static class Launcher
    implements Callable<Integer> {
        @CommandLine.Option(names={"-t", "--type"}, descriptionKey="option.type.description", completionCandidates=TypesCandidates.class)
        private String packageType;
        @CommandLine.Option(names={"-i", "--input"}, descriptionKey="option.input.description")
        private Path input;
        @CommandLine.Option(names={"--input-image"}, descriptionKey="option.inputimage.description")
        private Path inputImage;
        @CommandLine.Option(names={"-o", "--output"}, descriptionKey="option.output.description")
        private Path output;
        @CommandLine.Option(names={"-c", "--config"}, descriptionKey="option.config.description")
        private Path config;
        @CommandLine.Option(names={"--save-config"}, descriptionKey="option.saveconfig.description")
        private Path configOut;
        @CommandLine.Option(names={"--save-templates"}, descriptionKey="option.savetemplates.description")
        private Path templatesOut;
        @CommandLine.Option(names={"--image-only"}, descriptionKey="option.imageonly.description")
        private boolean imageOnly;
        @CommandLine.Option(names={"-v", "--verbose"}, descriptionKey="option.verbose.description")
        private boolean verbose;
        @CommandLine.Option(names={"-P"}, descriptionKey="option.property.description")
        private Map<String, String> options;

        private Launcher() {
        }

        @Override
        public Integer call() throws Exception {
            try {
                if (this.input == null && this.inputImage == null && !this.hasAuxTasks()) {
                    this.error(NBPackage.MESSAGES.getString("message.notasks"));
                    return 1;
                }
                if (this.input != null && this.inputImage != null) {
                    this.error(NBPackage.MESSAGES.getString("message.inputandimage"));
                    return 2;
                }
                Configuration.Builder cb = Configuration.builder();
                if (this.config != null) {
                    cb.load(this.config.toAbsolutePath());
                }
                if (this.packageType != null && !this.packageType.isBlank()) {
                    cb.set(NBPackage.PACKAGE_TYPE, this.packageType);
                }
                if (this.options != null && !this.options.isEmpty()) {
                    this.options.forEach((key, value) -> {
                        Option opt = NBPackage.options().filter(o -> o.key().equals(key) || o.key().equals("package." + key)).findFirst().orElseThrow(() -> new IllegalArgumentException((String)key));
                        cb.set(opt, (String)value);
                    });
                }
                if (this.verbose) {
                    cb.verbose();
                }
                cb.messageHandlers(this::warning, this::info);
                Configuration conf = cb.build();
                if (this.configOut != null) {
                    NBPackage.writeFullConfiguration(conf, this.configOut);
                }
                if (this.templatesOut != null) {
                    NBPackage.copyTemplates(conf, this.templatesOut);
                }
                Path dest = this.output == null ? Path.of("", new String[0]) : this.output;
                Path created = null;
                if (this.input != null) {
                    created = this.imageOnly ? NBPackage.createImage(this.input, conf, dest) : NBPackage.createPackage(this.input, conf, dest);
                } else if (this.inputImage != null) {
                    created = NBPackage.packageImage(this.inputImage, conf, dest);
                }
                return 0;
            }
            catch (Exception ex) {
                this.error(ex.getClass().getSimpleName());
                this.error(ex.getLocalizedMessage());
                if (this.verbose) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    this.error(sw.toString());
                }
                return 3;
            }
        }

        private void info(String msg) {
            System.out.println(msg);
        }

        private void warning(String msg) {
            String ansiMsg = CommandLine.Help.Ansi.AUTO.string("@|bold " + msg + "|@");
            System.out.println(ansiMsg);
        }

        private void error(String msg) {
            String ansiMsg = CommandLine.Help.Ansi.AUTO.string("@|bold,red " + msg + "|@");
            System.out.println(ansiMsg);
        }

        private boolean hasAuxTasks() {
            return this.configOut != null || this.templatesOut != null;
        }
    }

    private static class VersionProvider
    implements CommandLine.IVersionProvider {
        private VersionProvider() {
        }

        public String[] getVersion() throws Exception {
            String msg = MessageFormat.format(NBPackage.MESSAGES.getString("message.version"), NBPackage.version().orElse("<DEV>"));
            return new String[]{msg};
        }
    }

    private static class TypesCandidates
    implements Iterable<String> {
        private TypesCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return NBPackage.packagers().map(Packager::name).sorted().iterator();
        }
    }
}

