/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.params.AbstractUpdateParamContextCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.dto.AssetReferenceDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextUpdateRequestEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;

public class AddAssetReference
extends AbstractUpdateParamContextCommand<VoidResult> {
    public AddAssetReference() {
        super("add-asset-reference", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Adds an asset reference to a parameter. The parameter will be created if it does not already exist.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.PARAM_NAME.createOption());
        this.addOption(CommandOption.PARAM_DESC.createOption());
        this.addOption(CommandOption.ASSET_ID.createOption());
        this.addOption(CommandOption.UPDATE_TIMEOUT.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String paramName = this.getRequiredArg(properties, CommandOption.PARAM_NAME);
        String paramDescription = this.getArg(properties, CommandOption.PARAM_DESC);
        String assetId = this.getRequiredArg(properties, CommandOption.ASSET_ID);
        int updateTimeout = this.getUpdateTimeout(properties);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity existingParameterContextEntity = paramContextClient.getParamContext(paramContextId, false);
        ParameterContextDTO existingParameterContextDTO = existingParameterContextEntity.getComponent();
        Optional<ParameterDTO> existingParam = existingParameterContextDTO.getParameters().stream().map(ParameterEntity::getParameter).filter(p -> p.getName().equals(paramName)).findFirst();
        ParameterDTO parameterDTO = existingParam.orElseGet(ParameterDTO::new);
        parameterDTO.setName(paramName);
        parameterDTO.setSensitive(Boolean.valueOf(false));
        parameterDTO.setProvided(Boolean.valueOf(false));
        parameterDTO.setValue(null);
        if (paramDescription != null) {
            parameterDTO.setDescription(paramDescription);
        }
        if (parameterDTO.getReferencedAssets() == null) {
            parameterDTO.setReferencedAssets(new ArrayList());
        }
        HashSet<AssetReferenceDTO> assetReferences = new HashSet<AssetReferenceDTO>(parameterDTO.getReferencedAssets());
        assetReferences.add(new AssetReferenceDTO(assetId));
        parameterDTO.getReferencedAssets().clear();
        parameterDTO.getReferencedAssets().addAll(assetReferences);
        ParameterContextEntity updatedParameterContextEntity = this.createContextEntityForUpdate(paramContextId, parameterDTO, existingParameterContextDTO.getInheritedParameterContexts(), existingParameterContextEntity.getRevision());
        ParameterContextUpdateRequestEntity updateRequestEntity = paramContextClient.updateParamContext(updatedParameterContextEntity);
        this.performUpdate(paramContextClient, updatedParameterContextEntity, updateRequestEntity, updateTimeout);
        if (this.isInteractive()) {
            this.println();
        }
        return VoidResult.getInstance();
    }
}

