/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;

public class RegistryClientsResult
extends AbstractWritableResult<FlowRegistryClientsEntity> {
    final FlowRegistryClientsEntity registryClients;

    public RegistryClientsResult(ResultType resultType, FlowRegistryClientsEntity registryClients) {
        super(resultType);
        this.registryClients = Objects.requireNonNull(registryClients);
    }

    @Override
    public FlowRegistryClientsEntity getResult() {
        return this.registryClients;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Set clients = this.registryClients.getRegistries();
        if (clients == null || clients.isEmpty()) {
            return;
        }
        List<FlowRegistryClientDTO> registries = clients.stream().map(FlowRegistryClientEntity::getComponent).sorted(Comparator.comparing(FlowRegistryClientDTO::getName)).toList();
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Properties", 3, Integer.MAX_VALUE, false).build();
        for (int i = 0; i < registries.size(); ++i) {
            FlowRegistryClientDTO clientDto = registries.get(i);
            Map properties = clientDto.getProperties();
            table.addRow("" + (i + 1), clientDto.getName(), clientDto.getId(), properties == null ? "" : properties.toString());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

