/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.AttributeCollector;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.FixedNsContext;
import com.fasterxml.aalto.in.NsBinding;
import com.fasterxml.aalto.in.NsDeclaration;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.EmptyIterator;
import com.fasterxml.aalto.util.IllegalCharHandler;
import com.fasterxml.aalto.util.SingletonIterator;
import com.fasterxml.aalto.util.TextBuilder;
import com.fasterxml.aalto.util.XmlChars;
import com.fasterxml.aalto.util.XmlConsts;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.olingo.javax.xml.stream.XMLStreamConstants;
import org.apache.olingo.javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XmlScanner
implements XmlConsts,
XMLStreamConstants,
NamespaceContext {
    protected final String CDATA_STR = "CDATA[";
    public static final int TOKEN_EOI = -1;
    protected static final int MAX_UNICODE_CHAR = 0x10FFFF;
    protected static final int INT_NULL = 0;
    protected static final int INT_CR = 13;
    protected static final int INT_LF = 10;
    protected static final int INT_TAB = 9;
    protected static final int INT_SPACE = 32;
    protected static final int INT_HYPHEN = 45;
    protected static final int INT_QMARK = 63;
    protected static final int INT_AMP = 38;
    protected static final int INT_LT = 60;
    protected static final int INT_GT = 62;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_APOS = 39;
    protected static final int INT_EXCL = 33;
    protected static final int INT_COLON = 58;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_SLASH = 47;
    protected static final int INT_EQ = 61;
    protected static final int INT_A = 65;
    protected static final int INT_F = 70;
    protected static final int INT_a = 97;
    protected static final int INT_f = 102;
    protected static final int INT_z = 122;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    private static final int BIND_MISSES_TO_ACTIVATE_CACHE = 10;
    private static final int BIND_CACHE_SIZE = 64;
    private static final int BIND_CACHE_MASK = 63;
    protected final ReaderConfig _config;
    protected final boolean _xml11;
    protected final boolean _cfgCoalescing;
    protected boolean _cfgLazyParsing;
    protected int _currToken = 7;
    protected boolean _tokenIncomplete = false;
    protected int _depth = 0;
    protected final TextBuilder _textBuilder;
    protected boolean _entityPending = false;
    protected char[] _nameBuffer = null;
    protected PName _tokenName = null;
    protected boolean _isEmptyTag = false;
    protected ElementScope _currElem;
    protected String _publicId;
    protected String _systemId;
    protected NsDeclaration _lastNsDecl = null;
    protected int _currNsCount = 0;
    protected NsBinding _defaultNs = NsBinding.createDefaultNs();
    protected NsBinding[] _nsBindings;
    protected int _nsBindingCount = 0;
    protected PName[] _nsBindingCache = null;
    protected int _nsBindMisses = 0;
    protected FixedNsContext _lastNsContext = FixedNsContext.EMPTY_CONTEXT;
    protected final AttributeCollector _attrCollector;
    protected int _attrCount = 0;
    protected long _pastBytesOrChars;
    protected int _currRow;
    protected int _rowStartOffset;
    protected long _startRawOffset;
    protected long _startRow = -1L;
    protected long _startColumn = -1L;

    protected XmlScanner(ReaderConfig cfg) {
        this._config = cfg;
        this._cfgCoalescing = cfg.willCoalesceText();
        this._cfgLazyParsing = cfg.willParseLazily();
        this._xml11 = cfg.isXml11();
        this._textBuilder = TextBuilder.createRecyclableBuffer(this._config);
        this._attrCollector = new AttributeCollector(cfg);
        this._nameBuffer = cfg.allocSmallCBuffer(60);
        this._currRow = 0;
    }

    public final void close(boolean forceCloseSource) throws XMLStreamException {
        this._releaseBuffers();
        if (forceCloseSource || this._config.willAutoCloseInput()) {
            try {
                this._closeSource();
            }
            catch (IOException ioe) {
                throw new IoStreamException(ioe);
            }
        }
    }

    protected void _releaseBuffers() {
        this._textBuilder.recycle(true);
        if (this._nameBuffer != null) {
            char[] buf = this._nameBuffer;
            this._nameBuffer = null;
            this._config.freeSmallCBuffer(buf);
        }
    }

    protected abstract void _closeSource() throws IOException;

    public ReaderConfig getConfig() {
        return this._config;
    }

    public AttributeCollector getAttrCollector() {
        return this._attrCollector;
    }

    public abstract int nextFromProlog(boolean var1) throws XMLStreamException;

    public abstract int nextFromTree() throws XMLStreamException;

    protected abstract void finishToken() throws XMLStreamException;

    protected final boolean skipToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.skipPI();
                break;
            }
            case 4: {
                if (this.skipCharacters()) {
                    this._currToken = 9;
                    return true;
                }
                if (!this._cfgCoalescing || !this.skipCoalescedText()) break;
                this._currToken = 9;
                return true;
            }
            case 5: {
                this.skipComment();
                break;
            }
            case 6: {
                this.skipSpace();
                break;
            }
            case 12: {
                this.skipCData();
                if (!this._cfgCoalescing) break;
                this.skipCoalescedText();
                if (!this._entityPending) break;
                this._currToken = 9;
                return true;
            }
            case 11: {
                this.finishDTD(false);
                break;
            }
            default: {
                throw new Error("Internal error, unexpected incomplete token type " + ErrorConsts.tokenTypeDesc(this._currToken));
            }
        }
        return false;
    }

    public abstract XMLStreamLocation2 getCurrentLocation();

    public final XMLStreamLocation2 getStartLocation() {
        int row = (int)this._startRow;
        int col = (int)this._startColumn;
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._startRawOffset, row, col);
    }

    public abstract long getStartingByteOffset();

    public abstract long getStartingCharOffset();

    public abstract long getEndingByteOffset() throws XMLStreamException;

    public abstract long getEndingCharOffset() throws XMLStreamException;

    public XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this.getCurrentLocation();
    }

    public final int getCurrentLineNr() {
        return this._currRow + 1;
    }

    public abstract int getCurrentColumnNr();

    public final String getInputSystemId() {
        return this._config.getSystemId();
    }

    public final String getInputPublicId() {
        return this._config.getPublicId();
    }

    public final boolean hasEmptyStack() {
        return this._depth == 0;
    }

    public final int getDepth() {
        return this._depth;
    }

    public final boolean isEmptyTag() {
        return this._isEmptyTag;
    }

    public final PName getName() {
        return this._tokenName;
    }

    public final QName getQName() {
        return this._tokenName.constructQName(this._defaultNs);
    }

    public final String getDTDPublicId() {
        return this._publicId;
    }

    public final String getDTDSystemId() {
        return this._systemId;
    }

    public final String getText() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsAsString();
    }

    public final int getTextLength() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.size();
    }

    public final char[] getTextCharacters() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.getTextBuffer();
    }

    public final int getTextCharacters(int srcStart, char[] target, int targetStart, int len) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.contentsToArray(srcStart, target, targetStart, len);
    }

    public final int getText(Writer w, boolean preserveContents) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        try {
            return this._textBuilder.rawContentsTo(w);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    public final boolean isTextWhitespace() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._textBuilder.isAllWhitespace();
    }

    public final int decodeElements(TypedArrayDecoder tad, boolean reset) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        try {
            return this._textBuilder.decodeElements(tad, reset);
        }
        catch (TypedXMLStreamException tex) {
            XMLStreamLocation2 loc = this.getCurrentLocation();
            String lexical = tex.getLexical();
            IllegalArgumentException iae = (IllegalArgumentException)tex.getCause();
            throw new TypedXMLStreamException(lexical, tex.getMessage(), loc, iae);
        }
    }

    public final void resetForDecoding(Base64Variant v, CharArrayBase64Decoder dec, boolean firstChunk) throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        this._textBuilder.resetForBinaryDecode(v, dec, firstChunk);
    }

    public void fireSaxStartElement(ContentHandler h, Attributes attrs) throws SAXException {
        if (h != null) {
            String uri;
            int level = this._depth - 1;
            for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null && nsDecl.getLevel() == level; nsDecl = nsDecl.getPrev()) {
                String prefix = nsDecl.getPrefix();
                uri = nsDecl.getCurrNsURI();
                h.startPrefixMapping(prefix == null ? "" : prefix, uri);
            }
            PName n = this.getName();
            uri = n.getNsUri();
            h.startElement(uri == null ? "" : uri, n.getLocalName(), n.getPrefixedName(), attrs);
        }
    }

    public void fireSaxEndElement(ContentHandler h) throws SAXException {
        if (h != null) {
            PName n = this.getName();
            String uri = n.getNsUri();
            h.endElement(uri == null ? "" : uri, n.getLocalName(), n.getPrefixedName());
            int level = this._depth;
            for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null && nsDecl.getLevel() == level; nsDecl = nsDecl.getPrev()) {
                String prefix = nsDecl.getPrefix();
                h.endPrefixMapping(prefix == null ? "" : prefix);
            }
        }
    }

    public void fireSaxCharacterEvents(ContentHandler h) throws XMLStreamException, SAXException {
        if (h != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxCharacterEvents(h);
        }
    }

    public void fireSaxSpaceEvents(ContentHandler h) throws XMLStreamException, SAXException {
        if (h != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxSpaceEvents(h);
        }
    }

    public void fireSaxCommentEvent(LexicalHandler h) throws XMLStreamException, SAXException {
        if (h != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            this._textBuilder.fireSaxCommentEvent(h);
        }
    }

    public void fireSaxPIEvent(ContentHandler h) throws XMLStreamException, SAXException {
        if (h != null) {
            if (this._tokenIncomplete) {
                this.finishToken();
            }
            h.processingInstruction(this._tokenName.getLocalName(), this.getText());
        }
    }

    public final int getAttrCount() {
        return this._attrCount;
    }

    public final String getAttrLocalName(int index) {
        return this._attrCollector.getName(index).getLocalName();
    }

    public final QName getAttrQName(int index) {
        return this._attrCollector.getQName(index);
    }

    public final String getAttrPrefixedName(int index) {
        return this._attrCollector.getName(index).getPrefixedName();
    }

    public final String getAttrNsURI(int index) {
        return this._attrCollector.getName(index).getNsUri();
    }

    public final String getAttrPrefix(int index) {
        return this._attrCollector.getName(index).getPrefix();
    }

    public final String getAttrValue(int index) {
        return this._attrCollector.getValue(index);
    }

    public final String getAttrValue(String nsURI, String localName) {
        if (this._attrCount < 1) {
            return null;
        }
        return this._attrCollector.getValue(nsURI, localName);
    }

    public final void decodeAttrValue(int index, TypedValueDecoder tvd) throws XMLStreamException {
        this._attrCollector.decodeValue(index, tvd);
    }

    public final int decodeAttrValues(int index, TypedArrayDecoder tad) throws XMLStreamException {
        return this._attrCollector.decodeValues(index, tad, this);
    }

    public final byte[] decodeAttrBinaryValue(int index, Base64Variant v, CharArrayBase64Decoder dec) throws XMLStreamException {
        return this._attrCollector.decodeBinaryValue(index, v, dec, this);
    }

    public final int findAttrIndex(String nsURI, String localName) {
        if (this._attrCount < 1) {
            return -1;
        }
        return this._attrCollector.findIndex(nsURI, localName);
    }

    public final String getAttrType(int index) {
        return "CDATA";
    }

    public final boolean isAttrSpecified(int index) {
        return true;
    }

    public final int getNsCount() {
        if (this._currToken == 1) {
            return this._currNsCount;
        }
        return this._lastNsDecl == null ? 0 : this._lastNsDecl.countDeclsOnLevel(this._depth);
    }

    public final String getNamespacePrefix(int index) {
        return this.findCurrNsDecl((int)index).getBinding().mPrefix;
    }

    public final String getNamespaceURI(int index) {
        return this.findCurrNsDecl((int)index).getBinding().mURI;
    }

    private NsDeclaration findCurrNsDecl(int index) {
        int count;
        NsDeclaration nsDecl = this._lastNsDecl;
        int level = this._depth;
        if (this._currToken == 1) {
            count = this._currNsCount - 1 - index;
            --level;
        } else {
            count = index;
        }
        while (nsDecl != null && nsDecl.getLevel() == level) {
            if (count == 0) {
                return nsDecl;
            }
            --count;
            nsDecl = nsDecl.getPrev();
        }
        this.reportInvalidNsIndex(index);
        return null;
    }

    public final String getNamespaceURI() {
        String uri = this._tokenName.getNsUri();
        return uri == null ? this._defaultNs.mURI : uri;
    }

    public final NamespaceContext getNonTransientNamespaceContext() {
        this._lastNsContext = this._lastNsContext.reuseOrCreate(this._lastNsDecl);
        return this._lastNsContext;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (prefix.length() == 0) {
            String uri = this._defaultNs.mURI;
            return uri == null ? "" : uri;
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            if (!nsDecl.hasPrefix(prefix)) continue;
            return nsDecl.getCurrNsURI();
        }
        return null;
    }

    @Override
    public String getPrefix(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (nsURI.equals(this._defaultNs.mURI)) {
            return "";
        }
        block0: for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            String prefix;
            if (!nsDecl.hasNsURI(nsURI) || (prefix = nsDecl.getPrefix()) == null) continue;
            for (NsDeclaration decl2 = this._lastNsDecl; decl2 != nsDecl; decl2 = decl2.getPrev()) {
                if (decl2.hasPrefix(prefix)) continue block0;
            }
            return prefix;
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return new SingletonIterator("xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return new SingletonIterator("xmlns");
        }
        ArrayList<String> l = null;
        if (nsURI.equals(this._defaultNs.mURI)) {
            l = new ArrayList<String>();
            l.add("");
        }
        block0: for (NsDeclaration nsDecl = this._lastNsDecl; nsDecl != null; nsDecl = nsDecl.getPrev()) {
            String prefix;
            if (!nsDecl.hasNsURI(nsURI) || (prefix = nsDecl.getPrefix()) == null) continue;
            for (NsDeclaration decl2 = this._lastNsDecl; decl2 != nsDecl; decl2 = decl2.getPrev()) {
                if (decl2.hasPrefix(prefix)) continue block0;
            }
            if (l == null) {
                l = new ArrayList();
            }
            l.add(prefix);
        }
        if (l == null) {
            return EmptyIterator.getInstance();
        }
        if (l.size() == 1) {
            return new SingletonIterator((String)l.get(0));
        }
        return l.iterator();
    }

    protected abstract void finishCharacters() throws XMLStreamException;

    protected abstract void finishCData() throws XMLStreamException;

    protected abstract void finishComment() throws XMLStreamException;

    protected abstract void finishDTD(boolean var1) throws XMLStreamException;

    protected abstract void finishPI() throws XMLStreamException;

    protected abstract void finishSpace() throws XMLStreamException;

    protected abstract boolean skipCharacters() throws XMLStreamException;

    protected abstract void skipCData() throws XMLStreamException;

    protected abstract void skipComment() throws XMLStreamException;

    protected abstract void skipPI() throws XMLStreamException;

    protected abstract void skipSpace() throws XMLStreamException;

    protected abstract boolean skipCoalescedText() throws XMLStreamException;

    protected abstract boolean loadMore() throws XMLStreamException;

    protected final PName bindName(PName name, String prefix) {
        PName cn;
        if (this._nsBindingCache != null && (cn = this._nsBindingCache[name.unboundHashCode() & 0x3F]) != null && cn.unboundEquals(name)) {
            return cn;
        }
        int len = this._nsBindingCount;
        for (int i = 0; i < len; ++i) {
            NsBinding b = this._nsBindings[i];
            if (b.mPrefix != prefix) continue;
            if (i > 0) {
                this._nsBindings[i] = this._nsBindings[i - 1];
                this._nsBindings[i - 1] = b;
            }
            PName bn = name.createBoundName(b);
            if (this._nsBindingCache == null) {
                if (++this._nsBindMisses < 10) {
                    return bn;
                }
                this._nsBindingCache = new PName[64];
            }
            this._nsBindingCache[bn.unboundHashCode() & 0x3F] = bn;
            return bn;
        }
        if (prefix == "xml") {
            return name.createBoundName(NsBinding.XML_BINDING);
        }
        ++this._nsBindMisses;
        NsBinding b = new NsBinding(prefix);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = b;
        ++this._nsBindingCount;
        return name.createBoundName(b);
    }

    protected final NsBinding findOrCreateBinding(String prefix) throws XMLStreamException {
        int len = this._nsBindingCount;
        for (int i = 0; i < len; ++i) {
            NsBinding b = this._nsBindings[i];
            if (b.mPrefix != prefix) continue;
            if (i > 0) {
                this._nsBindings[i] = this._nsBindings[i - 1];
                this._nsBindings[i - 1] = b;
            }
            return b;
        }
        if (prefix == "xml") {
            return NsBinding.XML_BINDING;
        }
        if (prefix == "xmlns") {
            return NsBinding.XMLNS_BINDING;
        }
        NsBinding b = new NsBinding(prefix);
        if (this._nsBindingCount == 0) {
            this._nsBindings = new NsBinding[16];
        } else if (this._nsBindingCount >= this._nsBindings.length) {
            this._nsBindings = (NsBinding[])DataUtil.growAnyArrayBy(this._nsBindings, this._nsBindings.length);
        }
        this._nsBindings[this._nsBindingCount] = b;
        ++this._nsBindingCount;
        return b;
    }

    protected final void bindNs(PName name, String uri) throws XMLStreamException {
        NsBinding ns;
        String prefix = name.getPrefix();
        if (prefix == null) {
            ns = this._defaultNs;
        } else {
            prefix = name.getLocalName();
            ns = this.findOrCreateBinding(prefix);
            if (ns.isImmutable()) {
                this.checkImmutableBinding(prefix, uri);
            }
        }
        if (!ns.isImmutable()) {
            if (uri == "http://www.w3.org/XML/1998/namespace") {
                this.reportIllegalNsDecl("xml", "http://www.w3.org/XML/1998/namespace");
            } else if (uri == "http://www.w3.org/2000/xmlns/") {
                this.reportIllegalNsDecl("xmlns", "http://www.w3.org/2000/xmlns/");
            }
        }
        if (this._lastNsDecl != null && this._lastNsDecl.alreadyDeclared(prefix, this._depth)) {
            this.reportDuplicateNsDecl(prefix);
        }
        this._lastNsDecl = new NsDeclaration(ns, uri, this._lastNsDecl, this._depth);
    }

    protected final void checkImmutableBinding(String prefix, String uri) throws XMLStreamException {
        if (prefix != "xml" || !uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.reportIllegalNsDecl(prefix);
        }
    }

    protected final void loadMoreGuaranteed() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
    }

    protected final void loadMoreGuaranteed(int tt) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(tt));
        }
    }

    protected final void verifyXmlChar(int value) throws XMLStreamException {
        if (value >= 55296) {
            if (value < 57344) {
                this.reportInvalidXmlChar(value);
            }
            if (value == 65534 || value == 65535) {
                this.reportInvalidXmlChar(value);
            }
        } else if (!(value >= 32 || value == 10 || value == 13 || value == 9 || this._xml11 && value != 0)) {
            this.reportInvalidXmlChar(value);
        }
    }

    protected void reportInputProblem(String msg) throws XMLStreamException {
        throw new WFCException(msg, this.getCurrentLocation());
    }

    protected void reportUnexpandedEntityInAttr(PName name, boolean isNsDecl) throws XMLStreamException {
        this.reportInputProblem("Unexpanded ENTITY_REFERENCE (" + this._tokenName + ") in " + (isNsDecl ? "namespace declaration" : "attribute value"));
    }

    protected void reportPrologUnexpElement(boolean isProlog, int ch) throws XMLStreamException {
        if (ch < 0) {
            ch &= 0x7FFFF;
        }
        if (ch == 47) {
            if (isProlog) {
                this.reportInputProblem("Unexpected end element in prolog: malformed XML document, expected root element");
            }
            this.reportInputProblem("Unexpected end element in epilog: malformed XML document (unbalanced start/end tags?)");
        }
        if (ch < 32) {
            String type = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
            this.throwUnexpectedChar(ch, "Unrecognized directive " + type);
        }
        this.reportInputProblem("Second root element in content: malformed XML document, only one allowed");
    }

    protected void reportPrologUnexpChar(boolean isProlog, int ch, String msg) throws XMLStreamException {
        String fullMsg;
        String string = fullMsg = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        if (msg == null) {
            if (ch == 38) {
                this.throwUnexpectedChar(ch, fullMsg + "; no entities allowed");
            }
        } else {
            fullMsg = fullMsg + msg;
        }
        this.throwUnexpectedChar(ch, fullMsg);
    }

    protected void reportPrologProblem(boolean isProlog, String msg) throws XMLStreamException {
        String prefix = isProlog ? ErrorConsts.SUFFIX_IN_PROLOG : ErrorConsts.SUFFIX_IN_EPILOG;
        this.reportInputProblem(prefix + ": " + msg);
    }

    protected void reportTreeUnexpChar(int ch, String msg) throws XMLStreamException {
        String fullMsg = ErrorConsts.SUFFIX_IN_TREE;
        if (msg != null) {
            fullMsg = fullMsg + msg;
        }
        this.throwUnexpectedChar(ch, fullMsg);
    }

    protected void reportInvalidNameChar(int ch, int index) throws XMLStreamException {
        if (ch == 58) {
            this.reportInputProblem("Invalid colon in name: at most one colon allowed in element/attribute names, and none in PI target or entity names");
        }
        if (index == 0) {
            this.reportInputProblem("Invalid name start character (0x" + Integer.toHexString(ch) + ")");
        }
        this.reportInputProblem("Invalid name character (0x" + Integer.toHexString(ch) + ")");
    }

    protected void reportInvalidXmlChar(int ch) throws XMLStreamException {
        if (ch == 0) {
            this.reportInputProblem("Invalid null character");
        }
        if (ch < 32) {
            this.reportInputProblem("Invalid white space character (0x" + Integer.toHexString(ch) + ")");
        }
        this.reportInputProblem("Invalid xml content character (0x" + Integer.toHexString(ch) + ")");
    }

    protected void reportEofInName(char[] cbuf, int clen) throws XMLStreamException {
        this.reportInputProblem("Unexpected end-of-input in name (parsing " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    protected void reportMissingPISpace(int ch) throws XMLStreamException {
        this.throwUnexpectedChar(ch, ": expected either white space, or closing '?>'");
    }

    protected void reportDoubleHyphenInComments() throws XMLStreamException {
        this.reportInputProblem("String '--' not allowed in comment (missing '>'?)");
    }

    protected void reportMultipleColonsInName() throws XMLStreamException {
        this.reportInputProblem("Multiple colons not allowed in names");
    }

    protected void reportEntityOverflow() throws XMLStreamException {
        this.reportInputProblem("Illegal character entity: value higher than max allowed (0x" + Integer.toHexString(0x10FFFF) + ")");
    }

    protected void reportInvalidNsIndex(int index) {
        throw new IndexOutOfBoundsException("Illegal namespace declaration index, " + index + ", current START_ELEMENT/END_ELEMENT has " + this.getNsCount() + " declarations");
    }

    protected void reportUnboundPrefix(PName name, boolean isAttr) throws XMLStreamException {
        this.reportInputProblem("Unbound namespace prefix '" + name.getPrefix() + "' (for " + (isAttr ? "attribute" : "element") + " name '" + name.getPrefixedName() + "')");
    }

    protected void reportDuplicateNsDecl(String prefix) throws XMLStreamException {
        if (prefix == null) {
            this.reportInputProblem("Duplicate namespace declaration for the default namespace");
        } else {
            this.reportInputProblem("Duplicate namespace declaration for prefix '" + prefix + "'");
        }
    }

    protected void reportIllegalNsDecl(String prefix) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not re-bind prefix '" + prefix + "'");
    }

    protected void reportIllegalNsDecl(String prefix, String uri) throws XMLStreamException {
        this.reportInputProblem("Illegal namespace declaration: can not bind URI '" + uri + "' to prefix other than '" + prefix + "'");
    }

    protected void reportUnexpectedEndTag(String expName) throws XMLStreamException {
        this.reportInputProblem("Unexpected end tag: expected </" + expName + ">");
    }

    protected void reportIllegalCDataEnd() throws XMLStreamException {
        this.reportInputProblem("String ']]>' not allowed in textual content, except as the end marker of CDATA section");
    }

    protected void throwUnexpectedChar(int i, String msg) throws XMLStreamException {
        if (i < 32 && i != 13 && i != 10 && i != 9) {
            this.throwInvalidSpace(i);
        }
        char c = (char)i;
        String excMsg = "Unexpected character " + XmlChars.getCharDesc(c) + msg;
        this.reportInputProblem(excMsg);
    }

    protected void throwNullChar() throws XMLStreamException {
        this.reportInputProblem("Illegal character (NULL, unicode 0) encountered: not valid in any content");
    }

    protected char handleInvalidXmlChar(int i) throws XMLStreamException {
        IllegalCharHandler iHandler = this._config.getIllegalCharHandler();
        if (iHandler != null) {
            return iHandler.convertIllegalChar(i);
        }
        char c = (char)i;
        if (c == '\u0000') {
            this.throwNullChar();
        }
        String msg = "Illegal XML character (" + XmlChars.getCharDesc(c) + ")";
        if (this._xml11 && i < 32) {
            msg = msg + " [note: in XML 1.1, it could be included via entity expansion]";
        }
        this.reportInputProblem(msg);
        return (char)i;
    }

    protected void throwInvalidSpace(int i) throws XMLStreamException {
        char c = (char)i;
        if (c == '\u0000') {
            this.throwNullChar();
        }
        String msg = "Illegal character (" + XmlChars.getCharDesc(c) + ")";
        if (this._xml11 && i < 32) {
            msg = msg + " [note: in XML 1.1, it could be included via entity expansion]";
        }
        this.reportInputProblem(msg);
    }
}

