/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmLogicalOrComparisonExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlLogicalOrComparisonExpression;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmExpression;

public abstract class AbstractEdmLogicalOrComparisonExpression
extends AbstractEdmAnnotatableDynamicExpression
implements EdmLogicalOrComparisonExpression {
    private EdmExpression left;
    private EdmExpression right;
    private CsdlLogicalOrComparisonExpression csdlExp;

    public AbstractEdmLogicalOrComparisonExpression(Edm edm, CsdlLogicalOrComparisonExpression csdlExp) {
        super(edm, csdlExp.getType().toString(), csdlExp);
        this.csdlExp = csdlExp;
    }

    @Override
    public EdmExpression.EdmExpressionType getExpressionType() {
        switch (this.csdlExp.getType()) {
            case And: {
                return EdmExpression.EdmExpressionType.And;
            }
            case Or: {
                return EdmExpression.EdmExpressionType.Or;
            }
            case Not: {
                return EdmExpression.EdmExpressionType.Not;
            }
            case Eq: {
                return EdmExpression.EdmExpressionType.Eq;
            }
            case Ne: {
                return EdmExpression.EdmExpressionType.Ne;
            }
            case Gt: {
                return EdmExpression.EdmExpressionType.Gt;
            }
            case Ge: {
                return EdmExpression.EdmExpressionType.Ge;
            }
            case Lt: {
                return EdmExpression.EdmExpressionType.Lt;
            }
            case Le: {
                return EdmExpression.EdmExpressionType.Le;
            }
        }
        throw new EdmException("Invalid Expressiontype for logical or comparison expression: " + (Object)((Object)this.csdlExp.getType()));
    }

    @Override
    public EdmExpression getLeftExpression() {
        if (this.left == null) {
            if (this.csdlExp.getLeft() == null) {
                throw new EdmException("Comparison Or Logical expression MUST have a left and right expression.");
            }
            this.left = AbstractEdmExpression.getExpression(this.edm, this.csdlExp.getLeft());
            if (this.csdlExp.getType() == CsdlLogicalOrComparisonExpression.LogicalOrComparisonExpressionType.Not) {
                this.right = this.left;
            }
        }
        return this.left;
    }

    @Override
    public EdmExpression getRightExpression() {
        if (this.right == null) {
            if (this.csdlExp.getRight() == null) {
                throw new EdmException("Comparison Or Logical expression MUST have a left and right expression.");
            }
            this.right = AbstractEdmExpression.getExpression(this.edm, this.csdlExp.getRight());
            if (this.csdlExp.getType() == CsdlLogicalOrComparisonExpression.LogicalOrComparisonExpressionType.Not) {
                this.left = this.right;
            }
        }
        return this.right;
    }
}

