/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigInteger;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmInt64
extends SingletonPrimitiveType {
    private static final EdmInt64 INSTANCE = new EdmInt64();

    public static EdmInt64 getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16 || primitiveType instanceof EdmInt32 || primitiveType instanceof EdmInt64;
    }

    @Override
    public Class<?> getDefaultType() {
        return Long.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Long valueLong;
        try {
            valueLong = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", e);
        }
        try {
            return EdmInt64.convertNumber(valueLong, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + returnType + ".", e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.", e);
        }
    }

    public static <T> T convertNumber(Number value, Class<T> returnType) throws IllegalArgumentException, ClassCastException {
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(value.longValue());
        }
        if (returnType.isAssignableFrom(BigInteger.class)) {
            return returnType.cast(BigInteger.valueOf(value.longValue()));
        }
        if (returnType.isAssignableFrom(Byte.class)) {
            if (value.longValue() >= -128L && value.longValue() <= 127L) {
                return returnType.cast(value.byteValue());
            }
            throw new IllegalArgumentException();
        }
        if (returnType.isAssignableFrom(Short.class)) {
            if (value.longValue() >= -32768L && value.longValue() <= 32767L) {
                return returnType.cast(value.shortValue());
            }
            throw new IllegalArgumentException();
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            if (value.longValue() >= Integer.MIN_VALUE && value.longValue() <= Integer.MAX_VALUE) {
                return returnType.cast(value.intValue());
            }
            throw new IllegalArgumentException();
        }
        throw new ClassCastException("unsupported return type " + returnType.getSimpleName());
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return value.toString();
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).bitLength() < 64) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + value + "' is not valid.");
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

