/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;

public class EdmStreamValueHandler
extends AbstractInvocationHandler {
    private URI uri;
    private InputStream stream;
    private String contentType;

    protected EdmStreamValueHandler(URI uri, AbstractService<?> service) {
        super(service);
        this.uri = uri;
    }

    protected EdmStreamValueHandler(String contentType, InputStream stream, URI uri, AbstractService<?> service) {
        super(service);
        this.contentType = contentType;
        this.stream = stream;
        this.uri = uri;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("load".equals(method.getName())) {
            this.load();
            return proxy;
        }
        if (this.isSelfMethod(method)) {
            return this.invokeSelfMethod(method, args);
        }
        throw new NoSuchMethodException(method.getName());
    }

    public void load() {
        if (this.uri != null) {
            ODataRetrieveResponse res = (ODataRetrieveResponse)this.getClient().getRetrieveRequestFactory().getMediaRequest(this.uri).execute();
            this.contentType = res.getContentType();
            this.stream = (InputStream)res.getBody();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void close() {
        IOUtils.closeQuietly((InputStream)this.stream);
        this.contentType = null;
        this.stream = null;
    }
}

