/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;

public final class ODataClientBuilder {
    private static final String ODATA_CLIENT_IMPL_CLASS = "org.apache.olingo.client.core.ODataClientImpl";
    private static final String ODATA_EDM_CLIENT_IMPL_CLASS = "org.apache.olingo.client.core.EdmEnabledODataClientImpl";
    public static final String ODATA_CLIENT_IMPL_SYS_PROPERTY = "ORG_APACHE_OLINGO_CLIENT_IMPL_FQN";
    public static final String ODATA_EMD_CLIENT_IMPL_SYS_PROPERTY = "ORG_APACHE_OLINGO_EDM_CLIENT_IMPL_FQN";

    private ODataClientBuilder() {
    }

    public static ODataClient createClient() {
        String clientImplClassName = System.getProperty(ODATA_CLIENT_IMPL_SYS_PROPERTY);
        if (clientImplClassName == null) {
            clientImplClassName = ODATA_CLIENT_IMPL_CLASS;
        }
        return ODataClientBuilder.loadClass(ODataClient.class, clientImplClassName);
    }

    public static ClientBuilder with(String serviceRoot) {
        return new ClientBuilder(serviceRoot);
    }

    private static EdmEnabledODataClient createEdmEnabledClient(String serviceRoot, Edm edm, String metadataETag) {
        String clientImplClassName = System.getProperty(ODATA_EMD_CLIENT_IMPL_SYS_PROPERTY);
        if (clientImplClassName == null) {
            clientImplClassName = ODATA_EDM_CLIENT_IMPL_CLASS;
        }
        EdmEnabledODataClient instance = ODataClientBuilder.loadClass(EdmEnabledODataClient.class, clientImplClassName, new Class[]{String.class, Edm.class, String.class}, new Object[]{serviceRoot, edm, metadataETag});
        instance.getConfiguration().setDefaultPubFormat(ContentType.JSON);
        return instance;
    }

    private static <T> T loadClass(Class<T> typeOfClass, String className) {
        return ODataClientBuilder.loadClass(typeOfClass, className, null, null);
    }

    private static <T> T loadClass(Class<T> typeOfClass, String className, Class<?>[] ctorParameterClasses, Object[] ctorParameters) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (ctorParameters == null || ctorParameterClasses == null) {
                return typeOfClass.cast(clazz.newInstance());
            }
            Constructor<?> ctor = clazz.getConstructor(ctorParameterClasses);
            return typeOfClass.cast(ctor.newInstance(ctorParameters));
        }
        catch (ClassNotFoundException e) {
            throw ODataClientBuilder.wrapException(className, e);
        }
        catch (InstantiationException e) {
            throw ODataClientBuilder.wrapException(className, e);
        }
        catch (IllegalAccessException e) {
            throw ODataClientBuilder.wrapException(className, e);
        }
        catch (NoSuchMethodException e) {
            throw ODataClientBuilder.wrapException(className, e);
        }
        catch (InvocationTargetException e) {
            throw ODataClientBuilder.wrapException(className, e);
        }
    }

    private static ODataRuntimeException wrapException(String className, Exception e) {
        return new ODataRuntimeException("Requested class '" + className + "' could not be loaded.", e);
    }

    public static class ClientBuilder {
        private final String serviceRoot;
        private Edm edm;
        private String metadataETag;

        public ClientBuilder(String serviceRoot) {
            this.serviceRoot = serviceRoot;
        }

        public ClientBuilder edm(Edm edm) {
            this.edm = edm;
            return this;
        }

        public ClientBuilder metadataETag(String metadataETag) {
            this.metadataETag = metadataETag;
            return this;
        }

        public EdmEnabledODataClient createClient() {
            return ODataClientBuilder.createEdmEnabledClient(this.serviceRoot, this.edm, this.metadataETag);
        }
    }
}

