/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Valid;
import jakarta.validation.executable.ValidateOnExecution;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.metadata.HierarchyBuilder;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;

class Liskov {
    static void validateContainerHierarchy(Collection<? extends HierarchyBuilder.ContainerDelegate<?>> delegates, ElementKind elementKind) {
        if (Validate.notNull(delegates, "delegates", new Object[0]).isEmpty()) {
            return;
        }
        if (Validate.notNull(elementKind, "elementKind", new Object[0]) == ElementKind.CONTAINER_ELEMENT) {
            elementKind = Liskov.getContainer(delegates.iterator().next().getHierarchyElement());
        }
        switch (elementKind) {
            case RETURN_VALUE: {
                Liskov.noRedeclarationOfReturnValueCascading(delegates);
                Map<Meta<?>, Set<ValidationElement>> detectedValidationElements = Liskov.detectValidationElements(delegates, HierarchyBuilder.HierarchyDelegate::getHierarchyElement, Liskov.detectGroupConversion());
                Stream.of(StrengtheningIssue.values()).filter(si -> si != StrengtheningIssue.overriddenHierarchy || detectedValidationElements.values().stream().filter(s -> !s.isEmpty()).count() >= 2L).forEach(si -> si.check(detectedValidationElements));
                break;
            }
            case PARAMETER: {
                Liskov.noStrengtheningOfPreconditions(delegates, Liskov.detectConstraints(), Liskov.detectCascading(), Liskov.detectGroupConversion());
                break;
            }
        }
    }

    static void validateCrossParameterHierarchy(Collection<? extends HierarchyBuilder.ElementDelegate<?, ?>> delegates) {
        if (Validate.notNull(delegates, "delegates", new Object[0]).isEmpty()) {
            return;
        }
        Liskov.noStrengtheningOfPreconditions(delegates, Liskov.detectConstraints());
    }

    static void validateValidateOnExecution(Collection<? extends HierarchyBuilder.HierarchyDelegate<?, ?>> delegates) {
        Liskov.noStrengtheningOfPreconditions(delegates, Liskov.detectValidateOnExecution());
    }

    private static ElementKind getContainer(Meta<?> meta) {
        Meta<?> m = meta;
        while (m.getElementType() == ElementType.TYPE_USE) {
            m = m.getParent();
        }
        switch (m.getElementType()) {
            case METHOD: {
                return ElementKind.RETURN_VALUE;
            }
            case PARAMETER: {
                return ElementKind.PARAMETER;
            }
        }
        return ElementKind.PROPERTY;
    }

    private static void noRedeclarationOfReturnValueCascading(Collection<? extends HierarchyBuilder.ContainerDelegate<?>> delegates) {
        Map cascadedReturnValues = delegates.stream().filter(HierarchyBuilder.ContainerDelegate::isCascade).map(HierarchyBuilder.HierarchyDelegate::getHierarchyElement).collect(Collectors.toMap(Meta::getDeclaringClass, Function.identity()));
        boolean anyRelated = cascadedReturnValues.keySet().stream().anyMatch(t -> cascadedReturnValues.keySet().stream().filter(Predicate.isEqual(t).negate()).anyMatch(t2 -> Liskov.related(t, t2)));
        Exceptions.raiseIf(anyRelated, ConstraintDeclarationException::new, "Multiple method return values marked @%s in hierarchy %s", f -> f.args(Valid.class.getSimpleName(), cascadedReturnValues.values()));
    }

    @SafeVarargs
    private static <D extends HierarchyBuilder.HierarchyDelegate<?, ?>> void noStrengtheningOfPreconditions(Collection<? extends D> delegates, Function<? super D, ValidationElement> ... detectors) {
        Map<Meta<?>, Set<ValidationElement>> detectedValidationElements = Liskov.detectValidationElements(delegates, HierarchyBuilder.HierarchyDelegate::getHierarchyElement, detectors);
        if (detectedValidationElements.isEmpty()) {
            return;
        }
        for (StrengtheningIssue s : StrengtheningIssue.values()) {
            s.check(detectedValidationElements);
        }
    }

    @SafeVarargs
    private static <T> Map<Meta<?>, Set<ValidationElement>> detectValidationElements(Collection<? extends T> delegates, Function<? super T, Meta<?>> toMeta, Function<? super T, ValidationElement> ... detectors) {
        LinkedHashMap detectedValidationElements = new LinkedHashMap();
        delegates.forEach(d -> detectedValidationElements.put((Meta)toMeta.apply(d), Stream.of(detectors).map(dt -> (ValidationElement)((Object)((Object)((Object)dt.apply(d))))).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValidationElement.class)))));
        if (detectedValidationElements.values().stream().allMatch(Collection::isEmpty)) {
            return Collections.emptyMap();
        }
        return detectedValidationElements;
    }

    private static boolean related(Class<?> c1, Class<?> c2) {
        return c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1);
    }

    private static Function<HierarchyBuilder.ElementDelegate<?, ?>, ValidationElement> detectConstraints() {
        return d -> d.getDeclaredConstraints().length > 0 ? ValidationElement.constraints : null;
    }

    private static Function<HierarchyBuilder.ContainerDelegate<?>, ValidationElement> detectCascading() {
        return d -> d.isCascade() ? ValidationElement.cascades : null;
    }

    private static Function<HierarchyBuilder.ContainerDelegate<?>, ValidationElement> detectGroupConversion() {
        return d -> d.getGroupConversions().isEmpty() ? null : ValidationElement.groupConversions;
    }

    private static Function<HierarchyBuilder.HierarchyDelegate<?, ?>, ValidationElement> detectValidateOnExecution() {
        return d -> d.getHierarchyElement().getHost().isAnnotationPresent(ValidateOnExecution.class) ? ValidationElement.validateOnExecution : null;
    }

    private Liskov() {
    }

    private static enum StrengtheningIssue implements Predicate<Map<Meta<?>, Set<ValidationElement>>>
    {
        overriddenHierarchy("overridden %s in inheritance hierarchy: %s"){

            @Override
            public boolean test(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
                Class<?> declaringType = null;
                for (Map.Entry<Meta<?>, Set<ValidationElement>> e : detectedValidationElements.entrySet()) {
                    Class<?> t = e.getKey().getDeclaringClass();
                    if (declaringType != null) {
                        if (declaringType.isAssignableFrom(t)) continue;
                        return false;
                    }
                    if (e.getValue().isEmpty()) continue;
                    declaringType = t;
                }
                return true;
            }
        }
        ,
        unrelatedInheritance("declared %s in unrelated inheritance hierarchies: %s"){

            @Override
            public boolean test(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
                if (detectedValidationElements.size() < 2) {
                    return true;
                }
                LinkedHashMap interfaceValidation = new LinkedHashMap();
                detectedValidationElements.forEach((k, v) -> {
                    Class<?> t = k.getDeclaringClass();
                    if (t.isInterface()) {
                        interfaceValidation.put(t, v);
                    }
                });
                if (interfaceValidation.isEmpty()) {
                    return true;
                }
                for (Meta<?> meta : detectedValidationElements.keySet()) {
                    Class<?> t = meta.getDeclaringClass();
                    for (Map.Entry e : interfaceValidation.entrySet()) {
                        if (t.equals(e.getKey()) || ((Set)e.getValue()).isEmpty() || ((Class)e.getKey()).isAssignableFrom(t)) continue;
                        return false;
                    }
                }
                return true;
            }
        };

        final String format;

        private StrengtheningIssue(String format) {
            this.format = "Illegal strengthening: " + format;
        }

        Supplier<String> messageFor(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
            return () -> {
                Set validationElements = detectedValidationElements.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValidationElement.class)));
                String describeHierarchy = detectedValidationElements.keySet().stream().map(Meta::describeHost).collect(Collectors.joining(", ", "[", "]"));
                return String.format(this.format, validationElements, describeHierarchy);
            };
        }

        void check(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
            Exceptions.raiseUnless(this.test(detectedValidationElements), ConstraintDeclarationException::new, this.messageFor(detectedValidationElements));
        }
    }

    private static enum ValidationElement {
        constraints,
        cascades,
        groupConversions,
        validateOnExecution;

    }
}

