/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.QpidException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.BasicCancelOkBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCancelOkMethodHandler
implements StateAwareMethodListener<BasicCancelOkBody> {
    private static final Logger _logger = LoggerFactory.getLogger(BasicCancelOkMethodHandler.class);
    private static final BasicCancelOkMethodHandler _instance = new BasicCancelOkMethodHandler();

    public static BasicCancelOkMethodHandler getInstance() {
        return _instance;
    }

    private BasicCancelOkMethodHandler() {
    }

    @Override
    public void methodReceived(AMQProtocolSession session, BasicCancelOkBody body, int channelId) throws QpidException {
        if (_logger.isInfoEnabled()) {
            _logger.info("New BasicCancelOk method received for consumer:" + body.getConsumerTag());
        }
        session.confirmConsumerCancelled(channelId, body.getConsumerTag());
    }
}

