////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package
{
    /**
     *  The FontAwesome6IconType class list all free possible icons
	 *  for Font Awesome version 6
     *  found in https://fontawesome.com/ to use with the 
     *  FontAwesomeIcon class.
     *
     *  @langversion 3.0
	 *  @playerversion Flash 10.2
	 *  @playerversion AIR 2.6
	 *  @productversion Royale 0.9.11
     */
    public class FontAwesome6IconType
    {
        /**
		 *  constructor.
         * 
		 *  @langversion 3.0
		 *  @playerversion Flash 10.2
		 *  @playerversion AIR 2.6
		 *  @productversion Royale 0.9.11
		 */
		public function FontAwesome6IconType()
		{
			super();
		}
		
		public static const _0:String = '0';
		public static const _1:String = '1';
		public static const _2:String = '2';
		public static const _3:String = '3';
		public static const _4:String = '4';
		public static const _42_GROUP:String = '42-group';
		public static const _5:String = '5';
		public static const _500PX:String = '500px';
		public static const _6:String = '6';
		public static const _7:String = '7';
		public static const _8:String = '8';
		public static const _9:String = '9';
		public static const A:String = 'a';
		public static const ACCESSIBLE_ICON:String = 'accessible-icon';
		public static const ACCUSOFT:String = 'accusoft';
		public static const AD:String = 'ad';
		public static const ADD:String = 'add';
		public static const ADDRESS_BOOK:String = 'address-book';
		public static const ADDRESS_CARD:String = 'address-card';
		public static const ADJUST:String = 'adjust';
		public static const ADN:String = 'adn';
		public static const ADVERSAL:String = 'adversal';
		public static const AFFILIATETHEME:String = 'affiliatetheme';
		public static const AIRBNB:String = 'airbnb';
		public static const AIR_FRESHENER:String = 'air-freshener';
		public static const ALGOLIA:String = 'algolia';
		public static const ALIGN_CENTER:String = 'align-center';
		public static const ALIGN_JUSTIFY:String = 'align-justify';
		public static const ALIGN_LEFT:String = 'align-left';
		public static const ALIGN_RIGHT:String = 'align-right';
		public static const ALIPAY:String = 'alipay';
		public static const ALLERGIES:String = 'allergies';
		public static const AMAZON:String = 'amazon';
		public static const AMAZON_PAY:String = 'amazon-pay';
		public static const AMBULANCE:String = 'ambulance';
		public static const AMERICAN_SIGN_LANGUAGE_INTERPRETING:String = 'american-sign-language-interpreting';
		public static const AMILIA:String = 'amilia';
		public static const ANCHOR:String = 'anchor';
		public static const ANCHOR_CIRCLE_CHECK:String = 'anchor-circle-check';
		public static const ANCHOR_CIRCLE_EXCLAMATION:String = 'anchor-circle-exclamation';
		public static const ANCHOR_CIRCLE_XMARK:String = 'anchor-circle-xmark';
		public static const ANCHOR_LOCK:String = 'anchor-lock';
		public static const ANDROID:String = 'android';
		public static const ANGELLIST:String = 'angellist';
		public static const ANGLE_DOUBLE_DOWN:String = 'angle-double-down';
		public static const ANGLE_DOUBLE_LEFT:String = 'angle-double-left';
		public static const ANGLE_DOUBLE_RIGHT:String = 'angle-double-right';
		public static const ANGLE_DOUBLE_UP:String = 'angle-double-up';
		public static const ANGLE_DOWN:String = 'angle-down';
		public static const ANGLE_LEFT:String = 'angle-left';
		public static const ANGLE_RIGHT:String = 'angle-right';
		public static const ANGLES_DOWN:String = 'angles-down';
		public static const ANGLES_LEFT:String = 'angles-left';
		public static const ANGLES_RIGHT:String = 'angles-right';
		public static const ANGLES_UP:String = 'angles-up';
		public static const ANGLE_UP:String = 'angle-up';
		public static const ANGRY:String = 'angry';
		public static const ANGRYCREATIVE:String = 'angrycreative';
		public static const ANGULAR:String = 'angular';
		public static const ANKH:String = 'ankh';
		public static const APPER:String = 'apper';
		public static const APPLE:String = 'apple';
		public static const APPLE_ALT:String = 'apple-alt';
		public static const APPLE_PAY:String = 'apple-pay';
		public static const APPLE_WHOLE:String = 'apple-whole';
		public static const APP_STORE:String = 'app-store';
		public static const APP_STORE_IOS:String = 'app-store-ios';
		public static const ARCHIVE:String = 'archive';
		public static const ARCHWAY:String = 'archway';
		public static const AREA_CHART:String = 'area-chart';
		public static const ARROW_ALT_CIRCLE_DOWN:String = 'arrow-alt-circle-down';
		public static const ARROW_ALT_CIRCLE_LEFT:String = 'arrow-alt-circle-left';
		public static const ARROW_ALT_CIRCLE_RIGHT:String = 'arrow-alt-circle-right';
		public static const ARROW_ALT_CIRCLE_UP:String = 'arrow-alt-circle-up';
		public static const ARROW_CIRCLE_DOWN:String = 'arrow-circle-down';
		public static const ARROW_CIRCLE_LEFT:String = 'arrow-circle-left';
		public static const ARROW_CIRCLE_RIGHT:String = 'arrow-circle-right';
		public static const ARROW_CIRCLE_UP:String = 'arrow-circle-up';
		public static const ARROW_DOWN:String = 'arrow-down';
		public static const ARROW_DOWN_1_9:String = 'arrow-down-1-9';
		public static const ARROW_DOWN_9_1:String = 'arrow-down-9-1';
		public static const ARROW_DOWN_A_Z:String = 'arrow-down-a-z';
		public static const ARROW_DOWN_LONG:String = 'arrow-down-long';
		public static const ARROW_DOWN_SHORT_WIDE:String = 'arrow-down-short-wide';
		public static const ARROW_DOWN_UP_ACROSS_LINE:String = 'arrow-down-up-across-line';
		public static const ARROW_DOWN_UP_LOCK:String = 'arrow-down-up-lock';
		public static const ARROW_DOWN_WIDE_SHORT:String = 'arrow-down-wide-short';
		public static const ARROW_DOWN_Z_A:String = 'arrow-down-z-a';
		public static const ARROW_LEFT:String = 'arrow-left';
		public static const ARROW_LEFT_LONG:String = 'arrow-left-long';
		public static const ARROW_LEFT_ROTATE:String = 'arrow-left-rotate';
		public static const ARROW_POINTER:String = 'arrow-pointer';
		public static const ARROW_RIGHT:String = 'arrow-right';
		public static const ARROW_RIGHT_ARROW_LEFT:String = 'arrow-right-arrow-left';
		public static const ARROW_RIGHT_FROM_BRACKET:String = 'arrow-right-from-bracket';
		public static const ARROW_RIGHT_FROM_FILE:String = 'arrow-right-from-file';
		public static const ARROW_RIGHT_LONG:String = 'arrow-right-long';
		public static const ARROW_RIGHT_ROTATE:String = 'arrow-right-rotate';
		public static const ARROW_RIGHT_TO_BRACKET:String = 'arrow-right-to-bracket';
		public static const ARROW_RIGHT_TO_CITY:String = 'arrow-right-to-city';
		public static const ARROW_RIGHT_TO_FILE:String = 'arrow-right-to-file';
		public static const ARROW_ROTATE_BACK:String = 'arrow-rotate-back';
		public static const ARROW_ROTATE_BACKWARD:String = 'arrow-rotate-backward';
		public static const ARROW_ROTATE_FORWARD:String = 'arrow-rotate-forward';
		public static const ARROW_ROTATE_LEFT:String = 'arrow-rotate-left';
		public static const ARROW_ROTATE_RIGHT:String = 'arrow-rotate-right';
		public static const ARROWS:String = 'arrows';
		public static const ARROWS_ALT:String = 'arrows-alt';
		public static const ARROWS_ALT_H:String = 'arrows-alt-h';
		public static const ARROWS_ALT_V:String = 'arrows-alt-v';
		public static const ARROWS_DOWN_TO_LINE:String = 'arrows-down-to-line';
		public static const ARROWS_DOWN_TO_PEOPLE:String = 'arrows-down-to-people';
		public static const ARROWS_H:String = 'arrows-h';
		public static const ARROWS_LEFT_RIGHT:String = 'arrows-left-right';
		public static const ARROWS_LEFT_RIGHT_TO_LINE:String = 'arrows-left-right-to-line';
		public static const ARROWS_ROTATE:String = 'arrows-rotate';
		public static const ARROWS_SPIN:String = 'arrows-spin';
		public static const ARROWS_SPLIT_UP_AND_LEFT:String = 'arrows-split-up-and-left';
		public static const ARROWS_TO_CIRCLE:String = 'arrows-to-circle';
		public static const ARROWS_TO_DOT:String = 'arrows-to-dot';
		public static const ARROWS_TO_EYE:String = 'arrows-to-eye';
		public static const ARROWS_TURN_RIGHT:String = 'arrows-turn-right';
		public static const ARROWS_TURN_TO_DOTS:String = 'arrows-turn-to-dots';
		public static const ARROWS_UP_DOWN:String = 'arrows-up-down';
		public static const ARROWS_UP_DOWN_LEFT_RIGHT:String = 'arrows-up-down-left-right';
		public static const ARROWS_UP_TO_LINE:String = 'arrows-up-to-line';
		public static const ARROWS_V:String = 'arrows-v';
		public static const ARROW_TREND_DOWN:String = 'arrow-trend-down';
		public static const ARROW_TREND_UP:String = 'arrow-trend-up';
		public static const ARROW_TURN_DOWN:String = 'arrow-turn-down';
		public static const ARROW_TURN_UP:String = 'arrow-turn-up';
		public static const ARROW_UP:String = 'arrow-up';
		public static const ARROW_UP_1_9:String = 'arrow-up-1-9';
		public static const ARROW_UP_9_1:String = 'arrow-up-9-1';
		public static const ARROW_UP_A_Z:String = 'arrow-up-a-z';
		public static const ARROW_UP_FROM_BRACKET:String = 'arrow-up-from-bracket';
		public static const ARROW_UP_FROM_GROUND_WATER:String = 'arrow-up-from-ground-water';
		public static const ARROW_UP_FROM_WATER_PUMP:String = 'arrow-up-from-water-pump';
		public static const ARROW_UP_LONG:String = 'arrow-up-long';
		public static const ARROW_UP_RIGHT_DOTS:String = 'arrow-up-right-dots';
		public static const ARROW_UP_RIGHT_FROM_SQUARE:String = 'arrow-up-right-from-square';
		public static const ARROW_UP_SHORT_WIDE:String = 'arrow-up-short-wide';
		public static const ARROW_UP_WIDE_SHORT:String = 'arrow-up-wide-short';
		public static const ARROW_UP_Z_A:String = 'arrow-up-z-a';
		public static const ARTSTATION:String = 'artstation';
		public static const ASL_INTERPRETING:String = 'asl-interpreting';
		public static const ASSISTIVE_LISTENING_SYSTEMS:String = 'assistive-listening-systems';
		public static const ASTERISK:String = 'asterisk';
		public static const ASYMMETRIK:String = 'asymmetrik';
		public static const AT:String = 'at';
		public static const ATLAS:String = 'atlas';
		public static const ATLASSIAN:String = 'atlassian';
		public static const ATOM:String = 'atom';
		public static const AUDIBLE:String = 'audible';
		public static const AUDIO_DESCRIPTION:String = 'audio-description';
		public static const AUSTRAL_SIGN:String = 'austral-sign';
		public static const AUTOMOBILE:String = 'automobile';
		public static const AUTOPREFIXER:String = 'autoprefixer';
		public static const AVIANEX:String = 'avianex';
		public static const AVIATO:String = 'aviato';
		public static const AWARD:String = 'award';
		public static const AWS:String = 'aws';
		public static const B:String = 'b';
		public static const BABY:String = 'baby';
		public static const BABY_CARRIAGE:String = 'baby-carriage';
		public static const BACKSPACE:String = 'backspace';
		public static const BACKWARD:String = 'backward';
		public static const BACKWARD_FAST:String = 'backward-fast';
		public static const BACKWARD_STEP:String = 'backward-step';
		public static const BACON:String = 'bacon';
		public static const BACTERIA:String = 'bacteria';
		public static const BACTERIUM:String = 'bacterium';
		public static const BAG_SHOPPING:String = 'bag-shopping';
		public static const BAHAI:String = 'bahai';
		public static const BAHT_SIGN:String = 'baht-sign';
		public static const BALANCE_SCALE:String = 'balance-scale';
		public static const BALANCE_SCALE_LEFT:String = 'balance-scale-left';
		public static const BALANCE_SCALE_RIGHT:String = 'balance-scale-right';
		public static const BAN:String = 'ban';
		public static const BANDAGE:String = 'bandage';
		public static const BAND_AID:String = 'band-aid';
		public static const BANDCAMP:String = 'bandcamp';
		public static const BANGLADESHI_TAKA_SIGN:String = 'bangladeshi-taka-sign';
		public static const BANK:String = 'bank';
		public static const BAN_SMOKING:String = 'ban-smoking';
		public static const BAR_CHART:String = 'bar-chart';
		public static const BARCODE:String = 'barcode';
		public static const BARS:String = 'bars';
		public static const BARS_PROGRESS:String = 'bars-progress';
		public static const BARS_STAGGERED:String = 'bars-staggered';
		public static const BASEBALL:String = 'baseball';
		public static const BASEBALL_BALL:String = 'baseball-ball';
		public static const BASEBALL_BAT_BALL:String = 'baseball-bat-ball';
		public static const BASKETBALL:String = 'basketball';
		public static const BASKETBALL_BALL:String = 'basketball-ball';
		public static const BASKET_SHOPPING:String = 'basket-shopping';
		public static const BATH:String = 'bath';
		public static const BATHTUB:String = 'bathtub';
		public static const BATTERY:String = 'battery';
		public static const BATTERY_0:String = 'battery-0';
		public static const BATTERY_2:String = 'battery-2';
		public static const BATTERY_3:String = 'battery-3';
		public static const BATTERY_4:String = 'battery-4';
		public static const BATTERY_5:String = 'battery-5';
		public static const BATTERY_CAR:String = 'battery-car';
		public static const BATTERY_EMPTY:String = 'battery-empty';
		public static const BATTERY_FULL:String = 'battery-full';
		public static const BATTERY_HALF:String = 'battery-half';
		public static const BATTERY_QUARTER:String = 'battery-quarter';
		public static const BATTERY_THREE_QUARTERS:String = 'battery-three-quarters';
		public static const BATTLE_NET:String = 'battle-net';
		public static const BED:String = 'bed';
		public static const BED_PULSE:String = 'bed-pulse';
		public static const BEER:String = 'beer';
		public static const BEER_MUG_EMPTY:String = 'beer-mug-empty';
		public static const BEHANCE:String = 'behance';
		public static const BEHANCE_SQUARE:String = 'behance-square';
		public static const BELL:String = 'bell';
		public static const BELL_CONCIERGE:String = 'bell-concierge';
		public static const BELL_SLASH:String = 'bell-slash';
		public static const BEZIER_CURVE:String = 'bezier-curve';
		public static const BIBLE:String = 'bible';
		public static const BICYCLE:String = 'bicycle';
		public static const BIKING:String = 'biking';
		public static const BILIBILI:String = 'bilibili';
		public static const BIMOBJECT:String = 'bimobject';
		public static const BINOCULARS:String = 'binoculars';
		public static const BIOHAZARD:String = 'biohazard';
		public static const BIRTHDAY_CAKE:String = 'birthday-cake';
		public static const BITBUCKET:String = 'bitbucket';
		public static const BITCOIN:String = 'bitcoin';
		public static const BITCOIN_SIGN:String = 'bitcoin-sign';
		public static const BITY:String = 'bity';
		public static const BLACKBERRY:String = 'blackberry';
		public static const BLACKBOARD:String = 'blackboard';
		public static const BLACK_TIE:String = 'black-tie';
		public static const BLENDER:String = 'blender';
		public static const BLENDER_PHONE:String = 'blender-phone';
		public static const BLIND:String = 'blind';
		public static const BLOG:String = 'blog';
		public static const BLOGGER:String = 'blogger';
		public static const BLOGGER_B:String = 'blogger-b';
		public static const BLUESKY:String = 'bluesky';
		public static const BLUETOOTH:String = 'bluetooth';
		public static const BLUETOOTH_B:String = 'bluetooth-b';
		public static const BOLD:String = 'bold';
		public static const BOLT:String = 'bolt';
		public static const BOLT_LIGHTNING:String = 'bolt-lightning';
		public static const BOMB:String = 'bomb';
		public static const BONE:String = 'bone';
		public static const BONG:String = 'bong';
		public static const BOOK:String = 'book';
		public static const BOOK_ATLAS:String = 'book-atlas';
		public static const BOOK_BIBLE:String = 'book-bible';
		public static const BOOK_BOOKMARK:String = 'book-bookmark';
		public static const BOOK_DEAD:String = 'book-dead';
		public static const BOOK_JOURNAL_WHILLS:String = 'book-journal-whills';
		public static const BOOKMARK:String = 'bookmark';
		public static const BOOK_MEDICAL:String = 'book-medical';
		public static const BOOK_OPEN:String = 'book-open';
		public static const BOOK_OPEN_READER:String = 'book-open-reader';
		public static const BOOK_QURAN:String = 'book-quran';
		public static const BOOK_READER:String = 'book-reader';
		public static const BOOK_SKULL:String = 'book-skull';
		public static const BOOK_TANAKH:String = 'book-tanakh';
		public static const BOOTSTRAP:String = 'bootstrap';
		public static const BORDER_ALL:String = 'border-all';
		public static const BORDER_NONE:String = 'border-none';
		public static const BORDER_STYLE:String = 'border-style';
		public static const BORDER_TOP_LEFT:String = 'border-top-left';
		public static const BORE_HOLE:String = 'bore-hole';
		public static const BOTS:String = 'bots';
		public static const BOTTLE_DROPLET:String = 'bottle-droplet';
		public static const BOTTLE_WATER:String = 'bottle-water';
		public static const BOWL_FOOD:String = 'bowl-food';
		public static const BOWLING_BALL:String = 'bowling-ball';
		public static const BOWL_RICE:String = 'bowl-rice';
		public static const BOX:String = 'box';
		public static const BOX_ARCHIVE:String = 'box-archive';
		public static const BOXES:String = 'boxes';
		public static const BOXES_ALT:String = 'boxes-alt';
		public static const BOXES_PACKING:String = 'boxes-packing';
		public static const BOXES_STACKED:String = 'boxes-stacked';
		public static const BOX_OPEN:String = 'box-open';
		public static const BOX_TISSUE:String = 'box-tissue';
		public static const BRAILLE:String = 'braille';
		public static const BRAIN:String = 'brain';
		public static const BRAVE:String = 'brave';
		public static const BRAVE_REVERSE:String = 'brave-reverse';
		public static const BRAZILIAN_REAL_SIGN:String = 'brazilian-real-sign';
		public static const BREAD_SLICE:String = 'bread-slice';
		public static const BRIDGE:String = 'bridge';
		public static const BRIDGE_CIRCLE_CHECK:String = 'bridge-circle-check';
		public static const BRIDGE_CIRCLE_EXCLAMATION:String = 'bridge-circle-exclamation';
		public static const BRIDGE_CIRCLE_XMARK:String = 'bridge-circle-xmark';
		public static const BRIDGE_LOCK:String = 'bridge-lock';
		public static const BRIDGE_WATER:String = 'bridge-water';
		public static const BRIEFCASE:String = 'briefcase';
		public static const BRIEFCASE_CLOCK:String = 'briefcase-clock';
		public static const BRIEFCASE_MEDICAL:String = 'briefcase-medical';
		public static const BROADCAST_TOWER:String = 'broadcast-tower';
		public static const BROOM:String = 'broom';
		public static const BROOM_BALL:String = 'broom-ball';
		public static const BRUSH:String = 'brush';
		public static const BTC:String = 'btc';
		public static const BUCKET:String = 'bucket';
		public static const BUFFER:String = 'buffer';
		public static const BUG:String = 'bug';
		public static const BUGS:String = 'bugs';
		public static const BUG_SLASH:String = 'bug-slash';
		public static const BUILDING:String = 'building';
		public static const BUILDING_CIRCLE_ARROW_RIGHT:String = 'building-circle-arrow-right';
		public static const BUILDING_CIRCLE_CHECK:String = 'building-circle-check';
		public static const BUILDING_CIRCLE_EXCLAMATION:String = 'building-circle-exclamation';
		public static const BUILDING_CIRCLE_XMARK:String = 'building-circle-xmark';
		public static const BUILDING_COLUMNS:String = 'building-columns';
		public static const BUILDING_FLAG:String = 'building-flag';
		public static const BUILDING_LOCK:String = 'building-lock';
		public static const BUILDING_NGO:String = 'building-ngo';
		public static const BUILDING_SHIELD:String = 'building-shield';
		public static const BUILDING_UN:String = 'building-un';
		public static const BUILDING_USER:String = 'building-user';
		public static const BUILDING_WHEAT:String = 'building-wheat';
		public static const BULLHORN:String = 'bullhorn';
		public static const BULLSEYE:String = 'bullseye';
		public static const BURGER:String = 'burger';
		public static const BURN:String = 'burn';
		public static const BUROMOBELEXPERTE:String = 'buromobelexperte';
		public static const BURST:String = 'burst';
		public static const BUS:String = 'bus';
		public static const BUS_ALT:String = 'bus-alt';
		public static const BUSINESS_TIME:String = 'business-time';
		public static const BUS_SIMPLE:String = 'bus-simple';
		public static const BUY_N_LARGE:String = 'buy-n-large';
		public static const BUYSELLADS:String = 'buysellads';
		public static const C:String = 'c';
		public static const CAB:String = 'cab';
		public static const CABLE_CAR:String = 'cable-car';
		public static const CAKE:String = 'cake';
		public static const CAKE_CANDLES:String = 'cake-candles';
		public static const CALCULATOR:String = 'calculator';
		public static const CALENDAR:String = 'calendar';
		public static const CALENDAR_ALT:String = 'calendar-alt';
		public static const CALENDAR_CHECK:String = 'calendar-check';
		public static const CALENDAR_DAY:String = 'calendar-day';
		public static const CALENDAR_DAYS:String = 'calendar-days';
		public static const CALENDAR_MINUS:String = 'calendar-minus';
		public static const CALENDAR_PLUS:String = 'calendar-plus';
		public static const CALENDAR_TIMES:String = 'calendar-times';
		public static const CALENDAR_WEEK:String = 'calendar-week';
		public static const CALENDAR_XMARK:String = 'calendar-xmark';
		public static const CAMERA:String = 'camera';
		public static const CAMERA_ALT:String = 'camera-alt';
		public static const CAMERA_RETRO:String = 'camera-retro';
		public static const CAMERA_ROTATE:String = 'camera-rotate';
		public static const CAMPGROUND:String = 'campground';
		public static const CANADIAN_MAPLE_LEAF:String = 'canadian-maple-leaf';
		public static const CANCEL:String = 'cancel';
		public static const CANDY_CANE:String = 'candy-cane';
		public static const CANNABIS:String = 'cannabis';
		public static const CAPSULES:String = 'capsules';
		public static const CAR:String = 'car';
		public static const CAR_ALT:String = 'car-alt';
		public static const CARAVAN:String = 'caravan';
		public static const CAR_BATTERY:String = 'car-battery';
		public static const CAR_BURST:String = 'car-burst';
		public static const CAR_CRASH:String = 'car-crash';
		public static const CARET_DOWN:String = 'caret-down';
		public static const CARET_LEFT:String = 'caret-left';
		public static const CARET_RIGHT:String = 'caret-right';
		public static const CARET_SQUARE_DOWN:String = 'caret-square-down';
		public static const CARET_SQUARE_LEFT:String = 'caret-square-left';
		public static const CARET_SQUARE_RIGHT:String = 'caret-square-right';
		public static const CARET_SQUARE_UP:String = 'caret-square-up';
		public static const CARET_UP:String = 'caret-up';
		public static const CAR_ON:String = 'car-on';
		public static const CAR_REAR:String = 'car-rear';
		public static const CARRIAGE_BABY:String = 'carriage-baby';
		public static const CARROT:String = 'carrot';
		public static const CAR_SIDE:String = 'car-side';
		public static const CART_ARROW_DOWN:String = 'cart-arrow-down';
		public static const CART_FLATBED:String = 'cart-flatbed';
		public static const CART_FLATBED_SUITCASE:String = 'cart-flatbed-suitcase';
		public static const CART_PLUS:String = 'cart-plus';
		public static const CART_SHOPPING:String = 'cart-shopping';
		public static const CAR_TUNNEL:String = 'car-tunnel';
		public static const CASH_REGISTER:String = 'cash-register';
		public static const CAT:String = 'cat';
		public static const CC_AMAZON_PAY:String = 'cc-amazon-pay';
		public static const CC_AMEX:String = 'cc-amex';
		public static const CC_APPLE_PAY:String = 'cc-apple-pay';
		public static const CC_DINERS_CLUB:String = 'cc-diners-club';
		public static const CC_DISCOVER:String = 'cc-discover';
		public static const CC_JCB:String = 'cc-jcb';
		public static const CC_MASTERCARD:String = 'cc-mastercard';
		public static const CC_PAYPAL:String = 'cc-paypal';
		public static const CC_STRIPE:String = 'cc-stripe';
		public static const CC_VISA:String = 'cc-visa';
		public static const CEDI_SIGN:String = 'cedi-sign';
		public static const CENTERCODE:String = 'centercode';
		public static const CENTOS:String = 'centos';
		public static const CENT_SIGN:String = 'cent-sign';
		public static const CERTIFICATE:String = 'certificate';
		public static const CHAIN:String = 'chain';
		public static const CHAIN_BROKEN:String = 'chain-broken';
		public static const CHAIN_SLASH:String = 'chain-slash';
		public static const CHAIR:String = 'chair';
		public static const CHALKBOARD:String = 'chalkboard';
		public static const CHALKBOARD_TEACHER:String = 'chalkboard-teacher';
		public static const CHALKBOARD_USER:String = 'chalkboard-user';
		public static const CHAMPAGNE_GLASSES:String = 'champagne-glasses';
		public static const CHARGING_STATION:String = 'charging-station';
		public static const CHART_AREA:String = 'chart-area';
		public static const CHART_BAR:String = 'chart-bar';
		public static const CHART_COLUMN:String = 'chart-column';
		public static const CHART_GANTT:String = 'chart-gantt';
		public static const CHART_LINE:String = 'chart-line';
		public static const CHART_PIE:String = 'chart-pie';
		public static const CHART_SIMPLE:String = 'chart-simple';
		public static const CHECK:String = 'check';
		public static const CHECK_CIRCLE:String = 'check-circle';
		public static const CHECK_DOUBLE:String = 'check-double';
		public static const CHECK_SQUARE:String = 'check-square';
		public static const CHECK_TO_SLOT:String = 'check-to-slot';
		public static const CHEESE:String = 'cheese';
		public static const CHESS:String = 'chess';
		public static const CHESS_BISHOP:String = 'chess-bishop';
		public static const CHESS_BOARD:String = 'chess-board';
		public static const CHESS_KING:String = 'chess-king';
		public static const CHESS_KNIGHT:String = 'chess-knight';
		public static const CHESS_PAWN:String = 'chess-pawn';
		public static const CHESS_QUEEN:String = 'chess-queen';
		public static const CHESS_ROOK:String = 'chess-rook';
		public static const CHEVRON_CIRCLE_DOWN:String = 'chevron-circle-down';
		public static const CHEVRON_CIRCLE_LEFT:String = 'chevron-circle-left';
		public static const CHEVRON_CIRCLE_RIGHT:String = 'chevron-circle-right';
		public static const CHEVRON_CIRCLE_UP:String = 'chevron-circle-up';
		public static const CHEVRON_DOWN:String = 'chevron-down';
		public static const CHEVRON_LEFT:String = 'chevron-left';
		public static const CHEVRON_RIGHT:String = 'chevron-right';
		public static const CHEVRON_UP:String = 'chevron-up';
		public static const CHILD:String = 'child';
		public static const CHILD_COMBATANT:String = 'child-combatant';
		public static const CHILD_DRESS:String = 'child-dress';
		public static const CHILD_REACHING:String = 'child-reaching';
		public static const CHILDREN:String = 'children';
		public static const CHILD_RIFLE:String = 'child-rifle';
		public static const CHROME:String = 'chrome';
		public static const CHROMECAST:String = 'chromecast';
		public static const CHURCH:String = 'church';
		public static const CIRCLE:String = 'circle';
		public static const CIRCLE_ARROW_DOWN:String = 'circle-arrow-down';
		public static const CIRCLE_ARROW_LEFT:String = 'circle-arrow-left';
		public static const CIRCLE_ARROW_RIGHT:String = 'circle-arrow-right';
		public static const CIRCLE_ARROW_UP:String = 'circle-arrow-up';
		public static const CIRCLE_CHECK:String = 'circle-check';
		public static const CIRCLE_CHEVRON_DOWN:String = 'circle-chevron-down';
		public static const CIRCLE_CHEVRON_LEFT:String = 'circle-chevron-left';
		public static const CIRCLE_CHEVRON_RIGHT:String = 'circle-chevron-right';
		public static const CIRCLE_CHEVRON_UP:String = 'circle-chevron-up';
		public static const CIRCLE_DOLLAR_TO_SLOT:String = 'circle-dollar-to-slot';
		public static const CIRCLE_DOT:String = 'circle-dot';
		public static const CIRCLE_DOWN:String = 'circle-down';
		public static const CIRCLE_EXCLAMATION:String = 'circle-exclamation';
		public static const CIRCLE_H:String = 'circle-h';
		public static const CIRCLE_HALF_STROKE:String = 'circle-half-stroke';
		public static const CIRCLE_INFO:String = 'circle-info';
		public static const CIRCLE_LEFT:String = 'circle-left';
		public static const CIRCLE_MINUS:String = 'circle-minus';
		public static const CIRCLE_NODES:String = 'circle-nodes';
		public static const CIRCLE_NOTCH:String = 'circle-notch';
		public static const CIRCLE_PAUSE:String = 'circle-pause';
		public static const CIRCLE_PLAY:String = 'circle-play';
		public static const CIRCLE_PLUS:String = 'circle-plus';
		public static const CIRCLE_QUESTION:String = 'circle-question';
		public static const CIRCLE_RADIATION:String = 'circle-radiation';
		public static const CIRCLE_RIGHT:String = 'circle-right';
		public static const CIRCLE_STOP:String = 'circle-stop';
		public static const CIRCLE_UP:String = 'circle-up';
		public static const CIRCLE_USER:String = 'circle-user';
		public static const CIRCLE_XMARK:String = 'circle-xmark';
		public static const CITY:String = 'city';
		public static const CLAPPERBOARD:String = 'clapperboard';
		public static const CLINIC_MEDICAL:String = 'clinic-medical';
		public static const CLIPBOARD:String = 'clipboard';
		public static const CLIPBOARD_CHECK:String = 'clipboard-check';
		public static const CLIPBOARD_LIST:String = 'clipboard-list';
		public static const CLIPBOARD_QUESTION:String = 'clipboard-question';
		public static const CLIPBOARD_USER:String = 'clipboard-user';
		public static const CLOCK:String = 'clock';
		public static const CLOCK_FOUR:String = 'clock-four';
		public static const CLOCK_ROTATE_LEFT:String = 'clock-rotate-left';
		public static const CLONE:String = 'clone';
		public static const CLOSE:String = 'close';
		public static const CLOSED_CAPTIONING:String = 'closed-captioning';
		public static const CLOUD:String = 'cloud';
		public static const CLOUD_ARROW_DOWN:String = 'cloud-arrow-down';
		public static const CLOUD_ARROW_UP:String = 'cloud-arrow-up';
		public static const CLOUD_BOLT:String = 'cloud-bolt';
		public static const CLOUD_DOWNLOAD:String = 'cloud-download';
		public static const CLOUD_DOWNLOAD_ALT:String = 'cloud-download-alt';
		public static const CLOUDFLARE:String = 'cloudflare';
		public static const CLOUD_MEATBALL:String = 'cloud-meatball';
		public static const CLOUD_MOON:String = 'cloud-moon';
		public static const CLOUD_MOON_RAIN:String = 'cloud-moon-rain';
		public static const CLOUD_RAIN:String = 'cloud-rain';
		public static const CLOUDSCALE:String = 'cloudscale';
		public static const CLOUD_SHOWERS_HEAVY:String = 'cloud-showers-heavy';
		public static const CLOUD_SHOWERS_WATER:String = 'cloud-showers-water';
		public static const CLOUDSMITH:String = 'cloudsmith';
		public static const CLOUD_SUN:String = 'cloud-sun';
		public static const CLOUD_SUN_RAIN:String = 'cloud-sun-rain';
		public static const CLOUD_UPLOAD:String = 'cloud-upload';
		public static const CLOUD_UPLOAD_ALT:String = 'cloud-upload-alt';
		public static const CLOUDVERSIFY:String = 'cloudversify';
		public static const CLOVER:String = 'clover';
		public static const CMPLID:String = 'cmplid';
		public static const CNY:String = 'cny';
		public static const COCKTAIL:String = 'cocktail';
		public static const CODE:String = 'code';
		public static const CODE_BRANCH:String = 'code-branch';
		public static const CODE_COMMIT:String = 'code-commit';
		public static const CODE_COMPARE:String = 'code-compare';
		public static const CODE_FORK:String = 'code-fork';
		public static const CODE_MERGE:String = 'code-merge';
		public static const CODEPEN:String = 'codepen';
		public static const CODE_PULL_REQUEST:String = 'code-pull-request';
		public static const CODIEPIE:String = 'codiepie';
		public static const COFFEE:String = 'coffee';
		public static const COG:String = 'cog';
		public static const COGS:String = 'cogs';
		public static const COINS:String = 'coins';
		public static const COLON_SIGN:String = 'colon-sign';
		public static const COLUMNS:String = 'columns';
		public static const COMMENT:String = 'comment';
		public static const COMMENT_ALT:String = 'comment-alt';
		public static const COMMENT_DOLLAR:String = 'comment-dollar';
		public static const COMMENT_DOTS:String = 'comment-dots';
		public static const COMMENTING:String = 'commenting';
		public static const COMMENT_MEDICAL:String = 'comment-medical';
		public static const COMMENTS:String = 'comments';
		public static const COMMENTS_DOLLAR:String = 'comments-dollar';
		public static const COMMENT_SLASH:String = 'comment-slash';
		public static const COMMENT_SMS:String = 'comment-sms';
		public static const COMPACT_DISC:String = 'compact-disc';
		public static const COMPASS:String = 'compass';
		public static const COMPASS_DRAFTING:String = 'compass-drafting';
		public static const COMPRESS:String = 'compress';
		public static const COMPRESS_ALT:String = 'compress-alt';
		public static const COMPRESS_ARROWS_ALT:String = 'compress-arrows-alt';
		public static const COMPUTER:String = 'computer';
		public static const COMPUTER_MOUSE:String = 'computer-mouse';
		public static const CONCIERGE_BELL:String = 'concierge-bell';
		public static const CONFLUENCE:String = 'confluence';
		public static const CONNECTDEVELOP:String = 'connectdevelop';
		public static const CONTACT_BOOK:String = 'contact-book';
		public static const CONTACT_CARD:String = 'contact-card';
		public static const CONTAO:String = 'contao';
		public static const COOKIE:String = 'cookie';
		public static const COOKIE_BITE:String = 'cookie-bite';
		public static const COPY:String = 'copy';
		public static const COPYRIGHT:String = 'copyright';
		public static const COTTON_BUREAU:String = 'cotton-bureau';
		public static const COUCH:String = 'couch';
		public static const COW:String = 'cow';
		public static const CPANEL:String = 'cpanel';
		public static const CREATIVE_COMMONS:String = 'creative-commons';
		public static const CREATIVE_COMMONS_BY:String = 'creative-commons-by';
		public static const CREATIVE_COMMONS_NC:String = 'creative-commons-nc';
		public static const CREATIVE_COMMONS_NC_EU:String = 'creative-commons-nc-eu';
		public static const CREATIVE_COMMONS_NC_JP:String = 'creative-commons-nc-jp';
		public static const CREATIVE_COMMONS_ND:String = 'creative-commons-nd';
		public static const CREATIVE_COMMONS_PD:String = 'creative-commons-pd';
		public static const CREATIVE_COMMONS_PD_ALT:String = 'creative-commons-pd-alt';
		public static const CREATIVE_COMMONS_REMIX:String = 'creative-commons-remix';
		public static const CREATIVE_COMMONS_SA:String = 'creative-commons-sa';
		public static const CREATIVE_COMMONS_SAMPLING:String = 'creative-commons-sampling';
		public static const CREATIVE_COMMONS_SAMPLING_PLUS:String = 'creative-commons-sampling-plus';
		public static const CREATIVE_COMMONS_SHARE:String = 'creative-commons-share';
		public static const CREATIVE_COMMONS_ZERO:String = 'creative-commons-zero';
		public static const CREDIT_CARD:String = 'credit-card';
		public static const CREDIT_CARD_ALT:String = 'credit-card-alt';
		public static const CRITICAL_ROLE:String = 'critical-role';
		public static const CROP:String = 'crop';
		public static const CROP_ALT:String = 'crop-alt';
		public static const CROP_SIMPLE:String = 'crop-simple';
		public static const CROSS:String = 'cross';
		public static const CROSSHAIRS:String = 'crosshairs';
		public static const CROW:String = 'crow';
		public static const CROWN:String = 'crown';
		public static const CRUTCH:String = 'crutch';
		public static const CRUZEIRO_SIGN:String = 'cruzeiro-sign';
		public static const CSS3:String = 'css3';
		public static const CSS3_ALT:String = 'css3-alt';
		public static const CUBE:String = 'cube';
		public static const CUBES:String = 'cubes';
		public static const CUBES_STACKED:String = 'cubes-stacked';
		public static const CUT:String = 'cut';
		public static const CUTLERY:String = 'cutlery';
		public static const CUTTLEFISH:String = 'cuttlefish';
		public static const D:String = 'd';
		public static const DAILYMOTION:String = 'dailymotion';
		public static const D_AND_D:String = 'd-and-d';
		public static const D_AND_D_BEYOND:String = 'd-and-d-beyond';
		public static const DASHBOARD:String = 'dashboard';
		public static const DASHCUBE:String = 'dashcube';
		public static const DATABASE:String = 'database';
		public static const DEAF:String = 'deaf';
		public static const DEAFNESS:String = 'deafness';
		public static const DEBIAN:String = 'debian';
		public static const DEDENT:String = 'dedent';
		public static const DEEZER:String = 'deezer';
		public static const DELETE_LEFT:String = 'delete-left';
		public static const DELICIOUS:String = 'delicious';
		public static const DEMOCRAT:String = 'democrat';
		public static const DEPLOYDOG:String = 'deploydog';
		public static const DESKPRO:String = 'deskpro';
		public static const DESKTOP:String = 'desktop';
		public static const DESKTOP_ALT:String = 'desktop-alt';
		public static const DEV:String = 'dev';
		public static const DEVIANTART:String = 'deviantart';
		public static const DHARMACHAKRA:String = 'dharmachakra';
		public static const DHL:String = 'dhl';
		public static const DIAGNOSES:String = 'diagnoses';
		public static const DIAGRAM_NEXT:String = 'diagram-next';
		public static const DIAGRAM_PREDECESSOR:String = 'diagram-predecessor';
		public static const DIAGRAM_PROJECT:String = 'diagram-project';
		public static const DIAGRAM_SUCCESSOR:String = 'diagram-successor';
		public static const DIAMOND:String = 'diamond';
		public static const DIAMOND_TURN_RIGHT:String = 'diamond-turn-right';
		public static const DIASPORA:String = 'diaspora';
		public static const DICE:String = 'dice';
		public static const DICE_D20:String = 'dice-d20';
		public static const DICE_D6:String = 'dice-d6';
		public static const DICE_FIVE:String = 'dice-five';
		public static const DICE_FOUR:String = 'dice-four';
		public static const DICE_ONE:String = 'dice-one';
		public static const DICE_SIX:String = 'dice-six';
		public static const DICE_THREE:String = 'dice-three';
		public static const DICE_TWO:String = 'dice-two';
		public static const DIGG:String = 'digg';
		public static const DIGGING:String = 'digging';
		public static const DIGITAL_OCEAN:String = 'digital-ocean';
		public static const DIGITAL_TACHOGRAPH:String = 'digital-tachograph';
		public static const DIRECTIONS:String = 'directions';
		public static const DISCORD:String = 'discord';
		public static const DISCOURSE:String = 'discourse';
		public static const DISEASE:String = 'disease';
		public static const DISPLAY:String = 'display';
		public static const DIVIDE:String = 'divide';
		public static const DIZZY:String = 'dizzy';
		public static const DNA:String = 'dna';
		public static const DOCHUB:String = 'dochub';
		public static const DOCKER:String = 'docker';
		public static const DOG:String = 'dog';
		public static const DOLLAR:String = 'dollar';
		public static const DOLLAR_SIGN:String = 'dollar-sign';
		public static const DOLLY:String = 'dolly';
		public static const DOLLY_BOX:String = 'dolly-box';
		public static const DOLLY_FLATBED:String = 'dolly-flatbed';
		public static const DONATE:String = 'donate';
		public static const DONG_SIGN:String = 'dong-sign';
		public static const DOOR_CLOSED:String = 'door-closed';
		public static const DOOR_OPEN:String = 'door-open';
		public static const DOT_CIRCLE:String = 'dot-circle';
		public static const DOVE:String = 'dove';
		public static const DOWN_LEFT_AND_UP_RIGHT_TO_CENTER:String = 'down-left-and-up-right-to-center';
		public static const DOWNLOAD:String = 'download';
		public static const DOWN_LONG:String = 'down-long';
		public static const DRAFT2DIGITAL:String = 'draft2digital';
		public static const DRAFTING_COMPASS:String = 'drafting-compass';
		public static const DRAGON:String = 'dragon';
		public static const DRAW_POLYGON:String = 'draw-polygon';
		public static const DRIBBBLE:String = 'dribbble';
		public static const DRIBBBLE_SQUARE:String = 'dribbble-square';
		public static const DRIVERS_LICENSE:String = 'drivers-license';
		public static const DROPBOX:String = 'dropbox';
		public static const DROPLET:String = 'droplet';
		public static const DROPLET_SLASH:String = 'droplet-slash';
		public static const DRUM:String = 'drum';
		public static const DRUM_STEELPAN:String = 'drum-steelpan';
		public static const DRUMSTICK_BITE:String = 'drumstick-bite';
		public static const DRUPAL:String = 'drupal';
		public static const DUMBBELL:String = 'dumbbell';
		public static const DUMPSTER:String = 'dumpster';
		public static const DUMPSTER_FIRE:String = 'dumpster-fire';
		public static const DUNGEON:String = 'dungeon';
		public static const DYALOG:String = 'dyalog';
		public static const E:String = 'e';
		public static const EAR_DEAF:String = 'ear-deaf';
		public static const EAR_LISTEN:String = 'ear-listen';
		public static const EARLYBIRDS:String = 'earlybirds';
		public static const EARTH:String = 'earth';
		public static const EARTH_AFRICA:String = 'earth-africa';
		public static const EARTH_AMERICA:String = 'earth-america';
		public static const EARTH_AMERICAS:String = 'earth-americas';
		public static const EARTH_ASIA:String = 'earth-asia';
		public static const EARTH_EUROPE:String = 'earth-europe';
		public static const EARTH_OCEANIA:String = 'earth-oceania';
		public static const EBAY:String = 'ebay';
		public static const EDGE:String = 'edge';
		public static const EDGE_LEGACY:String = 'edge-legacy';
		public static const EDIT:String = 'edit';
		public static const EGG:String = 'egg';
		public static const EJECT:String = 'eject';
		public static const ELEMENTOR:String = 'elementor';
		public static const ELEVATOR:String = 'elevator';
		public static const ELLIPSIS:String = 'ellipsis';
		public static const ELLIPSIS_H:String = 'ellipsis-h';
		public static const ELLIPSIS_V:String = 'ellipsis-v';
		public static const ELLIPSIS_VERTICAL:String = 'ellipsis-vertical';
		public static const ELLO:String = 'ello';
		public static const EMBER:String = 'ember';
		public static const EMPIRE:String = 'empire';
		public static const ENVELOPE:String = 'envelope';
		public static const ENVELOPE_CIRCLE_CHECK:String = 'envelope-circle-check';
		public static const ENVELOPE_OPEN:String = 'envelope-open';
		public static const ENVELOPE_OPEN_TEXT:String = 'envelope-open-text';
		public static const ENVELOPES_BULK:String = 'envelopes-bulk';
		public static const ENVELOPE_SQUARE:String = 'envelope-square';
		public static const ENVIRA:String = 'envira';
		public static const EQUALS:String = 'equals';
		public static const ERASER:String = 'eraser';
		public static const ERLANG:String = 'erlang';
		public static const ETHEREUM:String = 'ethereum';
		public static const ETHERNET:String = 'ethernet';
		public static const ETSY:String = 'etsy';
		public static const EUR:String = 'eur';
		public static const EURO:String = 'euro';
		public static const EURO_SIGN:String = 'euro-sign';
		public static const EVERNOTE:String = 'evernote';
		public static const EXCHANGE:String = 'exchange';
		public static const EXCHANGE_ALT:String = 'exchange-alt';
		public static const EXCLAMATION:String = 'exclamation';
		public static const EXCLAMATION_CIRCLE:String = 'exclamation-circle';
		public static const EXCLAMATION_TRIANGLE:String = 'exclamation-triangle';
		public static const EXPAND:String = 'expand';
		public static const EXPAND_ALT:String = 'expand-alt';
		public static const EXPAND_ARROWS_ALT:String = 'expand-arrows-alt';
		public static const EXPEDITEDSSL:String = 'expeditedssl';
		public static const EXPLOSION:String = 'explosion';
		public static const EXTERNAL_LINK:String = 'external-link';
		public static const EXTERNAL_LINK_ALT:String = 'external-link-alt';
		public static const EXTERNAL_LINK_SQUARE:String = 'external-link-square';
		public static const EXTERNAL_LINK_SQUARE_ALT:String = 'external-link-square-alt';
		public static const EYE:String = 'eye';
		public static const EYEDROPPER:String = 'eyedropper';
		public static const EYE_DROPPER:String = 'eye-dropper';
		public static const EYE_DROPPER_EMPTY:String = 'eye-dropper-empty';
		public static const EYE_LOW_VISION:String = 'eye-low-vision';
		public static const EYE_SLASH:String = 'eye-slash';
		public static const F:String = 'f';
		public static const FACE_ANGRY:String = 'face-angry';
		public static const FACEBOOK:String = 'facebook';
		public static const FACEBOOK_F:String = 'facebook-f';
		public static const FACEBOOK_MESSENGER:String = 'facebook-messenger';
		public static const FACEBOOK_SQUARE:String = 'facebook-square';
		public static const FACE_DIZZY:String = 'face-dizzy';
		public static const FACE_FLUSHED:String = 'face-flushed';
		public static const FACE_FROWN:String = 'face-frown';
		public static const FACE_FROWN_OPEN:String = 'face-frown-open';
		public static const FACE_GRIMACE:String = 'face-grimace';
		public static const FACE_GRIN:String = 'face-grin';
		public static const FACE_GRIN_BEAM:String = 'face-grin-beam';
		public static const FACE_GRIN_BEAM_SWEAT:String = 'face-grin-beam-sweat';
		public static const FACE_GRIN_HEARTS:String = 'face-grin-hearts';
		public static const FACE_GRIN_SQUINT:String = 'face-grin-squint';
		public static const FACE_GRIN_SQUINT_TEARS:String = 'face-grin-squint-tears';
		public static const FACE_GRIN_STARS:String = 'face-grin-stars';
		public static const FACE_GRIN_TEARS:String = 'face-grin-tears';
		public static const FACE_GRIN_TONGUE:String = 'face-grin-tongue';
		public static const FACE_GRIN_TONGUE_SQUINT:String = 'face-grin-tongue-squint';
		public static const FACE_GRIN_TONGUE_WINK:String = 'face-grin-tongue-wink';
		public static const FACE_GRIN_WIDE:String = 'face-grin-wide';
		public static const FACE_GRIN_WINK:String = 'face-grin-wink';
		public static const FACE_KISS:String = 'face-kiss';
		public static const FACE_KISS_BEAM:String = 'face-kiss-beam';
		public static const FACE_KISS_WINK_HEART:String = 'face-kiss-wink-heart';
		public static const FACE_LAUGH:String = 'face-laugh';
		public static const FACE_LAUGH_BEAM:String = 'face-laugh-beam';
		public static const FACE_LAUGH_SQUINT:String = 'face-laugh-squint';
		public static const FACE_LAUGH_WINK:String = 'face-laugh-wink';
		public static const FACE_MEH:String = 'face-meh';
		public static const FACE_MEH_BLANK:String = 'face-meh-blank';
		public static const FACE_ROLLING_EYES:String = 'face-rolling-eyes';
		public static const FACE_SAD_CRY:String = 'face-sad-cry';
		public static const FACE_SAD_TEAR:String = 'face-sad-tear';
		public static const FACE_SMILE:String = 'face-smile';
		public static const FACE_SMILE_BEAM:String = 'face-smile-beam';
		public static const FACE_SMILE_WINK:String = 'face-smile-wink';
		public static const FACE_SURPRISE:String = 'face-surprise';
		public static const FACE_TIRED:String = 'face-tired';
		public static const FAN:String = 'fan';
		public static const FANTASY_FLIGHT_GAMES:String = 'fantasy-flight-games';
		public static const FAST_BACKWARD:String = 'fast-backward';
		public static const FAST_FORWARD:String = 'fast-forward';
		public static const FAUCET:String = 'faucet';
		public static const FAUCET_DRIP:String = 'faucet-drip';
		public static const FAX:String = 'fax';
		public static const FEATHER:String = 'feather';
		public static const FEATHER_ALT:String = 'feather-alt';
		public static const FEATHER_POINTED:String = 'feather-pointed';
		public static const FEDEX:String = 'fedex';
		public static const FEDORA:String = 'fedora';
		public static const FEED:String = 'feed';
		public static const FEMALE:String = 'female';
		public static const FERRY:String = 'ferry';
		public static const FIGHTER_JET:String = 'fighter-jet';
		public static const FIGMA:String = 'figma';
		public static const FILE:String = 'file';
		public static const FILE_ALT:String = 'file-alt';
		public static const FILE_ARCHIVE:String = 'file-archive';
		public static const FILE_ARROW_DOWN:String = 'file-arrow-down';
		public static const FILE_ARROW_UP:String = 'file-arrow-up';
		public static const FILE_AUDIO:String = 'file-audio';
		public static const FILE_CIRCLE_CHECK:String = 'file-circle-check';
		public static const FILE_CIRCLE_EXCLAMATION:String = 'file-circle-exclamation';
		public static const FILE_CIRCLE_MINUS:String = 'file-circle-minus';
		public static const FILE_CIRCLE_PLUS:String = 'file-circle-plus';
		public static const FILE_CIRCLE_QUESTION:String = 'file-circle-question';
		public static const FILE_CIRCLE_XMARK:String = 'file-circle-xmark';
		public static const FILE_CLIPBOARD:String = 'file-clipboard';
		public static const FILE_CODE:String = 'file-code';
		public static const FILE_CONTRACT:String = 'file-contract';
		public static const FILE_CSV:String = 'file-csv';
		public static const FILE_DOWNLOAD:String = 'file-download';
		public static const FILE_EDIT:String = 'file-edit';
		public static const FILE_EXCEL:String = 'file-excel';
		public static const FILE_EXPORT:String = 'file-export';
		public static const FILE_IMAGE:String = 'file-image';
		public static const FILE_IMPORT:String = 'file-import';
		public static const FILE_INVOICE:String = 'file-invoice';
		public static const FILE_INVOICE_DOLLAR:String = 'file-invoice-dollar';
		public static const FILE_LINES:String = 'file-lines';
		public static const FILE_MEDICAL:String = 'file-medical';
		public static const FILE_MEDICAL_ALT:String = 'file-medical-alt';
		public static const FILE_PDF:String = 'file-pdf';
		public static const FILE_PEN:String = 'file-pen';
		public static const FILE_POWERPOINT:String = 'file-powerpoint';
		public static const FILE_PRESCRIPTION:String = 'file-prescription';
		public static const FILE_SHIELD:String = 'file-shield';
		public static const FILE_SIGNATURE:String = 'file-signature';
		public static const FILE_TEXT:String = 'file-text';
		public static const FILE_UPLOAD:String = 'file-upload';
		public static const FILE_VIDEO:String = 'file-video';
		public static const FILE_WAVEFORM:String = 'file-waveform';
		public static const FILE_WORD:String = 'file-word';
		public static const FILE_ZIPPER:String = 'file-zipper';
		public static const FILL:String = 'fill';
		public static const FILL_DRIP:String = 'fill-drip';
		public static const FILM:String = 'film';
		public static const FILTER:String = 'filter';
		public static const FILTER_CIRCLE_DOLLAR:String = 'filter-circle-dollar';
		public static const FILTER_CIRCLE_XMARK:String = 'filter-circle-xmark';
		public static const FINGERPRINT:String = 'fingerprint';
		public static const FIRE:String = 'fire';
		public static const FIRE_ALT:String = 'fire-alt';
		public static const FIRE_BURNER:String = 'fire-burner';
		public static const FIRE_EXTINGUISHER:String = 'fire-extinguisher';
		public static const FIRE_FLAME_CURVED:String = 'fire-flame-curved';
		public static const FIRE_FLAME_SIMPLE:String = 'fire-flame-simple';
		public static const FIREFOX:String = 'firefox';
		public static const FIREFOX_BROWSER:String = 'firefox-browser';
		public static const FIRST_AID:String = 'first-aid';
		public static const FIRSTDRAFT:String = 'firstdraft';
		public static const FIRST_ORDER:String = 'first-order';
		public static const FIRST_ORDER_ALT:String = 'first-order-alt';
		public static const FISH:String = 'fish';
		public static const FISH_FINS:String = 'fish-fins';
		public static const FIST_RAISED:String = 'fist-raised';
		public static const FLAG:String = 'flag';
		public static const FLAG_CHECKERED:String = 'flag-checkered';
		public static const FLAG_USA:String = 'flag-usa';
		public static const FLASK:String = 'flask';
		public static const FLASK_VIAL:String = 'flask-vial';
		public static const FLICKR:String = 'flickr';
		public static const FLIPBOARD:String = 'flipboard';
		public static const FLOPPY_DISK:String = 'floppy-disk';
		public static const FLORIN_SIGN:String = 'florin-sign';
		public static const FLUSHED:String = 'flushed';
		public static const FLY:String = 'fly';
		public static const FOLDER:String = 'folder';
		public static const FOLDER_BLANK:String = 'folder-blank';
		public static const FOLDER_CLOSED:String = 'folder-closed';
		public static const FOLDER_MINUS:String = 'folder-minus';
		public static const FOLDER_OPEN:String = 'folder-open';
		public static const FOLDER_PLUS:String = 'folder-plus';
		public static const FOLDER_TREE:String = 'folder-tree';
		public static const FONT:String = 'font';
		public static const FONT_AWESOME:String = 'font-awesome';
		public static const FONT_AWESOME_ALT:String = 'font-awesome-alt';
		public static const FONT_AWESOME_FLAG:String = 'font-awesome-flag';
		public static const FONT_AWESOME_LOGO_FULL:String = 'font-awesome-logo-full';
		public static const FONTICONS:String = 'fonticons';
		public static const FONTICONS_FI:String = 'fonticons-fi';
		public static const FOOTBALL:String = 'football';
		public static const FOOTBALL_BALL:String = 'football-ball';
		public static const FORT_AWESOME:String = 'fort-awesome';
		public static const FORT_AWESOME_ALT:String = 'fort-awesome-alt';
		public static const FORUMBEE:String = 'forumbee';
		public static const FORWARD:String = 'forward';
		public static const FORWARD_FAST:String = 'forward-fast';
		public static const FORWARD_STEP:String = 'forward-step';
		public static const FOURSQUARE:String = 'foursquare';
		public static const FRANC_SIGN:String = 'franc-sign';
		public static const FREEBSD:String = 'freebsd';
		public static const FREE_CODE_CAMP:String = 'free-code-camp';
		public static const FROG:String = 'frog';
		public static const FROWN:String = 'frown';
		public static const FROWN_OPEN:String = 'frown-open';
		public static const FULCRUM:String = 'fulcrum';
		public static const FUNNEL_DOLLAR:String = 'funnel-dollar';
		public static const FUTBOL:String = 'futbol';
		public static const FUTBOL_BALL:String = 'futbol-ball';
		public static const G:String = 'g';
		public static const GALACTIC_REPUBLIC:String = 'galactic-republic';
		public static const GALACTIC_SENATE:String = 'galactic-senate';
		public static const GAMEPAD:String = 'gamepad';
		public static const GAS_PUMP:String = 'gas-pump';
		public static const GAUGE:String = 'gauge';
		public static const GAUGE_HIGH:String = 'gauge-high';
		public static const GAUGE_MED:String = 'gauge-med';
		public static const GAUGE_SIMPLE:String = 'gauge-simple';
		public static const GAUGE_SIMPLE_HIGH:String = 'gauge-simple-high';
		public static const GAUGE_SIMPLE_MED:String = 'gauge-simple-med';
		public static const GAVEL:String = 'gavel';
		public static const GBP:String = 'gbp';
		public static const GEAR:String = 'gear';
		public static const GEARS:String = 'gears';
		public static const GEM:String = 'gem';
		public static const GENDERLESS:String = 'genderless';
		public static const GET_POCKET:String = 'get-pocket';
		public static const GG:String = 'gg';
		public static const GG_CIRCLE:String = 'gg-circle';
		public static const GHOST:String = 'ghost';
		public static const GIFT:String = 'gift';
		public static const GIFTS:String = 'gifts';
		public static const GIT:String = 'git';
		public static const GIT_ALT:String = 'git-alt';
		public static const GITHUB:String = 'github';
		public static const GITHUB_ALT:String = 'github-alt';
		public static const GITHUB_SQUARE:String = 'github-square';
		public static const GITKRAKEN:String = 'gitkraken';
		public static const GITLAB:String = 'gitlab';
		public static const GITLAB_SQUARE:String = 'gitlab-square';
		public static const GIT_SQUARE:String = 'git-square';
		public static const GITTER:String = 'gitter';
		public static const GLASS_CHEERS:String = 'glass-cheers';
		public static const GLASSES:String = 'glasses';
		public static const GLASS_MARTINI:String = 'glass-martini';
		public static const GLASS_MARTINI_ALT:String = 'glass-martini-alt';
		public static const GLASS_WATER:String = 'glass-water';
		public static const GLASS_WATER_DROPLET:String = 'glass-water-droplet';
		public static const GLASS_WHISKEY:String = 'glass-whiskey';
		public static const GLIDE:String = 'glide';
		public static const GLIDE_G:String = 'glide-g';
		public static const GLOBE:String = 'globe';
		public static const GLOBE_AFRICA:String = 'globe-africa';
		public static const GLOBE_AMERICAS:String = 'globe-americas';
		public static const GLOBE_ASIA:String = 'globe-asia';
		public static const GLOBE_EUROPE:String = 'globe-europe';
		public static const GLOBE_OCEANIA:String = 'globe-oceania';
		public static const GOFORE:String = 'gofore';
		public static const GOLANG:String = 'golang';
		public static const GOLF_BALL:String = 'golf-ball';
		public static const GOLF_BALL_TEE:String = 'golf-ball-tee';
		public static const GOODREADS:String = 'goodreads';
		public static const GOODREADS_G:String = 'goodreads-g';
		public static const GOOGLE:String = 'google';
		public static const GOOGLE_DRIVE:String = 'google-drive';
		public static const GOOGLE_PAY:String = 'google-pay';
		public static const GOOGLE_PLAY:String = 'google-play';
		public static const GOOGLE_PLUS:String = 'google-plus';
		public static const GOOGLE_PLUS_G:String = 'google-plus-g';
		public static const GOOGLE_PLUS_SQUARE:String = 'google-plus-square';
		public static const GOOGLE_SCHOLAR:String = 'google-scholar';
		public static const GOOGLE_WALLET:String = 'google-wallet';
		public static const GOPURAM:String = 'gopuram';
		public static const GRADUATION_CAP:String = 'graduation-cap';
		public static const GRATIPAY:String = 'gratipay';
		public static const GRAV:String = 'grav';
		public static const GREATER_THAN:String = 'greater-than';
		public static const GREATER_THAN_EQUAL:String = 'greater-than-equal';
		public static const GRIMACE:String = 'grimace';
		public static const GRIN:String = 'grin';
		public static const GRIN_ALT:String = 'grin-alt';
		public static const GRIN_BEAM:String = 'grin-beam';
		public static const GRIN_BEAM_SWEAT:String = 'grin-beam-sweat';
		public static const GRIN_HEARTS:String = 'grin-hearts';
		public static const GRIN_SQUINT:String = 'grin-squint';
		public static const GRIN_SQUINT_TEARS:String = 'grin-squint-tears';
		public static const GRIN_STARS:String = 'grin-stars';
		public static const GRIN_TEARS:String = 'grin-tears';
		public static const GRIN_TONGUE:String = 'grin-tongue';
		public static const GRIN_TONGUE_SQUINT:String = 'grin-tongue-squint';
		public static const GRIN_TONGUE_WINK:String = 'grin-tongue-wink';
		public static const GRIN_WINK:String = 'grin-wink';
		public static const GRIP:String = 'grip';
		public static const GRIPFIRE:String = 'gripfire';
		public static const GRIP_HORIZONTAL:String = 'grip-horizontal';
		public static const GRIP_LINES:String = 'grip-lines';
		public static const GRIP_LINES_VERTICAL:String = 'grip-lines-vertical';
		public static const GRIP_VERTICAL:String = 'grip-vertical';
		public static const GROUP_ARROWS_ROTATE:String = 'group-arrows-rotate';
		public static const GRUNT:String = 'grunt';
		public static const GUARANI_SIGN:String = 'guarani-sign';
		public static const GUILDED:String = 'guilded';
		public static const GUITAR:String = 'guitar';
		public static const GULP:String = 'gulp';
		public static const GUN:String = 'gun';
		public static const H:String = 'h';
		public static const HACKER_NEWS:String = 'hacker-news';
		public static const HACKER_NEWS_SQUARE:String = 'hacker-news-square';
		public static const HACKERRANK:String = 'hackerrank';
		public static const HAMBURGER:String = 'hamburger';
		public static const HAMMER:String = 'hammer';
		public static const HAMSA:String = 'hamsa';
		public static const HAND:String = 'hand';
		public static const HAND_BACK_FIST:String = 'hand-back-fist';
		public static const HANDCUFFS:String = 'handcuffs';
		public static const HAND_DOTS:String = 'hand-dots';
		public static const HAND_FIST:String = 'hand-fist';
		public static const HAND_HOLDING:String = 'hand-holding';
		public static const HAND_HOLDING_DOLLAR:String = 'hand-holding-dollar';
		public static const HAND_HOLDING_DROPLET:String = 'hand-holding-droplet';
		public static const HAND_HOLDING_HAND:String = 'hand-holding-hand';
		public static const HAND_HOLDING_HEART:String = 'hand-holding-heart';
		public static const HAND_HOLDING_MEDICAL:String = 'hand-holding-medical';
		public static const HAND_HOLDING_USD:String = 'hand-holding-usd';
		public static const HAND_HOLDING_WATER:String = 'hand-holding-water';
		public static const HAND_LIZARD:String = 'hand-lizard';
		public static const HAND_MIDDLE_FINGER:String = 'hand-middle-finger';
		public static const HAND_PAPER:String = 'hand-paper';
		public static const HAND_PEACE:String = 'hand-peace';
		public static const HAND_POINT_DOWN:String = 'hand-point-down';
		public static const HAND_POINTER:String = 'hand-pointer';
		public static const HAND_POINT_LEFT:String = 'hand-point-left';
		public static const HAND_POINT_RIGHT:String = 'hand-point-right';
		public static const HAND_POINT_UP:String = 'hand-point-up';
		public static const HAND_ROCK:String = 'hand-rock';
		public static const HANDS:String = 'hands';
		public static const HANDS_AMERICAN_SIGN_LANGUAGE_INTERPRETING:String = 'hands-american-sign-language-interpreting';
		public static const HANDS_ASL_INTERPRETING:String = 'hands-asl-interpreting';
		public static const HANDS_BOUND:String = 'hands-bound';
		public static const HANDS_BUBBLES:String = 'hands-bubbles';
		public static const HAND_SCISSORS:String = 'hand-scissors';
		public static const HANDS_CLAPPING:String = 'hands-clapping';
		public static const HANDSHAKE:String = 'handshake';
		public static const HANDSHAKE_ALT:String = 'handshake-alt';
		public static const HANDSHAKE_ALT_SLASH:String = 'handshake-alt-slash';
		public static const HANDSHAKE_ANGLE:String = 'handshake-angle';
		public static const HANDSHAKE_SIMPLE:String = 'handshake-simple';
		public static const HANDSHAKE_SIMPLE_SLASH:String = 'handshake-simple-slash';
		public static const HANDSHAKE_SLASH:String = 'handshake-slash';
		public static const HANDS_HELPING:String = 'hands-helping';
		public static const HANDS_HOLDING:String = 'hands-holding';
		public static const HANDS_HOLDING_CHILD:String = 'hands-holding-child';
		public static const HANDS_HOLDING_CIRCLE:String = 'hands-holding-circle';
		public static const HAND_SPARKLES:String = 'hand-sparkles';
		public static const HAND_SPOCK:String = 'hand-spock';
		public static const HANDS_PRAYING:String = 'hands-praying';
		public static const HANDS_WASH:String = 'hands-wash';
		public static const HANUKIAH:String = 'hanukiah';
		public static const HARD_DRIVE:String = 'hard-drive';
		public static const HARD_HAT:String = 'hard-hat';
		public static const HARD_OF_HEARING:String = 'hard-of-hearing';
		public static const HASHNODE:String = 'hashnode';
		public static const HASHTAG:String = 'hashtag';
		public static const HAT_COWBOY:String = 'hat-cowboy';
		public static const HAT_COWBOY_SIDE:String = 'hat-cowboy-side';
		public static const HAT_HARD:String = 'hat-hard';
		public static const HAT_WIZARD:String = 'hat-wizard';
		public static const HAYKAL:String = 'haykal';
		public static const HDD:String = 'hdd';
		public static const HEADER:String = 'header';
		public static const HEADING:String = 'heading';
		public static const HEADPHONES:String = 'headphones';
		public static const HEADPHONES_ALT:String = 'headphones-alt';
		public static const HEADPHONES_SIMPLE:String = 'headphones-simple';
		public static const HEADSET:String = 'headset';
		public static const HEAD_SIDE_COUGH:String = 'head-side-cough';
		public static const HEAD_SIDE_COUGH_SLASH:String = 'head-side-cough-slash';
		public static const HEAD_SIDE_MASK:String = 'head-side-mask';
		public static const HEAD_SIDE_VIRUS:String = 'head-side-virus';
		public static const HEART:String = 'heart';
		public static const HEARTBEAT:String = 'heartbeat';
		public static const HEART_BROKEN:String = 'heart-broken';
		public static const HEART_CIRCLE_BOLT:String = 'heart-circle-bolt';
		public static const HEART_CIRCLE_CHECK:String = 'heart-circle-check';
		public static const HEART_CIRCLE_EXCLAMATION:String = 'heart-circle-exclamation';
		public static const HEART_CIRCLE_MINUS:String = 'heart-circle-minus';
		public static const HEART_CIRCLE_PLUS:String = 'heart-circle-plus';
		public static const HEART_CIRCLE_XMARK:String = 'heart-circle-xmark';
		public static const HEART_CRACK:String = 'heart-crack';
		public static const HEART_MUSIC_CAMERA_BOLT:String = 'heart-music-camera-bolt';
		public static const HEART_PULSE:String = 'heart-pulse';
		public static const HELICOPTER:String = 'helicopter';
		public static const HELICOPTER_SYMBOL:String = 'helicopter-symbol';
		public static const HELMET_SAFETY:String = 'helmet-safety';
		public static const HELMET_UN:String = 'helmet-un';
		public static const HIGHLIGHTER:String = 'highlighter';
		public static const HIKING:String = 'hiking';
		public static const HILL_AVALANCHE:String = 'hill-avalanche';
		public static const HILL_ROCKSLIDE:String = 'hill-rockslide';
		public static const HIPPO:String = 'hippo';
		public static const HIPS:String = 'hips';
		public static const HIRE_A_HELPER:String = 'hire-a-helper';
		public static const HISTORY:String = 'history';
		public static const HIVE:String = 'hive';
		public static const HOCKEY_PUCK:String = 'hockey-puck';
		public static const HOLLY_BERRY:String = 'holly-berry';
		public static const HOME:String = 'home';
		public static const HOME_ALT:String = 'home-alt';
		public static const HOME_LG:String = 'home-lg';
		public static const HOME_LG_ALT:String = 'home-lg-alt';
		public static const HOME_USER:String = 'home-user';
		public static const HOOLI:String = 'hooli';
		public static const HORNBILL:String = 'hornbill';
		public static const HORSE:String = 'horse';
		public static const HORSE_HEAD:String = 'horse-head';
		public static const HOSPITAL:String = 'hospital';
		public static const HOSPITAL_ALT:String = 'hospital-alt';
		public static const HOSPITAL_SYMBOL:String = 'hospital-symbol';
		public static const HOSPITAL_USER:String = 'hospital-user';
		public static const HOSPITAL_WIDE:String = 'hospital-wide';
		public static const HOTDOG:String = 'hotdog';
		public static const HOTEL:String = 'hotel';
		public static const HOTJAR:String = 'hotjar';
		public static const HOT_TUB:String = 'hot-tub';
		public static const HOT_TUB_PERSON:String = 'hot-tub-person';
		public static const HOURGLASS:String = 'hourglass';
		public static const HOURGLASS_1:String = 'hourglass-1';
		public static const HOURGLASS_2:String = 'hourglass-2';
		public static const HOURGLASS_3:String = 'hourglass-3';
		public static const HOURGLASS_EMPTY:String = 'hourglass-empty';
		public static const HOURGLASS_END:String = 'hourglass-end';
		public static const HOURGLASS_HALF:String = 'hourglass-half';
		public static const HOURGLASS_START:String = 'hourglass-start';
		public static const HOUSE:String = 'house';
		public static const HOUSE_CHIMNEY:String = 'house-chimney';
		public static const HOUSE_CHIMNEY_CRACK:String = 'house-chimney-crack';
		public static const HOUSE_CHIMNEY_MEDICAL:String = 'house-chimney-medical';
		public static const HOUSE_CHIMNEY_USER:String = 'house-chimney-user';
		public static const HOUSE_CHIMNEY_WINDOW:String = 'house-chimney-window';
		public static const HOUSE_CIRCLE_CHECK:String = 'house-circle-check';
		public static const HOUSE_CIRCLE_EXCLAMATION:String = 'house-circle-exclamation';
		public static const HOUSE_CIRCLE_XMARK:String = 'house-circle-xmark';
		public static const HOUSE_CRACK:String = 'house-crack';
		public static const HOUSE_DAMAGE:String = 'house-damage';
		public static const HOUSE_FIRE:String = 'house-fire';
		public static const HOUSE_FLAG:String = 'house-flag';
		public static const HOUSE_FLOOD_WATER:String = 'house-flood-water';
		public static const HOUSE_FLOOD_WATER_CIRCLE_ARROW_RIGHT:String = 'house-flood-water-circle-arrow-right';
		public static const HOUSE_LAPTOP:String = 'house-laptop';
		public static const HOUSE_LOCK:String = 'house-lock';
		public static const HOUSE_MEDICAL:String = 'house-medical';
		public static const HOUSE_MEDICAL_CIRCLE_CHECK:String = 'house-medical-circle-check';
		public static const HOUSE_MEDICAL_CIRCLE_EXCLAMATION:String = 'house-medical-circle-exclamation';
		public static const HOUSE_MEDICAL_CIRCLE_XMARK:String = 'house-medical-circle-xmark';
		public static const HOUSE_MEDICAL_FLAG:String = 'house-medical-flag';
		public static const HOUSE_SIGNAL:String = 'house-signal';
		public static const HOUSE_TSUNAMI:String = 'house-tsunami';
		public static const HOUSE_USER:String = 'house-user';
		public static const HOUZZ:String = 'houzz';
		public static const HRYVNIA:String = 'hryvnia';
		public static const HRYVNIA_SIGN:String = 'hryvnia-sign';
		public static const H_SQUARE:String = 'h-square';
		public static const HTML5:String = 'html5';
		public static const HUBSPOT:String = 'hubspot';
		public static const HURRICANE:String = 'hurricane';
		public static const I:String = 'i';
		public static const ICE_CREAM:String = 'ice-cream';
		public static const ICICLES:String = 'icicles';
		public static const ICONS:String = 'icons';
		public static const I_CURSOR:String = 'i-cursor';
		public static const ID_BADGE:String = 'id-badge';
		public static const ID_CARD:String = 'id-card';
		public static const ID_CARD_ALT:String = 'id-card-alt';
		public static const ID_CARD_CLIP:String = 'id-card-clip';
		public static const IDEAL:String = 'ideal';
		public static const IGLOO:String = 'igloo';
		public static const ILS:String = 'ils';
		public static const IMAGE:String = 'image';
		public static const IMAGE_PORTRAIT:String = 'image-portrait';
		public static const IMAGES:String = 'images';
		public static const IMDB:String = 'imdb';
		public static const INBOX:String = 'inbox';
		public static const INDENT:String = 'indent';
		public static const INDIAN_RUPEE:String = 'indian-rupee';
		public static const INDIAN_RUPEE_SIGN:String = 'indian-rupee-sign';
		public static const INDUSTRY:String = 'industry';
		public static const INFINITY:String = 'infinity';
		public static const INFO:String = 'info';
		public static const INFO_CIRCLE:String = 'info-circle';
		public static const INNOSOFT:String = 'innosoft';
		public static const INR:String = 'inr';
		public static const INSTAGRAM:String = 'instagram';
		public static const INSTAGRAM_SQUARE:String = 'instagram-square';
		public static const INSTALOD:String = 'instalod';
		public static const INSTITUTION:String = 'institution';
		public static const INTERCOM:String = 'intercom';
		public static const INTERNET_EXPLORER:String = 'internet-explorer';
		public static const INVISION:String = 'invision';
		public static const IOXHOST:String = 'ioxhost';
		public static const ITALIC:String = 'italic';
		public static const ITCH_IO:String = 'itch-io';
		public static const ITUNES:String = 'itunes';
		public static const ITUNES_NOTE:String = 'itunes-note';
		public static const J:String = 'j';
		public static const JAR:String = 'jar';
		public static const JAR_WHEAT:String = 'jar-wheat';
		public static const JAVA:String = 'java';
		public static const JEDI:String = 'jedi';
		public static const JEDI_ORDER:String = 'jedi-order';
		public static const JENKINS:String = 'jenkins';
		public static const JET_FIGHTER:String = 'jet-fighter';
		public static const JET_FIGHTER_UP:String = 'jet-fighter-up';
		public static const JIRA:String = 'jira';
		public static const JOGET:String = 'joget';
		public static const JOINT:String = 'joint';
		public static const JOOMLA:String = 'joomla';
		public static const JOURNAL_WHILLS:String = 'journal-whills';
		public static const JPY:String = 'jpy';
		public static const JS:String = 'js';
		public static const JSFIDDLE:String = 'jsfiddle';
		public static const JS_SQUARE:String = 'js-square';
		public static const JUG_DETERGENT:String = 'jug-detergent';
		public static const JXL:String = 'jxl';
		public static const K:String = 'k';
		public static const KAABA:String = 'kaaba';
		public static const KAGGLE:String = 'kaggle';
		public static const KEY:String = 'key';
		public static const KEYBASE:String = 'keybase';
		public static const KEYBOARD:String = 'keyboard';
		public static const KEYCDN:String = 'keycdn';
		public static const KHANDA:String = 'khanda';
		public static const KICKSTARTER:String = 'kickstarter';
		public static const KICKSTARTER_K:String = 'kickstarter-k';
		public static const KIP_SIGN:String = 'kip-sign';
		public static const KISS:String = 'kiss';
		public static const KISS_BEAM:String = 'kiss-beam';
		public static const KISS_WINK_HEART:String = 'kiss-wink-heart';
		public static const KITCHEN_SET:String = 'kitchen-set';
		public static const KIT_MEDICAL:String = 'kit-medical';
		public static const KIWI_BIRD:String = 'kiwi-bird';
		public static const KORVUE:String = 'korvue';
		public static const KRW:String = 'krw';
		public static const L:String = 'l';
		public static const LADDER_WATER:String = 'ladder-water';
		public static const LANDMARK:String = 'landmark';
		public static const LANDMARK_ALT:String = 'landmark-alt';
		public static const LANDMARK_DOME:String = 'landmark-dome';
		public static const LANDMARK_FLAG:String = 'landmark-flag';
		public static const LAND_MINE_ON:String = 'land-mine-on';
		public static const LANGUAGE:String = 'language';
		public static const LAPTOP:String = 'laptop';
		public static const LAPTOP_CODE:String = 'laptop-code';
		public static const LAPTOP_FILE:String = 'laptop-file';
		public static const LAPTOP_HOUSE:String = 'laptop-house';
		public static const LAPTOP_MEDICAL:String = 'laptop-medical';
		public static const LARAVEL:String = 'laravel';
		public static const LARI_SIGN:String = 'lari-sign';
		public static const LASTFM:String = 'lastfm';
		public static const LASTFM_SQUARE:String = 'lastfm-square';
		public static const LAUGH:String = 'laugh';
		public static const LAUGH_BEAM:String = 'laugh-beam';
		public static const LAUGH_SQUINT:String = 'laugh-squint';
		public static const LAUGH_WINK:String = 'laugh-wink';
		public static const LAYER_GROUP:String = 'layer-group';
		public static const LEAF:String = 'leaf';
		public static const LEANPUB:String = 'leanpub';
		public static const LEFT_LONG:String = 'left-long';
		public static const LEFT_RIGHT:String = 'left-right';
		public static const LEGAL:String = 'legal';
		public static const LEMON:String = 'lemon';
		public static const LESS:String = 'less';
		public static const LESS_THAN:String = 'less-than';
		public static const LESS_THAN_EQUAL:String = 'less-than-equal';
		public static const LETTERBOXD:String = 'letterboxd';
		public static const LEVEL_DOWN:String = 'level-down';
		public static const LEVEL_DOWN_ALT:String = 'level-down-alt';
		public static const LEVEL_UP:String = 'level-up';
		public static const LEVEL_UP_ALT:String = 'level-up-alt';
		public static const LIFE_RING:String = 'life-ring';
		public static const LIGHTBULB:String = 'lightbulb';
		public static const LINE:String = 'line';
		public static const LINE_CHART:String = 'line-chart';
		public static const LINES_LEANING:String = 'lines-leaning';
		public static const LINK:String = 'link';
		public static const LINKEDIN:String = 'linkedin';
		public static const LINKEDIN_IN:String = 'linkedin-in';
		public static const LINK_SLASH:String = 'link-slash';
		public static const LINODE:String = 'linode';
		public static const LINUX:String = 'linux';
		public static const LIRA_SIGN:String = 'lira-sign';
		public static const LIST:String = 'list';
		public static const LIST_1_2:String = 'list-1-2';
		public static const LIST_ALT:String = 'list-alt';
		public static const LIST_CHECK:String = 'list-check';
		public static const LIST_DOTS:String = 'list-dots';
		public static const LIST_NUMERIC:String = 'list-numeric';
		public static const LIST_OL:String = 'list-ol';
		public static const LIST_SQUARES:String = 'list-squares';
		public static const LIST_UL:String = 'list-ul';
		public static const LITECOIN_SIGN:String = 'litecoin-sign';
		public static const LOCATION:String = 'location';
		public static const LOCATION_ARROW:String = 'location-arrow';
		public static const LOCATION_CROSSHAIRS:String = 'location-crosshairs';
		public static const LOCATION_DOT:String = 'location-dot';
		public static const LOCATION_PIN:String = 'location-pin';
		public static const LOCATION_PIN_LOCK:String = 'location-pin-lock';
		public static const LOCK:String = 'lock';
		public static const LOCK_OPEN:String = 'lock-open';
		public static const LOCUST:String = 'locust';
		public static const LONG_ARROW_ALT_DOWN:String = 'long-arrow-alt-down';
		public static const LONG_ARROW_ALT_LEFT:String = 'long-arrow-alt-left';
		public static const LONG_ARROW_ALT_RIGHT:String = 'long-arrow-alt-right';
		public static const LONG_ARROW_ALT_UP:String = 'long-arrow-alt-up';
		public static const LONG_ARROW_DOWN:String = 'long-arrow-down';
		public static const LONG_ARROW_LEFT:String = 'long-arrow-left';
		public static const LONG_ARROW_RIGHT:String = 'long-arrow-right';
		public static const LONG_ARROW_UP:String = 'long-arrow-up';
		public static const LOW_VISION:String = 'low-vision';
		public static const LUGGAGE_CART:String = 'luggage-cart';
		public static const LUNGS:String = 'lungs';
		public static const LUNGS_VIRUS:String = 'lungs-virus';
		public static const LYFT:String = 'lyft';
		public static const M:String = 'm';
		public static const MAGENTO:String = 'magento';
		public static const MAGIC:String = 'magic';
		public static const MAGIC_WAND_SPARKLES:String = 'magic-wand-sparkles';
		public static const MAGNET:String = 'magnet';
		public static const MAGNIFYING_GLASS:String = 'magnifying-glass';
		public static const MAGNIFYING_GLASS_ARROW_RIGHT:String = 'magnifying-glass-arrow-right';
		public static const MAGNIFYING_GLASS_CHART:String = 'magnifying-glass-chart';
		public static const MAGNIFYING_GLASS_DOLLAR:String = 'magnifying-glass-dollar';
		public static const MAGNIFYING_GLASS_LOCATION:String = 'magnifying-glass-location';
		public static const MAGNIFYING_GLASS_MINUS:String = 'magnifying-glass-minus';
		public static const MAGNIFYING_GLASS_PLUS:String = 'magnifying-glass-plus';
		public static const MAIL_BULK:String = 'mail-bulk';
		public static const MAILCHIMP:String = 'mailchimp';
		public static const MAIL_FORWARD:String = 'mail-forward';
		public static const MAIL_REPLY:String = 'mail-reply';
		public static const MAIL_REPLY_ALL:String = 'mail-reply-all';
		public static const MALE:String = 'male';
		public static const MANAT_SIGN:String = 'manat-sign';
		public static const MANDALORIAN:String = 'mandalorian';
		public static const MAP:String = 'map';
		public static const MAP_LOCATION:String = 'map-location';
		public static const MAP_LOCATION_DOT:String = 'map-location-dot';
		public static const MAP_MARKED:String = 'map-marked';
		public static const MAP_MARKED_ALT:String = 'map-marked-alt';
		public static const MAP_MARKER:String = 'map-marker';
		public static const MAP_MARKER_ALT:String = 'map-marker-alt';
		public static const MAP_PIN:String = 'map-pin';
		public static const MAP_SIGNS:String = 'map-signs';
		public static const MARKDOWN:String = 'markdown';
		public static const MARKER:String = 'marker';
		public static const MARS:String = 'mars';
		public static const MARS_AND_VENUS:String = 'mars-and-venus';
		public static const MARS_AND_VENUS_BURST:String = 'mars-and-venus-burst';
		public static const MARS_DOUBLE:String = 'mars-double';
		public static const MARS_STROKE:String = 'mars-stroke';
		public static const MARS_STROKE_H:String = 'mars-stroke-h';
		public static const MARS_STROKE_RIGHT:String = 'mars-stroke-right';
		public static const MARS_STROKE_UP:String = 'mars-stroke-up';
		public static const MARS_STROKE_V:String = 'mars-stroke-v';
		public static const MARTINI_GLASS:String = 'martini-glass';
		public static const MARTINI_GLASS_CITRUS:String = 'martini-glass-citrus';
		public static const MARTINI_GLASS_EMPTY:String = 'martini-glass-empty';
		public static const MASK:String = 'mask';
		public static const MASK_FACE:String = 'mask-face';
		public static const MASKS_THEATER:String = 'masks-theater';
		public static const MASK_VENTILATOR:String = 'mask-ventilator';
		public static const MASTODON:String = 'mastodon';
		public static const MATTRESS_PILLOW:String = 'mattress-pillow';
		public static const MAXCDN:String = 'maxcdn';
		public static const MAXIMIZE:String = 'maximize';
		public static const MDB:String = 'mdb';
		public static const MEDAL:String = 'medal';
		public static const MEDAPPS:String = 'medapps';
		public static const MEDIUM:String = 'medium';
		public static const MEDIUM_M:String = 'medium-m';
		public static const MEDKIT:String = 'medkit';
		public static const MEDRT:String = 'medrt';
		public static const MEETUP:String = 'meetup';
		public static const MEGAPORT:String = 'megaport';
		public static const MEH:String = 'meh';
		public static const MEH_BLANK:String = 'meh-blank';
		public static const MEH_ROLLING_EYES:String = 'meh-rolling-eyes';
		public static const MEMORY:String = 'memory';
		public static const MENDELEY:String = 'mendeley';
		public static const MENORAH:String = 'menorah';
		public static const MERCURY:String = 'mercury';
		public static const MESSAGE:String = 'message';
		public static const META:String = 'meta';
		public static const METEOR:String = 'meteor';
		public static const MICROBLOG:String = 'microblog';
		public static const MICROCHIP:String = 'microchip';
		public static const MICROPHONE:String = 'microphone';
		public static const MICROPHONE_ALT:String = 'microphone-alt';
		public static const MICROPHONE_ALT_SLASH:String = 'microphone-alt-slash';
		public static const MICROPHONE_LINES:String = 'microphone-lines';
		public static const MICROPHONE_LINES_SLASH:String = 'microphone-lines-slash';
		public static const MICROPHONE_SLASH:String = 'microphone-slash';
		public static const MICROSCOPE:String = 'microscope';
		public static const MICROSOFT:String = 'microsoft';
		public static const MILL_SIGN:String = 'mill-sign';
		public static const MINIMIZE:String = 'minimize';
		public static const MINTBIT:String = 'mintbit';
		public static const MINUS:String = 'minus';
		public static const MINUS_CIRCLE:String = 'minus-circle';
		public static const MINUS_SQUARE:String = 'minus-square';
		public static const MITTEN:String = 'mitten';
		public static const MIX:String = 'mix';
		public static const MIXCLOUD:String = 'mixcloud';
		public static const MIXER:String = 'mixer';
		public static const MIZUNI:String = 'mizuni';
		public static const MOBILE:String = 'mobile';
		public static const MOBILE_ALT:String = 'mobile-alt';
		public static const MOBILE_ANDROID:String = 'mobile-android';
		public static const MOBILE_ANDROID_ALT:String = 'mobile-android-alt';
		public static const MOBILE_BUTTON:String = 'mobile-button';
		public static const MOBILE_PHONE:String = 'mobile-phone';
		public static const MOBILE_RETRO:String = 'mobile-retro';
		public static const MOBILE_SCREEN:String = 'mobile-screen';
		public static const MOBILE_SCREEN_BUTTON:String = 'mobile-screen-button';
		public static const MODX:String = 'modx';
		public static const MONERO:String = 'monero';
		public static const MONEY_BILL:String = 'money-bill';
		public static const MONEY_BILL_1:String = 'money-bill-1';
		public static const MONEY_BILL_1_WAVE:String = 'money-bill-1-wave';
		public static const MONEY_BILL_ALT:String = 'money-bill-alt';
		public static const MONEY_BILLS:String = 'money-bills';
		public static const MONEY_BILL_TRANSFER:String = 'money-bill-transfer';
		public static const MONEY_BILL_TREND_UP:String = 'money-bill-trend-up';
		public static const MONEY_BILL_WAVE:String = 'money-bill-wave';
		public static const MONEY_BILL_WAVE_ALT:String = 'money-bill-wave-alt';
		public static const MONEY_BILL_WHEAT:String = 'money-bill-wheat';
		public static const MONEY_CHECK:String = 'money-check';
		public static const MONEY_CHECK_ALT:String = 'money-check-alt';
		public static const MONEY_CHECK_DOLLAR:String = 'money-check-dollar';
		public static const MONUMENT:String = 'monument';
		public static const MOON:String = 'moon';
		public static const MORTAR_BOARD:String = 'mortar-board';
		public static const MORTAR_PESTLE:String = 'mortar-pestle';
		public static const MOSQUE:String = 'mosque';
		public static const MOSQUITO:String = 'mosquito';
		public static const MOSQUITO_NET:String = 'mosquito-net';
		public static const MOTORCYCLE:String = 'motorcycle';
		public static const MOUND:String = 'mound';
		public static const MOUNTAIN:String = 'mountain';
		public static const MOUNTAIN_CITY:String = 'mountain-city';
		public static const MOUNTAIN_SUN:String = 'mountain-sun';
		public static const MOUSE:String = 'mouse';
		public static const MOUSE_POINTER:String = 'mouse-pointer';
		public static const MUG_HOT:String = 'mug-hot';
		public static const MUG_SAUCER:String = 'mug-saucer';
		public static const MULTIPLY:String = 'multiply';
		public static const MUSEUM:String = 'museum';
		public static const MUSIC:String = 'music';
		public static const N:String = 'n';
		public static const NAIRA_SIGN:String = 'naira-sign';
		public static const NAPSTER:String = 'napster';
		public static const NAVICON:String = 'navicon';
		public static const NEOS:String = 'neos';
		public static const NETWORK_WIRED:String = 'network-wired';
		public static const NEUTER:String = 'neuter';
		public static const NEWSPAPER:String = 'newspaper';
		public static const NFC_DIRECTIONAL:String = 'nfc-directional';
		public static const NFC_SYMBOL:String = 'nfc-symbol';
		public static const NIMBLR:String = 'nimblr';
		public static const NODE:String = 'node';
		public static const NODE_JS:String = 'node-js';
		public static const NOTDEF:String = 'notdef';
		public static const NOT_EQUAL:String = 'not-equal';
		public static const NOTES_MEDICAL:String = 'notes-medical';
		public static const NOTE_STICKY:String = 'note-sticky';
		public static const NPM:String = 'npm';
		public static const NS8:String = 'ns8';
		public static const NUTRITIONIX:String = 'nutritionix';
		public static const O:String = 'o';
		public static const OBJECT_GROUP:String = 'object-group';
		public static const OBJECT_UNGROUP:String = 'object-ungroup';
		public static const OCTOPUS_DEPLOY:String = 'octopus-deploy';
		public static const ODNOKLASSNIKI:String = 'odnoklassniki';
		public static const ODNOKLASSNIKI_SQUARE:String = 'odnoklassniki-square';
		public static const ODYSEE:String = 'odysee';
		public static const OIL_CAN:String = 'oil-can';
		public static const OIL_WELL:String = 'oil-well';
		public static const OLD_REPUBLIC:String = 'old-republic';
		public static const OM:String = 'om';
		public static const OPENCART:String = 'opencart';
		public static const OPENID:String = 'openid';
		public static const OPENSUSE:String = 'opensuse';
		public static const OPERA:String = 'opera';
		public static const OPTIN_MONSTER:String = 'optin-monster';
		public static const ORCID:String = 'orcid';
		public static const OSI:String = 'osi';
		public static const OTTER:String = 'otter';
		public static const OUTDENT:String = 'outdent';
		public static const P:String = 'p';
		public static const PADLET:String = 'padlet';
		public static const PAGE4:String = 'page4';
		public static const PAGELINES:String = 'pagelines';
		public static const PAGER:String = 'pager';
		public static const PAINTBRUSH:String = 'paintbrush';
		public static const PAINT_BRUSH:String = 'paint-brush';
		public static const PAINT_ROLLER:String = 'paint-roller';
		public static const PALETTE:String = 'palette';
		public static const PALFED:String = 'palfed';
		public static const PALLET:String = 'pallet';
		public static const PANORAMA:String = 'panorama';
		public static const PAPERCLIP:String = 'paperclip';
		public static const PAPER_PLANE:String = 'paper-plane';
		public static const PARACHUTE_BOX:String = 'parachute-box';
		public static const PARAGRAPH:String = 'paragraph';
		public static const PARKING:String = 'parking';
		public static const PASSPORT:String = 'passport';
		public static const PASTAFARIANISM:String = 'pastafarianism';
		public static const PASTE:String = 'paste';
		public static const PATREON:String = 'patreon';
		public static const PAUSE:String = 'pause';
		public static const PAUSE_CIRCLE:String = 'pause-circle';
		public static const PAW:String = 'paw';
		public static const PAYPAL:String = 'paypal';
		public static const PEACE:String = 'peace';
		public static const PEN:String = 'pen';
		public static const PEN_ALT:String = 'pen-alt';
		public static const PENCIL:String = 'pencil';
		public static const PENCIL_ALT:String = 'pencil-alt';
		public static const PENCIL_RULER:String = 'pencil-ruler';
		public static const PENCIL_SQUARE:String = 'pencil-square';
		public static const PEN_CLIP:String = 'pen-clip';
		public static const PEN_FANCY:String = 'pen-fancy';
		public static const PEN_NIB:String = 'pen-nib';
		public static const PEN_RULER:String = 'pen-ruler';
		public static const PEN_SQUARE:String = 'pen-square';
		public static const PEN_TO_SQUARE:String = 'pen-to-square';
		public static const PEOPLE_ARROWS:String = 'people-arrows';
		public static const PEOPLE_ARROWS_LEFT_RIGHT:String = 'people-arrows-left-right';
		public static const PEOPLE_CARRY:String = 'people-carry';
		public static const PEOPLE_CARRY_BOX:String = 'people-carry-box';
		public static const PEOPLE_GROUP:String = 'people-group';
		public static const PEOPLE_LINE:String = 'people-line';
		public static const PEOPLE_PULLING:String = 'people-pulling';
		public static const PEOPLE_ROBBERY:String = 'people-robbery';
		public static const PEOPLE_ROOF:String = 'people-roof';
		public static const PEPPER_HOT:String = 'pepper-hot';
		public static const PERBYTE:String = 'perbyte';
		public static const PERCENT:String = 'percent';
		public static const PERCENTAGE:String = 'percentage';
		public static const PERISCOPE:String = 'periscope';
		public static const PERSON:String = 'person';
		public static const PERSON_ARROW_DOWN_TO_LINE:String = 'person-arrow-down-to-line';
		public static const PERSON_ARROW_UP_FROM_LINE:String = 'person-arrow-up-from-line';
		public static const PERSON_BIKING:String = 'person-biking';
		public static const PERSON_BOOTH:String = 'person-booth';
		public static const PERSON_BREASTFEEDING:String = 'person-breastfeeding';
		public static const PERSON_BURST:String = 'person-burst';
		public static const PERSON_CANE:String = 'person-cane';
		public static const PERSON_CHALKBOARD:String = 'person-chalkboard';
		public static const PERSON_CIRCLE_CHECK:String = 'person-circle-check';
		public static const PERSON_CIRCLE_EXCLAMATION:String = 'person-circle-exclamation';
		public static const PERSON_CIRCLE_MINUS:String = 'person-circle-minus';
		public static const PERSON_CIRCLE_PLUS:String = 'person-circle-plus';
		public static const PERSON_CIRCLE_QUESTION:String = 'person-circle-question';
		public static const PERSON_CIRCLE_XMARK:String = 'person-circle-xmark';
		public static const PERSON_DIGGING:String = 'person-digging';
		public static const PERSON_DOTS_FROM_LINE:String = 'person-dots-from-line';
		public static const PERSON_DRESS:String = 'person-dress';
		public static const PERSON_DRESS_BURST:String = 'person-dress-burst';
		public static const PERSON_DROWNING:String = 'person-drowning';
		public static const PERSON_FALLING:String = 'person-falling';
		public static const PERSON_FALLING_BURST:String = 'person-falling-burst';
		public static const PERSON_HALF_DRESS:String = 'person-half-dress';
		public static const PERSON_HARASSING:String = 'person-harassing';
		public static const PERSON_HIKING:String = 'person-hiking';
		public static const PERSON_MILITARY_POINTING:String = 'person-military-pointing';
		public static const PERSON_MILITARY_RIFLE:String = 'person-military-rifle';
		public static const PERSON_MILITARY_TO_PERSON:String = 'person-military-to-person';
		public static const PERSON_PRAYING:String = 'person-praying';
		public static const PERSON_PREGNANT:String = 'person-pregnant';
		public static const PERSON_RAYS:String = 'person-rays';
		public static const PERSON_RIFLE:String = 'person-rifle';
		public static const PERSON_RUNNING:String = 'person-running';
		public static const PERSON_SHELTER:String = 'person-shelter';
		public static const PERSON_SKATING:String = 'person-skating';
		public static const PERSON_SKIING:String = 'person-skiing';
		public static const PERSON_SKIING_NORDIC:String = 'person-skiing-nordic';
		public static const PERSON_SNOWBOARDING:String = 'person-snowboarding';
		public static const PERSON_SWIMMING:String = 'person-swimming';
		public static const PERSON_THROUGH_WINDOW:String = 'person-through-window';
		public static const PERSON_WALKING:String = 'person-walking';
		public static const PERSON_WALKING_ARROW_LOOP_LEFT:String = 'person-walking-arrow-loop-left';
		public static const PERSON_WALKING_ARROW_RIGHT:String = 'person-walking-arrow-right';
		public static const PERSON_WALKING_DASHED_LINE_ARROW_RIGHT:String = 'person-walking-dashed-line-arrow-right';
		public static const PERSON_WALKING_LUGGAGE:String = 'person-walking-luggage';
		public static const PERSON_WALKING_WITH_CANE:String = 'person-walking-with-cane';
		public static const PESETA_SIGN:String = 'peseta-sign';
		public static const PESO_SIGN:String = 'peso-sign';
		public static const PHABRICATOR:String = 'phabricator';
		public static const PHOENIX_FRAMEWORK:String = 'phoenix-framework';
		public static const PHOENIX_SQUADRON:String = 'phoenix-squadron';
		public static const PHONE:String = 'phone';
		public static const PHONE_ALT:String = 'phone-alt';
		public static const PHONE_FLIP:String = 'phone-flip';
		public static const PHONE_SLASH:String = 'phone-slash';
		public static const PHONE_SQUARE:String = 'phone-square';
		public static const PHONE_SQUARE_ALT:String = 'phone-square-alt';
		public static const PHONE_VOLUME:String = 'phone-volume';
		public static const PHOTO_FILM:String = 'photo-film';
		public static const PHOTO_VIDEO:String = 'photo-video';
		public static const PHP:String = 'php';
		public static const PIE_CHART:String = 'pie-chart';
		public static const PIED_PIPER:String = 'pied-piper';
		public static const PIED_PIPER_ALT:String = 'pied-piper-alt';
		public static const PIED_PIPER_HAT:String = 'pied-piper-hat';
		public static const PIED_PIPER_PP:String = 'pied-piper-pp';
		public static const PIED_PIPER_SQUARE:String = 'pied-piper-square';
		public static const PIGGY_BANK:String = 'piggy-bank';
		public static const PILLS:String = 'pills';
		public static const PING_PONG_PADDLE_BALL:String = 'ping-pong-paddle-ball';
		public static const PINTEREST:String = 'pinterest';
		public static const PINTEREST_P:String = 'pinterest-p';
		public static const PINTEREST_SQUARE:String = 'pinterest-square';
		public static const PIX:String = 'pix';
		public static const PIXIV:String = 'pixiv';
		public static const PIZZA_SLICE:String = 'pizza-slice';
		public static const PLACE_OF_WORSHIP:String = 'place-of-worship';
		public static const PLANE:String = 'plane';
		public static const PLANE_ARRIVAL:String = 'plane-arrival';
		public static const PLANE_CIRCLE_CHECK:String = 'plane-circle-check';
		public static const PLANE_CIRCLE_EXCLAMATION:String = 'plane-circle-exclamation';
		public static const PLANE_CIRCLE_XMARK:String = 'plane-circle-xmark';
		public static const PLANE_DEPARTURE:String = 'plane-departure';
		public static const PLANE_LOCK:String = 'plane-lock';
		public static const PLANE_SLASH:String = 'plane-slash';
		public static const PLANE_UP:String = 'plane-up';
		public static const PLANT_WILT:String = 'plant-wilt';
		public static const PLATE_WHEAT:String = 'plate-wheat';
		public static const PLAY:String = 'play';
		public static const PLAY_CIRCLE:String = 'play-circle';
		public static const PLAYSTATION:String = 'playstation';
		public static const PLUG:String = 'plug';
		public static const PLUG_CIRCLE_BOLT:String = 'plug-circle-bolt';
		public static const PLUG_CIRCLE_CHECK:String = 'plug-circle-check';
		public static const PLUG_CIRCLE_EXCLAMATION:String = 'plug-circle-exclamation';
		public static const PLUG_CIRCLE_MINUS:String = 'plug-circle-minus';
		public static const PLUG_CIRCLE_PLUS:String = 'plug-circle-plus';
		public static const PLUG_CIRCLE_XMARK:String = 'plug-circle-xmark';
		public static const PLUS:String = 'plus';
		public static const PLUS_CIRCLE:String = 'plus-circle';
		public static const PLUS_MINUS:String = 'plus-minus';
		public static const PLUS_SQUARE:String = 'plus-square';
		public static const PODCAST:String = 'podcast';
		public static const POLL:String = 'poll';
		public static const POLL_H:String = 'poll-h';
		public static const POO:String = 'poo';
		public static const POO_BOLT:String = 'poo-bolt';
		public static const POOP:String = 'poop';
		public static const POO_STORM:String = 'poo-storm';
		public static const PORTRAIT:String = 'portrait';
		public static const POUND_SIGN:String = 'pound-sign';
		public static const POWER_OFF:String = 'power-off';
		public static const PRAY:String = 'pray';
		public static const PRAYING_HANDS:String = 'praying-hands';
		public static const PRESCRIPTION:String = 'prescription';
		public static const PRESCRIPTION_BOTTLE:String = 'prescription-bottle';
		public static const PRESCRIPTION_BOTTLE_ALT:String = 'prescription-bottle-alt';
		public static const PRESCRIPTION_BOTTLE_MEDICAL:String = 'prescription-bottle-medical';
		public static const PRINT:String = 'print';
		public static const PROCEDURES:String = 'procedures';
		public static const PRODUCT_HUNT:String = 'product-hunt';
		public static const PROJECT_DIAGRAM:String = 'project-diagram';
		public static const PUMP_MEDICAL:String = 'pump-medical';
		public static const PUMP_SOAP:String = 'pump-soap';
		public static const PUSHED:String = 'pushed';
		public static const PUZZLE_PIECE:String = 'puzzle-piece';
		public static const PYTHON:String = 'python';
		public static const Q:String = 'q';
		public static const QQ:String = 'qq';
		public static const QRCODE:String = 'qrcode';
		public static const QUESTION:String = 'question';
		public static const QUESTION_CIRCLE:String = 'question-circle';
		public static const QUIDDITCH:String = 'quidditch';
		public static const QUIDDITCH_BROOM_BALL:String = 'quidditch-broom-ball';
		public static const QUINSCAPE:String = 'quinscape';
		public static const QUORA:String = 'quora';
		public static const QUOTE_LEFT:String = 'quote-left';
		public static const QUOTE_LEFT_ALT:String = 'quote-left-alt';
		public static const QUOTE_RIGHT:String = 'quote-right';
		public static const QUOTE_RIGHT_ALT:String = 'quote-right-alt';
		public static const QURAN:String = 'quran';
		public static const R:String = 'r';
		public static const RADIATION:String = 'radiation';
		public static const RADIATION_ALT:String = 'radiation-alt';
		public static const RADIO:String = 'radio';
		public static const RAINBOW:String = 'rainbow';
		public static const RANDOM:String = 'random';
		public static const RANKING_STAR:String = 'ranking-star';
		public static const RASPBERRY_PI:String = 'raspberry-pi';
		public static const RAVELRY:String = 'ravelry';
		public static const REACT:String = 'react';
		public static const REACTEUROPE:String = 'reacteurope';
		public static const README:String = 'readme';
		public static const REBEL:String = 'rebel';
		public static const RECEIPT:String = 'receipt';
		public static const RECORD_VINYL:String = 'record-vinyl';
		public static const RECTANGLE_AD:String = 'rectangle-ad';
		public static const RECTANGLE_LIST:String = 'rectangle-list';
		public static const RECTANGLE_TIMES:String = 'rectangle-times';
		public static const RECTANGLE_XMARK:String = 'rectangle-xmark';
		public static const RECYCLE:String = 'recycle';
		public static const REDDIT:String = 'reddit';
		public static const REDDIT_ALIEN:String = 'reddit-alien';
		public static const REDDIT_SQUARE:String = 'reddit-square';
		public static const REDHAT:String = 'redhat';
		public static const REDO:String = 'redo';
		public static const REDO_ALT:String = 'redo-alt';
		public static const RED_RIVER:String = 'red-river';
		public static const REFRESH:String = 'refresh';
		public static const REGISTERED:String = 'registered';
		public static const REMOVE:String = 'remove';
		public static const REMOVE_FORMAT:String = 'remove-format';
		public static const RENDACT:String = 'rendact';
		public static const RENREN:String = 'renren';
		public static const REORDER:String = 'reorder';
		public static const REPEAT:String = 'repeat';
		public static const REPLY:String = 'reply';
		public static const REPLY_ALL:String = 'reply-all';
		public static const REPLYD:String = 'replyd';
		public static const REPUBLICAN:String = 'republican';
		public static const RESEARCHGATE:String = 'researchgate';
		public static const RESOLVING:String = 'resolving';
		public static const RESTROOM:String = 'restroom';
		public static const RETWEET:String = 'retweet';
		public static const REV:String = 'rev';
		public static const RIBBON:String = 'ribbon';
		public static const RIGHT_FROM_BRACKET:String = 'right-from-bracket';
		public static const RIGHT_LEFT:String = 'right-left';
		public static const RIGHT_LONG:String = 'right-long';
		public static const RIGHT_TO_BRACKET:String = 'right-to-bracket';
		public static const RING:String = 'ring';
		public static const RMB:String = 'rmb';
		public static const ROAD:String = 'road';
		public static const ROAD_BARRIER:String = 'road-barrier';
		public static const ROAD_BRIDGE:String = 'road-bridge';
		public static const ROAD_CIRCLE_CHECK:String = 'road-circle-check';
		public static const ROAD_CIRCLE_EXCLAMATION:String = 'road-circle-exclamation';
		public static const ROAD_CIRCLE_XMARK:String = 'road-circle-xmark';
		public static const ROAD_LOCK:String = 'road-lock';
		public static const ROAD_SPIKES:String = 'road-spikes';
		public static const ROBOT:String = 'robot';
		public static const ROCKET:String = 'rocket';
		public static const ROCKETCHAT:String = 'rocketchat';
		public static const ROCKRMS:String = 'rockrms';
		public static const ROD_ASCLEPIUS:String = 'rod-asclepius';
		public static const ROD_SNAKE:String = 'rod-snake';
		public static const ROTATE:String = 'rotate';
		public static const ROTATE_BACK:String = 'rotate-back';
		public static const ROTATE_BACKWARD:String = 'rotate-backward';
		public static const ROTATE_FORWARD:String = 'rotate-forward';
		public static const ROTATE_LEFT:String = 'rotate-left';
		public static const ROTATE_RIGHT:String = 'rotate-right';
		public static const ROUBLE:String = 'rouble';
		public static const ROUTE:String = 'route';
		public static const R_PROJECT:String = 'r-project';
		public static const RSS:String = 'rss';
		public static const RSS_SQUARE:String = 'rss-square';
		public static const RUB:String = 'rub';
		public static const RUBLE:String = 'ruble';
		public static const RUBLE_SIGN:String = 'ruble-sign';
		public static const RUG:String = 'rug';
		public static const RULER:String = 'ruler';
		public static const RULER_COMBINED:String = 'ruler-combined';
		public static const RULER_HORIZONTAL:String = 'ruler-horizontal';
		public static const RULER_VERTICAL:String = 'ruler-vertical';
		public static const RUNNING:String = 'running';
		public static const RUPEE:String = 'rupee';
		public static const RUPEE_SIGN:String = 'rupee-sign';
		public static const RUPIAH_SIGN:String = 'rupiah-sign';
		public static const RUST:String = 'rust';
		public static const S:String = 's';
		public static const SACK_DOLLAR:String = 'sack-dollar';
		public static const SACK_XMARK:String = 'sack-xmark';
		public static const SAD_CRY:String = 'sad-cry';
		public static const SAD_TEAR:String = 'sad-tear';
		public static const SAFARI:String = 'safari';
		public static const SAILBOAT:String = 'sailboat';
		public static const SALESFORCE:String = 'salesforce';
		public static const SASS:String = 'sass';
		public static const SATELLITE:String = 'satellite';
		public static const SATELLITE_DISH:String = 'satellite-dish';
		public static const SAVE:String = 'save';
		public static const SCALE_BALANCED:String = 'scale-balanced';
		public static const SCALE_UNBALANCED:String = 'scale-unbalanced';
		public static const SCALE_UNBALANCED_FLIP:String = 'scale-unbalanced-flip';
		public static const SCHLIX:String = 'schlix';
		public static const SCHOOL:String = 'school';
		public static const SCHOOL_CIRCLE_CHECK:String = 'school-circle-check';
		public static const SCHOOL_CIRCLE_EXCLAMATION:String = 'school-circle-exclamation';
		public static const SCHOOL_CIRCLE_XMARK:String = 'school-circle-xmark';
		public static const SCHOOL_FLAG:String = 'school-flag';
		public static const SCHOOL_LOCK:String = 'school-lock';
		public static const SCISSORS:String = 'scissors';
		public static const SCREENPAL:String = 'screenpal';
		public static const SCREWDRIVER:String = 'screwdriver';
		public static const SCREWDRIVER_WRENCH:String = 'screwdriver-wrench';
		public static const SCRIBD:String = 'scribd';
		public static const SCROLL:String = 'scroll';
		public static const SCROLL_TORAH:String = 'scroll-torah';
		public static const SD_CARD:String = 'sd-card';
		public static const SEARCH:String = 'search';
		public static const SEARCH_DOLLAR:String = 'search-dollar';
		public static const SEARCHENGIN:String = 'searchengin';
		public static const SEARCH_LOCATION:String = 'search-location';
		public static const SEARCH_MINUS:String = 'search-minus';
		public static const SEARCH_PLUS:String = 'search-plus';
		public static const SECTION:String = 'section';
		public static const SEEDLING:String = 'seedling';
		public static const SELLCAST:String = 'sellcast';
		public static const SELLSY:String = 'sellsy';
		public static const SERVER:String = 'server';
		public static const SERVICESTACK:String = 'servicestack';
		public static const SHAPES:String = 'shapes';
		public static const SHARE:String = 'share';
		public static const SHARE_ALT:String = 'share-alt';
		public static const SHARE_ALT_SQUARE:String = 'share-alt-square';
		public static const SHARE_FROM_SQUARE:String = 'share-from-square';
		public static const SHARE_NODES:String = 'share-nodes';
		public static const SHARE_SQUARE:String = 'share-square';
		public static const SHEET_PLASTIC:String = 'sheet-plastic';
		public static const SHEKEL:String = 'shekel';
		public static const SHEKEL_SIGN:String = 'shekel-sign';
		public static const SHEQEL:String = 'sheqel';
		public static const SHEQEL_SIGN:String = 'sheqel-sign';
		public static const SHIELD:String = 'shield';
		public static const SHIELD_ALT:String = 'shield-alt';
		public static const SHIELD_BLANK:String = 'shield-blank';
		public static const SHIELD_CAT:String = 'shield-cat';
		public static const SHIELD_DOG:String = 'shield-dog';
		public static const SHIELD_HALVED:String = 'shield-halved';
		public static const SHIELD_HEART:String = 'shield-heart';
		public static const SHIELD_VIRUS:String = 'shield-virus';
		public static const SHIP:String = 'ship';
		public static const SHIPPING_FAST:String = 'shipping-fast';
		public static const SHIRT:String = 'shirt';
		public static const SHIRTSINBULK:String = 'shirtsinbulk';
		public static const SHOELACE:String = 'shoelace';
		public static const SHOE_PRINTS:String = 'shoe-prints';
		public static const SHOP:String = 'shop';
		public static const SHOPIFY:String = 'shopify';
		public static const SHOP_LOCK:String = 'shop-lock';
		public static const SHOPPING_BAG:String = 'shopping-bag';
		public static const SHOPPING_BASKET:String = 'shopping-basket';
		public static const SHOPPING_CART:String = 'shopping-cart';
		public static const SHOP_SLASH:String = 'shop-slash';
		public static const SHOPWARE:String = 'shopware';
		public static const SHOWER:String = 'shower';
		public static const SHRIMP:String = 'shrimp';
		public static const SHUFFLE:String = 'shuffle';
		public static const SHUTTLE_SPACE:String = 'shuttle-space';
		public static const SHUTTLE_VAN:String = 'shuttle-van';
		public static const SIGN:String = 'sign';
		public static const SIGNAL:String = 'signal';
		public static const SIGNAL_5:String = 'signal-5';
		public static const SIGNAL_MESSENGER:String = 'signal-messenger';
		public static const SIGNAL_PERFECT:String = 'signal-perfect';
		public static const SIGNATURE:String = 'signature';
		public static const SIGN_HANGING:String = 'sign-hanging';
		public static const SIGN_IN:String = 'sign-in';
		public static const SIGN_IN_ALT:String = 'sign-in-alt';
		public static const SIGNING:String = 'signing';
		public static const SIGN_LANGUAGE:String = 'sign-language';
		public static const SIGN_OUT:String = 'sign-out';
		public static const SIGN_OUT_ALT:String = 'sign-out-alt';
		public static const SIGNS_POST:String = 'signs-post';
		public static const SIM_CARD:String = 'sim-card';
		public static const SIMPLYBUILT:String = 'simplybuilt';
		public static const SINK:String = 'sink';
		public static const SISTRIX:String = 'sistrix';
		public static const SITEMAP:String = 'sitemap';
		public static const SITH:String = 'sith';
		public static const SITROX:String = 'sitrox';
		public static const SKATING:String = 'skating';
		public static const SKETCH:String = 'sketch';
		public static const SKIING:String = 'skiing';
		public static const SKIING_NORDIC:String = 'skiing-nordic';
		public static const SKULL:String = 'skull';
		public static const SKULL_CROSSBONES:String = 'skull-crossbones';
		public static const SKYATLAS:String = 'skyatlas';
		public static const SKYPE:String = 'skype';
		public static const SLACK:String = 'slack';
		public static const SLACK_HASH:String = 'slack-hash';
		public static const SLASH:String = 'slash';
		public static const SLEIGH:String = 'sleigh';
		public static const SLIDERS:String = 'sliders';
		public static const SLIDERS_H:String = 'sliders-h';
		public static const SLIDESHARE:String = 'slideshare';
		public static const SMILE:String = 'smile';
		public static const SMILE_BEAM:String = 'smile-beam';
		public static const SMILE_WINK:String = 'smile-wink';
		public static const SMOG:String = 'smog';
		public static const SMOKING:String = 'smoking';
		public static const SMOKING_BAN:String = 'smoking-ban';
		public static const SMS:String = 'sms';
		public static const SNAPCHAT:String = 'snapchat';
		public static const SNAPCHAT_GHOST:String = 'snapchat-ghost';
		public static const SNAPCHAT_SQUARE:String = 'snapchat-square';
		public static const SNOWBOARDING:String = 'snowboarding';
		public static const SNOWFLAKE:String = 'snowflake';
		public static const SNOWMAN:String = 'snowman';
		public static const SNOWPLOW:String = 'snowplow';
		public static const SOAP:String = 'soap';
		public static const SOCCER_BALL:String = 'soccer-ball';
		public static const SOCKS:String = 'socks';
		public static const SOLAR_PANEL:String = 'solar-panel';
		public static const SORT:String = 'sort';
		public static const SORT_ALPHA_ASC:String = 'sort-alpha-asc';
		public static const SORT_ALPHA_DESC:String = 'sort-alpha-desc';
		public static const SORT_ALPHA_DOWN:String = 'sort-alpha-down';
		public static const SORT_ALPHA_DOWN_ALT:String = 'sort-alpha-down-alt';
		public static const SORT_ALPHA_UP:String = 'sort-alpha-up';
		public static const SORT_ALPHA_UP_ALT:String = 'sort-alpha-up-alt';
		public static const SORT_AMOUNT_ASC:String = 'sort-amount-asc';
		public static const SORT_AMOUNT_DESC:String = 'sort-amount-desc';
		public static const SORT_AMOUNT_DOWN:String = 'sort-amount-down';
		public static const SORT_AMOUNT_DOWN_ALT:String = 'sort-amount-down-alt';
		public static const SORT_AMOUNT_UP:String = 'sort-amount-up';
		public static const SORT_AMOUNT_UP_ALT:String = 'sort-amount-up-alt';
		public static const SORT_ASC:String = 'sort-asc';
		public static const SORT_DESC:String = 'sort-desc';
		public static const SORT_DOWN:String = 'sort-down';
		public static const SORT_NUMERIC_ASC:String = 'sort-numeric-asc';
		public static const SORT_NUMERIC_DESC:String = 'sort-numeric-desc';
		public static const SORT_NUMERIC_DOWN:String = 'sort-numeric-down';
		public static const SORT_NUMERIC_DOWN_ALT:String = 'sort-numeric-down-alt';
		public static const SORT_NUMERIC_UP:String = 'sort-numeric-up';
		public static const SORT_NUMERIC_UP_ALT:String = 'sort-numeric-up-alt';
		public static const SORT_UP:String = 'sort-up';
		public static const SOUNDCLOUD:String = 'soundcloud';
		public static const SOURCETREE:String = 'sourcetree';
		public static const SPA:String = 'spa';
		public static const SPACE_AWESOME:String = 'space-awesome';
		public static const SPACE_SHUTTLE:String = 'space-shuttle';
		public static const SPAGHETTI_MONSTER_FLYING:String = 'spaghetti-monster-flying';
		public static const SPEAKAP:String = 'speakap';
		public static const SPEAKER_DECK:String = 'speaker-deck';
		public static const SPELL_CHECK:String = 'spell-check';
		public static const SPIDER:String = 'spider';
		public static const SPINNER:String = 'spinner';
		public static const SPLOTCH:String = 'splotch';
		public static const SPOON:String = 'spoon';
		public static const SPOTIFY:String = 'spotify';
		public static const SPRAY_CAN:String = 'spray-can';
		public static const SPRAY_CAN_SPARKLES:String = 'spray-can-sparkles';
		public static const SPROUT:String = 'sprout';
		public static const SQUARE:String = 'square';
		public static const SQUARE_ARROW_UP_RIGHT:String = 'square-arrow-up-right';
		public static const SQUARE_BEHANCE:String = 'square-behance';
		public static const SQUARE_CARET_DOWN:String = 'square-caret-down';
		public static const SQUARE_CARET_LEFT:String = 'square-caret-left';
		public static const SQUARE_CARET_RIGHT:String = 'square-caret-right';
		public static const SQUARE_CARET_UP:String = 'square-caret-up';
		public static const SQUARE_CHECK:String = 'square-check';
		public static const SQUARE_DRIBBBLE:String = 'square-dribbble';
		public static const SQUARE_ENVELOPE:String = 'square-envelope';
		public static const SQUARE_FACEBOOK:String = 'square-facebook';
		public static const SQUARE_FONT_AWESOME:String = 'square-font-awesome';
		public static const SQUARE_FONT_AWESOME_STROKE:String = 'square-font-awesome-stroke';
		public static const SQUARE_FULL:String = 'square-full';
		public static const SQUARE_GIT:String = 'square-git';
		public static const SQUARE_GITHUB:String = 'square-github';
		public static const SQUARE_GITLAB:String = 'square-gitlab';
		public static const SQUARE_GOOGLE_PLUS:String = 'square-google-plus';
		public static const SQUARE_H:String = 'square-h';
		public static const SQUARE_HACKER_NEWS:String = 'square-hacker-news';
		public static const SQUARE_INSTAGRAM:String = 'square-instagram';
		public static const SQUARE_JS:String = 'square-js';
		public static const SQUARE_KICKSTARTER:String = 'square-kickstarter';
		public static const SQUARE_LASTFM:String = 'square-lastfm';
		public static const SQUARE_LETTERBOXD:String = 'square-letterboxd';
		public static const SQUARE_MINUS:String = 'square-minus';
		public static const SQUARE_NFI:String = 'square-nfi';
		public static const SQUARE_ODNOKLASSNIKI:String = 'square-odnoklassniki';
		public static const SQUARE_PARKING:String = 'square-parking';
		public static const SQUARE_PEN:String = 'square-pen';
		public static const SQUARE_PERSON_CONFINED:String = 'square-person-confined';
		public static const SQUARE_PHONE:String = 'square-phone';
		public static const SQUARE_PHONE_FLIP:String = 'square-phone-flip';
		public static const SQUARE_PIED_PIPER:String = 'square-pied-piper';
		public static const SQUARE_PINTEREST:String = 'square-pinterest';
		public static const SQUARE_PLUS:String = 'square-plus';
		public static const SQUARE_POLL_HORIZONTAL:String = 'square-poll-horizontal';
		public static const SQUARE_POLL_VERTICAL:String = 'square-poll-vertical';
		public static const SQUARE_REDDIT:String = 'square-reddit';
		public static const SQUARE_ROOT_ALT:String = 'square-root-alt';
		public static const SQUARE_ROOT_VARIABLE:String = 'square-root-variable';
		public static const SQUARE_RSS:String = 'square-rss';
		public static const SQUARE_SHARE_NODES:String = 'square-share-nodes';
		public static const SQUARE_SNAPCHAT:String = 'square-snapchat';
		public static const SQUARESPACE:String = 'squarespace';
		public static const SQUARE_STEAM:String = 'square-steam';
		public static const SQUARE_THREADS:String = 'square-threads';
		public static const SQUARE_TUMBLR:String = 'square-tumblr';
		public static const SQUARE_TWITTER:String = 'square-twitter';
		public static const SQUARE_UP_RIGHT:String = 'square-up-right';
		public static const SQUARE_UPWORK:String = 'square-upwork';
		public static const SQUARE_VIADEO:String = 'square-viadeo';
		public static const SQUARE_VIMEO:String = 'square-vimeo';
		public static const SQUARE_VIRUS:String = 'square-virus';
		public static const SQUARE_WEB_AWESOME:String = 'square-web-awesome';
		public static const SQUARE_WEB_AWESOME_STROKE:String = 'square-web-awesome-stroke';
		public static const SQUARE_WHATSAPP:String = 'square-whatsapp';
		public static const SQUARE_XING:String = 'square-xing';
		public static const SQUARE_XMARK:String = 'square-xmark';
		public static const SQUARE_X_TWITTER:String = 'square-x-twitter';
		public static const SQUARE_YOUTUBE:String = 'square-youtube';
		public static const STACK_EXCHANGE:String = 'stack-exchange';
		public static const STACK_OVERFLOW:String = 'stack-overflow';
		public static const STACKPATH:String = 'stackpath';
		public static const STAFF_AESCULAPIUS:String = 'staff-aesculapius';
		public static const STAFF_SNAKE:String = 'staff-snake';
		public static const STAIRS:String = 'stairs';
		public static const STAMP:String = 'stamp';
		public static const STAPLER:String = 'stapler';
		public static const STAR:String = 'star';
		public static const STAR_AND_CRESCENT:String = 'star-and-crescent';
		public static const STAR_HALF:String = 'star-half';
		public static const STAR_HALF_ALT:String = 'star-half-alt';
		public static const STAR_HALF_STROKE:String = 'star-half-stroke';
		public static const STAR_OF_DAVID:String = 'star-of-david';
		public static const STAR_OF_LIFE:String = 'star-of-life';
		public static const STAYLINKED:String = 'staylinked';
		public static const STEAM:String = 'steam';
		public static const STEAM_SQUARE:String = 'steam-square';
		public static const STEAM_SYMBOL:String = 'steam-symbol';
		public static const STEP_BACKWARD:String = 'step-backward';
		public static const STEP_FORWARD:String = 'step-forward';
		public static const STERLING_SIGN:String = 'sterling-sign';
		public static const STETHOSCOPE:String = 'stethoscope';
		public static const STICKER_MULE:String = 'sticker-mule';
		public static const STICKY_NOTE:String = 'sticky-note';
		public static const STOP:String = 'stop';
		public static const STOP_CIRCLE:String = 'stop-circle';
		public static const STOPWATCH:String = 'stopwatch';
		public static const STOPWATCH_20:String = 'stopwatch-20';
		public static const STORE:String = 'store';
		public static const STORE_ALT:String = 'store-alt';
		public static const STORE_ALT_SLASH:String = 'store-alt-slash';
		public static const STORE_SLASH:String = 'store-slash';
		public static const STRAVA:String = 'strava';
		public static const STREAM:String = 'stream';
		public static const STREET_VIEW:String = 'street-view';
		public static const STRIKETHROUGH:String = 'strikethrough';
		public static const STRIPE:String = 'stripe';
		public static const STRIPE_S:String = 'stripe-s';
		public static const STROOPWAFEL:String = 'stroopwafel';
		public static const STUBBER:String = 'stubber';
		public static const STUDIOVINARI:String = 'studiovinari';
		public static const STUMBLEUPON:String = 'stumbleupon';
		public static const STUMBLEUPON_CIRCLE:String = 'stumbleupon-circle';
		public static const SUBSCRIPT:String = 'subscript';
		public static const SUBTRACT:String = 'subtract';
		public static const SUBWAY:String = 'subway';
		public static const SUITCASE:String = 'suitcase';
		public static const SUITCASE_MEDICAL:String = 'suitcase-medical';
		public static const SUITCASE_ROLLING:String = 'suitcase-rolling';
		public static const SUN:String = 'sun';
		public static const SUN_PLANT_WILT:String = 'sun-plant-wilt';
		public static const SUPERPOWERS:String = 'superpowers';
		public static const SUPERSCRIPT:String = 'superscript';
		public static const SUPPLE:String = 'supple';
		public static const SURPRISE:String = 'surprise';
		public static const SUSE:String = 'suse';
		public static const SWATCHBOOK:String = 'swatchbook';
		public static const SWIFT:String = 'swift';
		public static const SWIMMER:String = 'swimmer';
		public static const SWIMMING_POOL:String = 'swimming-pool';
		public static const SYMFONY:String = 'symfony';
		public static const SYNAGOGUE:String = 'synagogue';
		public static const SYNC:String = 'sync';
		public static const SYNC_ALT:String = 'sync-alt';
		public static const SYRINGE:String = 'syringe';
		public static const T:String = 't';
		public static const TABLE:String = 'table';
		public static const TABLE_CELLS:String = 'table-cells';
		public static const TABLE_CELLS_COLUMN_LOCK:String = 'table-cells-column-lock';
		public static const TABLE_CELLS_LARGE:String = 'table-cells-large';
		public static const TABLE_CELLS_ROW_LOCK:String = 'table-cells-row-lock';
		public static const TABLE_COLUMNS:String = 'table-columns';
		public static const TABLE_LIST:String = 'table-list';
		public static const TABLET:String = 'tablet';
		public static const TABLET_ALT:String = 'tablet-alt';
		public static const TABLET_ANDROID:String = 'tablet-android';
		public static const TABLET_BUTTON:String = 'tablet-button';
		public static const TABLE_TENNIS:String = 'table-tennis';
		public static const TABLE_TENNIS_PADDLE_BALL:String = 'table-tennis-paddle-ball';
		public static const TABLETS:String = 'tablets';
		public static const TABLET_SCREEN_BUTTON:String = 'tablet-screen-button';
		public static const TACHOGRAPH_DIGITAL:String = 'tachograph-digital';
		public static const TACHOMETER:String = 'tachometer';
		public static const TACHOMETER_ALT:String = 'tachometer-alt';
		public static const TACHOMETER_ALT_AVERAGE:String = 'tachometer-alt-average';
		public static const TACHOMETER_ALT_FAST:String = 'tachometer-alt-fast';
		public static const TACHOMETER_AVERAGE:String = 'tachometer-average';
		public static const TACHOMETER_FAST:String = 'tachometer-fast';
		public static const TAG:String = 'tag';
		public static const TAGS:String = 'tags';
		public static const TANAKH:String = 'tanakh';
		public static const TAPE:String = 'tape';
		public static const TARP:String = 'tarp';
		public static const TARP_DROPLET:String = 'tarp-droplet';
		public static const TASKS:String = 'tasks';
		public static const TASKS_ALT:String = 'tasks-alt';
		public static const TAXI:String = 'taxi';
		public static const TEAMSPEAK:String = 'teamspeak';
		public static const TEETH:String = 'teeth';
		public static const TEETH_OPEN:String = 'teeth-open';
		public static const TELEGRAM:String = 'telegram';
		public static const TELEGRAM_PLANE:String = 'telegram-plane';
		public static const TELETYPE:String = 'teletype';
		public static const TELEVISION:String = 'television';
		public static const TEMPERATURE_0:String = 'temperature-0';
		public static const TEMPERATURE_1:String = 'temperature-1';
		public static const TEMPERATURE_2:String = 'temperature-2';
		public static const TEMPERATURE_3:String = 'temperature-3';
		public static const TEMPERATURE_4:String = 'temperature-4';
		public static const TEMPERATURE_ARROW_DOWN:String = 'temperature-arrow-down';
		public static const TEMPERATURE_ARROW_UP:String = 'temperature-arrow-up';
		public static const TEMPERATURE_DOWN:String = 'temperature-down';
		public static const TEMPERATURE_EMPTY:String = 'temperature-empty';
		public static const TEMPERATURE_FULL:String = 'temperature-full';
		public static const TEMPERATURE_HALF:String = 'temperature-half';
		public static const TEMPERATURE_HIGH:String = 'temperature-high';
		public static const TEMPERATURE_LOW:String = 'temperature-low';
		public static const TEMPERATURE_QUARTER:String = 'temperature-quarter';
		public static const TEMPERATURE_THREE_QUARTERS:String = 'temperature-three-quarters';
		public static const TEMPERATURE_UP:String = 'temperature-up';
		public static const TENCENT_WEIBO:String = 'tencent-weibo';
		public static const TENGE:String = 'tenge';
		public static const TENGE_SIGN:String = 'tenge-sign';
		public static const TENT:String = 'tent';
		public static const TENT_ARROW_DOWN_TO_LINE:String = 'tent-arrow-down-to-line';
		public static const TENT_ARROW_LEFT_RIGHT:String = 'tent-arrow-left-right';
		public static const TENT_ARROWS_DOWN:String = 'tent-arrows-down';
		public static const TENT_ARROW_TURN_LEFT:String = 'tent-arrow-turn-left';
		public static const TENTS:String = 'tents';
		public static const TERMINAL:String = 'terminal';
		public static const TEXT_HEIGHT:String = 'text-height';
		public static const TEXT_SLASH:String = 'text-slash';
		public static const TEXT_WIDTH:String = 'text-width';
		public static const TH:String = 'th';
		public static const THEATER_MASKS:String = 'theater-masks';
		public static const THEMECO:String = 'themeco';
		public static const THEMEISLE:String = 'themeisle';
		public static const THE_RED_YETI:String = 'the-red-yeti';
		public static const THERMOMETER:String = 'thermometer';
		public static const THERMOMETER_0:String = 'thermometer-0';
		public static const THERMOMETER_1:String = 'thermometer-1';
		public static const THERMOMETER_2:String = 'thermometer-2';
		public static const THERMOMETER_3:String = 'thermometer-3';
		public static const THERMOMETER_4:String = 'thermometer-4';
		public static const THERMOMETER_EMPTY:String = 'thermometer-empty';
		public static const THERMOMETER_FULL:String = 'thermometer-full';
		public static const THERMOMETER_HALF:String = 'thermometer-half';
		public static const THERMOMETER_QUARTER:String = 'thermometer-quarter';
		public static const THERMOMETER_THREE_QUARTERS:String = 'thermometer-three-quarters';
		public static const THINK_PEAKS:String = 'think-peaks';
		public static const TH_LARGE:String = 'th-large';
		public static const TH_LIST:String = 'th-list';
		public static const THREADS:String = 'threads';
		public static const THUMBS_DOWN:String = 'thumbs-down';
		public static const THUMBS_UP:String = 'thumbs-up';
		public static const THUMBTACK:String = 'thumbtack';
		public static const THUMB_TACK:String = 'thumb-tack';
		public static const THUNDERSTORM:String = 'thunderstorm';
		public static const TICKET:String = 'ticket';
		public static const TICKET_ALT:String = 'ticket-alt';
		public static const TICKET_SIMPLE:String = 'ticket-simple';
		public static const TIKTOK:String = 'tiktok';
		public static const TIMELINE:String = 'timeline';
		public static const TIMES:String = 'times';
		public static const TIMES_CIRCLE:String = 'times-circle';
		public static const TIMES_RECTANGLE:String = 'times-rectangle';
		public static const TIMES_SQUARE:String = 'times-square';
		public static const TINT:String = 'tint';
		public static const TINT_SLASH:String = 'tint-slash';
		public static const TIRED:String = 'tired';
		public static const TOGGLE_OFF:String = 'toggle-off';
		public static const TOGGLE_ON:String = 'toggle-on';
		public static const TOILET:String = 'toilet';
		public static const TOILET_PAPER:String = 'toilet-paper';
		public static const TOILET_PAPER_SLASH:String = 'toilet-paper-slash';
		public static const TOILET_PORTABLE:String = 'toilet-portable';
		public static const TOILETS_PORTABLE:String = 'toilets-portable';
		public static const TOOLBOX:String = 'toolbox';
		public static const TOOLS:String = 'tools';
		public static const TOOTH:String = 'tooth';
		public static const TORAH:String = 'torah';
		public static const TORII_GATE:String = 'torii-gate';
		public static const TORNADO:String = 'tornado';
		public static const TOWER_BROADCAST:String = 'tower-broadcast';
		public static const TOWER_CELL:String = 'tower-cell';
		public static const TOWER_OBSERVATION:String = 'tower-observation';
		public static const TRACTOR:String = 'tractor';
		public static const TRADE_FEDERATION:String = 'trade-federation';
		public static const TRADEMARK:String = 'trademark';
		public static const TRAFFIC_LIGHT:String = 'traffic-light';
		public static const TRAILER:String = 'trailer';
		public static const TRAIN:String = 'train';
		public static const TRAIN_SUBWAY:String = 'train-subway';
		public static const TRAIN_TRAM:String = 'train-tram';
		public static const TRAM:String = 'tram';
		public static const TRANSGENDER:String = 'transgender';
		public static const TRANSGENDER_ALT:String = 'transgender-alt';
		public static const TRASH:String = 'trash';
		public static const TRASH_ALT:String = 'trash-alt';
		public static const TRASH_ARROW_UP:String = 'trash-arrow-up';
		public static const TRASH_CAN:String = 'trash-can';
		public static const TRASH_CAN_ARROW_UP:String = 'trash-can-arrow-up';
		public static const TRASH_RESTORE:String = 'trash-restore';
		public static const TRASH_RESTORE_ALT:String = 'trash-restore-alt';
		public static const TREE:String = 'tree';
		public static const TREE_CITY:String = 'tree-city';
		public static const TRELLO:String = 'trello';
		public static const TRIANGLE_CIRCLE_SQUARE:String = 'triangle-circle-square';
		public static const TRIANGLE_EXCLAMATION:String = 'triangle-exclamation';
		public static const TROPHY:String = 'trophy';
		public static const TROWEL:String = 'trowel';
		public static const TROWEL_BRICKS:String = 'trowel-bricks';
		public static const TRUCK:String = 'truck';
		public static const TRUCK_ARROW_RIGHT:String = 'truck-arrow-right';
		public static const TRUCK_DROPLET:String = 'truck-droplet';
		public static const TRUCK_FAST:String = 'truck-fast';
		public static const TRUCK_FIELD:String = 'truck-field';
		public static const TRUCK_FIELD_UN:String = 'truck-field-un';
		public static const TRUCK_FRONT:String = 'truck-front';
		public static const TRUCK_LOADING:String = 'truck-loading';
		public static const TRUCK_MEDICAL:String = 'truck-medical';
		public static const TRUCK_MONSTER:String = 'truck-monster';
		public static const TRUCK_MOVING:String = 'truck-moving';
		public static const TRUCK_PICKUP:String = 'truck-pickup';
		public static const TRUCK_PLANE:String = 'truck-plane';
		public static const TRUCK_RAMP_BOX:String = 'truck-ramp-box';
		public static const TRY:String = 'try';
		public static const TSHIRT:String = 'tshirt';
		public static const T_SHIRT:String = 't-shirt';
		public static const TTY:String = 'tty';
		public static const TUMBLR:String = 'tumblr';
		public static const TUMBLR_SQUARE:String = 'tumblr-square';
		public static const TURKISH_LIRA:String = 'turkish-lira';
		public static const TURKISH_LIRA_SIGN:String = 'turkish-lira-sign';
		public static const TURN_DOWN:String = 'turn-down';
		public static const TURN_UP:String = 'turn-up';
		public static const TV:String = 'tv';
		public static const TV_ALT:String = 'tv-alt';
		public static const TWITCH:String = 'twitch';
		public static const TWITTER:String = 'twitter';
		public static const TWITTER_SQUARE:String = 'twitter-square';
		public static const TYPO3:String = 'typo3';
		public static const U:String = 'u';
		public static const UBER:String = 'uber';
		public static const UBUNTU:String = 'ubuntu';
		public static const UIKIT:String = 'uikit';
		public static const UMBRACO:String = 'umbraco';
		public static const UMBRELLA:String = 'umbrella';
		public static const UMBRELLA_BEACH:String = 'umbrella-beach';
		public static const UNCHARTED:String = 'uncharted';
		public static const UNDERLINE:String = 'underline';
		public static const UNDO:String = 'undo';
		public static const UNDO_ALT:String = 'undo-alt';
		public static const UNIREGISTRY:String = 'uniregistry';
		public static const UNITY:String = 'unity';
		public static const UNIVERSAL_ACCESS:String = 'universal-access';
		public static const UNIVERSITY:String = 'university';
		public static const UNLINK:String = 'unlink';
		public static const UNLOCK:String = 'unlock';
		public static const UNLOCK_ALT:String = 'unlock-alt';
		public static const UNLOCK_KEYHOLE:String = 'unlock-keyhole';
		public static const UNSORTED:String = 'unsorted';
		public static const UNSPLASH:String = 'unsplash';
		public static const UNTAPPD:String = 'untappd';
		public static const UP_DOWN:String = 'up-down';
		public static const UP_DOWN_LEFT_RIGHT:String = 'up-down-left-right';
		public static const UPLOAD:String = 'upload';
		public static const UP_LONG:String = 'up-long';
		public static const UP_RIGHT_AND_DOWN_LEFT_FROM_CENTER:String = 'up-right-and-down-left-from-center';
		public static const UP_RIGHT_FROM_SQUARE:String = 'up-right-from-square';
		public static const UPS:String = 'ups';
		public static const UPWORK:String = 'upwork';
		public static const USB:String = 'usb';
		public static const USD:String = 'usd';
		public static const USER:String = 'user';
		public static const USER_ALT:String = 'user-alt';
		public static const USER_ALT_SLASH:String = 'user-alt-slash';
		public static const USER_ASTRONAUT:String = 'user-astronaut';
		public static const USER_CHECK:String = 'user-check';
		public static const USER_CIRCLE:String = 'user-circle';
		public static const USER_CLOCK:String = 'user-clock';
		public static const USER_COG:String = 'user-cog';
		public static const USER_DOCTOR:String = 'user-doctor';
		public static const USER_EDIT:String = 'user-edit';
		public static const USER_FRIENDS:String = 'user-friends';
		public static const USER_GEAR:String = 'user-gear';
		public static const USER_GRADUATE:String = 'user-graduate';
		public static const USER_GROUP:String = 'user-group';
		public static const USER_INJURED:String = 'user-injured';
		public static const USER_LARGE:String = 'user-large';
		public static const USER_LARGE_SLASH:String = 'user-large-slash';
		public static const USER_LOCK:String = 'user-lock';
		public static const USER_MD:String = 'user-md';
		public static const USER_MINUS:String = 'user-minus';
		public static const USER_NINJA:String = 'user-ninja';
		public static const USER_NURSE:String = 'user-nurse';
		public static const USER_PEN:String = 'user-pen';
		public static const USER_PLUS:String = 'user-plus';
		public static const USERS:String = 'users';
		public static const USERS_BETWEEN_LINES:String = 'users-between-lines';
		public static const USERS_COG:String = 'users-cog';
		public static const USER_SECRET:String = 'user-secret';
		public static const USERS_GEAR:String = 'users-gear';
		public static const USER_SHIELD:String = 'user-shield';
		public static const USER_SLASH:String = 'user-slash';
		public static const USERS_LINE:String = 'users-line';
		public static const USERS_RAYS:String = 'users-rays';
		public static const USERS_RECTANGLE:String = 'users-rectangle';
		public static const USERS_SLASH:String = 'users-slash';
		public static const USERS_VIEWFINDER:String = 'users-viewfinder';
		public static const USER_TAG:String = 'user-tag';
		public static const USER_TIE:String = 'user-tie';
		public static const USER_TIMES:String = 'user-times';
		public static const USER_XMARK:String = 'user-xmark';
		public static const USPS:String = 'usps';
		public static const USSUNNAH:String = 'ussunnah';
		public static const UTENSILS:String = 'utensils';
		public static const UTENSIL_SPOON:String = 'utensil-spoon';
		public static const V:String = 'v';
		public static const VAADIN:String = 'vaadin';
		public static const VAN_SHUTTLE:String = 'van-shuttle';
		public static const VAULT:String = 'vault';
		public static const VCARD:String = 'vcard';
		public static const VECTOR_SQUARE:String = 'vector-square';
		public static const VENUS:String = 'venus';
		public static const VENUS_DOUBLE:String = 'venus-double';
		public static const VENUS_MARS:String = 'venus-mars';
		public static const VEST:String = 'vest';
		public static const VEST_PATCHES:String = 'vest-patches';
		public static const VIACOIN:String = 'viacoin';
		public static const VIADEO:String = 'viadeo';
		public static const VIADEO_SQUARE:String = 'viadeo-square';
		public static const VIAL:String = 'vial';
		public static const VIAL_CIRCLE_CHECK:String = 'vial-circle-check';
		public static const VIALS:String = 'vials';
		public static const VIAL_VIRUS:String = 'vial-virus';
		public static const VIBER:String = 'viber';
		public static const VIDEO:String = 'video';
		public static const VIDEO_CAMERA:String = 'video-camera';
		public static const VIDEO_SLASH:String = 'video-slash';
		public static const VIHARA:String = 'vihara';
		public static const VIMEO:String = 'vimeo';
		public static const VIMEO_SQUARE:String = 'vimeo-square';
		public static const VIMEO_V:String = 'vimeo-v';
		public static const VINE:String = 'vine';
		public static const VIRUS:String = 'virus';
		public static const VIRUS_COVID:String = 'virus-covid';
		public static const VIRUS_COVID_SLASH:String = 'virus-covid-slash';
		public static const VIRUSES:String = 'viruses';
		public static const VIRUS_SLASH:String = 'virus-slash';
		public static const VK:String = 'vk';
		public static const VNV:String = 'vnv';
		public static const VOICEMAIL:String = 'voicemail';
		public static const VOLCANO:String = 'volcano';
		public static const VOLLEYBALL:String = 'volleyball';
		public static const VOLLEYBALL_BALL:String = 'volleyball-ball';
		public static const VOLUME_CONTROL_PHONE:String = 'volume-control-phone';
		public static const VOLUME_DOWN:String = 'volume-down';
		public static const VOLUME_HIGH:String = 'volume-high';
		public static const VOLUME_LOW:String = 'volume-low';
		public static const VOLUME_MUTE:String = 'volume-mute';
		public static const VOLUME_OFF:String = 'volume-off';
		public static const VOLUME_TIMES:String = 'volume-times';
		public static const VOLUME_UP:String = 'volume-up';
		public static const VOLUME_XMARK:String = 'volume-xmark';
		public static const VOTE_YEA:String = 'vote-yea';
		public static const VR_CARDBOARD:String = 'vr-cardboard';
		public static const VUEJS:String = 'vuejs';
		public static const W:String = 'w';
		public static const WALKIE_TALKIE:String = 'walkie-talkie';
		public static const WALKING:String = 'walking';
		public static const WALLET:String = 'wallet';
		public static const WAND_MAGIC:String = 'wand-magic';
		public static const WAND_MAGIC_SPARKLES:String = 'wand-magic-sparkles';
		public static const WAND_SPARKLES:String = 'wand-sparkles';
		public static const WAREHOUSE:String = 'warehouse';
		public static const WARNING:String = 'warning';
		public static const WATCHMAN_MONITORING:String = 'watchman-monitoring';
		public static const WATER:String = 'water';
		public static const WATER_LADDER:String = 'water-ladder';
		public static const WAVE_SQUARE:String = 'wave-square';
		public static const WAZE:String = 'waze';
		public static const WEB_AWESOME:String = 'web-awesome';
		public static const WEBFLOW:String = 'webflow';
		public static const WEEBLY:String = 'weebly';
		public static const WEIBO:String = 'weibo';
		public static const WEIGHT:String = 'weight';
		public static const WEIGHT_HANGING:String = 'weight-hanging';
		public static const WEIGHT_SCALE:String = 'weight-scale';
		public static const WEIXIN:String = 'weixin';
		public static const WHATSAPP:String = 'whatsapp';
		public static const WHATSAPP_SQUARE:String = 'whatsapp-square';
		public static const WHEAT_ALT:String = 'wheat-alt';
		public static const WHEAT_AWN:String = 'wheat-awn';
		public static const WHEAT_AWN_CIRCLE_EXCLAMATION:String = 'wheat-awn-circle-exclamation';
		public static const WHEELCHAIR:String = 'wheelchair';
		public static const WHEELCHAIR_ALT:String = 'wheelchair-alt';
		public static const WHEELCHAIR_MOVE:String = 'wheelchair-move';
		public static const WHISKEY_GLASS:String = 'whiskey-glass';
		public static const WHMCS:String = 'whmcs';
		public static const WIFI:String = 'wifi';
		public static const WIFI_3:String = 'wifi-3';
		public static const WIFI_STRONG:String = 'wifi-strong';
		public static const WIKIPEDIA_W:String = 'wikipedia-w';
		public static const WIND:String = 'wind';
		public static const WINDOW_CLOSE:String = 'window-close';
		public static const WINDOW_MAXIMIZE:String = 'window-maximize';
		public static const WINDOW_MINIMIZE:String = 'window-minimize';
		public static const WINDOW_RESTORE:String = 'window-restore';
		public static const WINDOWS:String = 'windows';
		public static const WINE_BOTTLE:String = 'wine-bottle';
		public static const WINE_GLASS:String = 'wine-glass';
		public static const WINE_GLASS_ALT:String = 'wine-glass-alt';
		public static const WINE_GLASS_EMPTY:String = 'wine-glass-empty';
		public static const WIRSINDHANDWERK:String = 'wirsindhandwerk';
		public static const WIX:String = 'wix';
		public static const WIZARDS_OF_THE_COAST:String = 'wizards-of-the-coast';
		public static const WODU:String = 'wodu';
		public static const WOLF_PACK_BATTALION:String = 'wolf-pack-battalion';
		public static const WON:String = 'won';
		public static const WON_SIGN:String = 'won-sign';
		public static const WORDPRESS:String = 'wordpress';
		public static const WORDPRESS_SIMPLE:String = 'wordpress-simple';
		public static const WORM:String = 'worm';
		public static const WPBEGINNER:String = 'wpbeginner';
		public static const WPEXPLORER:String = 'wpexplorer';
		public static const WPFORMS:String = 'wpforms';
		public static const WPRESSR:String = 'wpressr';
		public static const WRENCH:String = 'wrench';
		public static const WSH:String = 'wsh';
		public static const X:String = 'x';
		public static const XBOX:String = 'xbox';
		public static const XING:String = 'xing';
		public static const XING_SQUARE:String = 'xing-square';
		public static const XMARK:String = 'xmark';
		public static const XMARK_CIRCLE:String = 'xmark-circle';
		public static const XMARKS_LINES:String = 'xmarks-lines';
		public static const XMARK_SQUARE:String = 'xmark-square';
		public static const X_RAY:String = 'x-ray';
		public static const X_TWITTER:String = 'x-twitter';
		public static const Y:String = 'y';
		public static const YAHOO:String = 'yahoo';
		public static const YAMMER:String = 'yammer';
		public static const YANDEX:String = 'yandex';
		public static const YANDEX_INTERNATIONAL:String = 'yandex-international';
		public static const YARN:String = 'yarn';
		public static const Y_COMBINATOR:String = 'y-combinator';
		public static const YELP:String = 'yelp';
		public static const YEN:String = 'yen';
		public static const YEN_SIGN:String = 'yen-sign';
		public static const YIN_YANG:String = 'yin-yang';
		public static const YOAST:String = 'yoast';
		public static const YOUTUBE:String = 'youtube';
		public static const YOUTUBE_SQUARE:String = 'youtube-square';
		public static const Z:String = 'z';
		public static const ZAP:String = 'zap';
		public static const ZHIHU:String = 'zhihu';
    }
}