/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.authorization.PrincipalSetPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewAdapter;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewImporter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.slf4j.Logger;

public class JackrabbitACLImporter
implements DocViewAdapter {
    private static final Name NAME_REP_EFFECTIVE_PATH = NameFactoryImpl.getInstance().create("internal", "effectivePath");
    private static final Name NAME_REP_PRINCIPAL_NAMES = NameFactoryImpl.getInstance().create("internal", "principalNames");
    private static final Logger log = DocViewImporter.log;
    private final JackrabbitSession session;
    private final AccessControlHandling aclHandling;
    private final AccessControlManager acMgr;
    private final PrincipalManager pMgr;
    private final String accessControlledPath;
    private final NamePathResolver resolver;
    private ImportedPolicy<? extends AccessControlPolicy> importPolicy;
    private final Deque<State> states = new LinkedList<State>();

    public JackrabbitACLImporter(Node accessControlledNode, AccessControlHandling aclHandling) throws RepositoryException {
        this(accessControlledNode.getSession(), accessControlledNode.getPath(), aclHandling);
    }

    public JackrabbitACLImporter(Session session, AccessControlHandling aclHandling) throws RepositoryException {
        this(session, null, aclHandling);
    }

    private JackrabbitACLImporter(Session session, String path, AccessControlHandling aclHandling) throws RepositoryException {
        if (aclHandling == AccessControlHandling.CLEAR || aclHandling == AccessControlHandling.IGNORE) {
            throw new RepositoryException("Error while reading access control content: unsupported AccessControlHandling: " + (Object)((Object)aclHandling));
        }
        this.accessControlledPath = path;
        this.session = (JackrabbitSession)session;
        this.acMgr = this.session.getAccessControlManager();
        this.pMgr = this.session.getPrincipalManager();
        this.aclHandling = aclHandling;
        this.states.push(State.INITIAL);
        this.resolver = new DefaultNamePathResolver(session);
    }

    @Override
    public void startNode(DocViewNode2 node) {
        State state = this.states.peek();
        switch (state) {
            case INITIAL: {
                String primaryType = node.getPrimaryType().orElseThrow(() -> new IllegalStateException("Error while reading access control content: Missing 'jcr:primaryType'"));
                if ("rep:ACL".equals(primaryType)) {
                    this.importPolicy = new ImportedAcList();
                    state = State.ACL;
                    break;
                }
                if ("rep:CugPolicy".equals(primaryType)) {
                    this.importPolicy = new ImportedPrincipalSet(node);
                    state = State.PRINCIPAL_SET_POLICY;
                    break;
                }
                if ("rep:PrincipalPolicy".equals(primaryType)) {
                    this.importPolicy = new ImportedPrincipalAcList(node);
                    state = State.ACL;
                    break;
                }
                log.error("Error while reading access control content: Expected rep:ACL or rep:CugPolicy but was: {}", node.getPrimaryType());
                state = State.ERROR;
                break;
            }
            case ACL: 
            case ACE: 
            case RESTRICTION: {
                state = this.importPolicy.append(state, node);
                break;
            }
            case PRINCIPAL_SET_POLICY: {
                state = this.importPolicy.append(state, node);
                break;
            }
        }
        this.states.push(state);
    }

    @Override
    public void endNode() {
        State state = this.states.pop();
        this.importPolicy.endNode(state);
    }

    @Override
    public List<String> close() throws RepositoryException {
        if (this.states.peek() != State.INITIAL) {
            log.error("Unexpected end state: {}", (Object)this.states.peek());
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.importPolicy.apply(paths, this.resolver);
        return paths;
    }

    private void addPathIfExists(List<String> paths, String path) throws RepositoryException {
        if (this.session.nodeExists(path)) {
            paths.add(path);
        }
    }

    private static class PrincipalEntry
    extends AbstractEntry {
        private final String effectivePath;

        private PrincipalEntry(DocViewNode2 node) {
            super(node);
            String v = node.getPropertyValue(NAME_REP_EFFECTIVE_PATH).orElseThrow(() -> new IllegalStateException("mandatory property 'rep:effectivePath ' missing on principal entry node"));
            this.effectivePath = v.isEmpty() ? null : v;
        }
    }

    private static class ACE
    extends AbstractEntry {
        private final boolean allow;
        private final String principalName;

        private ACE(DocViewNode2 childNode) {
            super(childNode);
            String primaryType = childNode.getPrimaryType().orElseThrow(() -> new IllegalStateException("mandatory property 'jcr:primaryType' missing on ace node"));
            if ("rep:GrantACE".equals(primaryType)) {
                this.allow = true;
            } else if ("rep:DenyACE".equals(primaryType)) {
                this.allow = false;
            } else {
                throw new IllegalArgumentException("Unexpected node ACE type: " + childNode.getPrimaryType());
            }
            this.principalName = childNode.getPropertyValue(NameConstants.REP_PRINCIPAL_NAME).orElseThrow(() -> new IllegalStateException("mandatory property 'rep:principalName' missing"));
        }
    }

    private static class AbstractEntry {
        private final Collection<String> privileges;
        private final Map<Name, DocViewProperty2> restrictions;

        private AbstractEntry(DocViewNode2 node) {
            this.privileges = node.getPropertyValues(NameConstants.REP_PRIVILEGES);
            this.restrictions = new HashMap<Name, DocViewProperty2>();
            this.addRestrictions(node);
        }

        void addRestrictions(DocViewNode2 node) {
            this.restrictions.putAll(node.getProperties().stream().collect(Collectors.toMap(DocViewProperty2::getName, Function.identity())));
        }

        void convertRestrictions(JackrabbitAccessControlList acl, ValueFactory vf, NameResolver resolver, Map<String, Value> svRestrictions, Map<String, Value[]> mvRestrictions) throws RepositoryException {
            for (String restName : acl.getRestrictionNames()) {
                DocViewProperty2 restriction = this.restrictions.get(resolver.getQName(restName));
                if (restriction == null) continue;
                Value[] values = new Value[restriction.getStringValues().size()];
                int type = acl.getRestrictionType(restName);
                for (int i = 0; i < values.length; ++i) {
                    values[i] = vf.createValue(restriction.getStringValues().get(i), type);
                }
                if (restriction.isMultiValue()) {
                    mvRestrictions.put(restName, values);
                    continue;
                }
                svRestrictions.put(restName, values[0]);
            }
        }

        Privilege[] getPrivileges(AccessControlManager acMgr) throws RepositoryException {
            return AccessControlUtils.privilegesFromNames(acMgr, this.privileges.toArray(new String[0]));
        }
    }

    private final class ImportedPrincipalAcList
    extends ImportedPolicy<PrincipalAccessControlList> {
        private final Principal principal;
        private final List<PrincipalEntry> entries;
        private PrincipalEntry currentEntry;

        private ImportedPrincipalAcList(DocViewNode2 node) {
            this.entries = new ArrayList<PrincipalEntry>();
            String principalName = node.getPropertyValue(NameConstants.REP_PRINCIPAL_NAME).orElseThrow(() -> new IllegalStateException("mandatory property 'rep:principalName' missing on principal policy node"));
            Principal p = JackrabbitACLImporter.this.pMgr.getPrincipal(principalName);
            if (p == null) {
                try {
                    Authorizable a = JackrabbitACLImporter.this.session.getUserManager().getAuthorizableByPath(JackrabbitACLImporter.this.accessControlledPath);
                    if (a != null) {
                        p = a.getPrincipal();
                    }
                }
                catch (RepositoryException e) {
                    log.debug("Error while trying to retrieve user/group from access controlled path {}, {}", (Object)JackrabbitACLImporter.this.accessControlledPath, (Object)e.getMessage());
                }
                if (p == null) {
                    p = this.getPrincipal(principalName);
                }
            }
            this.principal = p;
        }

        @Override
        State append(State state, DocViewNode2 childNode) {
            if (state == State.ACL) {
                if (!"rep:PrincipalEntry".equals(childNode.getPrimaryType().orElseThrow(() -> new IllegalStateException("mandatory property 'jcr:primaryType' missing on principal policy node")))) {
                    log.error("Unexpected node type of access control entry: {}", childNode.getPrimaryType());
                    return State.ERROR;
                }
                this.currentEntry = new PrincipalEntry(childNode);
                this.entries.add(this.currentEntry);
                return State.ACE;
            }
            if (state == State.ACE) {
                this.currentEntry.addRestrictions(childNode);
                return State.RESTRICTION;
            }
            log.error("Error while reading access control content: Unexpected node: {} for state {}", childNode.getPrimaryType(), (Object)state);
            return State.ERROR;
        }

        @Override
        void endNode(State state) {
            if (state == State.ACE) {
                this.currentEntry = null;
            }
        }

        @Override
        void apply(List<String> paths, NameResolver resolver) throws RepositoryException {
            if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.MERGE_PRESERVE) {
                log.debug("MERGE_PRESERVE for principal-based access control list is equivalent to IGNORE.");
                return;
            }
            PrincipalAccessControlList acl = this.getPolicy(PrincipalAccessControlList.class, this.principal);
            if (acl != null && JackrabbitACLImporter.this.aclHandling == AccessControlHandling.OVERWRITE) {
                JackrabbitACLImporter.this.acMgr.removePolicy(acl.getPath(), acl);
                acl = null;
            }
            if (acl == null) {
                acl = this.getApplicablePolicy(PrincipalAccessControlList.class, this.principal);
            }
            for (PrincipalEntry entry : this.entries) {
                HashMap<String, Value> svRestrictions = new HashMap<String, Value>();
                HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
                entry.convertRestrictions(acl, JackrabbitACLImporter.this.session.getValueFactory(), resolver, svRestrictions, mvRestrictions);
                acl.addEntry(entry.effectivePath, entry.getPrivileges(JackrabbitACLImporter.this.acMgr), svRestrictions, mvRestrictions);
            }
            JackrabbitACLImporter.this.acMgr.setPolicy(acl.getPath(), acl);
            if (JackrabbitACLImporter.this.accessControlledPath == null) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:repoPolicy");
            } else if ("/".equals(JackrabbitACLImporter.this.accessControlledPath)) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:policy");
            } else {
                JackrabbitACLImporter.this.addPathIfExists(paths, JackrabbitACLImporter.this.accessControlledPath + "/rep:policy");
            }
        }
    }

    private final class ImportedPrincipalSet
    extends ImportedPolicy<PrincipalSetPolicy> {
        private final Collection<String> principalNames;

        private ImportedPrincipalSet(DocViewNode2 node) {
            this.principalNames = node.getPropertyValues(NAME_REP_PRINCIPAL_NAMES);
        }

        @Override
        State append(State state, DocViewNode2 childNode) {
            log.error("Error while reading access control content: Unexpected node: {} for state {}", childNode.getPrimaryType(), (Object)state);
            return State.ERROR;
        }

        @Override
        void endNode(State state) {
        }

        @Override
        void apply(List<String> paths, NameResolver resolver) throws RepositoryException {
            PrincipalSetPolicy psPolicy = this.getPolicy(PrincipalSetPolicy.class);
            if (psPolicy != null) {
                Set<Principal> existingPrincipals = psPolicy.getPrincipals();
                if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.OVERWRITE) {
                    psPolicy.removePrincipals(existingPrincipals.toArray(new Principal[existingPrincipals.size()]));
                }
            } else {
                psPolicy = this.getApplicablePolicy(PrincipalSetPolicy.class);
            }
            Principal[] principals = (Principal[])this.principalNames.stream().map(name -> this.getPrincipal((String)name)).toArray(Principal[]::new);
            psPolicy.addPrincipals(principals);
            JackrabbitACLImporter.this.acMgr.setPolicy(JackrabbitACLImporter.this.accessControlledPath, psPolicy);
            if ("/".equals(JackrabbitACLImporter.this.accessControlledPath)) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:cugPolicy");
            } else {
                JackrabbitACLImporter.this.addPathIfExists(paths, JackrabbitACLImporter.this.accessControlledPath + "/rep:cugPolicy");
            }
        }
    }

    private final class ImportedAcList
    extends ImportedPolicy<JackrabbitAccessControlList> {
        private List<ACE> aceList;
        private ACE currentACE;

        private ImportedAcList() {
            this.aceList = new ArrayList<ACE>();
        }

        @Override
        State append(State state, DocViewNode2 childNode) {
            if (state == State.ACL) {
                try {
                    this.currentACE = new ACE(childNode);
                    this.aceList.add(this.currentACE);
                    return State.ACE;
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while reading access control content: {}", (Throwable)e);
                    return State.ERROR;
                }
            }
            if (state == State.ACE) {
                this.currentACE.addRestrictions(childNode);
                return State.RESTRICTION;
            }
            log.error("Error while reading access control content: Unexpected node: {} for state {}", childNode.getPrimaryType(), (Object)state);
            return State.ERROR;
        }

        @Override
        void endNode(State state) {
            if (state == State.ACE) {
                this.currentACE = null;
            }
        }

        @Override
        void apply(List<String> paths, NameResolver resolver) throws RepositoryException {
            JackrabbitAccessControlList acl = this.getPolicy(JackrabbitAccessControlList.class);
            HashSet<String> existingPrincipals = new HashSet<String>();
            if (acl != null) {
                for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                    existingPrincipals.add(ace.getPrincipal().getName());
                }
                if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.OVERWRITE) {
                    JackrabbitACLImporter.this.acMgr.removePolicy(JackrabbitACLImporter.this.accessControlledPath, acl);
                    acl = null;
                }
            }
            if (acl == null) {
                acl = this.getApplicablePolicy(JackrabbitAccessControlList.class);
            }
            if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.MERGE) {
                for (ACE entry : this.aceList) {
                    for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                        if (!ace.getPrincipal().getName().equals(entry.principalName)) continue;
                        acl.removeAccessControlEntry(ace);
                    }
                }
            }
            for (ACE ace : this.aceList) {
                String principalName = ace.principalName;
                if (JackrabbitACLImporter.this.aclHandling == AccessControlHandling.MERGE_PRESERVE && existingPrincipals.contains(principalName)) continue;
                Principal principal = this.getPrincipal(principalName);
                HashMap<String, Value> svRestrictions = new HashMap<String, Value>();
                HashMap<String, Value[]> mvRestrictions = new HashMap<String, Value[]>();
                ace.convertRestrictions(acl, JackrabbitACLImporter.this.session.getValueFactory(), resolver, svRestrictions, mvRestrictions);
                acl.addEntry(principal, ace.getPrivileges(JackrabbitACLImporter.this.acMgr), ace.allow, svRestrictions, mvRestrictions);
            }
            JackrabbitACLImporter.this.acMgr.setPolicy(JackrabbitACLImporter.this.accessControlledPath, acl);
            if (JackrabbitACLImporter.this.accessControlledPath == null) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:repoPolicy");
            } else if ("/".equals(JackrabbitACLImporter.this.accessControlledPath)) {
                JackrabbitACLImporter.this.addPathIfExists(paths, "/rep:policy");
            } else {
                JackrabbitACLImporter.this.addPathIfExists(paths, JackrabbitACLImporter.this.accessControlledPath + "/rep:policy");
            }
        }
    }

    private abstract class ImportedPolicy<T extends AccessControlPolicy> {
        private ImportedPolicy() {
        }

        abstract State append(State var1, DocViewNode2 var2);

        abstract void endNode(State var1);

        abstract void apply(List<String> var1, NameResolver var2) throws RepositoryException;

        Principal getPrincipal(final String principalName) {
            Principal principal = new Principal(){

                @Override
                public String getName() {
                    return principalName;
                }
            };
            return principal;
        }

        T getPolicy(Class<T> clz) throws RepositoryException {
            for (AccessControlPolicy p : JackrabbitACLImporter.this.acMgr.getPolicies(JackrabbitACLImporter.this.accessControlledPath)) {
                if (!clz.isAssignableFrom(p.getClass())) continue;
                return (T)((AccessControlPolicy)clz.cast(p));
            }
            return null;
        }

        T getPolicy(Class<T> clz, Principal principal) throws RepositoryException {
            if (JackrabbitACLImporter.this.acMgr instanceof JackrabbitAccessControlManager) {
                for (JackrabbitAccessControlPolicy p : ((JackrabbitAccessControlManager)JackrabbitACLImporter.this.acMgr).getPolicies(principal)) {
                    if (!clz.isAssignableFrom(p.getClass())) continue;
                    return (T)((AccessControlPolicy)clz.cast(p));
                }
            }
            return null;
        }

        T getApplicablePolicy(Class<T> clz) throws RepositoryException {
            AccessControlPolicyIterator iter = JackrabbitACLImporter.this.acMgr.getApplicablePolicies(JackrabbitACLImporter.this.accessControlledPath);
            while (iter.hasNext()) {
                AccessControlPolicy p = iter.nextAccessControlPolicy();
                if (!clz.isAssignableFrom(p.getClass())) continue;
                return (T)((AccessControlPolicy)clz.cast(p));
            }
            throw new RepositoryException("no applicable AccessControlPolicy of type " + clz + " on " + (JackrabbitACLImporter.this.accessControlledPath == null ? "'root'" : JackrabbitACLImporter.this.accessControlledPath));
        }

        T getApplicablePolicy(Class<T> clz, Principal principal) throws RepositoryException {
            if (JackrabbitACLImporter.this.acMgr instanceof JackrabbitAccessControlManager) {
                for (JackrabbitAccessControlPolicy p : ((JackrabbitAccessControlManager)JackrabbitACLImporter.this.acMgr).getApplicablePolicies(principal)) {
                    if (!clz.isAssignableFrom(p.getClass())) continue;
                    return (T)((AccessControlPolicy)clz.cast(p));
                }
            }
            throw new AccessControlException("no applicable AccessControlPolicy of type " + clz + " for " + principal.getName());
        }
    }

    private static enum State {
        INITIAL,
        ACL,
        ACE,
        RESTRICTION,
        ERROR,
        PRINCIPAL_SET_POLICY;

    }
}

