/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html;

import java.util.Map;
import org.apache.sling.commons.html.AttrValue;
import org.apache.sling.commons.html.HtmlElementType;
import org.apache.sling.commons.html.util.Visitor;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface HtmlElement {
    public HtmlElementType getType();

    public boolean supportsAttributes();

    public Map<String, AttrValue> getAttributes();

    public String getValue();

    default public <T> T accept(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    default public boolean getVoidTag() {
        return false;
    }

    default public boolean hasAttributes() {
        if (this.supportsAttributes()) {
            return !this.getAttributes().isEmpty();
        }
        return false;
    }

    default public boolean containsAttribute(String attrName) {
        return this.getAttributes().containsKey(attrName);
    }

    default public String getAttributeValue(String name) {
        if (this.supportsAttributes()) {
            return this.getAttributes().get(name).toString();
        }
        return null;
    }

    default public void setAttribute(String name, String value) {
        if (this.supportsAttributes()) {
            this.getAttributes().put(name, new AttrValue(value));
            return;
        }
        throw new UnsupportedOperationException();
    }
}

