/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.scheduling;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.scheduling.JobSchedulerImpl;
import org.apache.sling.event.impl.jobs.scheduling.ScheduledJobInfoImpl;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledJobHandler
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final JobSchedulerImpl jobScheduler;
    private final Map<String, Holder> scheduledJobs = new HashMap<String, Holder>();
    private final AtomicLong lastBundleActivity = new AtomicLong();
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();

    public ScheduledJobHandler(JobManagerConfiguration configuration, JobSchedulerImpl jobScheduler) {
        this.configuration = configuration;
        this.jobScheduler = jobScheduler;
        Thread t = new Thread((Runnable)this, "Apache Sling Scheduled Job Handler Thread");
        t.setDaemon(true);
        t.start();
        this.addFullScan();
    }

    private void addTask(Runnable r) {
        try {
            this.queue.put(r);
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    private void addFullScan() {
        this.addTask(new Runnable(){

            @Override
            public void run() {
                ScheduledJobHandler.this.scan();
            }
        });
    }

    public void deactivate() {
        this.isRunning.set(false);
        this.queue.clear();
        this.addTask(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public void run() {
        while (this.isRunning.get()) {
            Runnable r = null;
            try {
                r = this.queue.take();
            }
            catch (InterruptedException e) {
                this.ignoreException(e);
                Thread.currentThread().interrupt();
                this.isRunning.set(false);
            }
            if (!this.isRunning.get() || r == null) continue;
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan() {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        if (resolver != null) {
            try {
                this.logger.debug("Scanning for scheduled jobs...");
                String path = this.configuration.getScheduledJobsPath(false);
                Resource startResource = resolver.getResource(path);
                if (startResource != null) {
                    HashMap<String, Holder> newScheduledJobs = new HashMap<String, Holder>();
                    Map<String, Holder> map = this.scheduledJobs;
                    synchronized (map) {
                        for (Resource rsrc : startResource.getChildren()) {
                            if (!this.isRunning.get()) break;
                            this.handleAddOrUpdate(newScheduledJobs, rsrc);
                        }
                        if (this.isRunning.get()) {
                            for (Holder h : this.scheduledJobs.values()) {
                                if (h.info == null) continue;
                                this.jobScheduler.unscheduleJob(h.info);
                            }
                            this.scheduledJobs.clear();
                            this.scheduledJobs.putAll(newScheduledJobs);
                        }
                    }
                }
                this.logger.debug("Finished scanning for scheduled jobs...");
            }
            finally {
                resolver.close();
            }
        }
    }

    private Map<String, Object> readScheduledJob(Resource eventResource) {
        block4: {
            try {
                ValueMap vm = ResourceHelper.getValueMap(eventResource);
                Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
                List readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
                if (readErrorList != null) {
                    for (Exception e : readErrorList) {
                        this.logger.warn("Unable to read scheduled job from " + eventResource.getPath(), (Throwable)e);
                    }
                    break block4;
                }
                return properties;
            }
            catch (InstantiationException ie) {
                this.ignoreException(ie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledJobInfoImpl addOrUpdateJob(String jobTopic, Map<String, Object> jobProperties, String scheduleName, boolean suspend, List<ScheduleInfoImpl> scheduleInfos) throws PersistenceException {
        Map<String, Object> properties = this.writeScheduledJob(jobTopic, jobProperties, scheduleName, suspend, scheduleInfos);
        String key = ResourceHelper.filterName(scheduleName);
        Map<String, Holder> map = this.scheduledJobs;
        synchronized (map) {
            Holder h = this.scheduledJobs.remove(key);
            if (h != null && h.info != null) {
                this.jobScheduler.unscheduleJob(h.info);
            }
            Holder holder = new Holder();
            holder.created = (Calendar)properties.get("slingevent:created");
            holder.read = System.currentTimeMillis();
            holder.info = this.addOrUpdateScheduledJob(properties, h == null ? null : h.info);
            this.scheduledJobs.put(key, holder);
            this.jobScheduler.scheduleJob(holder.info);
            return holder.info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> writeScheduledJob(String jobTopic, Map<String, Object> jobProperties, String scheduleName, boolean suspend, List<ScheduleInfoImpl> scheduleInfos) throws PersistenceException {
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (jobProperties != null) {
                for (Map.Entry<String, Object> entry : jobProperties.entrySet()) {
                    String propName = entry.getKey();
                    if (ResourceHelper.ignoreProperty(propName)) continue;
                    properties.put(propName, entry.getValue());
                }
            }
            properties.put("event.job.topic", jobTopic);
            properties.put("slingevent:created", Calendar.getInstance());
            properties.put("slingevent:application", Environment.APPLICATION_ID);
            properties.put("slingevent:scheduleName", scheduleName);
            String[] infoArray = new String[scheduleInfos.size()];
            int index = 0;
            for (ScheduleInfoImpl info : scheduleInfos) {
                infoArray[index] = info.getSerializedString();
                ++index;
            }
            properties.put("slingevent:scheduleInfo", infoArray);
            if (suspend) {
                properties.put("slingevent:scheduleSuspended", Boolean.TRUE);
            }
            properties.put("sling:resourceType", "slingevent:TimedEvent");
            String path = this.configuration.getScheduledJobsPath(true) + ResourceHelper.filterName(scheduleName);
            Resource existingInfo = resolver.getResource(path);
            if (existingInfo != null) {
                resolver.delete(existingInfo);
                this.logger.debug("Updating scheduled job {} at {}", properties, (Object)path);
            } else {
                this.logger.debug("Storing new scheduled job {} at {}", properties, (Object)path);
            }
            ResourceHelper.createAndCommitResource(resolver, path, properties);
            properties.put("slingevent:scheduleInfo", scheduleInfos);
            HashMap<String, Object> hashMap = properties;
            return hashMap;
        }
    }

    private ScheduledJobInfoImpl addOrUpdateScheduledJob(Map<String, Object> properties, ScheduledJobInfoImpl oldInfo) {
        properties.remove("sling:resourceType");
        properties.remove("slingevent:created");
        properties.remove("slingevent:application");
        properties.remove("jcr:primaryType");
        String jobTopic = (String)properties.remove("event.job.topic");
        String schedulerName = (String)properties.remove("slingevent:scheduleName");
        ScheduledJobInfoImpl info = oldInfo == null ? new ScheduledJobInfoImpl(this.jobScheduler, schedulerName) : oldInfo;
        info.update(jobTopic, properties);
        return info;
    }

    public void bundleEvent() {
        this.lastBundleActivity.set(System.currentTimeMillis());
        this.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                HashMap<String, Holder> updateJobs = new HashMap<String, Holder>();
                Map map = ScheduledJobHandler.this.scheduledJobs;
                synchronized (map) {
                    for (Map.Entry entry : ScheduledJobHandler.this.scheduledJobs.entrySet()) {
                        if (((Holder)entry.getValue()).info != null || ((Holder)entry.getValue()).read >= ScheduledJobHandler.this.lastBundleActivity.get()) continue;
                        updateJobs.put((String)entry.getKey(), (Holder)entry.getValue());
                    }
                }
                if (updateJobs.isEmpty()) return;
                if (!ScheduledJobHandler.this.isRunning.get()) return;
                ResourceResolver resolver = ScheduledJobHandler.this.configuration.createResourceResolver();
                if (resolver == null) return;
                try {
                    Iterator iterator = updateJobs.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry;
                        entry = iterator.next();
                        String path = ScheduledJobHandler.this.configuration.getScheduledJobsPath(true) + (String)entry.getKey();
                        Resource rsrc = resolver.getResource(path);
                        if (!ScheduledJobHandler.this.isRunning.get()) {
                            return;
                        }
                        if (rsrc == null) continue;
                        Map map2 = ScheduledJobHandler.this.scheduledJobs;
                        synchronized (map2) {
                            ScheduledJobHandler.this.handleAddOrUpdate(ScheduledJobHandler.this.scheduledJobs, rsrc);
                        }
                    }
                    return;
                }
                finally {
                    resolver.close();
                }
            }
        });
    }

    public void handleRemove(final String path) {
        this.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String scheduleKey;
                if (ScheduledJobHandler.this.isRunning.get() && (scheduleKey = ResourceHelper.filterName(ResourceUtil.getName((String)path))) != null) {
                    Map map = ScheduledJobHandler.this.scheduledJobs;
                    synchronized (map) {
                        Holder h = (Holder)ScheduledJobHandler.this.scheduledJobs.remove(scheduleKey);
                        if (h != null && h.info != null) {
                            ScheduledJobHandler.this.jobScheduler.unscheduleJob(h.info);
                        }
                    }
                }
            }
        });
    }

    public void handleAddUpdate(final String path) {
        this.addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    ResourceResolver resolver;
                    if (ScheduledJobHandler.this.isRunning.get() && (resolver = ScheduledJobHandler.this.configuration.createResourceResolver()) != null) {
                        try {
                            Resource rsrc = resolver.getResource(path);
                            if (rsrc == null) break block7;
                            Map map = ScheduledJobHandler.this.scheduledJobs;
                            synchronized (map) {
                                ScheduledJobHandler.this.handleAddOrUpdate(ScheduledJobHandler.this.scheduledJobs, rsrc);
                            }
                        }
                        finally {
                            resolver.close();
                        }
                    }
                }
            }
        });
    }

    private void handleAddOrUpdate(Map<String, Holder> newScheduledJobs, Resource rsrc) {
        String id = ResourceHelper.filterName(rsrc.getName());
        Holder scheduled = this.scheduledJobs.remove(id);
        boolean read = false;
        if (scheduled != null) {
            ValueMap vm;
            Calendar changed;
            if (scheduled.info == null || scheduled.read < this.lastBundleActivity.get()) {
                read = true;
            }
            if (scheduled.info != null && (changed = (Calendar)(vm = ResourceUtil.getValueMap((Resource)rsrc)).get((Object)"slingevent:created")) != null && scheduled.created.compareTo(changed) < 0) {
                read = true;
            }
            if (!read) {
                newScheduledJobs.put(id, scheduled);
            }
        } else {
            read = true;
        }
        if (read) {
            Holder holder = new Holder();
            holder.read = System.currentTimeMillis();
            Map<String, Object> properties = this.readScheduledJob(rsrc);
            if (properties != null) {
                holder.created = (Calendar)properties.get("slingevent:created");
                holder.info = this.addOrUpdateScheduledJob(properties, scheduled != null ? scheduled.info : null);
            }
            newScheduledJobs.put(id, holder);
            if (holder.info == null && scheduled != null && scheduled.info != null) {
                this.jobScheduler.unscheduleJob(scheduled.info);
            }
            if (holder.info != null) {
                this.jobScheduler.scheduleJob(holder.info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ScheduledJobInfoImpl info) {
        String scheduleKey = ResourceHelper.filterName(info.getName());
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            StringBuilder sb = new StringBuilder(this.configuration.getScheduledJobsPath(true));
            sb.append(scheduleKey);
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                resolver.delete(eventResource);
                resolver.commit();
            }
        }
        Map<String, Holder> map = this.scheduledJobs;
        synchronized (map) {
            Holder h = this.scheduledJobs.remove(scheduleKey);
            if (h != null && h.info != null) {
                this.jobScheduler.unscheduleJob(h.info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchedule(String scheduleName, Collection<ScheduleInfo> scheduleInfo) {
        block10: {
            try (ResourceResolver resolver = this.configuration.createResourceResolver();){
                String scheduleKey = ResourceHelper.filterName(scheduleName);
                StringBuilder sb = new StringBuilder(this.configuration.getScheduledJobsPath(true));
                sb.append(scheduleKey);
                String path = sb.toString();
                Resource rsrc = resolver.getResource(path);
                if (rsrc == null) break block10;
                Calendar now = Calendar.getInstance();
                Map<String, Holder> map = this.scheduledJobs;
                synchronized (map) {
                    Holder h = this.scheduledJobs.get(scheduleKey);
                    if (h != null) {
                        h.created = now;
                    }
                }
                ModifiableValueMap mvm = (ModifiableValueMap)rsrc.adaptTo(ModifiableValueMap.class);
                mvm.put((Object)"slingevent:created", (Object)now);
                String[] infoArray = new String[scheduleInfo.size()];
                int index = 0;
                for (ScheduleInfo si : scheduleInfo) {
                    infoArray[index] = ((ScheduleInfoImpl)si).getSerializedString();
                    ++index;
                }
                mvm.put((Object)"slingevent:scheduleInfo", (Object)infoArray);
                try {
                    resolver.commit();
                }
                catch (PersistenceException pe) {
                    this.logger.warn("Unable to update scheduled job " + scheduleName, (Throwable)pe);
                }
            }
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    public void maintenance() {
        this.addFullScan();
    }

    public static final class Holder {
        public Calendar created;
        public ScheduledJobInfoImpl info;
        public long read;
    }
}

