/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.JcrNamespaceRegistryProvider;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleSlingInitialContentExtractContext {
    private final ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy;
    private final String path;
    private final ArtifactId bundleArtifactId;
    private final JarFile jarFile;
    private final ContentPackage2FeatureModelConverter converter;
    private final String runMode;
    private final Manifest manifest;
    private final JcrNamespaceRegistry namespaceRegistry;
    private final List<PathEntry> pathEntryList = new ArrayList<PathEntry>();

    public BundleSlingInitialContentExtractContext(@NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy, @NotNull String path, @NotNull ArtifactId bundleArtifactId, @NotNull JarFile jarFile, @NotNull ContentPackage2FeatureModelConverter converter, @Nullable String runMode) throws IOException {
        this.slingInitialContentPolicy = slingInitialContentPolicy;
        this.path = path;
        this.bundleArtifactId = bundleArtifactId;
        this.jarFile = jarFile;
        this.converter = converter;
        this.runMode = runMode;
        this.manifest = Objects.requireNonNull(jarFile.getManifest());
        this.namespaceRegistry = new JcrNamespaceRegistryProvider(this.manifest, jarFile, converter.getFeaturesManager().getNamespaceUriByPrefix()).provideRegistryFromBundle();
        Iterator pathEntries = PathEntry.getContentPaths((Manifest)this.manifest, (long)-1L);
        if (pathEntries != null) {
            pathEntries.forEachRemaining(this.pathEntryList::add);
        }
    }

    @NotNull
    public ContentPackage2FeatureModelConverter.SlingInitialContentPolicy getSlingInitialContentPolicy() {
        return this.slingInitialContentPolicy;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public ArtifactId getBundleArtifactId() {
        return this.bundleArtifactId;
    }

    @NotNull
    public ContentPackage2FeatureModelConverter getConverter() {
        return this.converter;
    }

    @Nullable
    public String getRunMode() {
        return this.runMode;
    }

    @NotNull
    public JarFile getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public Manifest getManifest() {
        return this.manifest;
    }

    @NotNull
    public JcrNamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    @NotNull
    public List<PathEntry> getPathEntryList() {
        return new ArrayList<PathEntry>(this.pathEntryList);
    }
}

