/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.junitbridge;

import junit.framework.TestCase;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.junitbridge.TestBridgeContext;
import org.apache.sling.hc.util.HealthCheckMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HealthCheckTest
extends TestCase {
    private final HealthCheck hc;
    private final HealthCheckMetadata metadata;
    private final BundleContext bundleContext;
    private final ServiceReference serviceRef;

    HealthCheckTest(TestBridgeContext context, ServiceReference ref) {
        super("testHealthCheck");
        this.bundleContext = context.getBundleContext();
        this.serviceRef = ref;
        this.hc = (HealthCheck)this.bundleContext.getService(ref);
        this.metadata = new HealthCheckMetadata(ref);
    }

    public String getName() {
        return this.metadata.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHealthCheck() {
        try {
            Result r = this.hc.execute();
            StringBuilder failMsg = new StringBuilder();
            if (!r.isOk()) {
                failMsg.append(this.metadata.getName());
                failMsg.append("\n");
                for (ResultLog.Entry log : r) {
                    if (log.getStatus().compareTo((Enum)Result.Status.INFO) <= 0) continue;
                    if (failMsg.length() > 0) {
                        failMsg.append("\n");
                    }
                    failMsg.append(log.getStatus().toString());
                    failMsg.append(" - ");
                    failMsg.append(log.getMessage());
                }
            }
            if (failMsg.length() > 0) {
                HealthCheckTest.fail((String)("Health Check failed: " + failMsg.toString()));
            }
        }
        finally {
            this.bundleContext.ungetService(this.serviceRef);
        }
    }
}

