/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hc.junitbridge;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.junitbridge.JUnitTestBridge;
import org.apache.sling.hc.junitbridge.TestBridgeContext;
import org.apache.sling.junit.TestsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, label="Apache Sling Health Checks/JUnit bridge", description="Makes Health Checks available as server-side JUnit tests")
@Service
public class HealthCheckTestsProvider
implements TestsProvider {
    private String servicePid;
    private long lastModified;
    private BundleContext bundleContext;
    public static final String TEST_NAME_PREFIX = "HealthChecks(";
    public static final String TEST_NAME_SUFFIX = ")";
    public static final String[] DEFAULT_TAG_GROUPS = new String[]{"No tag groups configured"};
    @Property(cardinality=0x7FFFFFFF, label="Health Check Tags", description="Groups of health check tags to execute as JUnit tests. Use the standard Health Checks 'includeThisTag,-omitThatTag' syntax")
    public static final String PROP_TAG_GROUPS = "health.check.tag.groups";
    private String[] tagGroups;

    @Activate
    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.tagGroups = PropertiesUtil.toStringArray(ctx.getProperties().get(PROP_TAG_GROUPS), (String[])DEFAULT_TAG_GROUPS);
        this.servicePid = (String)ctx.getProperties().get("service.pid");
        this.lastModified = System.currentTimeMillis();
    }

    @Deactivate
    protected void deactivate() {
        this.bundleContext = null;
        this.servicePid = null;
        this.lastModified = -1L;
    }

    public Class<?> createTestClass(String testName) throws ClassNotFoundException {
        String tagString = null;
        try {
            tagString = testName.substring(0, testName.length() - TEST_NAME_SUFFIX.length()).substring(TEST_NAME_PREFIX.length());
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid test name:" + testName);
        }
        JUnitTestBridge.setThreadContext(new TestBridgeContext(this.bundleContext, this.splitTags(tagString)));
        return JUnitTestBridge.class;
    }

    private String[] splitTags(String tags) {
        ArrayList<String> result = new ArrayList<String>();
        for (String tag : tags.split(",")) {
            result.add(tag.trim());
        }
        return result.toArray(new String[0]);
    }

    public String getServicePid() {
        return this.servicePid;
    }

    public List<String> getTestNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String t : this.tagGroups) {
            result.add(TEST_NAME_PREFIX + t + TEST_NAME_SUFFIX);
        }
        return result;
    }

    public long lastModified() {
        return this.lastModified;
    }
}

