/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.jackrabbit.spi.commons.privilege.ParseException;
import org.apache.jackrabbit.spi.commons.privilege.PrivilegeDefinitionReader;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.AbstractVaultFsConfig;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.config.VaultSettings;
import org.apache.jackrabbit.vault.fs.spi.CNDReader;
import org.apache.jackrabbit.vault.fs.spi.NodeTypeSet;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions;
import org.apache.jackrabbit.vault.fs.spi.ServiceProviderFactory;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.impl.PackagePropertiesImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetaInf
implements MetaInf {
    private static Logger log = LoggerFactory.getLogger(DefaultMetaInf.class);
    private VaultSettings settings;
    private WorkspaceFilter filter;
    private VaultFsConfig config;
    private Properties properties;
    private Collection<NodeTypeSet> cnds = new LinkedList<NodeTypeSet>();
    private PrivilegeDefinitions privileges = new PrivilegeDefinitions();
    private boolean hasDefinition;

    @Override
    public int getPackageFormatVersion() {
        String prop;
        String string = prop = this.properties == null ? null : this.properties.getProperty("packageFormatVersion");
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 2;
    }

    public boolean load(@Nullable InputStream in, @NotNull String systemId) throws IOException, ConfigurationException {
        if (systemId.endsWith("/definition/.content.xml")) {
            this.setHasDefinition(true);
            log.trace("Contains package definition {}.", (Object)systemId);
            return true;
        }
        if (in == null) {
            return false;
        }
        String name = Text.getName(systemId);
        if ("filter.xml".equals(name)) {
            this.loadFilter(in, systemId);
            return true;
        }
        if ("config.xml".equals(name)) {
            this.loadConfig(in, systemId);
            return true;
        }
        if ("settings.xml".equals(name)) {
            this.loadSettings(in, systemId);
            return true;
        }
        if ("properties.xml".equals(name)) {
            this.loadProperties(in, systemId);
            return true;
        }
        if ("privileges.xml".equals(name)) {
            this.loadPrivileges(in, systemId);
            return true;
        }
        if (name.endsWith(".cnd")) {
            InputStreamReader r = new InputStreamReader(in, "utf8");
            CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
            reader.read(r, systemId, null);
            this.getNodeTypes().add(reader);
            log.trace("Loaded nodetypes from {}.", (Object)systemId);
            return true;
        }
        return false;
    }

    public void loadFilter(@NotNull InputStream in, @NotNull String systemId) throws ConfigurationException, IOException {
        DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
        filter.load(in);
        this.setFilter(filter);
        log.trace("Loaded filter from {}.", (Object)systemId);
    }

    public void loadConfig(@NotNull InputStream in, @NotNull String systemId) throws ConfigurationException, IOException {
        VaultFsConfig config = AbstractVaultFsConfig.load(in, systemId);
        this.setConfig(config);
        log.trace("Loaded config from {}.", (Object)systemId);
    }

    public void loadSettings(@NotNull InputStream in, @NotNull String systemId) throws ConfigurationException, IOException {
        VaultSettings settings = new VaultSettings();
        settings.load(in);
        this.setSettings(settings);
        log.trace("Loaded settings from {}.", (Object)systemId);
    }

    public void loadProperties(@NotNull InputStream in, @NotNull String systemId) throws IOException {
        Properties props = new Properties();
        props.loadFromXML(new CloseShieldInputStream(in));
        this.setProperties(props);
        log.trace("Loaded properties from {}.", (Object)systemId);
    }

    public void loadPrivileges(@NotNull InputStream in, @NotNull String systemId) throws IOException {
        try {
            PrivilegeDefinitionReader reader = new PrivilegeDefinitionReader(in, "text/xml");
            Collections.addAll(this.privileges.getDefinitions(), reader.getPrivilegeDefinitions());
            for (Map.Entry<String, String> e : reader.getNamespaces().entrySet()) {
                this.privileges.getNamespaceMapping().setMapping(e.getKey(), e.getValue());
            }
        }
        catch (NamespaceException | ParseException e) {
            log.error("Error while reading Privileges: {}", (Object)e.toString());
            throw new IOException("Error while reading privileges.", e);
        }
        log.trace("Loaded privileges from {}.", (Object)systemId);
    }

    public void save(@NotNull File metaDir) throws IOException {
        if (!metaDir.isDirectory()) {
            throw new IOException("meta directory does not exist or is non a directory: " + metaDir.getAbsolutePath());
        }
        this.saveConfig(metaDir);
        this.saveFilter(metaDir);
        this.saveSettings(metaDir);
        this.saveProperties(metaDir);
    }

    @Override
    public VaultSettings getSettings() {
        return this.settings;
    }

    public void setSettings(VaultSettings settings) {
        this.settings = settings;
    }

    @Override
    public WorkspaceFilter getFilter() {
        return this.filter;
    }

    public void setFilter(WorkspaceFilter filter) {
        this.filter = filter;
    }

    @Override
    public VaultFsConfig getConfig() {
        return this.config;
    }

    public void setConfig(VaultFsConfig config) {
        this.config = config;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Collection<NodeTypeSet> getNodeTypes() {
        return this.cnds;
    }

    @Override
    public PrivilegeDefinitions getPrivileges() {
        return this.privileges;
    }

    public void setCNDs(Collection<NodeTypeSet> cnds) {
        this.cnds = cnds;
    }

    @Override
    public boolean hasDefinition() {
        return this.hasDefinition;
    }

    public void setHasDefinition(boolean hasDefinition) {
        this.hasDefinition = hasDefinition;
    }

    protected void loadSettings(@NotNull File metaDir) throws ConfigurationException, IOException {
        File file = new File(metaDir, "settings.xml");
        if (file.isFile()) {
            VaultSettings settings = new VaultSettings();
            settings.load(file);
            this.settings = settings;
        } else {
            this.settings = VaultSettings.createDefault();
        }
    }

    protected void saveSettings(@NotNull File metaDir) throws IOException {
        if (this.settings != null) {
            File file = new File(metaDir, "settings.xml");
            this.settings.save(file);
        }
    }

    protected void loadConfig(@NotNull File metaDir) throws ConfigurationException, IOException {
        File file = new File(metaDir, "config.xml");
        if (file.isFile()) {
            this.config = AbstractVaultFsConfig.load(file);
        }
    }

    protected void saveConfig(@NotNull File metaDir) throws IOException {
        if (this.config != null) {
            File file = new File(metaDir, "config.xml");
            try (FileOutputStream output = FileUtils.openOutputStream(file);){
                IOUtils.copy(this.config.getSource(), (OutputStream)output);
            }
        }
    }

    protected void loadFilter(@NotNull File metaDir, boolean vltMode) throws ConfigurationException, IOException {
        File altFile;
        File file = new File(metaDir, "filter.xml");
        if (vltMode && (altFile = new File(metaDir, "filter-vlt.xml")).isFile()) {
            file = altFile;
            log.debug("Using alternative filter from {}", (Object)altFile.getPath());
        }
        if (file.isFile()) {
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            filter.load(file);
            this.filter = filter;
        }
    }

    protected void saveFilter(@NotNull File metaDir) throws IOException {
        if (this.filter != null) {
            File file = new File(metaDir, "filter.xml");
            try (FileOutputStream output = FileUtils.openOutputStream(file);){
                IOUtils.copy(this.filter.getSource(), (OutputStream)output);
            }
        }
    }

    protected void loadProperties(@NotNull File metaDir) throws IOException {
        File file = new File(metaDir, "properties.xml");
        if (file.isFile()) {
            try (FileInputStream input = FileUtils.openInputStream(file);){
                Properties properties = new Properties();
                properties.loadFromXML(input);
                this.properties = properties;
            }
        }
    }

    protected void saveProperties(@NotNull File metaDir) throws IOException {
        if (this.properties != null) {
            File file = new File(metaDir, "properties.xml");
            try (FileOutputStream output = FileUtils.openOutputStream(file);){
                this.properties.storeToXML((OutputStream)output, "Custom Vault Properties", "utf-8");
            }
        }
    }

    protected void loadPrivileges(@NotNull File metaDir) throws IOException {
        File file = new File(metaDir, "privileges.xml");
        if (file.isFile()) {
            try (FileInputStream in = FileUtils.openInputStream(file);){
                this.loadPrivileges(in, file.getPath());
            }
        }
    }

    protected void loadCNDs(@NotNull File metaDir) throws IOException {
        File[] files = metaDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".cnd")) continue;
            try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), "utf8");){
                CNDReader reader = ServiceProviderFactory.getProvider().getCNDReader();
                reader.read(r, file.getName(), null);
                this.cnds.add(reader);
            }
            catch (IOException e) {
                log.error("Error while reading CND: {}", (Object)e.toString());
                throw new IOException("Error while reading CND.", e);
            }
        }
    }

    @Override
    public PackageProperties getPackageProperties() {
        return new PackagePropertiesImpl(){

            @Override
            protected Properties getPropertiesMap() {
                return DefaultMetaInf.this.getProperties();
            }
        };
    }
}

