/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.logger;

import java.util.List;
import org.apache.sling.ide.eclipse.core.logger.LogSubscriber;
import org.apache.sling.ide.log.Logger;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class CompositeLogger
implements Logger {
    private static final long PERF_IGNORE_THRESHOLD = 50L;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.AT_LEAST_ONE)
    List<LogSubscriber> logSubscribers;

    public void trace(String message, Object ... arguments) {
        if (arguments.length > 0) {
            message = NLS.bind((String)message, (Object[])arguments);
        }
        this.logInternal(LogSubscriber.Severity.TRACE, message);
    }

    public void trace(String message, Throwable error) {
        this.logInternal(LogSubscriber.Severity.TRACE, message, error);
    }

    public void warn(String message) {
        this.logInternal(LogSubscriber.Severity.WARNING, message);
    }

    public void warn(String message, Throwable cause) {
        this.logInternal(LogSubscriber.Severity.WARNING, message, cause);
    }

    public void error(String message) {
        this.logInternal(LogSubscriber.Severity.ERROR, message);
    }

    public void error(String message, Throwable cause) {
        this.logInternal(LogSubscriber.Severity.ERROR, message, cause);
    }

    public void tracePerformance(String message, long duration, Object ... arguments) {
        if (duration < 50L) {
            return;
        }
        if (arguments.length > 0) {
            message = NLS.bind((String)message, (Object[])arguments);
        }
        String fullMessage = message + " took " + duration + " ms";
        this.logInternal(LogSubscriber.Severity.TRACE_PERFORMANCE, fullMessage);
    }

    private void logInternal(LogSubscriber.Severity severity, String message) {
        this.logInternal(severity, message, null);
    }

    private void logInternal(LogSubscriber.Severity severity, String message, Throwable cause) {
        for (LogSubscriber logSubscriber : this.logSubscribers) {
            logSubscriber.log(severity, message, cause);
        }
    }
}

