/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefWriter;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"felix.inventory.printer.name=JCR CND", "felix.inventory.printer.format=TEXT", "felix.inventory.printer.title=JCR Compact Node Type and Name Space Definition (CND)"})
public class CndPrinter
implements InventoryPrinter {
    @Reference
    private SlingRepository slingRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        Session session = null;
        try {
            session = this.slingRepository.loginAdministrative(null);
            CompactNodeTypeDefWriter cnd = new CompactNodeTypeDefWriter((Writer)printWriter, session, true);
            List<String> prefixes = Arrays.asList(session.getWorkspace().getNamespaceRegistry().getPrefixes());
            Collections.sort(prefixes);
            for (String prefix : prefixes) {
                if (prefix.equals("")) continue;
                cnd.writeNamespaceDeclaration(prefix);
            }
            NodeTypeIterator ntIterator = session.getWorkspace().getNodeTypeManager().getAllNodeTypes();
            while (ntIterator.hasNext()) {
                cnd.write((NodeTypeDefinition)ntIterator.nextNodeType());
            }
            cnd.close();
        }
        catch (IOException | RepositoryException e) {
            printWriter.println("Unable to output CND.");
            e.printStackTrace(printWriter);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

