/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers.internalrequests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlethelpers.MockRequestPathInfo;
import org.apache.sling.servlethelpers.MockSlingHttpServletRequest;
import org.apache.sling.servlethelpers.MockSlingHttpServletResponse;
import org.apache.sling.servlethelpers.MockSlingJakartaHttpServletRequest;
import org.apache.sling.servlethelpers.MockSlingJakartaHttpServletResponse;
import org.apache.sling.servlethelpers.internalrequests.BaseInternalRequest;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;

@Deprecated(since="2.0.0")
public abstract class InternalRequest
extends BaseInternalRequest {
    private MockSlingHttpServletRequest request;
    private MockSlingHttpServletResponse response;

    protected InternalRequest(@NotNull ResourceResolver resourceResolver, @NotNull String path) {
        super(resourceResolver, path);
    }

    @Override
    public InternalRequest withRequestMethod(String method) {
        return (InternalRequest)super.withRequestMethod(method);
    }

    @Override
    public InternalRequest withContentType(String contentType) {
        return (InternalRequest)super.withContentType(contentType);
    }

    @Override
    public InternalRequest withBody(Reader bodyContent) {
        return (InternalRequest)super.withBody(bodyContent);
    }

    @Override
    public InternalRequest withSelectors(String ... selectors) {
        return (InternalRequest)super.withSelectors(selectors);
    }

    @Override
    public InternalRequest withExtension(String extension) {
        return (InternalRequest)super.withExtension(extension);
    }

    @Override
    public InternalRequest withParameter(String key, Object value) {
        return (InternalRequest)super.withParameter(key, value);
    }

    @Override
    public InternalRequest withParameters(Map<String, Object> additionalParameters) {
        return (InternalRequest)super.withParameters(additionalParameters);
    }

    @Override
    public final InternalRequest execute() throws IOException {
        if (this.request != null) {
            throw new IOException("Request was already executed");
        }
        Resource resource = this.getExecutionResource();
        this.request = new MockSlingHttpServletRequest(new MockSlingJakartaHttpServletRequest(this.resourceResolver){

            @Override
            protected MockRequestPathInfo newMockRequestPathInfo() {
                MockRequestPathInfo rpi = super.newMockRequestPathInfo();
                rpi.setResourcePath(InternalRequest.this.path);
                rpi.setExtension(InternalRequest.this.extension);
                rpi.setSelectorString(InternalRequest.this.selectorString);
                return rpi;
            }

            @Override
            public BufferedReader getReader() {
                if (InternalRequest.this.bodyReader != null) {
                    return new BufferedReader(InternalRequest.this.bodyReader);
                }
                return super.getReader();
            }
        });
        this.request.setMethod(this.requestMethod);
        this.request.setContentType(this.contentType);
        this.request.setResource(resource);
        this.request.setParameterMap(this.parameters);
        this.response = new MockSlingHttpServletResponse(new MockSlingJakartaHttpServletResponse());
        MDC.put((String)MDC_KEY, (String)this.toString());
        try {
            this.delegateExecute((SlingHttpServletRequest)this.request, (SlingHttpServletResponse)this.response, this.resourceResolver);
        }
        catch (ServletException sx) {
            throw new IOException("ServletException in execute()", sx);
        }
        return this;
    }

    protected abstract void delegateExecute(SlingHttpServletRequest var1, SlingHttpServletResponse var2, ResourceResolver var3) throws ServletException, IOException;

    @Override
    protected void assertRequestExecuted() throws IOException {
        if (this.request == null) {
            throw new IOException("Request hasn't been executed");
        }
    }

    @Override
    public InternalRequest checkStatus(int ... acceptableValues) throws IOException {
        return (InternalRequest)super.checkStatus(acceptableValues);
    }

    private void maybeCheckOkStatus() throws IOException {
        if (!this.explicitStatusCheck) {
            try {
                this.checkStatus(200);
            }
            finally {
                this.explicitStatusCheck = false;
            }
        }
    }

    @Override
    public InternalRequest checkResponseContentType(String contentType) throws IOException {
        this.assertRequestExecuted();
        if (!contentType.equals(this.response.getContentType())) {
            throw new IOException("Expected content type " + contentType + " but got " + this.response.getContentType());
        }
        return this;
    }

    @Override
    public int getStatus() throws IOException {
        this.assertRequestExecuted();
        return this.response.getStatus();
    }

    public SlingHttpServletResponse getResponse() throws IOException {
        this.assertRequestExecuted();
        this.maybeCheckOkStatus();
        return this.response;
    }

    @Override
    public String getResponseAsString() throws IOException {
        this.assertRequestExecuted();
        this.maybeCheckOkStatus();
        return this.response.getOutputAsString();
    }
}

