/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={SitemapServiceConfiguration.class})
@Designate(ocd=Configuration.class)
public class SitemapServiceConfiguration {
    private int maxSize;
    private int maxEntries;

    @Activate
    protected void activate(Configuration configuration) {
        this.maxSize = configuration.maxSize();
        this.maxEntries = configuration.maxEntries();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    @ObjectClassDefinition(name="Apache Sling Sitemap - Sitemap Service")
    static @interface Configuration {
        @AttributeDefinition(name="Max Size", description="The maximum size of a sitemap in bytes. Files that exceed the size will be flagged with a warning.")
        public int maxSize() default 0xA00000;

        @AttributeDefinition(name="Max Entries", description="The maximum number of urls of a sitemap. Files that exceed this number will be flagged with a warning.")
        public int maxEntries() default 50000;
    }
}

