/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.Service3;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface1;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface2;
import org.apache.sling.testing.mock.osgi.testsvc.osgiserviceutil.ServiceInterface3;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.osgi.framework.BundleContext;

public class OsgiServiceRegisterTest {
    @Rule
    public OsgiContext context = new OsgiContext();

    @Test
    public void testRegisterClassesFromMetadata() {
        this.context.registerInjectActivateService(new Service2());
        Assert.assertEquals((long)1L, (long)((ServiceInterface2[])this.context.getServices(ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)1L, (long)((ServiceInterface3[])this.context.getServices(ServiceInterface3.class, null)).length);
    }

    @Test
    public void testRegisterExplicitClass1() {
        Service2 service = new Service2();
        MockOsgi.injectServices((Object)service, (BundleContext)this.context.bundleContext());
        MockOsgi.activate((Object)service, (BundleContext)this.context.bundleContext());
        this.context.registerService(ServiceInterface2.class, service);
        Assert.assertEquals((long)1L, (long)((ServiceInterface2[])this.context.getServices(ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)0L, (long)((ServiceInterface3[])this.context.getServices(ServiceInterface3.class, null)).length);
    }

    @Test
    public void testRegisterExplicitClass2() {
        Service2 service = new Service2();
        MockOsgi.injectServices((Object)service, (BundleContext)this.context.bundleContext());
        MockOsgi.activate((Object)service, (BundleContext)this.context.bundleContext());
        this.context.registerService(ServiceInterface3.class, service);
        Assert.assertEquals((long)0L, (long)((ServiceInterface2[])this.context.getServices(ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)1L, (long)((ServiceInterface3[])this.context.getServices(ServiceInterface3.class, null)).length);
    }

    @Test
    public void testRegisterExplicitClass3() {
        Service2 service = new Service2();
        MockOsgi.injectServices((Object)service, (BundleContext)this.context.bundleContext());
        MockOsgi.activate((Object)service, (BundleContext)this.context.bundleContext());
        this.context.registerService(ServiceInterface2.class, service);
        this.context.registerService(ServiceInterface3.class, service);
        Assert.assertEquals((long)1L, (long)((ServiceInterface2[])this.context.getServices(ServiceInterface2.class, null)).length);
        Assert.assertEquals((long)1L, (long)((ServiceInterface3[])this.context.getServices(ServiceInterface3.class, null)).length);
    }

    @Test
    public void testInjectMandatoryUnaryReferenceOutOfMultipleServices() {
        this.context.registerService(ServiceInterface2.class, (ServiceInterface2)Mockito.mock(ServiceInterface2.class));
        ServiceInterface1 service1_ranking100 = (ServiceInterface1)Mockito.mock(ServiceInterface1.class);
        this.context.registerService(ServiceInterface1.class, service1_ranking100, new Object[]{"service.ranking", 100});
        ServiceInterface1 service1_ranking200 = (ServiceInterface1)Mockito.mock(ServiceInterface1.class);
        this.context.registerService(ServiceInterface1.class, service1_ranking200, new Object[]{"service.ranking", 200});
        ServiceInterface1 service1_ranking10 = (ServiceInterface1)Mockito.mock(ServiceInterface1.class);
        this.context.registerService(ServiceInterface1.class, service1_ranking10, new Object[]{"service.ranking", 10});
        Service3 service3 = (Service3)this.context.registerInjectActivateService(new Service3());
        Assert.assertSame((Object)service1_ranking200, (Object)service3.getReference1());
    }
}

