/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules;

import java.net.URI;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.apache.sling.testing.junit.rules.SlingClassRule;
import org.apache.sling.testing.junit.rules.instance.ExistingInstance;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.apache.sling.testing.serversetup.instance.SlingTestBase;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingInstanceRule
implements TestRule {
    private static final SlingTestBase S = new SlingTestBase();
    public static final InstanceConfiguration DEFAULT_INSTANCE = new InstanceConfiguration(URI.create(S.getServerBaseUrl()), "default");
    private static final Logger LOG = LoggerFactory.getLogger(SlingInstanceRule.class);
    public final SlingClassRule slingClassRule = new SlingClassRule();
    public final Instance defaultInstance = new ExistingInstance().withRunMode("default").orDefault(DEFAULT_INSTANCE);
    protected TestRule ruleChain = RuleChain.outerRule((TestRule)this.slingClassRule).around((TestRule)this.defaultInstance);

    public <T extends SlingClient> T getAdminClient(Class<T> clientClass) {
        return this.defaultInstance.getClient(clientClass, S.getServerUsername(), S.getServerPassword());
    }

    public SlingClient getAdminClient() {
        return this.getAdminClient(SlingClient.class);
    }

    public Statement apply(Statement base, Description description) {
        return this.ruleChain.apply(base, description);
    }
}

