/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.ReadOnly;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Strings;

public final class PermissionUtil
implements PermissionConstants {
    private PermissionUtil() {
    }

    @Nullable
    public static String getParentPathOrNull(@NotNull String path) {
        if (path.length() <= 1) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        if (idx == 0) {
            return "/";
        }
        return path.substring(0, idx);
    }

    @NotNull
    public static String getEntryName(@Nullable String accessControlledPath) {
        String path = Strings.nullToEmpty(accessControlledPath);
        return String.valueOf(path.hashCode());
    }

    public static boolean checkACLPath(@NotNull NodeBuilder node, @NotNull String path) {
        PropertyState property = node.getProperty("rep:accessControlledPath");
        return property != null && path.equals(property.getValue(Type.STRING));
    }

    public static boolean checkACLPath(@NotNull Tree node, @NotNull String path) {
        PropertyState property = node.getProperty("rep:accessControlledPath");
        return property != null && path.equals(property.getValue(Type.STRING));
    }

    @NotNull
    public static Tree getPermissionsRoot(@NotNull Root root, @NotNull String permissionRootName) {
        return root.getTree("/jcr:system/rep:permissionStore/" + permissionRootName);
    }

    @NotNull
    public static Tree getPrincipalRoot(@NotNull Tree permissionsTree, @NotNull String principalName) {
        return permissionsTree.getChild(Text.escapeIllegalJcrChars(principalName));
    }

    public static boolean isAdminOrSystem(@NotNull Set<Principal> principals, @NotNull ConfigurationParameters config) {
        if (principals.contains(SystemPrincipal.INSTANCE)) {
            return true;
        }
        Set adminNames = config.getConfigValue("administrativePrincipals", Collections.EMPTY_SET);
        for (Principal principal : principals) {
            if (!(principal instanceof AdminPrincipal) && !adminNames.contains(principal.getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getPath(@Nullable Tree parentBefore, @Nullable Tree parentAfter) {
        String path = null;
        if (parentBefore != null) {
            path = parentBefore.getPath();
        } else if (parentAfter != null) {
            path = parentAfter.getPath();
        }
        return path;
    }

    @Nullable
    public static Tree getReadOnlyTreeOrNull(@Nullable Tree tree, @NotNull Root readOnlyRoot) {
        if (tree instanceof ReadOnly) {
            return tree;
        }
        return tree == null ? null : readOnlyRoot.getTree(tree.getPath());
    }

    @NotNull
    public static Tree getReadOnlyTree(@NotNull Tree tree, @NotNull Root readOnlyRoot) {
        if (tree instanceof ReadOnly) {
            return tree;
        }
        return readOnlyRoot.getTree(tree.getPath());
    }
}

