/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collections;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.collect.ImmutableSet;

public class VersionablePathHook
implements CommitHook {
    private final String workspaceName;
    private final ProviderCtx providerCtx;

    public VersionablePathHook(@NotNull String workspaceName, @NotNull ProviderCtx providerCtx) {
        this.workspaceName = workspaceName;
        this.providerCtx = providerCtx;
    }

    @Override
    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        NodeBuilder rootBuilder = after.builder();
        NodeBuilder vsRoot = rootBuilder.child("jcr:system").child("jcr:versionStorage");
        ReadWriteVersionManager vMgr = new ReadWriteVersionManager(vsRoot, rootBuilder);
        ReadOnlyNodeTypeManager ntMgr = ReadOnlyNodeTypeManager.getInstance(this.providerCtx.getRootProvider().createReadOnlyRoot(rootBuilder.getNodeState()), NamePathMapper.DEFAULT);
        after.compareAgainstBaseState(before, new Diff(vMgr, ntMgr, new Node(rootBuilder)));
        return rootBuilder.getNodeState();
    }

    public String toString() {
        return "VersionablePathHook : workspaceName = " + this.workspaceName;
    }

    private final class Node {
        private final String path;
        private final NodeBuilder builder;

        private Node(NodeBuilder rootBuilder) {
            this.path = "/";
            this.builder = rootBuilder;
        }

        private Node(@NotNull Node parent, String name) {
            this.builder = parent.builder.child(name);
            this.path = PathUtils.concat(parent.path, name);
        }

        private boolean isVersionable(@NotNull ReadOnlyNodeTypeManager ntMgr) {
            Tree tree = VersionablePathHook.this.providerCtx.getTreeProvider().createReadOnlyTree(this.builder.getNodeState());
            return ntMgr.isNodeType(tree, "mix:versionable");
        }
    }

    private final class Diff
    extends DefaultNodeStateDiff
    implements VersionConstants {
        private final ReadWriteVersionManager versionManager;
        private final ReadOnlyNodeTypeManager ntMgr;
        private final Node nodeAfter;

        private Diff(@NotNull ReadWriteVersionManager versionManager, @NotNull ReadOnlyNodeTypeManager ntMgr, Node node) {
            this.versionManager = versionManager;
            this.ntMgr = ntMgr;
            this.nodeAfter = node;
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            return this.setVersionablePath(after);
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.setVersionablePath(after);
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            return this.childNodeChanged(name, EmptyNodeState.EMPTY_NODE, after);
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (NodeStateUtils.isHidden(name)) {
                return true;
            }
            Node node = new Node(this.nodeAfter, name);
            return after.compareAgainstBaseState(before, new Diff(this.versionManager, this.ntMgr, node));
        }

        private boolean setVersionablePath(@NotNull PropertyState after) {
            if ("jcr:versionHistory".equals(after.getName()) && this.nodeAfter.isVersionable(this.ntMgr)) {
                NodeBuilder vhBuilder = this.versionManager.getOrCreateVersionHistory(this.nodeAfter.builder, Collections.emptyMap());
                if (!vhBuilder.hasProperty("jcr:mixinTypes")) {
                    vhBuilder.setProperty("jcr:mixinTypes", ImmutableSet.of("rep:VersionablePaths"), Type.NAMES);
                }
                String versionablePath = this.nodeAfter.path;
                vhBuilder.setProperty(VersionablePathHook.this.workspaceName, versionablePath, Type.PATH);
            }
            return true;
        }
    }
}

