/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.HeaderResultMatchers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001c\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013J'\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0015\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00170\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/springframework/test/web/servlet/result/HeaderResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "(Lorg/springframework/test/web/servlet/ResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/HeaderResultMatchers;", "kotlin.jvm.PlatformType", "dateValue", "", "name", "", "value", "", "doesNotExist", "exists", "longValue", "string", "matcher", "Lorg/hamcrest/Matcher;", "stringValues", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "", "spring-test"})
public final class HeaderResultMatchersDsl {
    @NotNull
    private final ResultActions actions;
    private final HeaderResultMatchers matchers;

    public HeaderResultMatchersDsl(@NotNull ResultActions actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.actions = actions;
        this.matchers = MockMvcResultMatchers.header();
    }

    public final void string(@NotNull String name, @NotNull Matcher<String> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.string(name, matcher));
    }

    public final void stringValues(@NotNull String name, @NotNull Matcher<Iterable<String>> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.stringValues(name, matcher));
    }

    public final void string(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.actions.andExpect(this.matchers.string(name, value));
    }

    public final void stringValues(@NotNull String name, String ... value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.actions.andExpect(this.matchers.stringValues(name, Arrays.copyOf(value, value.length)));
    }

    public final void exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.exists(name));
    }

    public final void doesNotExist(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.doesNotExist(name));
    }

    public final void longValue(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.longValue(name, value));
    }

    public final void dateValue(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.dateValue(name, value));
    }
}

