/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMapping;

public class OptTreePlanMappingAbstract
extends OptTreePlanMapping {
    private DMLProgram _prog = null;
    private Program _rtprog = null;
    private Map<Long, Object> _id_hlprog = new HashMap<Long, Object>();
    private Map<Long, Object> _id_rtprog = new HashMap<Long, Object>();

    public void putRootProgram(DMLProgram prog, Program rtprog) {
        this._prog = prog;
        this._rtprog = rtprog;
    }

    public long putHopMapping(Hop hops, OptNode n) {
        long id = this._idSeq.getNextID();
        this._id_hlprog.put(id, hops);
        this._id_rtprog.put(id, null);
        this._id_optnode.put(id, n);
        n.setID(id);
        return id;
    }

    public long putProgMapping(StatementBlock sb, ProgramBlock pb, OptNode n) {
        long id = this._idSeq.getNextID();
        this._id_hlprog.put(id, sb);
        this._id_rtprog.put(id, pb);
        this._id_optnode.put(id, n);
        n.setID(id);
        return id;
    }

    public Object[] getRootProgram() {
        Object[] ret = new Object[]{this._prog, this._rtprog};
        return ret;
    }

    public Hop getMappedHop(long id) {
        return (Hop)this._id_hlprog.get(id);
    }

    public Object[] getMappedProg(long id) {
        Object[] ret = new Object[]{(StatementBlock)this._id_hlprog.get(id), (ProgramBlock)this._id_rtprog.get(id)};
        return ret;
    }

    public void replaceMapping(ProgramBlock pb, OptNode n) {
        long id = n.getID();
        this._id_rtprog.put(id, pb);
        this._id_optnode.put(id, n);
    }

    @Override
    public void clear() {
        super.clear();
        this._prog = null;
        this._rtprog = null;
        this._id_hlprog.clear();
        this._id_rtprog.clear();
    }
}

