/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Collection;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.InjectionProvider2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class InjectWorker
implements ComponentClassTransformWorker2 {
    private final ObjectLocator locator;
    private final InjectionProvider2 injectionProvider;
    private final OperationTracker tracker;
    private final Predicate<PlasticField> MATCHER = new Predicate<PlasticField>(){

        public boolean accept(PlasticField field) {
            return field.hasAnnotation(Inject.class) || field.hasAnnotation(javax.inject.Inject.class);
        }
    };

    public InjectWorker(ObjectLocator locator, InjectionProvider2 injectionProvider, OperationTracker tracker) {
        this.locator = locator;
        this.injectionProvider = injectionProvider;
        this.tracker = tracker;
    }

    @Override
    public void transform(final PlasticClass plasticClass, TransformationSupport support, final MutableComponentModel model) {
        for (final PlasticField field : (Flow)F.flow((Collection)plasticClass.getUnclaimedFields()).filter(this.MATCHER)) {
            final String fieldName = field.getName();
            this.tracker.run(String.format("Injecting field  %s.%s", plasticClass.getClassName(), fieldName), new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean success = InjectWorker.this.injectionProvider.provideInjection(field, InjectWorker.this.locator, model);
                        if (success) {
                            field.claim((Object)"@Inject");
                        }
                    }
                    catch (RuntimeException ex) {
                        throw new RuntimeException(String.format("Error obtaining injected value for field %s.%s: %s", plasticClass.getClassName(), fieldName, ExceptionUtils.toMessage((Throwable)ex)), ex);
                    }
                }
            });
        }
    }
}

