/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.dom.Visitor;
import org.apache.tapestry5.internal.SingleKeySymbolProvider;
import org.apache.tapestry5.internal.TapestryAppInitializer;
import org.apache.tapestry5.internal.test.PageTesterContext;
import org.apache.tapestry5.internal.test.PageTesterModule;
import org.apache.tapestry5.internal.test.TestableRequest;
import org.apache.tapestry5.internal.test.TestableResponse;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.RequestHandler;
import org.slf4j.LoggerFactory;

public class PageTester {
    private final Registry registry;
    private final TestableRequest request;
    private final TestableResponse response;
    private final RequestHandler requestHandler;
    public static final String DEFAULT_CONTEXT_PATH = "src/main/webapp";
    private static final String DEFAULT_SUBMIT_VALUE_ATTRIBUTE = "Submit Query";

    public PageTester(String appPackage, String appName) {
        this(appPackage, appName, DEFAULT_CONTEXT_PATH, new Class[0]);
    }

    public PageTester(String appPackage, String appName, String contextPath, Class ... moduleClasses) {
        assert (InternalUtils.isNonBlank((String)appPackage));
        assert (appName != null);
        assert (InternalUtils.isNonBlank((String)contextPath));
        SingleKeySymbolProvider provider = new SingleKeySymbolProvider("tapestry.app-package", appPackage);
        TapestryAppInitializer initializer = new TapestryAppInitializer(LoggerFactory.getLogger(PageTester.class), provider, appName, null);
        initializer.addModules(PageTesterModule.class);
        initializer.addModules(moduleClasses);
        initializer.addModules(this.provideExtraModuleDefs());
        this.registry = initializer.createRegistry();
        this.request = (TestableRequest)this.registry.getService(TestableRequest.class);
        this.response = (TestableResponse)this.registry.getService(TestableResponse.class);
        ApplicationGlobals globals = (ApplicationGlobals)this.registry.getObject(ApplicationGlobals.class, null);
        globals.storeContext(new PageTesterContext(contextPath));
        this.registry.performRegistryStartup();
        this.requestHandler = (RequestHandler)this.registry.getService("RequestHandler", RequestHandler.class);
        this.request.setLocale(Locale.ENGLISH);
        initializer.announceStartup();
    }

    protected ModuleDef[] provideExtraModuleDefs() {
        return new ModuleDef[0];
    }

    public void shutdown() {
        this.registry.cleanupThread();
        this.registry.shutdown();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public <T> T getService(Class<T> serviceInterface) {
        return (T)this.registry.getService(serviceInterface);
    }

    public Document renderPage(String pageName) {
        this.renderPageAndReturnResponse(pageName);
        Document result = this.response.getRenderedDocument();
        if (result == null) {
            throw new RuntimeException(String.format("Render of page '%s' did not result in a Document.", pageName));
        }
        return result;
    }

    public TestableResponse renderPageAndReturnResponse(String pageName) {
        this.request.clear().setPath("/" + pageName);
        while (true) {
            try {
                this.response.clear();
                boolean handled = this.requestHandler.service(this.request, this.response);
                if (!handled) {
                    throw new RuntimeException(String.format("Request was not handled: '%s' may not be a valid page name.", pageName));
                }
                Link link = this.response.getRedirectLink();
                if (link != null) {
                    this.setupRequestFromLink(link);
                    continue;
                }
                TestableResponse testableResponse = this.response;
                return testableResponse;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.registry.cleanupThread();
                continue;
            }
            break;
        }
    }

    public Document clickLink(Element linkElement) {
        this.clickLinkAndReturnResponse(linkElement);
        return this.getDocumentFromResponse();
    }

    public TestableResponse clickLinkAndReturnResponse(Element linkElement) {
        assert (linkElement != null);
        this.validateElementName(linkElement, "a");
        String href = this.extractNonBlank(linkElement, "href");
        this.setupRequestFromURI(href);
        return this.runComponentEventRequest();
    }

    private String extractNonBlank(Element element, String attributeName) {
        String result = element.getAttribute(attributeName);
        if (InternalUtils.isBlank((String)result)) {
            throw new RuntimeException(String.format("The %s attribute of the <%s> element was blank or missing.", attributeName, element.getName()));
        }
        return result;
    }

    private void validateElementName(Element element, String expectedElementName) {
        if (!element.getName().equalsIgnoreCase(expectedElementName)) {
            throw new RuntimeException(String.format("The element must be type '%s', not '%s'.", expectedElementName, element.getName()));
        }
    }

    private Document getDocumentFromResponse() {
        Document result = this.response.getRenderedDocument();
        if (result == null) {
            throw new RuntimeException(String.format("Render request '%s' did not result in a Document.", this.request.getPath()));
        }
        return result;
    }

    private TestableResponse runComponentEventRequest() {
        while (true) {
            this.response.clear();
            try {
                boolean handled = this.requestHandler.service(this.request, this.response);
                if (!handled) {
                    throw new RuntimeException(String.format("Request for path '%s' was not handled by Tapestry.", this.request.getPath()));
                }
                Link link = this.response.getRedirectLink();
                if (link != null) {
                    this.setupRequestFromLink(link);
                    continue;
                }
                TestableResponse testableResponse = this.response;
                return testableResponse;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.registry.cleanupThread();
                continue;
            }
            break;
        }
    }

    private void setupRequestFromLink(Link link) {
        this.setupRequestFromURI(link.toRedirectURI());
    }

    public void setupRequestFromURI(String URI2) {
        String linkPath = this.stripContextFromPath(URI2);
        int comma = linkPath.indexOf(63);
        String path = comma < 0 ? linkPath : linkPath.substring(0, comma);
        this.request.clear().setPath(path);
        if (comma > 0) {
            this.decodeParametersIntoRequest(linkPath.substring(comma + 1));
        }
    }

    private void decodeParametersIntoRequest(String queryString) {
        if (InternalUtils.isBlank((String)queryString)) {
            return;
        }
        for (String term : queryString.split("&")) {
            int eqx = term.indexOf("=");
            String key = term.substring(0, eqx).trim();
            String value = term.substring(eqx + 1).trim();
            this.request.loadParameter(key, value);
        }
    }

    private String stripContextFromPath(String path) {
        String contextPath = this.request.getContextPath();
        if (contextPath.equals("")) {
            return path;
        }
        if (!path.startsWith(contextPath)) {
            throw new RuntimeException(String.format("Path '%s' does not start with context path '%s'.", path, contextPath));
        }
        return path.substring(contextPath.length());
    }

    public Document submitForm(Element form, Map<String, String> parameters) {
        this.submitFormAndReturnResponse(form, parameters);
        return this.getDocumentFromResponse();
    }

    public TestableResponse submitFormAndReturnResponse(Element form, Map<String, String> parameters) {
        assert (form != null);
        this.validateElementName(form, "form");
        this.request.clear().setPath(this.stripContextFromPath(this.extractNonBlank(form, "action")));
        this.pushFieldValuesIntoRequest(form);
        this.overrideParameters(parameters);
        return this.runComponentEventRequest();
    }

    private void overrideParameters(Map<String, String> fieldValues) {
        for (Map.Entry<String, String> e : fieldValues.entrySet()) {
            this.request.overrideParameter(e.getKey(), e.getValue());
        }
    }

    private void pushFieldValuesIntoRequest(Element form) {
        Visitor visitor = new Visitor(){

            @Override
            public void visit(Element element) {
                if (InternalUtils.isNonBlank((String)element.getAttribute("disabled"))) {
                    return;
                }
                String name = element.getName();
                if (name.equals("input")) {
                    String type = PageTester.this.extractNonBlank(element, "type");
                    if ((type.equals("radio") || type.equals("checkbox")) && InternalUtils.isBlank((String)element.getAttribute("checked"))) {
                        return;
                    }
                    if (type.equals("button") || type.equals("submit")) {
                        return;
                    }
                    String value = element.getAttribute("value");
                    if (InternalUtils.isNonBlank((String)value)) {
                        PageTester.this.request.loadParameter(PageTester.this.extractNonBlank(element, "name"), value);
                    }
                    return;
                }
                if (name.equals("option")) {
                    String value = element.getAttribute("value");
                    if (InternalUtils.isNonBlank((String)element.getAttribute("selected"))) {
                        String selectName = PageTester.this.extractNonBlank(PageTester.this.findAncestor(element, "select"), "name");
                        PageTester.this.request.loadParameter(selectName, value);
                    }
                    return;
                }
                if (name.equals("textarea")) {
                    String content = element.getChildMarkup();
                    if (InternalUtils.isNonBlank((String)content)) {
                        PageTester.this.request.loadParameter(PageTester.this.extractNonBlank(element, "name"), content);
                    }
                    return;
                }
            }
        };
        form.visit(visitor);
    }

    public Document clickSubmit(Element submitButton, Map<String, String> fieldValues) {
        this.clickSubmitAndReturnResponse(submitButton, fieldValues);
        return this.getDocumentFromResponse();
    }

    public TestableResponse clickSubmitAndReturnResponse(Element submitButton, Map<String, String> fieldValues) {
        assert (submitButton != null);
        this.assertIsSubmit(submitButton);
        Element form = this.getFormAncestor(submitButton);
        this.request.clear().setPath(this.stripContextFromPath(this.extractNonBlank(form, "action")));
        this.pushFieldValuesIntoRequest(form);
        this.overrideParameters(fieldValues);
        String value = submitButton.getAttribute("value");
        if (value == null) {
            value = DEFAULT_SUBMIT_VALUE_ATTRIBUTE;
        }
        this.request.overrideParameter(this.extractNonBlank(submitButton, "name"), value);
        return this.runComponentEventRequest();
    }

    private void assertIsSubmit(Element element) {
        String type;
        if (element.getName().equals("input") && "submit".equals(type = element.getAttribute("type"))) {
            return;
        }
        throw new IllegalArgumentException("The specified element is not a submit button.");
    }

    private Element getFormAncestor(Element element) {
        return this.findAncestor(element, "form");
    }

    private Element findAncestor(Element element, String ancestorName) {
        for (Element e = element; e != null; e = e.getContainer()) {
            if (!e.getName().equalsIgnoreCase(ancestorName)) continue;
            return e;
        }
        throw new RuntimeException(String.format("Could not locate an ancestor element of type '%s'.", ancestorName));
    }

    public void setPreferedLanguage(Locale preferedLanguage) {
        this.request.setLocale(preferedLanguage);
    }
}

