/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.internal.services.ClassPropertyAdapterImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAccess;

public class PropertyAccessImpl
implements PropertyAccess {
    private final Map<Class, ClassPropertyAdapter> adapters = CollectionFactory.newConcurrentMap();

    public Object get(Object instance, String propertyName) {
        return this.getAdapter(instance).get(instance, propertyName);
    }

    public void set(Object instance, String propertyName, Object value) {
        this.getAdapter(instance).set(instance, propertyName, value);
    }

    public Annotation getAnnotation(Object instance, String propertyName, Class<? extends Annotation> annotationClass) {
        return this.getAdapter(instance).getAnnotation(instance, propertyName, annotationClass);
    }

    public synchronized void clearCache() {
        this.adapters.clear();
        Introspector.flushCaches();
    }

    public ClassPropertyAdapter getAdapter(Object instance) {
        return this.getAdapter(instance.getClass());
    }

    public ClassPropertyAdapter getAdapter(Class forClass) {
        ClassPropertyAdapter result = this.adapters.get(forClass);
        if (result == null) {
            result = this.buildAdapter(forClass);
            this.adapters.put(forClass, result);
        }
        return result;
    }

    private synchronized ClassPropertyAdapter buildAdapter(Class forClass) {
        try {
            BeanInfo info = Introspector.getBeanInfo(forClass);
            List descriptors = CollectionFactory.newList();
            PropertyAccessImpl.addAll(descriptors, info.getPropertyDescriptors());
            PropertyAccessImpl.addPropertiesFromExtendedInterfaces(forClass, descriptors);
            this.addPropertiesFromScala(forClass, descriptors);
            return new ClassPropertyAdapterImpl(forClass, descriptors);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static <T> void addAll(List<T> list, T[] array) {
        if (array.length > 0) {
            list.addAll(Arrays.asList(array));
        }
    }

    private static <T> void addInterfacesRecursively(List<Class> list, Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> iface = interfaces[i];
            PropertyAccessImpl.addInterfacesRecursively(list, iface);
            list.add(iface);
        }
    }

    private static void addPropertiesFromExtendedInterfaces(Class forClass, List<PropertyDescriptor> descriptors) throws IntrospectionException {
        Class<?>[] interfaces = forClass.getInterfaces();
        if (interfaces.length == 0) {
            return;
        }
        LinkedList queue = CollectionFactory.newLinkedList();
        PropertyAccessImpl.addInterfacesRecursively(queue, forClass);
        while (!queue.isEmpty()) {
            Class c = (Class)queue.removeFirst();
            BeanInfo info = Introspector.getBeanInfo(c);
            PropertyAccessImpl.addAll(descriptors, info.getPropertyDescriptors());
        }
    }

    private void addPropertiesFromScala(Class forClass, List<PropertyDescriptor> descriptors) throws IntrospectionException {
        for (Method method : forClass.getMethods()) {
            this.addPropertyIfScalaGetterMethod(forClass, descriptors, method);
        }
    }

    private void addPropertyIfScalaGetterMethod(Class forClass, List<PropertyDescriptor> descriptors, Method method) throws IntrospectionException {
        if (!this.isScalaGetterMethod(method)) {
            return;
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(method.getName(), forClass, method.getName(), null);
        try {
            Method setterMethod = this.findScalaSetterMethod(forClass, method);
            propertyDescriptor.setWriteMethod(setterMethod);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.addScalaPropertyIfNoJavaBeansProperty(descriptors, propertyDescriptor, method);
    }

    private void addScalaPropertyIfNoJavaBeansProperty(List<PropertyDescriptor> descriptors, PropertyDescriptor propertyDescriptor, Method getterMethod) {
        boolean found = false;
        for (PropertyDescriptor currentPropertyDescriptor : descriptors) {
            if (!currentPropertyDescriptor.getName().equals(getterMethod.getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            descriptors.add(propertyDescriptor);
        }
    }

    private Method findScalaSetterMethod(Class forClass, Method getterMethod) throws NoSuchMethodException {
        return forClass.getMethod(getterMethod.getName() + "_$eq", getterMethod.getReturnType());
    }

    private boolean isScalaGetterMethod(Method method) {
        try {
            return Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && method.getDeclaringClass().getDeclaredField(method.getName()) != null;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }
}

