/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.util.ser.Serializers;

public class ProfilingApplication {
    private static final Random random = new Random(0L);
    private static final String[] scripts = new String[]{"g.V()", "g.V(1).out('knows')", "g.V(1).out('knows').has('name','josh')", "g.V(1).as(\"a\").out(\"knows\").as(\"b\").select(\"a\", \"b\")", "g.V(1).as(\"a\").out(\"knows\").as(\"b\").select(\"a\", \"b\").by(\"name\")", "g.V().hasLabel(\"person\").as(\"p\").map(__.bothE().label().groupCount()).as(\"r\").select(\"p\", \"r\")", "g.V().choose(__.outE().count().is(0L), __.as(\"a\"), __.as(\"b\")).choose(__.select(\"a\"), __.select(\"a\"), __.select(\"b\"))", "g.V().group(\"a\").by(T.label).by(outE().values(\"weight\").sum()).cap(\"a\")", "g.V().repeat(__.union(__.out(\"knows\").group(\"a\").by(\"age\"), __.out(\"created\").group(\"b\").by(\"name\").by(count())).group(\"a\").by(\"name\")).times(2).cap(\"a\", \"b\")", "g.V().match(\n  as(\"a\").out(\"knows\").as(\"b\"),\n  as(\"b\").out(\"created\").has(\"name\", \"lop\"),\n  as(\"b\").match(\n  as(\"b\").out(\"created\").as(\"d\"),\n  as(\"d\").in(\"created\").as(\"c\")).select(\"c\").as(\"c\")).<Vertex>select(\"a\", \"b\", \"c\")"};
    private final Cluster cluster;
    private final int requests;
    private final String executionName;
    private final String script;
    private final int tooSlowThreshold;
    private final boolean exercise;
    private final boolean suppressStackTraces;
    private final ExecutorService executor;

    public ProfilingApplication(String executionName, Cluster cluster, int requests, ExecutorService executor, String script, int tooSlowThreshold, boolean exercise, boolean suppressStackTraces) {
        this.executionName = executionName;
        this.cluster = cluster;
        this.requests = requests;
        this.executor = executor;
        this.script = script;
        this.tooSlowThreshold = tooSlowThreshold;
        this.exercise = exercise;
        this.suppressStackTraces = suppressStackTraces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeThroughput() throws Exception {
        AtomicInteger tooSlow = new AtomicInteger(0);
        AtomicInteger errors = new AtomicInteger(0);
        String executionId = "[" + this.executionName + "]";
        try (Object client = this.cluster.connect();){
            CountDownLatch latch = new CountDownLatch(this.requests);
            ((Client)client).init();
            long start = System.nanoTime();
            IntStream.range(0, this.requests).forEach(i -> {
                String s = this.exercise ? this.chooseScript() : this.script;
                client.submitAsync(s).thenAcceptAsync(r -> {
                    try {
                        r.all().get(this.tooSlowThreshold, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ex) {
                        tooSlow.incrementAndGet();
                    }
                    catch (Exception ex) {
                        errors.incrementAndGet();
                        if (!this.suppressStackTraces) {
                            ex.printStackTrace();
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }, (Executor)this.executor);
            });
            latch.await();
            long end = System.nanoTime();
            long total = end - start;
            double totalSeconds = (double)total / 1.0E9;
            long requestCount = this.requests;
            long reqSec = Math.round((double)requestCount / totalSeconds);
            System.out.println(String.format(StringUtils.rightPad((String)executionId, (int)10) + " requests: %s | time(s): %s | req/sec: %s | too slow: %s | errors: %s", requestCount, StringUtils.rightPad((String)String.valueOf(totalSeconds), (int)14), StringUtils.rightPad((String)String.valueOf(reqSec), (int)7), this.exercise ? "N/A" : Integer.valueOf(tooSlow.get()), errors.get()));
            long l = reqSec;
            return l;
        }
    }

    public double executeLatency() throws Exception {
        String executionId = "[" + this.executionName + "]";
        try (Object client = this.cluster.connect();){
            ((Client)client).init();
            long start = System.nanoTime();
            int size = 0;
            Iterator<Result> itr = ((Client)client).submitAsync(this.script).get().iterator();
            try {
                while (true) {
                    itr.next();
                    ++size;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                long end = System.nanoTime();
                long total = end - start;
                double totalSeconds = (double)total / 1.0E9;
                System.out.println(String.format(StringUtils.rightPad((String)executionId, (int)10) + "time: %s, result count: %s", StringUtils.rightPad((String)String.valueOf(totalSeconds), (int)7), StringUtils.rightPad((String)String.valueOf(size), (int)10)));
                double d = totalSeconds;
                return d;
            }
        }
    }

    private String chooseScript() {
        return scripts[random.nextInt(scripts.length - 1)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Map options = ElementHelper.asMap((Object[])args);
        boolean noExit = Boolean.parseBoolean(options.getOrDefault("noExit", "false").toString());
        int parallelism = Integer.parseInt(options.getOrDefault("parallelism", "16").toString());
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("profiler-%d").build();
        ExecutorService executor = Executors.newFixedThreadPool(parallelism, (ThreadFactory)threadFactory);
        TestType testType = TestType.values()[Integer.parseInt(options.getOrDefault("testType", "1").toString()) % TestType.values().length];
        String host = options.getOrDefault("host", "localhost").toString();
        int minExpectedRps = Integer.parseInt(options.getOrDefault("minExpectedRps", "1000").toString());
        int timeout = Integer.parseInt(options.getOrDefault("timeout", "1200000").toString());
        int warmups = Integer.parseInt(options.getOrDefault("warmups", "5").toString());
        int executions = Integer.parseInt(options.getOrDefault("executions", "10").toString());
        int nioPoolSize = Integer.parseInt(options.getOrDefault("nioPoolSize", "1").toString());
        int requests = Integer.parseInt(options.getOrDefault("requests", "10000").toString());
        int maxConnectionPoolSize = Integer.parseInt(options.getOrDefault("maxConnectionPoolSize", "256").toString());
        int maxWaitForConnection = Integer.parseInt(options.getOrDefault("maxWaitForConnection", "3000").toString());
        int workerPoolSize = Integer.parseInt(((Object)options.getOrDefault("workerPoolSize", Runtime.getRuntime().availableProcessors() * 2)).toString());
        int tooSlowThreshold = Integer.parseInt(options.getOrDefault("tooSlowThreshold", "125").toString());
        String serializer = options.getOrDefault("serializer", Serializers.GRAPHBINARY_V4.name()).toString();
        int pauseBetweenRuns = Integer.parseInt(options.getOrDefault("pauseBetweenRuns", "1000").toString());
        boolean suppressStackTraces = Boolean.parseBoolean(options.getOrDefault("suppressStackTraces", "false").toString());
        boolean exercise = Boolean.parseBoolean(options.getOrDefault("exercise", "false").toString());
        String script = options.getOrDefault("script", "1+1").toString();
        Cluster cluster = Cluster.build(host).maxConnectionPoolSize(maxConnectionPoolSize).nioPoolSize(nioPoolSize).maxWaitForConnection(maxWaitForConnection).serializer(Serializers.valueOf((String)serializer)).workerPoolSize(workerPoolSize).create();
        try {
            if (TestType.LATENCY == testType) {
                System.out.println("-----------------------LATENCY TEST SELECTED----------------------");
            } else {
                System.out.println("---------------------THROUGHPUT TEST SELECTED---------------------");
            }
            if (exercise) {
                System.out.println("--------------------------INITIALIZATION--------------------------");
                Object client = cluster.connect();
                ((Client)client).submit("graph.clear()").all().join();
                System.out.println("Cleared existing 'graph'");
                ((Client)client).submit("TinkerFactory.generateModern(graph)").all().join();
                ((Client)client).close();
                System.out.println("Modern graph loaded");
            }
            if (TestType.THROUGHPUT == testType) {
                File f;
                Object fileName = options.get("store");
                File file = f = null == fileName ? null : new File(fileName.toString());
                if (f != null && f.length() == 0L) {
                    try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                        writer.println("parallelism\tnioPoolSize\tmaxConnectionPoolSize\tworkerPoolSize\trequestPerSecond");
                    }
                }
                AtomicBoolean meetsRpsExpectation = new AtomicBoolean(true);
                System.out.println("---------------------------WARMUP CYCLE---------------------------");
                for (int ix = 0; ix < warmups && meetsRpsExpectation.get(); ++ix) {
                    long averageRequestsPerSecond = new ProfilingApplication("warmup-" + (ix + 1), cluster, 1000, executor, script, tooSlowThreshold, exercise, suppressStackTraces).executeThroughput();
                    meetsRpsExpectation.set(averageRequestsPerSecond >= (long)minExpectedRps);
                    TimeUnit.MILLISECONDS.sleep(pauseBetweenRuns);
                }
                AtomicBoolean exceededTimeout = new AtomicBoolean(false);
                long totalRequestsPerSecond = 0L;
                if (exercise || meetsRpsExpectation.get()) {
                    long start = System.nanoTime();
                    System.out.println("----------------------------TEST CYCLE----------------------------");
                    for (int ix = 0; ix < executions && !exceededTimeout.get(); ++ix) {
                        totalRequestsPerSecond += new ProfilingApplication("test-" + (ix + 1), cluster, requests, executor, script, tooSlowThreshold, exercise, suppressStackTraces).executeThroughput();
                        exceededTimeout.set(System.nanoTime() - start > TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS));
                        TimeUnit.MILLISECONDS.sleep(pauseBetweenRuns);
                    }
                }
                int averageRequestPerSecond = !meetsRpsExpectation.get() || exceededTimeout.get() ? 0 : Math.round(totalRequestsPerSecond / (long)executions);
                System.out.println(String.format("avg req/sec: %s", averageRequestPerSecond));
                if (f != null) {
                    try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));){
                        writer.println(String.join((CharSequence)"\t", String.valueOf(parallelism), String.valueOf(nioPoolSize), String.valueOf(maxConnectionPoolSize), String.valueOf(workerPoolSize), String.valueOf(averageRequestPerSecond)));
                    }
                }
            } else if (TestType.LATENCY == testType) {
                AtomicBoolean meetsTimeoutExpectation = new AtomicBoolean(true);
                System.out.println("---------------------------WARMUP CYCLE---------------------------");
                for (int ix = 0; ix < warmups && meetsTimeoutExpectation.get(); ++ix) {
                    double latency = new ProfilingApplication("warmup-" + (ix + 1), cluster, 1000, executor, script, tooSlowThreshold, exercise, suppressStackTraces).executeLatency();
                    meetsTimeoutExpectation.set(latency < (double)timeout);
                    TimeUnit.MILLISECONDS.sleep(pauseBetweenRuns);
                }
                AtomicBoolean exceededTimeout = new AtomicBoolean(false);
                double totalTime = 0.0;
                if (exercise || meetsTimeoutExpectation.get()) {
                    long start = System.nanoTime();
                    System.out.println("----------------------------TEST CYCLE----------------------------");
                    for (int ix = 0; ix < executions && !exceededTimeout.get(); ++ix) {
                        totalTime += new ProfilingApplication("test-" + (ix + 1), cluster, requests, executor, script, tooSlowThreshold, exercise, suppressStackTraces).executeLatency();
                        exceededTimeout.set(System.nanoTime() - start > TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS));
                        TimeUnit.MILLISECONDS.sleep(pauseBetweenRuns);
                    }
                }
                double averageLatency = !meetsTimeoutExpectation.get() || exceededTimeout.get() ? 0.0 : totalTime / (double)executions;
                System.out.println(String.format("avg latency (sec/req): %s", averageLatency));
            } else {
                System.out.println("Encountered unknown testType. Please enter a valid value and try again.");
            }
            if (!noExit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!noExit) {
                System.exit(1);
            }
        }
        finally {
            executor.shutdown();
            cluster.close();
        }
    }

    public static enum TestType {
        LATENCY,
        THROUGHPUT;

    }
}

